/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

class MapIteratorCache<K, V> {
    private final Map<K, V> backingMap;
    @NullableDecl
    private transient Map.Entry<K, V> entrySetCache;

    MapIteratorCache(Map<K, V> map) {
        this.backingMap = Preconditions.checkNotNull(map);
    }

    static /* synthetic */ Map.Entry access$102(MapIteratorCache mapIteratorCache, Map.Entry entry) {
        mapIteratorCache.entrySetCache = entry;
        return entry;
    }

    public void clear() {
        this.clearCache();
        this.backingMap.clear();
    }

    protected void clearCache() {
        this.entrySetCache = null;
    }

    public final boolean containsKey(@NullableDecl Object object) {
        boolean bl = this.getIfCached(object) != null || this.backingMap.containsKey(object);
        return bl;
    }

    public V get(@NullableDecl Object object) {
        V v2 = this.getIfCached(object);
        object = v2 != null ? v2 : this.getWithoutCaching(object);
        return (V)object;
    }

    protected V getIfCached(@NullableDecl Object object) {
        Map.Entry<K, V> entry = this.entrySetCache;
        if (entry != null && entry.getKey() == object) {
            return entry.getValue();
        }
        return null;
    }

    public final V getWithoutCaching(@NullableDecl Object object) {
        return this.backingMap.get(object);
    }

    public V put(@NullableDecl K k2, @NullableDecl V v2) {
        this.clearCache();
        return this.backingMap.put(k2, v2);
    }

    public V remove(@NullableDecl Object object) {
        this.clearCache();
        return this.backingMap.remove(object);
    }

    public final Set<K> unmodifiableKeySet() {
        return new AbstractSet<K>(){

            @Override
            public boolean contains(@NullableDecl Object object) {
                return MapIteratorCache.this.containsKey(object);
            }

            @Override
            public UnmodifiableIterator<K> iterator() {
                return new UnmodifiableIterator<K>(MapIteratorCache.this.backingMap.entrySet().iterator()){
                    final /* synthetic */ Iterator val$entryIterator;
                    {
                        this.val$entryIterator = iterator2;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.val$entryIterator.hasNext();
                    }

                    @Override
                    public K next() {
                        Map.Entry entry = (Map.Entry)this.val$entryIterator.next();
                        MapIteratorCache.access$102(MapIteratorCache.this, entry);
                        return entry.getKey();
                    }
                };
            }

            @Override
            public int size() {
                return MapIteratorCache.this.backingMap.size();
            }
        };
    }
}

