/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.graph.ConfigurableValueGraph;
import com.google.common.graph.DirectedGraphConnections;
import com.google.common.graph.GraphConnections;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.UndirectedGraphConnections;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import com.google.errorprone.annotations.Immutable;

@Immutable(containerOf={"N", "V"})
public final class ImmutableValueGraph<N, V>
extends ConfigurableValueGraph<N, V> {
    private ImmutableValueGraph(ValueGraph<N, V> valueGraph) {
        super(ValueGraphBuilder.from(valueGraph), ImmutableValueGraph.getNodeConnections(valueGraph), valueGraph.edges().size());
    }

    private static <N, V> GraphConnections<N, V> connectionsOf(ValueGraph<N, V> object, N n2) {
        Function function = new Function<N, V>((ValueGraph)object, n2){
            final /* synthetic */ ValueGraph val$graph;
            final /* synthetic */ Object val$node;
            {
                this.val$graph = valueGraph;
                this.val$node = object;
            }

            @Override
            public V apply(N n2) {
                return this.val$graph.edgeValueOrDefault(this.val$node, n2, null);
            }
        };
        object = object.isDirected() ? DirectedGraphConnections.ofImmutable(object.predecessors(n2), Maps.asMap(object.successors(n2), function)) : UndirectedGraphConnections.ofImmutable(Maps.asMap(object.adjacentNodes(n2), function));
        return object;
    }

    @Deprecated
    public static <N, V> ImmutableValueGraph<N, V> copyOf(ImmutableValueGraph<N, V> immutableValueGraph) {
        return Preconditions.checkNotNull(immutableValueGraph);
    }

    public static <N, V> ImmutableValueGraph<N, V> copyOf(ValueGraph<N, V> immutableValueGraph) {
        immutableValueGraph = immutableValueGraph instanceof ImmutableValueGraph ? (ImmutableValueGraph<N, V>)immutableValueGraph : new ImmutableValueGraph<N, V>(immutableValueGraph);
        return immutableValueGraph;
    }

    private static <N, V> ImmutableMap<N, GraphConnections<N, V>> getNodeConnections(ValueGraph<N, V> valueGraph) {
        ImmutableMap.Builder<N, GraphConnections<N, V>> builder = ImmutableMap.builder();
        for (N n2 : valueGraph.nodes()) {
            builder.put(n2, ImmutableValueGraph.connectionsOf(valueGraph, n2));
        }
        return builder.build();
    }

    @Override
    public ImmutableGraph<N> asGraph() {
        return new ImmutableGraph(this);
    }
}

