/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.graph.ConfigurableNetwork;
import com.google.common.graph.DirectedMultiNetworkConnections;
import com.google.common.graph.DirectedNetworkConnections;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.NetworkConnections;
import com.google.common.graph.UndirectedMultiNetworkConnections;
import com.google.common.graph.UndirectedNetworkConnections;
import com.google.errorprone.annotations.Immutable;
import java.util.Map;

@Immutable(containerOf={"N", "E"})
public final class ImmutableNetwork<N, E>
extends ConfigurableNetwork<N, E> {
    private ImmutableNetwork(Network<N, E> network) {
        super(NetworkBuilder.from(network), ImmutableNetwork.getNodeConnections(network), ImmutableNetwork.getEdgeToReferenceNode(network));
    }

    private static <N, E> Function<E, N> adjacentNodeFn(final Network<N, E> network, final N n2) {
        return new Function<E, N>(){

            @Override
            public N apply(E e2) {
                return network.incidentNodes(e2).adjacentNode(n2);
            }
        };
    }

    private static <N, E> NetworkConnections<N, E> connectionsOf(Network<N, E> object, N object2) {
        if (object.isDirected()) {
            Map<E, N> map = Maps.asMap(object.inEdges(object2), ImmutableNetwork.sourceNodeFn(object));
            Map<E, N> map2 = Maps.asMap(object.outEdges(object2), ImmutableNetwork.targetNodeFn(object));
            int n2 = object.edgesConnecting(object2, object2).size();
            object = object.allowsParallelEdges() ? DirectedMultiNetworkConnections.ofImmutable(map, map2, n2) : DirectedNetworkConnections.ofImmutable(map, map2, (int)n2);
            return object;
        }
        object2 = Maps.asMap(object.incidentEdges(object2), ImmutableNetwork.adjacentNodeFn(object, object2));
        object = object.allowsParallelEdges() ? UndirectedMultiNetworkConnections.ofImmutable(object2) : UndirectedNetworkConnections.ofImmutable(object2);
        return object;
    }

    @Deprecated
    public static <N, E> ImmutableNetwork<N, E> copyOf(ImmutableNetwork<N, E> immutableNetwork) {
        return Preconditions.checkNotNull(immutableNetwork);
    }

    public static <N, E> ImmutableNetwork<N, E> copyOf(Network<N, E> immutableNetwork) {
        immutableNetwork = immutableNetwork instanceof ImmutableNetwork ? (ImmutableNetwork<N, E>)immutableNetwork : new ImmutableNetwork<N, E>(immutableNetwork);
        return immutableNetwork;
    }

    private static <N, E> Map<E, N> getEdgeToReferenceNode(Network<N, E> network) {
        ImmutableMap.Builder<E, N> builder = ImmutableMap.builder();
        for (E e2 : network.edges()) {
            builder.put(e2, network.incidentNodes(e2).nodeU());
        }
        return builder.build();
    }

    private static <N, E> Map<N, NetworkConnections<N, E>> getNodeConnections(Network<N, E> network) {
        ImmutableMap.Builder<N, NetworkConnections<N, E>> builder = ImmutableMap.builder();
        for (N n2 : network.nodes()) {
            builder.put(n2, ImmutableNetwork.connectionsOf(network, n2));
        }
        return builder.build();
    }

    private static <N, E> Function<E, N> sourceNodeFn(final Network<N, E> network) {
        return new Function<E, N>(){

            @Override
            public N apply(E e2) {
                return network.incidentNodes(e2).source();
            }
        };
    }

    private static <N, E> Function<E, N> targetNodeFn(final Network<N, E> network) {
        return new Function<E, N>(){

            @Override
            public N apply(E e2) {
                return network.incidentNodes(e2).target();
            }
        };
    }

    @Override
    public ImmutableGraph<N> asGraph() {
        return new ImmutableGraph(super.asGraph());
    }
}

