/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.graph.BaseGraph;
import com.google.common.graph.ConfigurableValueGraph;
import com.google.common.graph.DirectedGraphConnections;
import com.google.common.graph.ForwardingGraph;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.GraphConnections;
import com.google.common.graph.GraphConstants;
import com.google.common.graph.UndirectedGraphConnections;
import com.google.errorprone.annotations.Immutable;

@Immutable(containerOf={"N"})
public class ImmutableGraph<N>
extends ForwardingGraph<N> {
    private final BaseGraph<N> backingGraph;

    ImmutableGraph(BaseGraph<N> baseGraph) {
        this.backingGraph = baseGraph;
    }

    private static <N> GraphConnections<N, GraphConstants.Presence> connectionsOf(Graph<N> object, N n2) {
        Function<Object, GraphConstants.Presence> function = Functions.constant(GraphConstants.Presence.EDGE_EXISTS);
        object = object.isDirected() ? DirectedGraphConnections.ofImmutable(object.predecessors(n2), Maps.asMap(object.successors(n2), function)) : UndirectedGraphConnections.ofImmutable(Maps.asMap(object.adjacentNodes(n2), function));
        return object;
    }

    public static <N> ImmutableGraph<N> copyOf(Graph<N> immutableGraph) {
        immutableGraph = immutableGraph instanceof ImmutableGraph ? (ImmutableGraph<N>)immutableGraph : new ImmutableGraph<N>(new ConfigurableValueGraph<N, GraphConstants.Presence>(GraphBuilder.from((Graph)immutableGraph), ImmutableGraph.getNodeConnections(immutableGraph), immutableGraph.edges().size()));
        return immutableGraph;
    }

    @Deprecated
    public static <N> ImmutableGraph<N> copyOf(ImmutableGraph<N> immutableGraph) {
        return Preconditions.checkNotNull(immutableGraph);
    }

    private static <N> ImmutableMap<N, GraphConnections<N, GraphConstants.Presence>> getNodeConnections(Graph<N> graph) {
        ImmutableMap.Builder<N, GraphConnections<N, GraphConstants.Presence>> builder = ImmutableMap.builder();
        for (N n2 : graph.nodes()) {
            builder.put(n2, ImmutableGraph.connectionsOf(graph, n2));
        }
        return builder.build();
    }

    @Override
    protected BaseGraph<N> delegate() {
        return this.backingGraph;
    }
}

