/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ForwardingGraph;
import com.google.common.graph.ForwardingNetwork;
import com.google.common.graph.ForwardingValueGraph;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Graphs {
    private Graphs() {
    }

    private static boolean canTraverseWithoutReusingEdge(Graph<?> graph, Object object, @NullableDecl Object object2) {
        return graph.isDirected() || !Objects.equal(object2, object);
        {
        }
    }

    static int checkNonNegative(int n2) {
        boolean bl = n2 >= 0;
        Preconditions.checkArgument(bl, "Not true that %s is non-negative.", n2);
        return n2;
    }

    static long checkNonNegative(long l2) {
        boolean bl = l2 >= 0L;
        Preconditions.checkArgument(bl, "Not true that %s is non-negative.", l2);
        return l2;
    }

    static int checkPositive(int n2) {
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl, "Not true that %s is positive.", n2);
        return n2;
    }

    static long checkPositive(long l2) {
        boolean bl = l2 > 0L;
        Preconditions.checkArgument(bl, "Not true that %s is positive.", l2);
        return l2;
    }

    public static <N> MutableGraph<N> copyOf(Graph<N> object) {
        MutableGraph mutableGraph = GraphBuilder.from((Graph)((Object)object)).expectedNodeCount(object.nodes().size()).build();
        Iterator object22 = object.nodes().iterator();
        while (object22.hasNext()) {
            mutableGraph.addNode(object22.next());
        }
        for (EndpointPair endpointPair : object.edges()) {
            mutableGraph.putEdge(endpointPair.nodeU(), endpointPair.nodeV());
        }
        return mutableGraph;
    }

    public static <N, E> MutableNetwork<N, E> copyOf(Network<N, E> network) {
        MutableNetwork mutableNetwork = NetworkBuilder.from(network).expectedNodeCount(network.nodes().size()).expectedEdgeCount(network.edges().size()).build();
        Iterator<Object> iterator2 = network.nodes().iterator();
        while (iterator2.hasNext()) {
            mutableNetwork.addNode(iterator2.next());
        }
        for (Object object : network.edges()) {
            EndpointPair<N> endpointPair = network.incidentNodes(object);
            mutableNetwork.addEdge(endpointPair.nodeU(), endpointPair.nodeV(), object);
        }
        return mutableNetwork;
    }

    public static <N, V> MutableValueGraph<N, V> copyOf(ValueGraph<N, V> valueGraph) {
        MutableValueGraph mutableValueGraph = ValueGraphBuilder.from(valueGraph).expectedNodeCount(valueGraph.nodes().size()).build();
        Iterator<Object> iterator2 = valueGraph.nodes().iterator();
        while (iterator2.hasNext()) {
            mutableValueGraph.addNode(iterator2.next());
        }
        for (EndpointPair endpointPair : valueGraph.edges()) {
            mutableValueGraph.putEdgeValue(endpointPair.nodeU(), endpointPair.nodeV(), valueGraph.edgeValueOrDefault(endpointPair.nodeU(), endpointPair.nodeV(), null));
        }
        return mutableValueGraph;
    }

    public static <N> boolean hasCycle(Graph<N> graph) {
        int n2 = graph.edges().size();
        if (n2 == 0) {
            return false;
        }
        if (!graph.isDirected() && n2 >= graph.nodes().size()) {
            return true;
        }
        HashMap<Object, NodeVisitState> hashMap = Maps.newHashMapWithExpectedSize(graph.nodes().size());
        Iterator<N> iterator2 = graph.nodes().iterator();
        while (iterator2.hasNext()) {
            if (!Graphs.subgraphHasCycle(graph, hashMap, iterator2.next(), null)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCycle(Network<?, ?> network) {
        if (!network.isDirected() && network.allowsParallelEdges() && network.edges().size() > network.asGraph().edges().size()) {
            return true;
        }
        return Graphs.hasCycle(network.asGraph());
    }

    public static <N> MutableGraph<N> inducedSubgraph(Graph<N> graph, Iterable<? extends N> iterator2) {
        MutableGraph mutableGraph = iterator2 instanceof Collection ? GraphBuilder.from(graph).expectedNodeCount(((Collection)((Object)iterator2)).size()).build() : GraphBuilder.from(graph).build();
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            mutableGraph.addNode(iterator2.next());
        }
        for (Object e2 : mutableGraph.nodes()) {
            for (N n2 : graph.successors(e2)) {
                if (!mutableGraph.nodes().contains(n2)) continue;
                mutableGraph.putEdge(e2, n2);
            }
        }
        return mutableGraph;
    }

    public static <N, E> MutableNetwork<N, E> inducedSubgraph(Network<N, E> network, Iterable<? extends N> iterator2) {
        MutableNetwork mutableNetwork = iterator2 instanceof Collection ? NetworkBuilder.from(network).expectedNodeCount(((Collection)((Object)iterator2)).size()).build() : NetworkBuilder.from(network).build();
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            mutableNetwork.addNode(iterator2.next());
        }
        for (Object e2 : mutableNetwork.nodes()) {
            for (E e3 : network.outEdges(e2)) {
                N n2 = network.incidentNodes(e3).adjacentNode(e2);
                if (!mutableNetwork.nodes().contains(n2)) continue;
                mutableNetwork.addEdge(e2, n2, e3);
            }
        }
        return mutableNetwork;
    }

    public static <N, V> MutableValueGraph<N, V> inducedSubgraph(ValueGraph<N, V> valueGraph, Iterable<? extends N> iterator2) {
        MutableValueGraph mutableValueGraph = iterator2 instanceof Collection ? ValueGraphBuilder.from(valueGraph).expectedNodeCount(((Collection)((Object)iterator2)).size()).build() : ValueGraphBuilder.from(valueGraph).build();
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            mutableValueGraph.addNode(iterator2.next());
        }
        for (Object e2 : mutableValueGraph.nodes()) {
            for (N n2 : valueGraph.successors(e2)) {
                if (!mutableValueGraph.nodes().contains(n2)) continue;
                mutableValueGraph.putEdgeValue(e2, n2, valueGraph.edgeValueOrDefault(e2, n2, null));
            }
        }
        return mutableValueGraph;
    }

    public static <N> Set<N> reachableNodes(Graph<N> graph, N object) {
        Preconditions.checkArgument(graph.nodes().contains(object), "Node %s is not an element of this graph.", object);
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        linkedHashSet.add(object);
        arrayDeque.add(object);
        while (!arrayDeque.isEmpty()) {
            for (Object e2 : graph.successors(arrayDeque.remove())) {
                if (!linkedHashSet.add(e2)) continue;
                arrayDeque.add(e2);
            }
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    private static <N> boolean subgraphHasCycle(Graph<N> graph, Map<Object, NodeVisitState> map, N n2, @NullableDecl N n3) {
        Object object = map.get(n2);
        if (object == NodeVisitState.COMPLETE) {
            return false;
        }
        if (object == NodeVisitState.PENDING) {
            return true;
        }
        map.put(n2, NodeVisitState.PENDING);
        for (Object e2 : graph.successors(n2)) {
            if (!Graphs.canTraverseWithoutReusingEdge(graph, e2, n3) || !Graphs.subgraphHasCycle(graph, map, e2, n2)) continue;
            return true;
        }
        map.put(n2, NodeVisitState.COMPLETE);
        return false;
    }

    public static <N> Graph<N> transitiveClosure(Graph<N> graph) {
        MutableGraph mutableGraph = GraphBuilder.from(graph).allowsSelfLoops(true).build();
        if (graph.isDirected()) {
            for (N n2 : graph.nodes()) {
                Iterator<N> iterator2 = Graphs.reachableNodes(graph, n2).iterator();
                while (iterator2.hasNext()) {
                    mutableGraph.putEdge(n2, iterator2.next());
                }
            }
        } else {
            HashSet hashSet = new HashSet();
            for (Object object : graph.nodes()) {
                if (hashSet.contains(object)) continue;
                object = Graphs.reachableNodes(graph, object);
                hashSet.addAll(object);
                Iterator iterator3 = object.iterator();
                int n3 = 1;
                while (iterator3.hasNext()) {
                    Object e2 = iterator3.next();
                    Iterator iterator4 = Iterables.limit(object, n3).iterator();
                    while (iterator4.hasNext()) {
                        mutableGraph.putEdge(e2, iterator4.next());
                    }
                    ++n3;
                }
            }
        }
        return mutableGraph;
    }

    static <N> EndpointPair<N> transpose(EndpointPair<N> endpointPair) {
        EndpointPair<N> endpointPair2 = endpointPair;
        if (endpointPair.isOrdered()) {
            endpointPair2 = EndpointPair.ordered(endpointPair.target(), endpointPair.source());
        }
        return endpointPair2;
    }

    public static <N> Graph<N> transpose(Graph<N> graph) {
        if (!graph.isDirected()) {
            return graph;
        }
        if (graph instanceof TransposedGraph) {
            return ((TransposedGraph)graph).graph;
        }
        return new TransposedGraph<N>(graph);
    }

    public static <N, E> Network<N, E> transpose(Network<N, E> network) {
        if (!network.isDirected()) {
            return network;
        }
        if (network instanceof TransposedNetwork) {
            return ((TransposedNetwork)((Object)network)).network;
        }
        return new TransposedNetwork<N, E>(network);
    }

    public static <N, V> ValueGraph<N, V> transpose(ValueGraph<N, V> valueGraph) {
        if (!valueGraph.isDirected()) {
            return valueGraph;
        }
        if (valueGraph instanceof TransposedValueGraph) {
            return ((TransposedValueGraph)valueGraph).graph;
        }
        return new TransposedValueGraph<N, V>(valueGraph);
    }

    private static enum NodeVisitState {
        PENDING,
        COMPLETE;

    }

    private static class TransposedGraph<N>
    extends ForwardingGraph<N> {
        private final Graph<N> graph;

        TransposedGraph(Graph<N> graph) {
            this.graph = graph;
        }

        @Override
        protected Graph<N> delegate() {
            return this.graph;
        }

        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
            return this.delegate().hasEdgeConnecting(Graphs.transpose(endpointPair));
        }

        @Override
        public boolean hasEdgeConnecting(N n2, N n3) {
            return this.delegate().hasEdgeConnecting(n3, n2);
        }

        @Override
        public int inDegree(N n2) {
            return this.delegate().outDegree(n2);
        }

        @Override
        public int outDegree(N n2) {
            return this.delegate().inDegree(n2);
        }

        @Override
        public Set<N> predecessors(N n2) {
            return this.delegate().successors(n2);
        }

        @Override
        public Set<N> successors(N n2) {
            return this.delegate().predecessors(n2);
        }
    }

    private static class TransposedNetwork<N, E>
    extends ForwardingNetwork<N, E> {
        private final Network<N, E> network;

        TransposedNetwork(Network<N, E> network) {
            this.network = network;
        }

        protected Network<N, E> delegate() {
            return this.network;
        }

        public E edgeConnectingOrNull(EndpointPair<N> endpointPair) {
            return this.delegate().edgeConnectingOrNull(Graphs.transpose(endpointPair));
        }

        public E edgeConnectingOrNull(N n2, N n3) {
            return this.delegate().edgeConnectingOrNull(n3, n2);
        }

        public Set<E> edgesConnecting(EndpointPair<N> endpointPair) {
            return this.delegate().edgesConnecting(Graphs.transpose(endpointPair));
        }

        public Set<E> edgesConnecting(N n2, N n3) {
            return this.delegate().edgesConnecting(n3, n2);
        }

        public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
            return this.delegate().hasEdgeConnecting(Graphs.transpose(endpointPair));
        }

        public boolean hasEdgeConnecting(N n2, N n3) {
            return this.delegate().hasEdgeConnecting(n3, n2);
        }

        public int inDegree(N n2) {
            return this.delegate().outDegree(n2);
        }

        public Set<E> inEdges(N n2) {
            return this.delegate().outEdges(n2);
        }

        public EndpointPair<N> incidentNodes(E object) {
            object = this.delegate().incidentNodes(object);
            return EndpointPair.of(this.network, ((EndpointPair)object).nodeV(), ((EndpointPair)object).nodeU());
        }

        public int outDegree(N n2) {
            return this.delegate().inDegree(n2);
        }

        public Set<E> outEdges(N n2) {
            return this.delegate().inEdges(n2);
        }

        public Set<N> predecessors(N n2) {
            return this.delegate().successors(n2);
        }

        public Set<N> successors(N n2) {
            return this.delegate().predecessors(n2);
        }
    }

    private static class TransposedValueGraph<N, V>
    extends ForwardingValueGraph<N, V> {
        private final ValueGraph<N, V> graph;

        TransposedValueGraph(ValueGraph<N, V> valueGraph) {
            this.graph = valueGraph;
        }

        @Override
        protected ValueGraph<N, V> delegate() {
            return this.graph;
        }

        @Override
        @NullableDecl
        public V edgeValueOrDefault(EndpointPair<N> endpointPair, @NullableDecl V v2) {
            return this.delegate().edgeValueOrDefault(Graphs.transpose(endpointPair), v2);
        }

        @Override
        @NullableDecl
        public V edgeValueOrDefault(N n2, N n3, @NullableDecl V v2) {
            return this.delegate().edgeValueOrDefault(n3, n2, v2);
        }

        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
            return this.delegate().hasEdgeConnecting(Graphs.transpose(endpointPair));
        }

        @Override
        public boolean hasEdgeConnecting(N n2, N n3) {
            return this.delegate().hasEdgeConnecting(n3, n2);
        }

        @Override
        public int inDegree(N n2) {
            return this.delegate().outDegree(n2);
        }

        @Override
        public int outDegree(N n2) {
            return this.delegate().inDegree(n2);
        }

        @Override
        public Set<N> predecessors(N n2) {
            return this.delegate().successors(n2);
        }

        @Override
        public Set<N> successors(N n2) {
            return this.delegate().predecessors(n2);
        }
    }
}

