/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.errorprone.annotations.Immutable;
import java.util.Comparator;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@Immutable
public final class ElementOrder<T> {
    @NullableDecl
    private final Comparator<T> comparator;
    private final Type type;

    private ElementOrder(Type type, @NullableDecl Comparator<T> comparator) {
        this.type = Preconditions.checkNotNull(type);
        this.comparator = comparator;
        Type type2 = Type.SORTED;
        boolean bl = true;
        boolean bl2 = type == type2;
        boolean bl3 = comparator != null;
        if (bl2 != bl3) {
            bl = false;
        }
        Preconditions.checkState(bl);
    }

    public static <S> ElementOrder<S> insertion() {
        return new ElementOrder(Type.INSERTION, null);
    }

    public static <S extends Comparable<? super S>> ElementOrder<S> natural() {
        return new ElementOrder(Type.SORTED, Ordering.natural());
    }

    public static <S> ElementOrder<S> sorted(Comparator<S> comparator) {
        return new ElementOrder<S>(Type.SORTED, comparator);
    }

    public static <S> ElementOrder<S> unordered() {
        return new ElementOrder(Type.UNORDERED, null);
    }

    <T1 extends T> ElementOrder<T1> cast() {
        return this;
    }

    public Comparator<T> comparator() {
        Comparator<T> comparator = this.comparator;
        if (comparator != null) {
            return comparator;
        }
        throw new UnsupportedOperationException("This ordering does not define a comparator.");
    }

    <K extends T, V> Map<K, V> createMap(int n2) {
        int n3 = 1.$SwitchMap$com$google$common$graph$ElementOrder$Type[this.type.ordinal()];
        if (n3 != 1) {
            if (n3 != 2) {
                if (n3 == 3) {
                    return Maps.newTreeMap(this.comparator());
                }
                throw new AssertionError();
            }
            return Maps.newLinkedHashMapWithExpectedSize(n2);
        }
        return Maps.newHashMapWithExpectedSize(n2);
    }

    public boolean equals(@NullableDecl Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (!(object instanceof ElementOrder)) {
            return false;
        }
        object = (ElementOrder)object;
        if (this.type != ((ElementOrder)object).type || !Objects.equal(this.comparator, ((ElementOrder)object).comparator)) {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.type, this.comparator});
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(this).add("type", (Object)this.type);
        Comparator<T> comparator = this.comparator;
        if (comparator != null) {
            toStringHelper.add("comparator", comparator);
        }
        return toStringHelper.toString();
    }

    public Type type() {
        return this.type;
    }

    public static enum Type {
        UNORDERED,
        INSERTION,
        SORTED;

    }
}

