/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractSet;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class EdgesConnecting<E>
extends AbstractSet<E> {
    private final Map<?, E> nodeToOutEdge;
    private final Object targetNode;

    EdgesConnecting(Map<?, E> map, Object object) {
        this.nodeToOutEdge = Preconditions.checkNotNull(map);
        this.targetNode = Preconditions.checkNotNull(object);
    }

    @NullableDecl
    private E getConnectingEdge() {
        return this.nodeToOutEdge.get(this.targetNode);
    }

    @Override
    public boolean contains(@NullableDecl Object object) {
        E e2 = this.getConnectingEdge();
        boolean bl = e2 != null && e2.equals(object);
        return bl;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        Object object = this.getConnectingEdge();
        object = object == null ? ImmutableSet.of().iterator() : Iterators.singletonIterator(object);
        return object;
    }

    @Override
    public int size() {
        int n2 = this.getConnectingEdge() == null ? 0 : 1;
        return n2;
    }
}

