/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.GraphConnections;
import com.google.common.graph.Graphs;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class DirectedGraphConnections<N, V>
implements GraphConnections<N, V> {
    private static final Object PRED = new Object();
    private final Map<N, Object> adjacentNodeValues;
    private int predecessorCount;
    private int successorCount;

    private DirectedGraphConnections(Map<N, Object> map, int n2, int n3) {
        this.adjacentNodeValues = Preconditions.checkNotNull(map);
        this.predecessorCount = Graphs.checkNonNegative(n2);
        this.successorCount = Graphs.checkNonNegative(n3);
        boolean bl = n2 <= map.size() && n3 <= map.size();
        Preconditions.checkState(bl);
    }

    private static boolean isPredecessor(@NullableDecl Object object) {
        boolean bl = object == PRED || object instanceof PredAndSucc;
        return bl;
    }

    private static boolean isSuccessor(@NullableDecl Object object) {
        boolean bl = object != PRED && object != null;
        return bl;
    }

    static <N, V> DirectedGraphConnections<N, V> of() {
        return new DirectedGraphConnections(new HashMap(4, 1.0f), 0, 0);
    }

    static <N, V> DirectedGraphConnections<N, V> ofImmutable(Set<N> set, Map<N, V> map) {
        HashMap<N, Object> hashMap = new HashMap<N, Object>();
        hashMap.putAll(map);
        for (N n2 : set) {
            Object object = hashMap.put(n2, PRED);
            if (object == null) continue;
            hashMap.put(n2, new PredAndSucc(object));
        }
        return new DirectedGraphConnections(ImmutableMap.copyOf(hashMap), set.size(), map.size());
    }

    @Override
    public void addPredecessor(N n2, V object) {
        object = this.adjacentNodeValues.put(n2, PRED);
        if (object == null) {
            int n3;
            this.predecessorCount = n3 = this.predecessorCount + 1;
            Graphs.checkPositive(n3);
        } else if (object instanceof PredAndSucc) {
            this.adjacentNodeValues.put(n2, object);
        } else if (object != PRED) {
            int n4;
            this.adjacentNodeValues.put(n2, new PredAndSucc(object));
            this.predecessorCount = n4 = this.predecessorCount + 1;
            Graphs.checkPositive(n4);
        }
    }

    @Override
    public V addSuccessor(N n2, V v2) {
        Object object = this.adjacentNodeValues.put(n2, v2);
        if (object == null) {
            int n3;
            this.successorCount = n3 = this.successorCount + 1;
            Graphs.checkPositive(n3);
            return null;
        }
        if (object instanceof PredAndSucc) {
            this.adjacentNodeValues.put(n2, new PredAndSucc(v2));
            return (V)((PredAndSucc)object).successorValue;
        }
        if (object == PRED) {
            int n4;
            this.adjacentNodeValues.put(n2, new PredAndSucc(v2));
            this.successorCount = n4 = this.successorCount + 1;
            Graphs.checkPositive(n4);
            return null;
        }
        return (V)object;
    }

    @Override
    public Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(this.adjacentNodeValues.keySet());
    }

    @Override
    public Set<N> predecessors() {
        return new AbstractSet<N>(){

            @Override
            public boolean contains(@NullableDecl Object object) {
                return DirectedGraphConnections.isPredecessor(DirectedGraphConnections.this.adjacentNodeValues.get(object));
            }

            @Override
            public UnmodifiableIterator<N> iterator() {
                return new AbstractIterator<N>(DirectedGraphConnections.this.adjacentNodeValues.entrySet().iterator()){
                    final /* synthetic */ Iterator val$entries;
                    {
                        this.val$entries = iterator2;
                    }

                    @Override
                    protected N computeNext() {
                        while (this.val$entries.hasNext()) {
                            Map.Entry entry = (Map.Entry)this.val$entries.next();
                            if (!DirectedGraphConnections.isPredecessor(entry.getValue())) continue;
                            return entry.getKey();
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                return DirectedGraphConnections.this.predecessorCount;
            }
        };
    }

    @Override
    public void removePredecessor(N n2) {
        Object object = this.adjacentNodeValues.get(n2);
        if (object == PRED) {
            int n3;
            this.adjacentNodeValues.remove(n2);
            this.predecessorCount = n3 = this.predecessorCount - 1;
            Graphs.checkNonNegative(n3);
        } else if (object instanceof PredAndSucc) {
            int n4;
            this.adjacentNodeValues.put(n2, ((PredAndSucc)object).successorValue);
            this.predecessorCount = n4 = this.predecessorCount - 1;
            Graphs.checkNonNegative(n4);
        }
    }

    @Override
    public V removeSuccessor(Object object) {
        Object object2;
        Object object3 = this.adjacentNodeValues.get(object);
        if (object3 != null && object3 != (object2 = PRED)) {
            int n2;
            if (object3 instanceof PredAndSucc) {
                int n3;
                this.adjacentNodeValues.put(object, object2);
                this.successorCount = n3 = this.successorCount - 1;
                Graphs.checkNonNegative(n3);
                return (V)((PredAndSucc)object3).successorValue;
            }
            this.adjacentNodeValues.remove(object);
            this.successorCount = n2 = this.successorCount - 1;
            Graphs.checkNonNegative(n2);
            return (V)object3;
        }
        return null;
    }

    @Override
    public Set<N> successors() {
        return new AbstractSet<N>(){

            @Override
            public boolean contains(@NullableDecl Object object) {
                return DirectedGraphConnections.isSuccessor(DirectedGraphConnections.this.adjacentNodeValues.get(object));
            }

            @Override
            public UnmodifiableIterator<N> iterator() {
                return new AbstractIterator<N>(DirectedGraphConnections.this.adjacentNodeValues.entrySet().iterator()){
                    final /* synthetic */ Iterator val$entries;
                    {
                        this.val$entries = iterator2;
                    }

                    @Override
                    protected N computeNext() {
                        while (this.val$entries.hasNext()) {
                            Map.Entry entry = (Map.Entry)this.val$entries.next();
                            if (!DirectedGraphConnections.isSuccessor(entry.getValue())) continue;
                            return entry.getKey();
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                return DirectedGraphConnections.this.successorCount;
            }
        };
    }

    @Override
    public V value(N object) {
        Object object2 = this.adjacentNodeValues.get(object);
        if (object2 == PRED) {
            return null;
        }
        object = object2;
        if (object2 instanceof PredAndSucc) {
            object = ((PredAndSucc)object2).successorValue;
        }
        return (V)object;
    }

    private static final class PredAndSucc {
        private final Object successorValue;

        PredAndSucc(Object object) {
            this.successorValue = object;
        }
    }
}

