/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.AbstractGraphBuilder;
import com.google.common.graph.AbstractValueGraph;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphConnections;
import com.google.common.graph.Graphs;
import com.google.common.graph.MapIteratorCache;
import com.google.common.graph.MapRetrievalCache;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

class ConfigurableValueGraph<N, V>
extends AbstractValueGraph<N, V> {
    private final boolean allowsSelfLoops;
    protected long edgeCount;
    private final boolean isDirected;
    protected final MapIteratorCache<N, GraphConnections<N, V>> nodeConnections;
    private final ElementOrder<N> nodeOrder;

    ConfigurableValueGraph(AbstractGraphBuilder<? super N> abstractGraphBuilder) {
        this(abstractGraphBuilder, abstractGraphBuilder.nodeOrder.createMap(abstractGraphBuilder.expectedNodeCount.or(10)), 0L);
    }

    ConfigurableValueGraph(AbstractGraphBuilder<? super N> mapIteratorCache, Map<N, GraphConnections<N, V>> map, long l2) {
        this.isDirected = ((AbstractGraphBuilder)((Object)mapIteratorCache)).directed;
        this.allowsSelfLoops = ((AbstractGraphBuilder)((Object)mapIteratorCache)).allowsSelfLoops;
        this.nodeOrder = ((AbstractGraphBuilder)((Object)mapIteratorCache)).nodeOrder.cast();
        mapIteratorCache = map instanceof TreeMap ? new MapRetrievalCache<N, GraphConnections<N, V>>(map) : new MapIteratorCache(map);
        this.nodeConnections = mapIteratorCache;
        this.edgeCount = Graphs.checkNonNegative(l2);
    }

    @Override
    public Set<N> adjacentNodes(N n2) {
        return this.checkedConnections(n2).adjacentNodes();
    }

    @Override
    public boolean allowsSelfLoops() {
        return this.allowsSelfLoops;
    }

    protected final GraphConnections<N, V> checkedConnections(N n2) {
        GraphConnections<N, V> graphConnections = this.nodeConnections.get(n2);
        if (graphConnections != null) {
            return graphConnections;
        }
        Preconditions.checkNotNull(n2);
        graphConnections = new StringBuilder();
        ((StringBuilder)((Object)graphConnections)).append("Node ");
        ((StringBuilder)((Object)graphConnections)).append(n2);
        ((StringBuilder)((Object)graphConnections)).append(" is not an element of this graph.");
        throw new IllegalArgumentException(((StringBuilder)((Object)graphConnections)).toString());
    }

    protected final boolean containsNode(@NullableDecl N n2) {
        return this.nodeConnections.containsKey(n2);
    }

    @Override
    protected long edgeCount() {
        return this.edgeCount;
    }

    @Override
    @NullableDecl
    public V edgeValueOrDefault(EndpointPair<N> endpointPair, @NullableDecl V v2) {
        this.validateEndpoints(endpointPair);
        return this.edgeValueOrDefault_internal(endpointPair.nodeU(), endpointPair.nodeV(), v2);
    }

    @Override
    @NullableDecl
    public V edgeValueOrDefault(N n2, N n3, @NullableDecl V v2) {
        return this.edgeValueOrDefault_internal(Preconditions.checkNotNull(n2), Preconditions.checkNotNull(n3), v2);
    }

    protected final V edgeValueOrDefault_internal(N object, N object2, V v2) {
        object = (object = this.nodeConnections.get(object)) == null ? null : object.value(object2);
        object2 = object;
        if (object == null) {
            object2 = v2;
        }
        return (V)object2;
    }

    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
        Preconditions.checkNotNull(endpointPair);
        boolean bl = this.isOrderingCompatible(endpointPair) && this.hasEdgeConnecting_internal(endpointPair.nodeU(), endpointPair.nodeV());
        return bl;
    }

    @Override
    public boolean hasEdgeConnecting(N n2, N n3) {
        return this.hasEdgeConnecting_internal(Preconditions.checkNotNull(n2), Preconditions.checkNotNull(n3));
    }

    protected final boolean hasEdgeConnecting_internal(N object, N n2) {
        boolean bl = (object = this.nodeConnections.get(object)) != null && object.successors().contains(n2);
        return bl;
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    public ElementOrder<N> nodeOrder() {
        return this.nodeOrder;
    }

    @Override
    public Set<N> nodes() {
        return this.nodeConnections.unmodifiableKeySet();
    }

    @Override
    public Set<N> predecessors(N n2) {
        return this.checkedConnections(n2).predecessors();
    }

    @Override
    public Set<N> successors(N n2) {
        return this.checkedConnections(n2).successors();
    }
}

