/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.AbstractGraph;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.Network;
import com.google.common.math.IntMath;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class AbstractNetwork<N, E>
implements Network<N, E> {
    private Predicate<E> connectedPredicate(final N n2, final N n3) {
        return new Predicate<E>(){

            @Override
            public boolean apply(E e2) {
                return AbstractNetwork.this.incidentNodes(e2).adjacentNode(n2).equals(n3);
            }
        };
    }

    private static <N, E> Map<E, EndpointPair<N>> edgeIncidentNodesMap(final Network<N, E> network) {
        Function function = new Function<E, EndpointPair<N>>(){

            @Override
            public EndpointPair<N> apply(E e2) {
                return network.incidentNodes(e2);
            }
        };
        return Maps.asMap(network.edges(), function);
    }

    @Override
    public Set<E> adjacentEdges(E e2) {
        EndpointPair endpointPair = this.incidentNodes(e2);
        return Sets.difference(Sets.union(this.incidentEdges(endpointPair.nodeU()), this.incidentEdges(endpointPair.nodeV())), ImmutableSet.of(e2));
    }

    @Override
    public Graph<N> asGraph() {
        return new AbstractGraph<N>(){

            @Override
            public Set<N> adjacentNodes(N n2) {
                return AbstractNetwork.this.adjacentNodes(n2);
            }

            @Override
            public boolean allowsSelfLoops() {
                return AbstractNetwork.this.allowsSelfLoops();
            }

            @Override
            public Set<EndpointPair<N>> edges() {
                if (AbstractNetwork.this.allowsParallelEdges()) {
                    return super.edges();
                }
                return new AbstractSet<EndpointPair<N>>(){

                    @Override
                    public boolean contains(@NullableDecl Object object) {
                        boolean bl = object instanceof EndpointPair;
                        boolean bl2 = false;
                        if (!bl) {
                            return false;
                        }
                        object = (EndpointPair)object;
                        bl = bl2;
                        if (this.isOrderingCompatible((EndpointPair<?>)object)) {
                            bl = bl2;
                            if (this.nodes().contains(((EndpointPair)object).nodeU())) {
                                bl = bl2;
                                if (this.successors(((EndpointPair)object).nodeU()).contains(((EndpointPair)object).nodeV())) {
                                    bl = true;
                                }
                            }
                        }
                        return bl;
                    }

                    @Override
                    public Iterator<EndpointPair<N>> iterator() {
                        return Iterators.transform(AbstractNetwork.this.edges().iterator(), new Function<E, EndpointPair<N>>(){

                            @Override
                            public EndpointPair<N> apply(E e2) {
                                return AbstractNetwork.this.incidentNodes(e2);
                            }
                        });
                    }

                    @Override
                    public int size() {
                        return AbstractNetwork.this.edges().size();
                    }
                };
            }

            @Override
            public boolean isDirected() {
                return AbstractNetwork.this.isDirected();
            }

            @Override
            public ElementOrder<N> nodeOrder() {
                return AbstractNetwork.this.nodeOrder();
            }

            @Override
            public Set<N> nodes() {
                return AbstractNetwork.this.nodes();
            }

            @Override
            public Set<N> predecessors(N n2) {
                return AbstractNetwork.this.predecessors(n2);
            }

            @Override
            public Set<N> successors(N n2) {
                return AbstractNetwork.this.successors(n2);
            }
        };
    }

    @Override
    public int degree(N n2) {
        if (this.isDirected()) {
            return IntMath.saturatedAdd((int)this.inEdges(n2).size(), (int)this.outEdges(n2).size());
        }
        return IntMath.saturatedAdd((int)this.incidentEdges(n2).size(), (int)this.edgesConnecting(n2, n2).size());
    }

    @Override
    @NullableDecl
    public E edgeConnectingOrNull(EndpointPair<N> endpointPair) {
        this.validateEndpoints(endpointPair);
        return this.edgeConnectingOrNull(endpointPair.nodeU(), endpointPair.nodeV());
    }

    @Override
    @NullableDecl
    public E edgeConnectingOrNull(N n2, N n3) {
        Set<E> set = this.edgesConnecting(n2, n3);
        int n4 = set.size();
        if (n4 != 0) {
            if (n4 == 1) {
                return set.iterator().next();
            }
            throw new IllegalArgumentException(String.format("Cannot call edgeConnecting() when parallel edges exist between %s and %s. Consider calling edgesConnecting() instead.", n2, n3));
        }
        return null;
    }

    @Override
    public Set<E> edgesConnecting(EndpointPair<N> endpointPair) {
        this.validateEndpoints(endpointPair);
        return this.edgesConnecting(endpointPair.nodeU(), endpointPair.nodeV());
    }

    @Override
    public Set<E> edgesConnecting(N object, N n2) {
        Set set = this.outEdges(object);
        Set set2 = this.inEdges(n2);
        object = set.size() <= set2.size() ? Collections.unmodifiableSet(Sets.filter(set, this.connectedPredicate(object, n2))) : Collections.unmodifiableSet(Sets.filter(set2, this.connectedPredicate(n2, object)));
        return object;
    }

    @Override
    public final boolean equals(@NullableDecl Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (!(object instanceof Network)) {
            return false;
        }
        object = (Network)object;
        if (this.isDirected() != object.isDirected() || !this.nodes().equals(object.nodes()) || !AbstractNetwork.edgeIncidentNodesMap(this).equals(AbstractNetwork.edgeIncidentNodesMap(object))) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
        Preconditions.checkNotNull(endpointPair);
        if (!this.isOrderingCompatible(endpointPair)) {
            return false;
        }
        return this.edgesConnecting(endpointPair.nodeU(), endpointPair.nodeV()).isEmpty() ^ true;
    }

    @Override
    public boolean hasEdgeConnecting(N n2, N n3) {
        return this.edgesConnecting(n2, n3).isEmpty() ^ true;
    }

    @Override
    public final int hashCode() {
        return AbstractNetwork.edgeIncidentNodesMap(this).hashCode();
    }

    @Override
    public int inDegree(N n2) {
        int n3 = this.isDirected() ? this.inEdges(n2).size() : this.degree(n2);
        return n3;
    }

    protected final boolean isOrderingCompatible(EndpointPair<?> endpointPair) {
        boolean bl = endpointPair.isOrdered() || !this.isDirected();
        return bl;
    }

    @Override
    public int outDegree(N n2) {
        int n3 = this.isDirected() ? this.outEdges(n2).size() : this.degree(n2);
        return n3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("isDirected: ");
        stringBuilder.append(this.isDirected());
        stringBuilder.append(", allowsParallelEdges: ");
        stringBuilder.append(this.allowsParallelEdges());
        stringBuilder.append(", allowsSelfLoops: ");
        stringBuilder.append(this.allowsSelfLoops());
        stringBuilder.append(", nodes: ");
        stringBuilder.append(this.nodes());
        stringBuilder.append(", edges: ");
        stringBuilder.append(AbstractNetwork.edgeIncidentNodesMap(this));
        return stringBuilder.toString();
    }

    protected final void validateEndpoints(EndpointPair<?> endpointPair) {
        Preconditions.checkNotNull(endpointPair);
        Preconditions.checkArgument(this.isOrderingCompatible(endpointPair), "Mismatch: unordered endpoints cannot be used with directed graphs");
    }
}

