/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.Graphs;
import com.google.common.graph.NetworkConnections;
import com.google.common.math.IntMath;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class AbstractDirectedNetworkConnections<N, E>
implements NetworkConnections<N, E> {
    protected final Map<E, N> inEdgeMap;
    protected final Map<E, N> outEdgeMap;
    private int selfLoopCount;

    protected AbstractDirectedNetworkConnections(Map<E, N> map, Map<E, N> map2, int n2) {
        this.inEdgeMap = Preconditions.checkNotNull(map);
        this.outEdgeMap = Preconditions.checkNotNull(map2);
        this.selfLoopCount = Graphs.checkNonNegative(n2);
        boolean bl = n2 <= map.size() && n2 <= map2.size();
        Preconditions.checkState(bl);
    }

    @Override
    public void addInEdge(E e2, N n2, boolean bl) {
        boolean bl2 = true;
        if (bl) {
            int n3;
            this.selfLoopCount = n3 = this.selfLoopCount + 1;
            Graphs.checkPositive(n3);
        }
        bl = this.inEdgeMap.put(e2, n2) == null ? bl2 : false;
        Preconditions.checkState(bl);
    }

    @Override
    public void addOutEdge(E e2, N n2) {
        boolean bl = this.outEdgeMap.put(e2, n2) == null;
        Preconditions.checkState(bl);
    }

    @Override
    public N adjacentNode(E e2) {
        return Preconditions.checkNotNull(this.outEdgeMap.get(e2));
    }

    @Override
    public Set<N> adjacentNodes() {
        return Sets.union(this.predecessors(), this.successors());
    }

    @Override
    public Set<E> inEdges() {
        return Collections.unmodifiableSet(this.inEdgeMap.keySet());
    }

    @Override
    public Set<E> incidentEdges() {
        return new AbstractSet<E>(){

            @Override
            public boolean contains(@NullableDecl Object object) {
                boolean bl = AbstractDirectedNetworkConnections.this.inEdgeMap.containsKey(object) || AbstractDirectedNetworkConnections.this.outEdgeMap.containsKey(object);
                return bl;
            }

            @Override
            public UnmodifiableIterator<E> iterator() {
                Iterable iterable = AbstractDirectedNetworkConnections.this.selfLoopCount == 0 ? Iterables.concat(AbstractDirectedNetworkConnections.this.inEdgeMap.keySet(), AbstractDirectedNetworkConnections.this.outEdgeMap.keySet()) : Sets.union(AbstractDirectedNetworkConnections.this.inEdgeMap.keySet(), AbstractDirectedNetworkConnections.this.outEdgeMap.keySet());
                return Iterators.unmodifiableIterator(iterable.iterator());
            }

            @Override
            public int size() {
                return IntMath.saturatedAdd((int)AbstractDirectedNetworkConnections.this.inEdgeMap.size(), (int)(AbstractDirectedNetworkConnections.this.outEdgeMap.size() - AbstractDirectedNetworkConnections.this.selfLoopCount));
            }
        };
    }

    @Override
    public Set<E> outEdges() {
        return Collections.unmodifiableSet(this.outEdgeMap.keySet());
    }

    @Override
    public N removeInEdge(E e2, boolean bl) {
        if (bl) {
            int n2;
            this.selfLoopCount = n2 = this.selfLoopCount - 1;
            Graphs.checkNonNegative(n2);
        }
        return Preconditions.checkNotNull(this.inEdgeMap.remove(e2));
    }

    @Override
    public N removeOutEdge(E e2) {
        return Preconditions.checkNotNull(this.outEdgeMap.remove(e2));
    }
}

