/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.BaseGraph;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.EndpointPairIterator;
import com.google.common.math.IntMath;
import com.google.common.primitives.Ints;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class AbstractBaseGraph<N>
implements BaseGraph<N> {
    AbstractBaseGraph() {
    }

    @Override
    public int degree(N n2) {
        if (this.isDirected()) {
            return IntMath.saturatedAdd((int)this.predecessors(n2).size(), (int)this.successors(n2).size());
        }
        Set<N> set = this.adjacentNodes(n2);
        int n3 = this.allowsSelfLoops() && set.contains(n2) ? 1 : 0;
        return IntMath.saturatedAdd((int)set.size(), (int)n3);
    }

    protected long edgeCount() {
        Iterator iterator2 = this.nodes().iterator();
        long l2 = 0L;
        while (iterator2.hasNext()) {
            l2 += (long)this.degree(iterator2.next());
        }
        boolean bl = (1L & l2) == 0L;
        Preconditions.checkState(bl);
        return l2 >>> 1;
    }

    @Override
    public Set<EndpointPair<N>> edges() {
        return new AbstractSet<EndpointPair<N>>(){

            @Override
            public boolean contains(@NullableDecl Object object) {
                boolean bl = object instanceof EndpointPair;
                boolean bl2 = false;
                if (!bl) {
                    return false;
                }
                object = (EndpointPair)object;
                bl = bl2;
                if (AbstractBaseGraph.this.isOrderingCompatible((EndpointPair<?>)object)) {
                    bl = bl2;
                    if (AbstractBaseGraph.this.nodes().contains(((EndpointPair)object).nodeU())) {
                        bl = bl2;
                        if (AbstractBaseGraph.this.successors(((EndpointPair)object).nodeU()).contains(((EndpointPair)object).nodeV())) {
                            bl = true;
                        }
                    }
                }
                return bl;
            }

            @Override
            public UnmodifiableIterator<EndpointPair<N>> iterator() {
                return EndpointPairIterator.of((BaseGraph)AbstractBaseGraph.this);
            }

            @Override
            public boolean remove(Object object) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return Ints.saturatedCast(AbstractBaseGraph.this.edgeCount());
            }
        };
    }

    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
        Preconditions.checkNotNull(endpointPair);
        boolean bl = this.isOrderingCompatible(endpointPair);
        boolean bl2 = false;
        if (!bl) {
            return false;
        }
        N n2 = endpointPair.nodeU();
        endpointPair = endpointPair.nodeV();
        bl = bl2;
        if (this.nodes().contains(n2)) {
            bl = bl2;
            if (this.successors(n2).contains(endpointPair)) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean hasEdgeConnecting(N n2, N n3) {
        Preconditions.checkNotNull(n2);
        Preconditions.checkNotNull(n3);
        boolean bl = this.nodes().contains(n2) && this.successors(n2).contains(n3);
        return bl;
    }

    @Override
    public int inDegree(N n2) {
        int n3 = this.isDirected() ? this.predecessors(n2).size() : this.degree(n2);
        return n3;
    }

    @Override
    public Set<EndpointPair<N>> incidentEdges(N n2) {
        Preconditions.checkNotNull(n2);
        Preconditions.checkArgument(this.nodes().contains(n2), "Node %s is not an element of this graph.", n2);
        return IncidentEdgeSet.of(this, n2);
    }

    protected final boolean isOrderingCompatible(EndpointPair<?> endpointPair) {
        boolean bl = endpointPair.isOrdered() || !this.isDirected();
        return bl;
    }

    @Override
    public int outDegree(N n2) {
        int n3 = this.isDirected() ? this.successors(n2).size() : this.degree(n2);
        return n3;
    }

    protected final void validateEndpoints(EndpointPair<?> endpointPair) {
        Preconditions.checkNotNull(endpointPair);
        Preconditions.checkArgument(this.isOrderingCompatible(endpointPair), "Mismatch: unordered endpoints cannot be used with directed graphs");
    }

    private static abstract class IncidentEdgeSet<N>
    extends AbstractSet<EndpointPair<N>> {
        protected final BaseGraph<N> graph;
        protected final N node;

        private IncidentEdgeSet(BaseGraph<N> baseGraph, N n2) {
            this.graph = baseGraph;
            this.node = n2;
        }

        public static <N> IncidentEdgeSet<N> of(BaseGraph<N> incidentEdgeSet, N n2) {
            incidentEdgeSet = incidentEdgeSet.isDirected() ? new Directed((BaseGraph)((Object)incidentEdgeSet), n2) : new Undirected((BaseGraph)((Object)incidentEdgeSet), n2);
            return incidentEdgeSet;
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        private static final class Directed<N>
        extends IncidentEdgeSet<N> {
            private Directed(BaseGraph<N> baseGraph, N n2) {
                super(baseGraph, n2);
            }

            @Override
            public boolean contains(@NullableDecl Object object) {
                boolean bl;
                block6: {
                    block5: {
                        bl = object instanceof EndpointPair;
                        boolean bl2 = false;
                        if (!bl) {
                            return false;
                        }
                        EndpointPair endpointPair = (EndpointPair)object;
                        if (!endpointPair.isOrdered()) {
                            return false;
                        }
                        object = endpointPair.source();
                        endpointPair = endpointPair.target();
                        if (this.node.equals(object) && this.graph.successors(this.node).contains(endpointPair)) break block5;
                        bl = bl2;
                        if (!this.node.equals(endpointPair)) break block6;
                        bl = bl2;
                        if (!this.graph.predecessors(this.node).contains(object)) break block6;
                    }
                    bl = true;
                }
                return bl;
            }

            @Override
            public UnmodifiableIterator<EndpointPair<N>> iterator() {
                return Iterators.unmodifiableIterator(Iterators.concat(Iterators.transform(this.graph.predecessors(this.node).iterator(), new Function<N, EndpointPair<N>>(){

                    @Override
                    public EndpointPair<N> apply(N n2) {
                        return EndpointPair.ordered(n2, Directed.this.node);
                    }
                }), Iterators.transform(Sets.difference(this.graph.successors(this.node), ImmutableSet.of(this.node)).iterator(), new Function<N, EndpointPair<N>>(){

                    @Override
                    public EndpointPair<N> apply(N n2) {
                        return EndpointPair.ordered(Directed.this.node, n2);
                    }
                })));
            }

            @Override
            public int size() {
                return this.graph.inDegree(this.node) + this.graph.outDegree(this.node) - this.graph.successors(this.node).contains(this.node);
            }
        }

        private static final class Undirected<N>
        extends IncidentEdgeSet<N> {
            private Undirected(BaseGraph<N> baseGraph, N n2) {
                super(baseGraph, n2);
            }

            @Override
            public boolean contains(@NullableDecl Object object) {
                boolean bl;
                block6: {
                    block5: {
                        bl = object instanceof EndpointPair;
                        boolean bl2 = false;
                        if (!bl) {
                            return false;
                        }
                        EndpointPair endpointPair = (EndpointPair)object;
                        if (endpointPair.isOrdered()) {
                            return false;
                        }
                        Set<Object> set = this.graph.adjacentNodes(this.node);
                        object = endpointPair.nodeU();
                        if (this.node.equals(endpointPair = endpointPair.nodeV()) && set.contains(object)) break block5;
                        bl = bl2;
                        if (!this.node.equals(object)) break block6;
                        bl = bl2;
                        if (!set.contains(endpointPair)) break block6;
                    }
                    bl = true;
                }
                return bl;
            }

            @Override
            public UnmodifiableIterator<EndpointPair<N>> iterator() {
                return Iterators.unmodifiableIterator(Iterators.transform(this.graph.adjacentNodes(this.node).iterator(), new Function<N, EndpointPair<N>>(){

                    @Override
                    public EndpointPair<N> apply(N n2) {
                        return EndpointPair.unordered(Undirected.this.node, n2);
                    }
                }));
            }

            @Override
            public int size() {
                return this.graph.adjacentNodes(this.node).size();
            }
        }
    }
}

