/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.eventbus.Subscriber;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class SubscriberRegistry {
    private static final LoadingCache<Class<?>, ImmutableSet<Class<?>>> flattenHierarchyCache;
    private static final LoadingCache<Class<?>, ImmutableList<Method>> subscriberMethodsCache;
    private final EventBus bus;
    private final ConcurrentMap<Class<?>, CopyOnWriteArraySet<Subscriber>> subscribers = Maps.newConcurrentMap();

    static {
        subscriberMethodsCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ImmutableList<Method>>(){

            public ImmutableList<Method> load(Class<?> clazz) throws Exception {
                return SubscriberRegistry.getAnnotatedMethodsNotCached(clazz);
            }
        });
        flattenHierarchyCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ImmutableSet<Class<?>>>(){

            public ImmutableSet<Class<?>> load(Class<?> clazz) {
                return ImmutableSet.copyOf(TypeToken.of(clazz).getTypes().rawTypes());
            }
        });
    }

    SubscriberRegistry(EventBus eventBus) {
        this.bus = Preconditions.checkNotNull(eventBus);
    }

    private Multimap<Class<?>, Subscriber> findAllSubscribers(Object object) {
        HashMultimap<Class<?>, Subscriber> hashMultimap = HashMultimap.create();
        for (Method method : SubscriberRegistry.getAnnotatedMethods(object.getClass())) {
            hashMultimap.put(method.getParameterTypes()[0], Subscriber.create(this.bus, object, method));
        }
        return hashMultimap;
    }

    static ImmutableSet<Class<?>> flattenHierarchy(Class<?> serializable) {
        try {
            serializable = flattenHierarchyCache.getUnchecked((Class<?>)serializable);
            return serializable;
        }
        catch (UncheckedExecutionException uncheckedExecutionException) {
            throw Throwables.propagate(uncheckedExecutionException.getCause());
        }
    }

    private static ImmutableList<Method> getAnnotatedMethods(Class<?> clazz) {
        return subscriberMethodsCache.getUnchecked(clazz);
    }

    private static ImmutableList<Method> getAnnotatedMethodsNotCached(Class<?> serializable) {
        Set object2 = TypeToken.of(serializable).getTypes().rawTypes();
        serializable = Maps.newHashMap();
        Iterator iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            for (Method method : iterator2.next().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Subscribe.class) || method.isSynthetic()) continue;
                Object object = method.getParameterTypes();
                int n2 = ((Class<?>[])object).length;
                boolean bl = true;
                if (n2 != 1) {
                    bl = false;
                }
                Preconditions.checkArgument(bl, "Method %s has @Subscribe annotation but has %s parameters.Subscriber methods must have exactly 1 parameter.", (Object)method, ((Class<?>[])object).length);
                object = new MethodIdentifier(method);
                if (serializable.containsKey(object)) continue;
                serializable.put(object, method);
            }
        }
        return ImmutableList.copyOf(serializable.values());
    }

    Iterator<Subscriber> getSubscribers(Object arrayList) {
        Object object = SubscriberRegistry.flattenHierarchy(arrayList.getClass());
        arrayList = Lists.newArrayListWithCapacity(((AbstractCollection)object).size());
        object = ((ImmutableSet)object).iterator();
        while (object.hasNext()) {
            Serializable serializable = (Class)object.next();
            if ((serializable = (CopyOnWriteArraySet)this.subscribers.get(serializable)) == null) continue;
            arrayList.add(((CopyOnWriteArraySet)serializable).iterator());
        }
        return Iterators.concat(arrayList.iterator());
    }

    Set<Subscriber> getSubscribersForTesting(Class<?> clazz) {
        return MoreObjects.firstNonNull(this.subscribers.get(clazz), ImmutableSet.of());
    }

    /*
     * WARNING - void declaration
     */
    void register(Object copyOnWriteArraySet2) {
        for (Map.Entry<Class<?>, Collection<Subscriber>> entry : this.findAllSubscribers(copyOnWriteArraySet2).asMap().entrySet()) {
            void var1_7;
            CopyOnWriteArraySet copyOnWriteArraySet;
            Class<?> clazz = entry.getKey();
            Collection<Subscriber> collection = entry.getValue();
            CopyOnWriteArraySet copyOnWriteArraySet3 = copyOnWriteArraySet = (CopyOnWriteArraySet)this.subscribers.get(clazz);
            if (copyOnWriteArraySet == null) {
                CopyOnWriteArraySet copyOnWriteArraySet5 = new CopyOnWriteArraySet();
                copyOnWriteArraySet5 = MoreObjects.firstNonNull(this.subscribers.putIfAbsent(clazz, copyOnWriteArraySet5), copyOnWriteArraySet5);
            }
            var1_7.addAll(collection);
        }
    }

    void unregister(Object object) {
        Object object2 = this.findAllSubscribers(object).asMap().entrySet().iterator();
        while (object2.hasNext()) {
            Object object3 = object2.next();
            Serializable serializable = object3.getKey();
            object3 = object3.getValue();
            if ((serializable = (CopyOnWriteArraySet)this.subscribers.get(serializable)) != null && ((CopyOnWriteArraySet)serializable).removeAll((Collection<?>)object3)) continue;
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("missing event subscriber for an annotated method. Is ");
            ((StringBuilder)object2).append(object);
            ((StringBuilder)object2).append(" registered?");
            throw new IllegalArgumentException(((StringBuilder)object2).toString());
        }
    }

    private static final class MethodIdentifier {
        private final String name;
        private final List<Class<?>> parameterTypes;

        MethodIdentifier(Method method) {
            this.name = method.getName();
            this.parameterTypes = Arrays.asList(method.getParameterTypes());
        }

        public boolean equals(@NullableDecl Object object) {
            boolean bl;
            boolean bl2 = object instanceof MethodIdentifier;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (MethodIdentifier)object;
                bl3 = bl;
                if (this.name.equals(((MethodIdentifier)object).name)) {
                    bl3 = bl;
                    if (this.parameterTypes.equals(((MethodIdentifier)object).parameterTypes)) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        public int hashCode() {
            return Objects.hashCode(this.name, this.parameterTypes);
        }
    }
}

