/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.base.Preconditions;
import com.google.common.escape.Escaper;
import com.google.common.escape.Platform;

public abstract class UnicodeEscaper
extends Escaper {
    private static final int DEST_PAD = 32;

    protected UnicodeEscaper() {
    }

    protected static int codePointAt(CharSequence charSequence, int n2, int n3) {
        Preconditions.checkNotNull(charSequence);
        if (n2 < n3) {
            int n4 = n2 + 1;
            char c2 = charSequence.charAt(n2);
            if (c2 >= '\ud800' && c2 <= '\udfff') {
                if (c2 <= '\udbff') {
                    if (n4 == n3) {
                        return -c2;
                    }
                    char c3 = charSequence.charAt(n4);
                    if (Character.isLowSurrogate(c3)) {
                        return Character.toCodePoint(c2, c3);
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Expected low surrogate but got char '");
                    stringBuilder.append(c3);
                    stringBuilder.append("' with value ");
                    stringBuilder.append((int)c3);
                    stringBuilder.append(" at index ");
                    stringBuilder.append(n4);
                    stringBuilder.append(" in '");
                    stringBuilder.append((Object)charSequence);
                    stringBuilder.append("'");
                    throw new IllegalArgumentException(stringBuilder.toString());
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Unexpected low surrogate character '");
                stringBuilder.append(c2);
                stringBuilder.append("' with value ");
                stringBuilder.append((int)c2);
                stringBuilder.append(" at index ");
                stringBuilder.append(n4 - 1);
                stringBuilder.append(" in '");
                stringBuilder.append((Object)charSequence);
                stringBuilder.append("'");
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            return c2;
        }
        throw new IndexOutOfBoundsException("Index exceeds specified range");
    }

    private static char[] growBuffer(char[] cArray, int n2, int n3) {
        if (n3 >= 0) {
            char[] cArray2 = new char[n3];
            if (n2 > 0) {
                System.arraycopy(cArray, 0, cArray2, 0, n2);
            }
            return cArray2;
        }
        throw new AssertionError((Object)"Cannot increase internal buffer any further");
    }

    @Override
    public String escape(String string2) {
        Preconditions.checkNotNull(string2);
        int n2 = string2.length();
        int n3 = this.nextEscapeIndex(string2, 0, n2);
        if (n3 != n2) {
            string2 = this.escapeSlow(string2, n3);
        }
        return string2;
    }

    protected abstract char[] escape(int var1);

    protected final String escapeSlow(String string2, int n2) {
        char[] cArray;
        int n3 = string2.length();
        char[] cArray2 = Platform.charBufferFromThreadLocal();
        int n4 = 0;
        int n5 = 0;
        int n6 = n2;
        n2 = n5;
        while (n6 < n3) {
            n5 = UnicodeEscaper.codePointAt(string2, n6, n3);
            if (n5 >= 0) {
                char[] cArray3 = this.escape(n5);
                n5 = Character.isSupplementaryCodePoint(n5) ? 2 : 1;
                int n7 = n5 + n6;
                int n8 = n4;
                n5 = n2;
                cArray = cArray2;
                if (cArray3 != null) {
                    int n9 = n6 - n4;
                    n8 = n2 + n9;
                    n5 = cArray3.length + n8;
                    cArray = cArray2;
                    if (cArray2.length < n5) {
                        cArray = UnicodeEscaper.growBuffer(cArray2, n2, n5 + (n3 - n6) + 32);
                    }
                    n5 = n2;
                    if (n9 > 0) {
                        string2.getChars(n4, n6, cArray, n2);
                        n5 = n8;
                    }
                    n2 = n5;
                    if (cArray3.length > 0) {
                        System.arraycopy(cArray3, 0, cArray, n5, cArray3.length);
                        n2 = n5 + cArray3.length;
                    }
                    n8 = n7;
                    n5 = n2;
                }
                n6 = this.nextEscapeIndex(string2, n7, n3);
                n4 = n8;
                n2 = n5;
                cArray2 = cArray;
                continue;
            }
            throw new IllegalArgumentException("Trailing high surrogate at end of input");
        }
        n5 = n3 - n4;
        if (n5 > 0) {
            cArray = cArray2;
            if (cArray2.length < (n5 += n2)) {
                cArray = UnicodeEscaper.growBuffer(cArray2, n2, n5);
            }
            string2.getChars(n4, n3, cArray, n2);
            cArray2 = cArray;
            n2 = n5;
        }
        return new String(cArray2, 0, n2);
    }

    protected int nextEscapeIndex(CharSequence charSequence, int n2, int n3) {
        int n4;
        while (n2 < n3 && (n4 = UnicodeEscaper.codePointAt(charSequence, n2, n3)) >= 0 && this.escape(n4) == null) {
            n4 = Character.isSupplementaryCodePoint(n4) ? 2 : 1;
            n2 += n4;
        }
        return n2;
    }
}

