/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.base.Preconditions;
import com.google.common.escape.ArrayBasedCharEscaper;
import com.google.common.escape.CharEscaper;
import com.google.common.escape.Escaper;
import com.google.common.escape.UnicodeEscaper;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Escapers {
    private static final Escaper NULL_ESCAPER = new CharEscaper(){

        public String escape(String string2) {
            return Preconditions.checkNotNull(string2);
        }

        protected char[] escape(char c2) {
            return null;
        }
    };

    private Escapers() {
    }

    static UnicodeEscaper asUnicodeEscaper(Escaper escaper) {
        Preconditions.checkNotNull(escaper);
        if (escaper instanceof UnicodeEscaper) {
            return (UnicodeEscaper)escaper;
        }
        if (escaper instanceof CharEscaper) {
            return Escapers.wrap((CharEscaper)escaper);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot create a UnicodeEscaper from: ");
        stringBuilder.append(escaper.getClass().getName());
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static String computeReplacement(CharEscaper charEscaper, char c2) {
        return Escapers.stringOrNull(charEscaper.escape(c2));
    }

    public static String computeReplacement(UnicodeEscaper unicodeEscaper, int n2) {
        return Escapers.stringOrNull(unicodeEscaper.escape(n2));
    }

    public static Escaper nullEscaper() {
        return NULL_ESCAPER;
    }

    private static String stringOrNull(char[] object) {
        object = object == null ? null : (Object)new String((char[])object);
        return object;
    }

    private static UnicodeEscaper wrap(final CharEscaper charEscaper) {
        return new UnicodeEscaper(){

            @Override
            protected char[] escape(int n2) {
                if (n2 < 65536) {
                    return charEscaper.escape((char)n2);
                }
                char[] cArray = new char[2];
                int n3 = 0;
                Character.toChars(n2, cArray, 0);
                char[] cArray2 = charEscaper.escape(cArray[0]);
                char[] cArray3 = charEscaper.escape(cArray[1]);
                if (cArray2 == null && cArray3 == null) {
                    return null;
                }
                n2 = cArray2 != null ? cArray2.length : 1;
                int n4 = cArray3 != null ? cArray3.length : 1;
                char[] cArray4 = new char[n4 + n2];
                if (cArray2 != null) {
                    for (n4 = 0; n4 < cArray2.length; ++n4) {
                        cArray4[n4] = cArray2[n4];
                    }
                } else {
                    cArray4[0] = cArray[0];
                }
                if (cArray3 != null) {
                    for (n4 = n3; n4 < cArray3.length; ++n4) {
                        cArray4[n2 + n4] = cArray3[n4];
                    }
                } else {
                    cArray4[n2] = cArray[1];
                }
                return cArray4;
            }
        };
    }

    public static final class Builder {
        private final Map<Character, String> replacementMap = new HashMap<Character, String>();
        private char safeMax;
        private char safeMin = (char)0;
        private String unsafeReplacement = null;

        private Builder() {
            this.safeMax = (char)65535;
        }

        public Builder addEscape(char c2, String string2) {
            Preconditions.checkNotNull(string2);
            this.replacementMap.put(Character.valueOf(c2), string2);
            return this;
        }

        public Escaper build() {
            return new ArrayBasedCharEscaper(this.replacementMap, this.safeMin, this.safeMax){
                private final char[] replacementChars;
                {
                    Builder.this = Builder.this.unsafeReplacement != null ? (Object)Builder.this.unsafeReplacement.toCharArray() : null;
                    this.replacementChars = (char[])Builder.this;
                }

                protected char[] escapeUnsafe(char c2) {
                    return this.replacementChars;
                }
            };
        }

        public Builder setSafeRange(char c2, char c3) {
            this.safeMin = c2;
            this.safeMax = c3;
            return this;
        }

        public Builder setUnsafeReplacement(@NullableDecl String string2) {
            this.unsafeReplacement = string2;
            return this;
        }
    }
}

