/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.base.Preconditions;
import com.google.common.escape.CharEscaper;
import com.google.common.escape.Escaper;
import java.util.HashMap;
import java.util.Map;

public final class CharEscaperBuilder {
    private final Map<Character, String> map = new HashMap<Character, String>();
    private int max = -1;

    public CharEscaperBuilder addEscape(char c2, String string2) {
        this.map.put(Character.valueOf(c2), Preconditions.checkNotNull(string2));
        if (c2 > this.max) {
            this.max = c2;
        }
        return this;
    }

    public CharEscaperBuilder addEscapes(char[] cArray, String string2) {
        Preconditions.checkNotNull(string2);
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addEscape(cArray[i2], string2);
        }
        return this;
    }

    public char[][] toArray() {
        char[][] cArrayArray = new char[this.max + 1][];
        for (Map.Entry<Character, String> entry : this.map.entrySet()) {
            cArrayArray[entry.getKey().charValue()] = entry.getValue().toCharArray();
        }
        return cArrayArray;
    }

    public Escaper toEscaper() {
        return new CharArrayDecorator(this.toArray());
    }

    private static class CharArrayDecorator
    extends CharEscaper {
        private final int replaceLength;
        private final char[][] replacements;

        CharArrayDecorator(char[][] cArray) {
            this.replacements = cArray;
            this.replaceLength = cArray.length;
        }

        public String escape(String string2) {
            int n2 = string2.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char[][] cArray;
                char c2 = string2.charAt(i2);
                if (c2 >= (cArray = this.replacements).length || cArray[c2] == null) continue;
                return this.escapeSlow(string2, i2);
            }
            return string2;
        }

        protected char[] escape(char c2) {
            char[] cArray = c2 < this.replaceLength ? this.replacements[c2] : null;
            return cArray;
        }
    }
}

