/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.base.Preconditions;
import com.google.common.escape.ArrayBasedEscaperMap;
import com.google.common.escape.UnicodeEscaper;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ArrayBasedUnicodeEscaper
extends UnicodeEscaper {
    private final char[][] replacements;
    private final int replacementsLength;
    private final int safeMax;
    private final char safeMaxChar;
    private final int safeMin;
    private final char safeMinChar;

    protected ArrayBasedUnicodeEscaper(ArrayBasedEscaperMap arrayBasedEscaperMap, int n2, int n3, @NullableDecl String string2) {
        Preconditions.checkNotNull(arrayBasedEscaperMap);
        this.replacements = arrayBasedEscaperMap.getReplacementArray();
        this.replacementsLength = this.replacements.length;
        int n4 = n2;
        int n5 = n3;
        if (n3 < n2) {
            n5 = -1;
            n4 = Integer.MAX_VALUE;
        }
        this.safeMin = n4;
        this.safeMax = n5;
        if (n4 >= 55296) {
            this.safeMinChar = (char)65535;
            this.safeMaxChar = (char)0;
        } else {
            this.safeMinChar = (char)n4;
            this.safeMaxChar = (char)Math.min(n5, 55295);
        }
    }

    protected ArrayBasedUnicodeEscaper(Map<Character, String> map, int n2, int n3, @NullableDecl String string2) {
        this(ArrayBasedEscaperMap.create(map), n2, n3, string2);
    }

    @Override
    public final String escape(String string2) {
        String string3;
        block1: {
            Preconditions.checkNotNull(string2);
            int n2 = 0;
            while (true) {
                string3 = string2;
                if (n2 >= string2.length()) break block1;
                char c2 = string2.charAt(n2);
                if (c2 < this.replacementsLength && this.replacements[c2] != null || c2 > this.safeMaxChar || c2 < this.safeMinChar) break;
                ++n2;
            }
            string3 = this.escapeSlow(string2, n2);
        }
        return string3;
    }

    @Override
    protected final char[] escape(int n2) {
        char[] cArray;
        if (n2 < this.replacementsLength && (cArray = this.replacements[n2]) != null) {
            return cArray;
        }
        if (n2 >= this.safeMin && n2 <= this.safeMax) {
            return null;
        }
        return this.escapeUnsafe(n2);
    }

    protected abstract char[] escapeUnsafe(int var1);

    @Override
    protected final int nextEscapeIndex(CharSequence charSequence, int n2, int n3) {
        char c2;
        while (n2 < n3 && ((c2 = charSequence.charAt(n2)) >= this.replacementsLength || this.replacements[c2] == null) && c2 <= this.safeMaxChar && c2 >= this.safeMinChar) {
            ++n2;
        }
        return n2;
    }
}

