/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.Cut;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class TreeRangeMap<K extends Comparable, V>
implements RangeMap<K, V> {
    private static final RangeMap EMPTY_SUB_RANGE_MAP = new RangeMap(){

        public Map<Range, Object> asDescendingMapOfRanges() {
            return Collections.emptyMap();
        }

        public Map<Range, Object> asMapOfRanges() {
            return Collections.emptyMap();
        }

        @Override
        public void clear() {
        }

        @NullableDecl
        public Object get(Comparable comparable) {
            return null;
        }

        @NullableDecl
        public Map.Entry<Range, Object> getEntry(Comparable comparable) {
            return null;
        }

        public void put(Range range, Object object) {
            Preconditions.checkNotNull(range);
            object = new StringBuilder();
            ((StringBuilder)object).append("Cannot insert range ");
            ((StringBuilder)object).append(range);
            ((StringBuilder)object).append(" into an empty subRangeMap");
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }

        public void putAll(RangeMap rangeMap) {
            if (rangeMap.asMapOfRanges().isEmpty()) {
                return;
            }
            throw new IllegalArgumentException("Cannot putAll(nonEmptyRangeMap) into an empty subRangeMap");
        }

        public void putCoalescing(Range range, Object object) {
            Preconditions.checkNotNull(range);
            object = new StringBuilder();
            ((StringBuilder)object).append("Cannot insert range ");
            ((StringBuilder)object).append(range);
            ((StringBuilder)object).append(" into an empty subRangeMap");
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }

        public void remove(Range range) {
            Preconditions.checkNotNull(range);
        }

        public Range span() {
            throw new NoSuchElementException();
        }

        public RangeMap subRangeMap(Range range) {
            Preconditions.checkNotNull(range);
            return this;
        }
    };
    private final NavigableMap<Cut<K>, RangeMapEntry<K, V>> entriesByLowerBound = Maps.newTreeMap();

    private TreeRangeMap() {
    }

    private static <K extends Comparable, V> Range<K> coalesce(Range<K> range, V v2, @NullableDecl Map.Entry<Cut<K>, RangeMapEntry<K, V>> entry) {
        Range<K> range2 = range;
        if (entry != null) {
            range2 = range;
            if (((Range)entry.getValue().getKey()).isConnected(range)) {
                range2 = range;
                if (entry.getValue().getValue().equals(v2)) {
                    range2 = range.span((Range<K>)entry.getValue().getKey());
                }
            }
        }
        return range2;
    }

    private Range<K> coalescedRange(Range<K> range, V v2) {
        return TreeRangeMap.coalesce(TreeRangeMap.coalesce(range, v2, this.entriesByLowerBound.lowerEntry(range.lowerBound)), v2, this.entriesByLowerBound.floorEntry(range.upperBound));
    }

    public static <K extends Comparable, V> TreeRangeMap<K, V> create() {
        return new TreeRangeMap<K, V>();
    }

    private RangeMap<K, V> emptySubRangeMap() {
        return EMPTY_SUB_RANGE_MAP;
    }

    private void putRangeMapEntry(Cut<K> cut, Cut<K> cut2, V v2) {
        this.entriesByLowerBound.put(cut, new RangeMapEntry<K, V>(cut, cut2, v2));
    }

    @Override
    public Map<Range<K>, V> asDescendingMapOfRanges() {
        return new AsMapOfRanges(this.entriesByLowerBound.descendingMap().values());
    }

    @Override
    public Map<Range<K>, V> asMapOfRanges() {
        return new AsMapOfRanges(this.entriesByLowerBound.values());
    }

    @Override
    public void clear() {
        this.entriesByLowerBound.clear();
    }

    @Override
    public boolean equals(@NullableDecl Object object) {
        if (object instanceof RangeMap) {
            object = (RangeMap)object;
            return this.asMapOfRanges().equals(object.asMapOfRanges());
        }
        return false;
    }

    @Override
    @NullableDecl
    public V get(K object) {
        object = (object = this.getEntry(object)) == null ? null : object.getValue();
        return (V)object;
    }

    @Override
    @NullableDecl
    public Map.Entry<Range<K>, V> getEntry(K k2) {
        Map.Entry<Cut<K>, RangeMapEntry<K, V>> entry = this.entriesByLowerBound.floorEntry(Cut.belowValue(k2));
        if (entry != null && entry.getValue().contains(k2)) {
            return entry.getValue();
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.asMapOfRanges().hashCode();
    }

    @Override
    public void put(Range<K> range, V v2) {
        if (!range.isEmpty()) {
            Preconditions.checkNotNull(v2);
            this.remove(range);
            this.entriesByLowerBound.put(range.lowerBound, new RangeMapEntry<K, V>(range, v2));
        }
    }

    @Override
    public void putAll(RangeMap<K, V> object) {
        for (Map.Entry entry : object.asMapOfRanges().entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putCoalescing(Range<K> range, V v2) {
        if (this.entriesByLowerBound.isEmpty()) {
            this.put(range, v2);
            return;
        }
        this.put(this.coalescedRange(range, Preconditions.checkNotNull(v2)), v2);
    }

    @Override
    public void remove(Range<K> range) {
        RangeMapEntry<K, V> rangeMapEntry;
        if (range.isEmpty()) {
            return;
        }
        Map.Entry entry = this.entriesByLowerBound.lowerEntry(range.lowerBound);
        if (entry != null && (rangeMapEntry = entry.getValue()).getUpperBound().compareTo(range.lowerBound) > 0) {
            if (rangeMapEntry.getUpperBound().compareTo(range.upperBound) > 0) {
                this.putRangeMapEntry(range.upperBound, rangeMapEntry.getUpperBound(), entry.getValue().getValue());
            }
            this.putRangeMapEntry(rangeMapEntry.getLowerBound(), range.lowerBound, entry.getValue().getValue());
        }
        if ((entry = this.entriesByLowerBound.lowerEntry(range.upperBound)) != null && (rangeMapEntry = entry.getValue()).getUpperBound().compareTo(range.upperBound) > 0) {
            this.putRangeMapEntry(range.upperBound, rangeMapEntry.getUpperBound(), entry.getValue().getValue());
        }
        this.entriesByLowerBound.subMap(range.lowerBound, range.upperBound).clear();
    }

    @Override
    public Range<K> span() {
        Map.Entry<Cut<K>, RangeMapEntry<K, V>> entry = this.entriesByLowerBound.firstEntry();
        Map.Entry<Cut<K>, RangeMapEntry<K, V>> entry2 = this.entriesByLowerBound.lastEntry();
        if (entry != null) {
            return Range.create(((Range)entry.getValue().getKey()).lowerBound, ((Range)entry2.getValue().getKey()).upperBound);
        }
        throw new NoSuchElementException();
    }

    @Override
    public RangeMap<K, V> subRangeMap(Range<K> range) {
        if (range.equals(Range.all())) {
            return this;
        }
        return new SubRangeMap(range);
    }

    @Override
    public String toString() {
        return this.entriesByLowerBound.values().toString();
    }

    private final class AsMapOfRanges
    extends Maps.IteratorBasedAbstractMap<Range<K>, V> {
        final Iterable<Map.Entry<Range<K>, V>> entryIterable;

        AsMapOfRanges(Iterable<RangeMapEntry<K, V>> iterable) {
            this.entryIterable = iterable;
        }

        @Override
        public boolean containsKey(@NullableDecl Object object) {
            boolean bl = this.get(object) != null;
            return bl;
        }

        @Override
        Iterator<Map.Entry<Range<K>, V>> entryIterator() {
            return this.entryIterable.iterator();
        }

        @Override
        public V get(@NullableDecl Object object) {
            if (object instanceof Range) {
                object = (Range)object;
                RangeMapEntry rangeMapEntry = (RangeMapEntry)TreeRangeMap.this.entriesByLowerBound.get(((Range)object).lowerBound);
                if (rangeMapEntry != null && ((Range)rangeMapEntry.getKey()).equals(object)) {
                    return rangeMapEntry.getValue();
                }
            }
            return null;
        }

        @Override
        public int size() {
            return TreeRangeMap.this.entriesByLowerBound.size();
        }
    }

    private static final class RangeMapEntry<K extends Comparable, V>
    extends AbstractMapEntry<Range<K>, V> {
        private final Range<K> range;
        private final V value;

        RangeMapEntry(Cut<K> cut, Cut<K> cut2, V v2) {
            this(Range.create(cut, cut2), v2);
        }

        RangeMapEntry(Range<K> range, V v2) {
            this.range = range;
            this.value = v2;
        }

        public boolean contains(K k2) {
            return this.range.contains(k2);
        }

        @Override
        public Range<K> getKey() {
            return this.range;
        }

        Cut<K> getLowerBound() {
            return this.range.lowerBound;
        }

        Cut<K> getUpperBound() {
            return this.range.upperBound;
        }

        @Override
        public V getValue() {
            return this.value;
        }
    }

    private class SubRangeMap
    implements RangeMap<K, V> {
        private final Range<K> subRange;

        SubRangeMap(Range<K> range) {
            this.subRange = range;
        }

        @Override
        public Map<Range<K>, V> asDescendingMapOfRanges() {
            return new SubRangeMapAsMap(){

                @Override
                Iterator<Map.Entry<Range<K>, V>> entryIterator() {
                    if (SubRangeMap.this.subRange.isEmpty()) {
                        return Iterators.emptyIterator();
                    }
                    return new AbstractIterator<Map.Entry<Range<K>, V>>(TreeRangeMap.this.entriesByLowerBound.headMap(((SubRangeMap)SubRangeMap.this).subRange.upperBound, false).descendingMap().values().iterator()){
                        final /* synthetic */ Iterator val$backingItr;
                        {
                            this.val$backingItr = iterator2;
                        }

                        @Override
                        protected Map.Entry<Range<K>, V> computeNext() {
                            if (this.val$backingItr.hasNext()) {
                                RangeMapEntry rangeMapEntry = (RangeMapEntry)this.val$backingItr.next();
                                if (rangeMapEntry.getUpperBound().compareTo(((SubRangeMap)SubRangeMap.this).subRange.lowerBound) <= 0) {
                                    return (Map.Entry)this.endOfData();
                                }
                                return Maps.immutableEntry(((Range)rangeMapEntry.getKey()).intersection(SubRangeMap.this.subRange), rangeMapEntry.getValue());
                            }
                            return (Map.Entry)this.endOfData();
                        }
                    };
                }
            };
        }

        @Override
        public Map<Range<K>, V> asMapOfRanges() {
            return new SubRangeMapAsMap();
        }

        @Override
        public void clear() {
            TreeRangeMap.this.remove(this.subRange);
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof RangeMap) {
                object = (RangeMap)object;
                return this.asMapOfRanges().equals(object.asMapOfRanges());
            }
            return false;
        }

        @Override
        @NullableDecl
        public V get(K object) {
            object = this.subRange.contains(object) ? TreeRangeMap.this.get(object) : null;
            return object;
        }

        @Override
        @NullableDecl
        public Map.Entry<Range<K>, V> getEntry(K object) {
            if (this.subRange.contains(object) && (object = TreeRangeMap.this.getEntry(object)) != null) {
                return Maps.immutableEntry(((Range)object.getKey()).intersection(this.subRange), object.getValue());
            }
            return null;
        }

        @Override
        public int hashCode() {
            return this.asMapOfRanges().hashCode();
        }

        @Override
        public void put(Range<K> range, V v2) {
            Preconditions.checkArgument(this.subRange.encloses(range), "Cannot put range %s into a subRangeMap(%s)", range, this.subRange);
            TreeRangeMap.this.put(range, v2);
        }

        @Override
        public void putAll(RangeMap<K, V> rangeMap) {
            if (rangeMap.asMapOfRanges().isEmpty()) {
                return;
            }
            Range range = rangeMap.span();
            Preconditions.checkArgument(this.subRange.encloses(range), "Cannot putAll rangeMap with span %s into a subRangeMap(%s)", range, this.subRange);
            TreeRangeMap.this.putAll(rangeMap);
        }

        @Override
        public void putCoalescing(Range<K> range, V v2) {
            if (!TreeRangeMap.this.entriesByLowerBound.isEmpty() && !range.isEmpty() && this.subRange.encloses(range)) {
                this.put(TreeRangeMap.this.coalescedRange(range, Preconditions.checkNotNull(v2)).intersection(this.subRange), v2);
                return;
            }
            this.put(range, v2);
        }

        @Override
        public void remove(Range<K> range) {
            if (range.isConnected(this.subRange)) {
                TreeRangeMap.this.remove(range.intersection(this.subRange));
            }
        }

        @Override
        public Range<K> span() {
            block6: {
                Cut cut;
                block5: {
                    block4: {
                        cut = TreeRangeMap.this.entriesByLowerBound.floorEntry(this.subRange.lowerBound);
                        if (cut == null || ((RangeMapEntry)cut.getValue()).getUpperBound().compareTo(this.subRange.lowerBound) <= 0) break block4;
                        cut = this.subRange.lowerBound;
                        break block5;
                    }
                    cut = TreeRangeMap.this.entriesByLowerBound.ceilingKey(this.subRange.lowerBound);
                    if (cut == null || cut.compareTo(this.subRange.upperBound) >= 0) break block6;
                }
                Cut<Object> cut2 = TreeRangeMap.this.entriesByLowerBound.lowerEntry(this.subRange.upperBound);
                if (cut2 != null) {
                    cut2 = ((RangeMapEntry)cut2.getValue()).getUpperBound().compareTo(this.subRange.upperBound) >= 0 ? this.subRange.upperBound : ((RangeMapEntry)cut2.getValue()).getUpperBound();
                    return Range.create(cut, cut2);
                }
                throw new NoSuchElementException();
            }
            throw new NoSuchElementException();
        }

        @Override
        public RangeMap<K, V> subRangeMap(Range<K> range) {
            if (!range.isConnected(this.subRange)) {
                return TreeRangeMap.this.emptySubRangeMap();
            }
            return TreeRangeMap.this.subRangeMap(range.intersection(this.subRange));
        }

        @Override
        public String toString() {
            return this.asMapOfRanges().toString();
        }

        class SubRangeMapAsMap
        extends AbstractMap<Range<K>, V> {
            SubRangeMapAsMap() {
            }

            private boolean removeEntryIf(Predicate<? super Map.Entry<Range<K>, V>> range22) {
                ArrayList<Range> arrayList = Lists.newArrayList();
                for (Map.Entry entry : this.entrySet()) {
                    if (!range22.apply(entry)) continue;
                    arrayList.add((Range)entry.getKey());
                }
                for (Range range22 : arrayList) {
                    TreeRangeMap.this.remove(range22);
                }
                return arrayList.isEmpty() ^ true;
            }

            @Override
            public void clear() {
                SubRangeMap.this.clear();
            }

            @Override
            public boolean containsKey(Object object) {
                boolean bl = this.get(object) != null;
                return bl;
            }

            Iterator<Map.Entry<Range<K>, V>> entryIterator() {
                if (SubRangeMap.this.subRange.isEmpty()) {
                    return Iterators.emptyIterator();
                }
                Cut cut = MoreObjects.firstNonNull(TreeRangeMap.this.entriesByLowerBound.floorKey(((SubRangeMap)SubRangeMap.this).subRange.lowerBound), ((SubRangeMap)SubRangeMap.this).subRange.lowerBound);
                return new AbstractIterator<Map.Entry<Range<K>, V>>(TreeRangeMap.this.entriesByLowerBound.tailMap(cut, true).values().iterator()){
                    final /* synthetic */ Iterator val$backingItr;
                    {
                        this.val$backingItr = iterator2;
                    }

                    @Override
                    protected Map.Entry<Range<K>, V> computeNext() {
                        while (this.val$backingItr.hasNext()) {
                            RangeMapEntry rangeMapEntry = (RangeMapEntry)this.val$backingItr.next();
                            if (rangeMapEntry.getLowerBound().compareTo(((SubRangeMap)SubRangeMap.this).subRange.upperBound) >= 0) {
                                return (Map.Entry)this.endOfData();
                            }
                            if (rangeMapEntry.getUpperBound().compareTo(((SubRangeMap)SubRangeMap.this).subRange.lowerBound) <= 0) continue;
                            return Maps.immutableEntry(((Range)rangeMapEntry.getKey()).intersection(SubRangeMap.this.subRange), rangeMapEntry.getValue());
                        }
                        return (Map.Entry)this.endOfData();
                    }
                };
            }

            @Override
            public Set<Map.Entry<Range<K>, V>> entrySet() {
                return new Maps.EntrySet<Range<K>, V>(){

                    @Override
                    public boolean isEmpty() {
                        return this.iterator().hasNext() ^ true;
                    }

                    @Override
                    public Iterator<Map.Entry<Range<K>, V>> iterator() {
                        return SubRangeMapAsMap.this.entryIterator();
                    }

                    @Override
                    Map<Range<K>, V> map() {
                        return SubRangeMapAsMap.this;
                    }

                    @Override
                    public boolean retainAll(Collection<?> collection) {
                        return SubRangeMapAsMap.this.removeEntryIf(Predicates.not(Predicates.in(collection)));
                    }

                    @Override
                    public int size() {
                        return Iterators.size(this.iterator());
                    }
                };
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public V get(Object rangeMapEntry) {
                block7: {
                    void var1_6;
                    Range range;
                    block10: {
                        block8: {
                            block9: {
                                Map.Entry entry;
                                try {
                                    if (!(rangeMapEntry instanceof Range)) break block7;
                                    range = (Range)((Object)rangeMapEntry);
                                    if (!SubRangeMap.this.subRange.encloses(range) || range.isEmpty()) break block7;
                                    if (range.lowerBound.compareTo(((SubRangeMap)SubRangeMap.this).subRange.lowerBound) != 0) break block8;
                                    entry = TreeRangeMap.this.entriesByLowerBound.floorEntry(range.lowerBound);
                                    if (entry == null) break block9;
                                }
                                catch (ClassCastException classCastException) {
                                    return null;
                                }
                                RangeMapEntry rangeMapEntry2 = (RangeMapEntry)entry.getValue();
                                break block10;
                            }
                            Object var1_4 = null;
                            break block10;
                        }
                        RangeMapEntry rangeMapEntry3 = (RangeMapEntry)TreeRangeMap.this.entriesByLowerBound.get(range.lowerBound);
                    }
                    if (var1_6 != null) {
                        if (!((Range)var1_6.getKey()).isConnected(SubRangeMap.this.subRange) || !((Range)var1_6.getKey()).intersection(SubRangeMap.this.subRange).equals(range)) break block7;
                        Object v2 = var1_6.getValue();
                        return v2;
                    }
                }
                return null;
            }

            @Override
            public Set<Range<K>> keySet() {
                return new Maps.KeySet<Range<K>, V>(this){

                    @Override
                    public boolean remove(@NullableDecl Object object) {
                        boolean bl = SubRangeMapAsMap.this.remove(object) != null;
                        return bl;
                    }

                    @Override
                    public boolean retainAll(Collection<?> collection) {
                        return SubRangeMapAsMap.this.removeEntryIf(Predicates.compose(Predicates.not(Predicates.in(collection)), Maps.keyFunction()));
                    }
                };
            }

            @Override
            public V remove(Object object) {
                Object v2 = this.get(object);
                if (v2 != null) {
                    object = (Range)object;
                    TreeRangeMap.this.remove(object);
                    return v2;
                }
                return null;
            }

            @Override
            public Collection<V> values() {
                return new Maps.Values<Range<K>, V>(this){

                    @Override
                    public boolean removeAll(Collection<?> collection) {
                        return SubRangeMapAsMap.this.removeEntryIf(Predicates.compose(Predicates.in(collection), Maps.valueFunction()));
                    }

                    @Override
                    public boolean retainAll(Collection<?> collection) {
                        return SubRangeMapAsMap.this.removeEntryIf(Predicates.compose(Predicates.not(Predicates.in(collection)), Maps.valueFunction()));
                    }
                };
            }
        }
    }
}

