/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractSortedMultiset;
import com.google.common.collect.BoundType;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.GeneralRange;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.Serialization;
import com.google.common.collect.SortedMultiset;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class TreeMultiset<E>
extends AbstractSortedMultiset<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient AvlNode<E> header;
    private final transient GeneralRange<E> range;
    private final transient Reference<AvlNode<E>> rootReference;

    TreeMultiset(Reference<AvlNode<E>> reference, GeneralRange<E> generalRange, AvlNode<E> avlNode) {
        super(generalRange.comparator());
        this.rootReference = reference;
        this.range = generalRange;
        this.header = avlNode;
    }

    TreeMultiset(Comparator<? super E> object) {
        super(object);
        this.range = GeneralRange.all(object);
        this.header = new AvlNode<Object>(null, 1);
        object = this.header;
        TreeMultiset.successor(object, object);
        this.rootReference = new Reference();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long aggregateAboveRange(Aggregate aggregate, @NullableDecl AvlNode<E> avlNode) {
        long l2;
        long l3;
        if (avlNode == null) {
            return 0L;
        }
        int n2 = this.comparator().compare(this.range.getUpperEndpoint(), ((AvlNode)avlNode).elem);
        if (n2 > 0) {
            return this.aggregateAboveRange(aggregate, ((AvlNode)avlNode).right);
        }
        if (n2 == 0) {
            n2 = 4.$SwitchMap$com$google$common$collect$BoundType[this.range.getUpperBoundType().ordinal()];
            if (n2 != 1) {
                if (n2 != 2) throw new AssertionError();
                return aggregate.treeAggregate(((AvlNode)avlNode).right);
            }
            l3 = aggregate.nodeAggregate(avlNode);
            l2 = aggregate.treeAggregate(((AvlNode)avlNode).right);
            return l3 + l2;
        }
        l3 = aggregate.treeAggregate(((AvlNode)avlNode).right) + (long)aggregate.nodeAggregate(avlNode);
        l2 = this.aggregateAboveRange(aggregate, ((AvlNode)avlNode).left);
        return l3 + l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long aggregateBelowRange(Aggregate aggregate, @NullableDecl AvlNode<E> avlNode) {
        long l2;
        long l3;
        if (avlNode == null) {
            return 0L;
        }
        int n2 = this.comparator().compare(this.range.getLowerEndpoint(), ((AvlNode)avlNode).elem);
        if (n2 < 0) {
            return this.aggregateBelowRange(aggregate, ((AvlNode)avlNode).left);
        }
        if (n2 == 0) {
            n2 = 4.$SwitchMap$com$google$common$collect$BoundType[this.range.getLowerBoundType().ordinal()];
            if (n2 != 1) {
                if (n2 != 2) throw new AssertionError();
                return aggregate.treeAggregate(((AvlNode)avlNode).left);
            }
            l3 = aggregate.nodeAggregate(avlNode);
            l2 = aggregate.treeAggregate(((AvlNode)avlNode).left);
            return l3 + l2;
        }
        l3 = aggregate.treeAggregate(((AvlNode)avlNode).left) + (long)aggregate.nodeAggregate(avlNode);
        l2 = this.aggregateBelowRange(aggregate, ((AvlNode)avlNode).right);
        return l3 + l2;
    }

    private long aggregateForEntries(Aggregate aggregate) {
        long l2;
        AvlNode<E> avlNode = this.rootReference.get();
        long l3 = l2 = aggregate.treeAggregate(avlNode);
        if (this.range.hasLowerBound()) {
            l3 = l2 - this.aggregateBelowRange(aggregate, avlNode);
        }
        l2 = l3;
        if (this.range.hasUpperBound()) {
            l2 = l3 - this.aggregateAboveRange(aggregate, avlNode);
        }
        return l2;
    }

    public static <E extends Comparable> TreeMultiset<E> create() {
        return new TreeMultiset(Ordering.natural());
    }

    public static <E extends Comparable> TreeMultiset<E> create(Iterable<? extends E> iterable) {
        TreeMultiset<E> treeMultiset = TreeMultiset.create();
        Iterables.addAll(treeMultiset, iterable);
        return treeMultiset;
    }

    public static <E> TreeMultiset<E> create(@NullableDecl Comparator<? super E> treeMultiset) {
        treeMultiset = treeMultiset == null ? new TreeMultiset(Ordering.natural()) : new TreeMultiset<E>(treeMultiset);
        return treeMultiset;
    }

    static int distinctElements(@NullableDecl AvlNode<?> avlNode) {
        int n2 = avlNode == null ? 0 : ((AvlNode)avlNode).distinctElements;
        return n2;
    }

    @NullableDecl
    private AvlNode<E> firstNode() {
        AvlNode avlNode;
        block11: {
            block10: {
                AvlNode avlNode2;
                if (this.rootReference.get() == null) {
                    return null;
                }
                if (this.range.hasLowerBound()) {
                    E e2 = this.range.getLowerEndpoint();
                    avlNode = ((AvlNode)this.rootReference.get()).ceiling(this.comparator(), e2);
                    if (avlNode == null) {
                        return null;
                    }
                    avlNode2 = avlNode;
                    if (this.range.getLowerBoundType() == BoundType.OPEN) {
                        avlNode2 = avlNode;
                        if (this.comparator().compare(e2, avlNode.getElement()) == 0) {
                            avlNode2 = avlNode.succ;
                        }
                    }
                } else {
                    avlNode2 = ((AvlNode)this.header).succ;
                }
                if (avlNode2 == this.header) break block10;
                avlNode = avlNode2;
                if (this.range.contains(avlNode2.getElement())) break block11;
            }
            avlNode = null;
        }
        return avlNode;
    }

    @NullableDecl
    private AvlNode<E> lastNode() {
        AvlNode avlNode;
        block11: {
            block10: {
                AvlNode avlNode2;
                if (this.rootReference.get() == null) {
                    return null;
                }
                if (this.range.hasUpperBound()) {
                    E e2 = this.range.getUpperEndpoint();
                    avlNode = ((AvlNode)this.rootReference.get()).floor(this.comparator(), e2);
                    if (avlNode == null) {
                        return null;
                    }
                    avlNode2 = avlNode;
                    if (this.range.getUpperBoundType() == BoundType.OPEN) {
                        avlNode2 = avlNode;
                        if (this.comparator().compare(e2, avlNode.getElement()) == 0) {
                            avlNode2 = avlNode.pred;
                        }
                    }
                } else {
                    avlNode2 = ((AvlNode)this.header).pred;
                }
                if (avlNode2 == this.header) break block10;
                avlNode = avlNode2;
                if (this.range.contains(avlNode2.getElement())) break block11;
            }
            avlNode = null;
        }
        return avlNode;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = (Comparator)objectInputStream.readObject();
        Serialization.getFieldSetter(AbstractSortedMultiset.class, (String)"comparator").set((Object)this, object);
        Serialization.getFieldSetter(TreeMultiset.class, (String)"range").set((Object)this, GeneralRange.all(object));
        Serialization.getFieldSetter(TreeMultiset.class, (String)"rootReference").set((Object)this, new Reference());
        object = new AvlNode<Object>(null, 1);
        Serialization.getFieldSetter(TreeMultiset.class, (String)"header").set((Object)this, object);
        TreeMultiset.successor(object, object);
        Serialization.populateMultiset((Multiset)this, (ObjectInputStream)objectInputStream);
    }

    private static <T> void successor(AvlNode<T> avlNode, AvlNode<T> avlNode2) {
        AvlNode.access$802(avlNode, avlNode2);
        AvlNode.access$902(avlNode2, avlNode);
    }

    private static <T> void successor(AvlNode<T> avlNode, AvlNode<T> avlNode2, AvlNode<T> avlNode3) {
        TreeMultiset.successor(avlNode, avlNode2);
        TreeMultiset.successor(avlNode2, avlNode3);
    }

    private Multiset.Entry<E> wrapEntry(final AvlNode<E> avlNode) {
        return new Multisets.AbstractEntry<E>(){

            @Override
            public int getCount() {
                int n2;
                int n3 = n2 = avlNode.getCount();
                if (n2 == 0) {
                    n3 = TreeMultiset.this.count(this.getElement());
                }
                return n3;
            }

            @Override
            public E getElement() {
                return avlNode.getElement();
            }
        };
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.elementSet().comparator());
        Serialization.writeMultiset((Multiset)this, (ObjectOutputStream)objectOutputStream);
    }

    @Override
    public int add(@NullableDecl E object, int n2) {
        CollectPreconditions.checkNonnegative((int)n2, (String)"occurrences");
        if (n2 == 0) {
            return this.count(object);
        }
        Preconditions.checkArgument(this.range.contains(object));
        AvlNode<E> avlNode = this.rootReference.get();
        if (avlNode == null) {
            this.comparator().compare(object, object);
            object = new AvlNode<E>(object, n2);
            AvlNode<E> avlNode2 = this.header;
            TreeMultiset.successor(avlNode2, object, avlNode2);
            this.rootReference.checkAndSet(avlNode, (AvlNode<E>)object);
            return 0;
        }
        int[] nArray = new int[1];
        object = avlNode.add(this.comparator(), object, n2, nArray);
        this.rootReference.checkAndSet(avlNode, (AvlNode<E>)object);
        return nArray[0];
    }

    @Override
    public void clear() {
        if (!this.range.hasLowerBound() && !this.range.hasUpperBound()) {
            AvlNode avlNode;
            AvlNode avlNode2 = ((AvlNode)this.header).succ;
            while (avlNode2 != (avlNode = this.header)) {
                avlNode = avlNode2.succ;
                AvlNode.access$202(avlNode2, 0);
                AvlNode.access$602(avlNode2, null);
                AvlNode.access$702(avlNode2, null);
                AvlNode.access$902(avlNode2, null);
                AvlNode.access$802(avlNode2, null);
                avlNode2 = avlNode;
            }
            TreeMultiset.successor(avlNode, avlNode);
            this.rootReference.clear();
        } else {
            Iterators.clear(this.entryIterator());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int count(@NullableDecl Object object) {
        AvlNode<Object> avlNode = this.rootReference.get();
        if (!this.range.contains(object)) return 0;
        if (avlNode == null) return 0;
        try {
            return avlNode.count(this.comparator(), object);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return 0;
        }
    }

    @Override
    Iterator<Multiset.Entry<E>> descendingEntryIterator() {
        return new Iterator<Multiset.Entry<E>>(){
            AvlNode<E> current;
            Multiset.Entry<E> prevEntry;
            {
                this.current = TreeMultiset.this.lastNode();
                this.prevEntry = null;
            }

            @Override
            public boolean hasNext() {
                if (this.current == null) {
                    return false;
                }
                if (TreeMultiset.this.range.tooLow(this.current.getElement())) {
                    this.current = null;
                    return false;
                }
                return true;
            }

            @Override
            public Multiset.Entry<E> next() {
                if (this.hasNext()) {
                    Multiset.Entry entry;
                    this.prevEntry = entry = TreeMultiset.this.wrapEntry(this.current);
                    this.current = this.current.pred == TreeMultiset.this.header ? null : this.current.pred;
                    return entry;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                boolean bl = this.prevEntry != null;
                CollectPreconditions.checkRemove((boolean)bl);
                TreeMultiset.this.setCount(this.prevEntry.getElement(), 0);
                this.prevEntry = null;
            }
        };
    }

    @Override
    int distinctElements() {
        return Ints.saturatedCast(this.aggregateForEntries(Aggregate.DISTINCT));
    }

    @Override
    Iterator<E> elementIterator() {
        return Multisets.elementIterator(this.entryIterator());
    }

    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        return new Iterator<Multiset.Entry<E>>(){
            AvlNode<E> current;
            @NullableDecl
            Multiset.Entry<E> prevEntry;
            {
                this.current = TreeMultiset.this.firstNode();
            }

            @Override
            public boolean hasNext() {
                if (this.current == null) {
                    return false;
                }
                if (TreeMultiset.this.range.tooHigh(this.current.getElement())) {
                    this.current = null;
                    return false;
                }
                return true;
            }

            @Override
            public Multiset.Entry<E> next() {
                if (this.hasNext()) {
                    Multiset.Entry entry;
                    this.prevEntry = entry = TreeMultiset.this.wrapEntry(this.current);
                    this.current = this.current.succ == TreeMultiset.this.header ? null : this.current.succ;
                    return entry;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                boolean bl = this.prevEntry != null;
                CollectPreconditions.checkRemove((boolean)bl);
                TreeMultiset.this.setCount(this.prevEntry.getElement(), 0);
                this.prevEntry = null;
            }
        };
    }

    @Override
    public SortedMultiset<E> headMultiset(@NullableDecl E e2, BoundType boundType) {
        return new TreeMultiset<E>(this.rootReference, this.range.intersect(GeneralRange.upTo(this.comparator(), e2, boundType)), this.header);
    }

    @Override
    public Iterator<E> iterator() {
        return Multisets.iteratorImpl(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int remove(@NullableDecl Object avlNode, int n2) {
        block6: {
            CollectPreconditions.checkNonnegative((int)n2, (String)"occurrences");
            if (n2 == 0) {
                return this.count(avlNode);
            }
            AvlNode<AvlNode<Object>> avlNode2 = this.rootReference.get();
            int[] nArray = new int[1];
            if (!this.range.contains(avlNode)) break block6;
            if (avlNode2 == null) return 0;
            try {
                avlNode = avlNode2.remove(this.comparator(), avlNode, n2, nArray);
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                return 0;
            }
            this.rootReference.checkAndSet(avlNode2, avlNode);
            return nArray[0];
        }
        return 0;
    }

    @Override
    public int setCount(@NullableDecl E object, int n2) {
        CollectPreconditions.checkNonnegative((int)n2, (String)"count");
        boolean bl = this.range.contains(object);
        boolean bl2 = true;
        if (!bl) {
            if (n2 != 0) {
                bl2 = false;
            }
            Preconditions.checkArgument(bl2);
            return 0;
        }
        AvlNode<E> avlNode = this.rootReference.get();
        if (avlNode == null) {
            if (n2 > 0) {
                this.add(object, n2);
            }
            return 0;
        }
        int[] nArray = new int[1];
        object = avlNode.setCount(this.comparator(), object, n2, nArray);
        this.rootReference.checkAndSet(avlNode, (AvlNode<E>)object);
        return nArray[0];
    }

    @Override
    public boolean setCount(@NullableDecl E object, int n2, int n3) {
        CollectPreconditions.checkNonnegative((int)n3, (String)"newCount");
        CollectPreconditions.checkNonnegative((int)n2, (String)"oldCount");
        Preconditions.checkArgument(this.range.contains(object));
        AvlNode<E> avlNode = this.rootReference.get();
        boolean bl = false;
        if (avlNode == null) {
            if (n2 == 0) {
                if (n3 > 0) {
                    this.add(object, n3);
                }
                return true;
            }
            return false;
        }
        int[] nArray = new int[1];
        object = avlNode.setCount(this.comparator(), object, n2, n3, nArray);
        this.rootReference.checkAndSet(avlNode, (AvlNode<E>)object);
        if (nArray[0] == n2) {
            bl = true;
        }
        return bl;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.aggregateForEntries(Aggregate.SIZE));
    }

    @Override
    public SortedMultiset<E> tailMultiset(@NullableDecl E e2, BoundType boundType) {
        return new TreeMultiset<E>(this.rootReference, this.range.intersect(GeneralRange.downTo(this.comparator(), e2, boundType)), this.header);
    }

    private static enum Aggregate {
        SIZE{

            @Override
            int nodeAggregate(AvlNode<?> avlNode) {
                return ((AvlNode)avlNode).elemCount;
            }

            @Override
            long treeAggregate(@NullableDecl AvlNode<?> avlNode) {
                long l2 = avlNode == null ? 0L : ((AvlNode)avlNode).totalCount;
                return l2;
            }
        }
        ,
        DISTINCT{

            @Override
            int nodeAggregate(AvlNode<?> avlNode) {
                return 1;
            }

            @Override
            long treeAggregate(@NullableDecl AvlNode<?> avlNode) {
                long l2 = avlNode == null ? 0L : (long)((AvlNode)avlNode).distinctElements;
                return l2;
            }
        };


        abstract int nodeAggregate(AvlNode<?> var1);

        abstract long treeAggregate(@NullableDecl AvlNode<?> var1);
    }

    private static final class AvlNode<E> {
        private int distinctElements;
        @NullableDecl
        private final E elem;
        private int elemCount;
        private int height;
        @NullableDecl
        private AvlNode<E> left;
        @NullableDecl
        private AvlNode<E> pred;
        @NullableDecl
        private AvlNode<E> right;
        @NullableDecl
        private AvlNode<E> succ;
        private long totalCount;

        AvlNode(@NullableDecl E e2, int n2) {
            boolean bl = n2 > 0;
            Preconditions.checkArgument(bl);
            this.elem = e2;
            this.elemCount = n2;
            this.totalCount = n2;
            this.distinctElements = 1;
            this.height = 1;
            this.left = null;
            this.right = null;
        }

        static /* synthetic */ int access$202(AvlNode avlNode, int n2) {
            avlNode.elemCount = n2;
            return n2;
        }

        static /* synthetic */ AvlNode access$602(AvlNode avlNode, AvlNode avlNode2) {
            avlNode.left = avlNode2;
            return avlNode2;
        }

        static /* synthetic */ AvlNode access$702(AvlNode avlNode, AvlNode avlNode2) {
            avlNode.right = avlNode2;
            return avlNode2;
        }

        static /* synthetic */ AvlNode access$802(AvlNode avlNode, AvlNode avlNode2) {
            avlNode.succ = avlNode2;
            return avlNode2;
        }

        static /* synthetic */ AvlNode access$902(AvlNode avlNode, AvlNode avlNode2) {
            avlNode.pred = avlNode2;
            return avlNode2;
        }

        private AvlNode<E> addLeftChild(E e2, int n2) {
            this.left = new AvlNode<E>(e2, n2);
            TreeMultiset.successor(this.pred, this.left, this);
            this.height = Math.max(2, this.height);
            ++this.distinctElements;
            this.totalCount += (long)n2;
            return this;
        }

        private AvlNode<E> addRightChild(E e2, int n2) {
            this.right = new AvlNode<E>(e2, n2);
            TreeMultiset.successor(this, this.right, this.succ);
            this.height = Math.max(2, this.height);
            ++this.distinctElements;
            this.totalCount += (long)n2;
            return this;
        }

        private int balanceFactor() {
            return AvlNode.height(this.left) - AvlNode.height(this.right);
        }

        @NullableDecl
        private AvlNode<E> ceiling(Comparator<? super E> avlNode, E e2) {
            int n2 = avlNode.compare(e2, this.elem);
            if (n2 < 0) {
                AvlNode<E> avlNode2 = this.left;
                avlNode = avlNode2 == null ? this : MoreObjects.firstNonNull(super.ceiling((Comparator<E>)((Object)avlNode), e2), this);
                return avlNode;
            }
            if (n2 == 0) {
                return this;
            }
            AvlNode<E> avlNode3 = this.right;
            avlNode = avlNode3 == null ? null : super.ceiling((Comparator<E>)((Object)avlNode), e2);
            return avlNode;
        }

        private AvlNode<E> deleteMe() {
            int n2 = this.elemCount;
            this.elemCount = 0;
            TreeMultiset.successor(this.pred, this.succ);
            AvlNode<E> avlNode = this.left;
            if (avlNode == null) {
                return this.right;
            }
            AvlNode<E> avlNode2 = this.right;
            if (avlNode2 == null) {
                return avlNode;
            }
            if (avlNode.height >= avlNode2.height) {
                avlNode2 = this.pred;
                avlNode2.left = super.removeMax(avlNode2);
                avlNode2.right = this.right;
                avlNode2.distinctElements = this.distinctElements - 1;
                avlNode2.totalCount = this.totalCount - (long)n2;
                return super.rebalance();
            }
            avlNode = this.succ;
            avlNode.right = super.removeMin(avlNode);
            avlNode.left = this.left;
            avlNode.distinctElements = this.distinctElements - 1;
            avlNode.totalCount = this.totalCount - (long)n2;
            return super.rebalance();
        }

        @NullableDecl
        private AvlNode<E> floor(Comparator<? super E> avlNode, E e2) {
            int n2 = avlNode.compare(e2, this.elem);
            if (n2 > 0) {
                AvlNode<E> avlNode2 = this.right;
                avlNode = avlNode2 == null ? this : MoreObjects.firstNonNull(super.floor((Comparator<E>)((Object)avlNode), e2), this);
                return avlNode;
            }
            if (n2 == 0) {
                return this;
            }
            AvlNode<E> avlNode3 = this.left;
            avlNode = avlNode3 == null ? null : super.floor((Comparator<E>)((Object)avlNode), e2);
            return avlNode;
        }

        private static int height(@NullableDecl AvlNode<?> avlNode) {
            int n2 = avlNode == null ? 0 : avlNode.height;
            return n2;
        }

        private AvlNode<E> rebalance() {
            int n2 = this.balanceFactor();
            if (n2 != -2) {
                if (n2 != 2) {
                    this.recomputeHeight();
                    return this;
                }
                if (super.balanceFactor() < 0) {
                    this.left = super.rotateLeft();
                }
                return this.rotateRight();
            }
            if (super.balanceFactor() > 0) {
                this.right = super.rotateRight();
            }
            return this.rotateLeft();
        }

        private void recompute() {
            this.recomputeMultiset();
            this.recomputeHeight();
        }

        private void recomputeHeight() {
            this.height = Math.max(AvlNode.height(this.left), AvlNode.height(this.right)) + 1;
        }

        private void recomputeMultiset() {
            this.distinctElements = TreeMultiset.distinctElements(this.left) + 1 + TreeMultiset.distinctElements(this.right);
            this.totalCount = (long)this.elemCount + AvlNode.totalCount(this.left) + AvlNode.totalCount(this.right);
        }

        private AvlNode<E> removeMax(AvlNode<E> avlNode) {
            AvlNode<E> avlNode2 = this.right;
            if (avlNode2 == null) {
                return this.left;
            }
            this.right = super.removeMax(avlNode);
            --this.distinctElements;
            this.totalCount -= (long)avlNode.elemCount;
            return this.rebalance();
        }

        private AvlNode<E> removeMin(AvlNode<E> avlNode) {
            AvlNode<E> avlNode2 = this.left;
            if (avlNode2 == null) {
                return this.right;
            }
            this.left = super.removeMin(avlNode);
            --this.distinctElements;
            this.totalCount -= (long)avlNode.elemCount;
            return this.rebalance();
        }

        private AvlNode<E> rotateLeft() {
            boolean bl = this.right != null;
            Preconditions.checkState(bl);
            AvlNode<E> avlNode = this.right;
            this.right = avlNode.left;
            avlNode.left = this;
            avlNode.totalCount = this.totalCount;
            avlNode.distinctElements = this.distinctElements;
            this.recompute();
            super.recomputeHeight();
            return avlNode;
        }

        private AvlNode<E> rotateRight() {
            boolean bl = this.left != null;
            Preconditions.checkState(bl);
            AvlNode<E> avlNode = this.left;
            this.left = avlNode.right;
            avlNode.right = this;
            avlNode.totalCount = this.totalCount;
            avlNode.distinctElements = this.distinctElements;
            this.recompute();
            super.recomputeHeight();
            return avlNode;
        }

        private static long totalCount(@NullableDecl AvlNode<?> avlNode) {
            long l2 = avlNode == null ? 0L : avlNode.totalCount;
            return l2;
        }

        AvlNode<E> add(Comparator<? super E> avlNode, @NullableDecl E e2, int n2, int[] nArray) {
            int n3 = avlNode.compare(e2, this.elem);
            boolean bl = true;
            if (n3 < 0) {
                AvlNode<E> avlNode2 = this.left;
                if (avlNode2 == null) {
                    nArray[0] = 0;
                    return this.addLeftChild(e2, n2);
                }
                n3 = avlNode2.height;
                this.left = avlNode2.add((Comparator<E>)((Object)avlNode), e2, n2, nArray);
                if (nArray[0] == 0) {
                    ++this.distinctElements;
                }
                this.totalCount += (long)n2;
                avlNode = this.left.height == n3 ? this : this.rebalance();
                return avlNode;
            }
            if (n3 > 0) {
                AvlNode<E> avlNode3 = this.right;
                if (avlNode3 == null) {
                    nArray[0] = 0;
                    return this.addRightChild(e2, n2);
                }
                n3 = avlNode3.height;
                this.right = avlNode3.add((Comparator<E>)((Object)avlNode), e2, n2, nArray);
                if (nArray[0] == 0) {
                    ++this.distinctElements;
                }
                this.totalCount += (long)n2;
                avlNode = this.right.height == n3 ? this : this.rebalance();
                return avlNode;
            }
            nArray[0] = n3 = this.elemCount;
            long l2 = n3;
            long l3 = n2;
            if (l2 + l3 > Integer.MAX_VALUE) {
                bl = false;
            }
            Preconditions.checkArgument(bl);
            this.elemCount += n2;
            this.totalCount += l3;
            return this;
        }

        public int count(Comparator<? super E> comparator, E e2) {
            int n2 = comparator.compare(e2, this.elem);
            int n3 = 0;
            int n4 = 0;
            if (n2 < 0) {
                AvlNode<E> avlNode = this.left;
                if (avlNode != null) {
                    n4 = avlNode.count(comparator, e2);
                }
                return n4;
            }
            if (n2 > 0) {
                AvlNode<E> avlNode = this.right;
                n4 = avlNode == null ? n3 : avlNode.count(comparator, e2);
                return n4;
            }
            return this.elemCount;
        }

        int getCount() {
            return this.elemCount;
        }

        E getElement() {
            return this.elem;
        }

        AvlNode<E> remove(Comparator<? super E> avlNode, @NullableDecl E e2, int n2, int[] nArray) {
            int n3 = avlNode.compare(e2, this.elem);
            if (n3 < 0) {
                AvlNode<E> avlNode2 = this.left;
                if (avlNode2 == null) {
                    nArray[0] = 0;
                    return this;
                }
                this.left = avlNode2.remove((Comparator<E>)((Object)avlNode), e2, n2, nArray);
                if (nArray[0] > 0) {
                    if (n2 >= nArray[0]) {
                        --this.distinctElements;
                        this.totalCount -= (long)nArray[0];
                    } else {
                        this.totalCount -= (long)n2;
                    }
                }
                avlNode = nArray[0] == 0 ? this : this.rebalance();
                return avlNode;
            }
            if (n3 > 0) {
                AvlNode<E> avlNode3 = this.right;
                if (avlNode3 == null) {
                    nArray[0] = 0;
                    return this;
                }
                this.right = avlNode3.remove((Comparator<E>)((Object)avlNode), e2, n2, nArray);
                if (nArray[0] > 0) {
                    if (n2 >= nArray[0]) {
                        --this.distinctElements;
                        this.totalCount -= (long)nArray[0];
                    } else {
                        this.totalCount -= (long)n2;
                    }
                }
                return this.rebalance();
            }
            nArray[0] = n3 = this.elemCount;
            if (n2 >= n3) {
                return this.deleteMe();
            }
            this.elemCount = n3 - n2;
            this.totalCount -= (long)n2;
            return this;
        }

        AvlNode<E> setCount(Comparator<? super E> comparator, @NullableDecl E e2, int n2, int n3, int[] nArray) {
            int n4 = comparator.compare(e2, this.elem);
            if (n4 < 0) {
                AvlNode<E> avlNode = this.left;
                if (avlNode == null) {
                    nArray[0] = 0;
                    if (n2 == 0 && n3 > 0) {
                        return this.addLeftChild(e2, n3);
                    }
                    return this;
                }
                this.left = avlNode.setCount(comparator, e2, n2, n3, nArray);
                if (nArray[0] == n2) {
                    if (n3 == 0 && nArray[0] != 0) {
                        --this.distinctElements;
                    } else if (n3 > 0 && nArray[0] == 0) {
                        ++this.distinctElements;
                    }
                    this.totalCount += (long)(n3 - nArray[0]);
                }
                return this.rebalance();
            }
            if (n4 > 0) {
                AvlNode<E> avlNode = this.right;
                if (avlNode == null) {
                    nArray[0] = 0;
                    if (n2 == 0 && n3 > 0) {
                        return this.addRightChild(e2, n3);
                    }
                    return this;
                }
                this.right = avlNode.setCount(comparator, e2, n2, n3, nArray);
                if (nArray[0] == n2) {
                    if (n3 == 0 && nArray[0] != 0) {
                        --this.distinctElements;
                    } else if (n3 > 0 && nArray[0] == 0) {
                        ++this.distinctElements;
                    }
                    this.totalCount += (long)(n3 - nArray[0]);
                }
                return this.rebalance();
            }
            nArray[0] = n4 = this.elemCount;
            if (n2 == n4) {
                if (n3 == 0) {
                    return this.deleteMe();
                }
                this.totalCount += (long)(n3 - n4);
                this.elemCount = n3;
            }
            return this;
        }

        AvlNode<E> setCount(Comparator<? super E> avlNode, @NullableDecl E e2, int n2, int[] nArray) {
            int n3 = avlNode.compare(e2, this.elem);
            if (n3 < 0) {
                AvlNode<E> avlNode2 = this.left;
                if (avlNode2 == null) {
                    nArray[0] = 0;
                    avlNode = n2 > 0 ? this.addLeftChild(e2, n2) : this;
                    return avlNode;
                }
                this.left = avlNode2.setCount((Comparator<E>)((Object)avlNode), e2, n2, nArray);
                if (n2 == 0 && nArray[0] != 0) {
                    --this.distinctElements;
                } else if (n2 > 0 && nArray[0] == 0) {
                    ++this.distinctElements;
                }
                this.totalCount += (long)(n2 - nArray[0]);
                return this.rebalance();
            }
            if (n3 > 0) {
                AvlNode<E> avlNode3 = this.right;
                if (avlNode3 == null) {
                    nArray[0] = 0;
                    avlNode = n2 > 0 ? this.addRightChild(e2, n2) : this;
                    return avlNode;
                }
                this.right = avlNode3.setCount((Comparator<E>)((Object)avlNode), e2, n2, nArray);
                if (n2 == 0 && nArray[0] != 0) {
                    --this.distinctElements;
                } else if (n2 > 0 && nArray[0] == 0) {
                    ++this.distinctElements;
                }
                this.totalCount += (long)(n2 - nArray[0]);
                return this.rebalance();
            }
            nArray[0] = n3 = this.elemCount;
            if (n2 == 0) {
                return this.deleteMe();
            }
            this.totalCount += (long)(n2 - n3);
            this.elemCount = n2;
            return this;
        }

        public String toString() {
            return Multisets.immutableEntry(this.getElement(), this.getCount()).toString();
        }
    }

    private static final class Reference<T> {
        @NullableDecl
        private T value;

        private Reference() {
        }

        public void checkAndSet(@NullableDecl T t2, T t3) {
            if (this.value == t2) {
                this.value = t3;
                return;
            }
            throw new ConcurrentModificationException();
        }

        void clear() {
            this.value = null;
        }

        @NullableDecl
        public T get() {
            return this.value;
        }
    }
}

