/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.StandardRowSortedTable;
import com.google.common.collect.StandardTable;
import com.google.common.collect.Table;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class TreeBasedTable<R, C, V>
extends StandardRowSortedTable<R, C, V> {
    private static final long serialVersionUID = 0L;
    private final Comparator<? super C> columnComparator;

    TreeBasedTable(Comparator<? super R> comparator, Comparator<? super C> comparator2) {
        super(new TreeMap(comparator), new Factory(comparator2));
        this.columnComparator = comparator2;
    }

    public static <R extends Comparable, C extends Comparable, V> TreeBasedTable<R, C, V> create() {
        return new TreeBasedTable(Ordering.natural(), Ordering.natural());
    }

    public static <R, C, V> TreeBasedTable<R, C, V> create(TreeBasedTable<R, C, ? extends V> treeBasedTable) {
        TreeBasedTable<R, C, V> treeBasedTable2 = new TreeBasedTable<R, C, V>(treeBasedTable.rowComparator(), treeBasedTable.columnComparator());
        treeBasedTable2.putAll((Table)treeBasedTable);
        return treeBasedTable2;
    }

    public static <R, C, V> TreeBasedTable<R, C, V> create(Comparator<? super R> comparator, Comparator<? super C> comparator2) {
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(comparator2);
        return new TreeBasedTable<R, C, V>(comparator, comparator2);
    }

    @Deprecated
    public Comparator<? super C> columnComparator() {
        return this.columnComparator;
    }

    @Override
    Iterator<C> createColumnKeyIterator() {
        Comparator<C> comparator = this.columnComparator();
        return new AbstractIterator<C>(Iterators.mergeSorted(Iterables.transform(this.backingMap.values(), new Function<Map<C, V>, Iterator<C>>(){

            @Override
            public Iterator<C> apply(Map<C, V> map) {
                return map.keySet().iterator();
            }
        }), comparator), comparator){
            @NullableDecl
            C lastValue;
            final /* synthetic */ Comparator val$comparator;
            final /* synthetic */ Iterator val$merged;
            {
                this.val$merged = iterator2;
                this.val$comparator = comparator;
            }

            @Override
            protected C computeNext() {
                while (this.val$merged.hasNext()) {
                    Object e2 = this.val$merged.next();
                    Object c2 = this.lastValue;
                    boolean bl = c2 != null && this.val$comparator.compare(e2, c2) == 0;
                    if (bl) continue;
                    this.lastValue = e2;
                    return this.lastValue;
                }
                this.lastValue = null;
                return this.endOfData();
            }
        };
    }

    @Override
    public SortedMap<C, V> row(R r2) {
        return new TreeRow(r2);
    }

    @Deprecated
    public Comparator<? super R> rowComparator() {
        return this.rowKeySet().comparator();
    }

    @Override
    public SortedSet<R> rowKeySet() {
        return super.rowKeySet();
    }

    @Override
    public SortedMap<R, Map<C, V>> rowMap() {
        return super.rowMap();
    }

    private static class Factory<C, V>
    implements Supplier<TreeMap<C, V>>,
    Serializable {
        private static final long serialVersionUID = 0L;
        final Comparator<? super C> comparator;

        Factory(Comparator<? super C> comparator) {
            this.comparator = comparator;
        }

        @Override
        public TreeMap<C, V> get() {
            return new TreeMap(this.comparator);
        }
    }

    private class TreeRow
    extends StandardTable.Row
    implements SortedMap<C, V> {
        @NullableDecl
        final C lowerBound;
        @NullableDecl
        final C upperBound;
        @NullableDecl
        transient SortedMap<C, V> wholeRow;

        TreeRow(R r2) {
            this(r2, null, null);
        }

        TreeRow(@NullableDecl R r2, @NullableDecl C c2, C c3) {
            super(r2);
            this.lowerBound = c2;
            this.upperBound = c3;
            boolean bl = c2 == null || c3 == null || this.compare(c2, c3) <= 0;
            Preconditions.checkArgument(bl);
        }

        SortedMap<C, V> backingRowMap() {
            return (SortedMap)super.backingRowMap();
        }

        @Override
        public Comparator<? super C> comparator() {
            return TreeBasedTable.this.columnComparator();
        }

        int compare(Object object, Object object2) {
            return this.comparator().compare(object, object2);
        }

        SortedMap<C, V> computeBackingRowMap() {
            SortedMap sortedMap = this.wholeRow();
            if (sortedMap != null) {
                Object c2 = this.lowerBound;
                SortedMap sortedMap2 = sortedMap;
                if (c2 != null) {
                    sortedMap2 = sortedMap.tailMap(c2);
                }
                c2 = this.upperBound;
                sortedMap = sortedMap2;
                if (c2 != null) {
                    sortedMap = sortedMap2.headMap(c2);
                }
                return sortedMap;
            }
            return null;
        }

        @Override
        public boolean containsKey(Object object) {
            boolean bl = this.rangeContains(object) && super.containsKey(object);
            return bl;
        }

        @Override
        public C firstKey() {
            if (this.backingRowMap() != null) {
                return this.backingRowMap().firstKey();
            }
            throw new NoSuchElementException();
        }

        @Override
        public SortedMap<C, V> headMap(C c2) {
            Preconditions.checkArgument(this.rangeContains(Preconditions.checkNotNull(c2)));
            return new TreeRow(this.rowKey, this.lowerBound, c2);
        }

        @Override
        public SortedSet<C> keySet() {
            return new Maps.SortedKeySet(this);
        }

        @Override
        public C lastKey() {
            if (this.backingRowMap() != null) {
                return this.backingRowMap().lastKey();
            }
            throw new NoSuchElementException();
        }

        @Override
        void maintainEmptyInvariant() {
            if (this.wholeRow() != null && this.wholeRow.isEmpty()) {
                TreeBasedTable.this.backingMap.remove(this.rowKey);
                this.wholeRow = null;
                this.backingRowMap = null;
            }
        }

        @Override
        public V put(C c2, V v2) {
            Preconditions.checkArgument(this.rangeContains(Preconditions.checkNotNull(c2)));
            return super.put(c2, v2);
        }

        boolean rangeContains(@NullableDecl Object object) {
            Object c2;
            boolean bl = !(object == null || (c2 = this.lowerBound) != null && this.compare(c2, object) > 0 || (c2 = this.upperBound) != null && this.compare(c2, object) <= 0);
            return bl;
        }

        @Override
        public SortedMap<C, V> subMap(C c2, C c3) {
            boolean bl = this.rangeContains(Preconditions.checkNotNull(c2)) && this.rangeContains(Preconditions.checkNotNull(c3));
            Preconditions.checkArgument(bl);
            return new TreeRow(this.rowKey, c2, c3);
        }

        @Override
        public SortedMap<C, V> tailMap(C c2) {
            Preconditions.checkArgument(this.rangeContains(Preconditions.checkNotNull(c2)));
            return new TreeRow(this.rowKey, c2, this.upperBound);
        }

        SortedMap<C, V> wholeRow() {
            SortedMap sortedMap = this.wholeRow;
            if (sortedMap == null || sortedMap.isEmpty() && TreeBasedTable.this.backingMap.containsKey(this.rowKey)) {
                this.wholeRow = (SortedMap)TreeBasedTable.this.backingMap.get(this.rowKey);
            }
            return this.wholeRow;
        }
    }
}

