/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.common.math.IntMath;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class TopKSelector<T> {
    private final T[] buffer;
    private int bufferSize;
    private final Comparator<? super T> comparator;
    private final int k;
    @NullableDecl
    private T threshold;

    private TopKSelector(Comparator<? super T> comparator, int n2) {
        this.comparator = Preconditions.checkNotNull(comparator, "comparator");
        this.k = n2;
        boolean bl = n2 >= 0;
        Preconditions.checkArgument(bl, "k must be nonnegative, was %s", n2);
        this.buffer = new Object[n2 * 2];
        this.bufferSize = 0;
        this.threshold = null;
    }

    public static <T extends Comparable<? super T>> TopKSelector<T> greatest(int n2) {
        return TopKSelector.greatest(n2, Ordering.natural());
    }

    public static <T> TopKSelector<T> greatest(int n2, Comparator<? super T> comparator) {
        return new TopKSelector(Ordering.from(comparator).reverse(), n2);
    }

    public static <T extends Comparable<? super T>> TopKSelector<T> least(int n2) {
        return TopKSelector.least(n2, Ordering.natural());
    }

    public static <T> TopKSelector<T> least(int n2, Comparator<? super T> comparator) {
        return new TopKSelector<T>(comparator, n2);
    }

    private int partition(int n2, int n3, int n4) {
        T[] TArray = this.buffer;
        T t2 = TArray[n4];
        TArray[n4] = TArray[n3];
        n4 = n2;
        while (n2 < n3) {
            int n5 = n4;
            if (this.comparator.compare(this.buffer[n2], t2) < 0) {
                this.swap(n4, n2);
                n5 = n4 + 1;
            }
            ++n2;
            n4 = n5;
        }
        TArray = this.buffer;
        TArray[n3] = TArray[n4];
        TArray[n4] = t2;
        return n4;
    }

    private void swap(int n2, int n3) {
        T[] TArray = this.buffer;
        T t2 = TArray[n2];
        TArray[n2] = TArray[n3];
        TArray[n3] = t2;
    }

    private void trim() {
        int n2;
        block4: {
            int n3;
            int n4;
            int n5;
            int n6 = this.k * 2 - 1;
            int n7 = IntMath.log2((int)(n6 + 0), (RoundingMode)RoundingMode.CEILING);
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            do {
                n2 = n10;
                if (n8 >= n6) break block4;
                n4 = this.partition(n8, n6, n8 + n6 + 1 >>> 1);
                if (n4 > (n3 = this.k)) {
                    n3 = n4 - 1;
                    n4 = n8;
                    n2 = n10;
                } else {
                    n2 = n10;
                    if (n4 >= n3) break block4;
                    n10 = Math.max(n4, n8 + 1);
                    n2 = n4;
                    n4 = n10;
                    n3 = n6;
                }
                n5 = n9 + 1;
                n6 = n3;
                n8 = n4;
                n9 = n5;
                n10 = n2;
            } while (n5 < n7 * 3);
            Arrays.sort(this.buffer, n4, n3, this.comparator);
        }
        this.bufferSize = this.k;
        this.threshold = this.buffer[n2];
        while (++n2 < this.k) {
            if (this.comparator.compare(this.buffer[n2], this.threshold) <= 0) continue;
            this.threshold = this.buffer[n2];
        }
    }

    public void offer(@NullableDecl T t2) {
        int n2 = this.k;
        if (n2 == 0) {
            return;
        }
        int n3 = this.bufferSize;
        if (n3 == 0) {
            this.buffer[0] = t2;
            this.threshold = t2;
            this.bufferSize = 1;
        } else if (n3 < n2) {
            T[] TArray = this.buffer;
            this.bufferSize = n3 + 1;
            TArray[n3] = t2;
            if (this.comparator.compare(t2, this.threshold) > 0) {
                this.threshold = t2;
            }
        } else if (this.comparator.compare(t2, this.threshold) < 0) {
            T[] TArray = this.buffer;
            n2 = this.bufferSize;
            this.bufferSize = n2 + 1;
            TArray[n2] = t2;
            if (this.bufferSize == this.k * 2) {
                this.trim();
            }
        }
    }

    public void offerAll(Iterable<? extends T> iterable) {
        this.offerAll(iterable.iterator());
    }

    public void offerAll(Iterator<? extends T> iterator2) {
        while (iterator2.hasNext()) {
            this.offer(iterator2.next());
        }
    }

    public List<T> topK() {
        Arrays.sort(this.buffer, 0, this.bufferSize, this.comparator);
        int n2 = this.bufferSize;
        int n3 = this.k;
        if (n2 > n3) {
            Object[] objectArray = this.buffer;
            Arrays.fill(objectArray, n3, objectArray.length, null);
            this.bufferSize = n3 = this.k;
            this.threshold = this.buffer[n3 - 1];
        }
        return Collections.unmodifiableList(Arrays.asList(Arrays.copyOf(this.buffer, this.bufferSize)));
    }
}

