/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.BaseImmutableMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.Table;
import com.google.common.collect.TransformedIterator;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class Synchronized {
    private Synchronized() {
    }

    static <K, V> BiMap<K, V> biMap(BiMap<K, V> biMap, @NullableDecl Object object) {
        if (!(biMap instanceof SynchronizedBiMap) && !(biMap instanceof ImmutableBiMap)) {
            return new SynchronizedBiMap(biMap, object, null);
        }
        return biMap;
    }

    private static <E> Collection<E> collection(Collection<E> collection, @NullableDecl Object object) {
        return new SynchronizedCollection(collection, object);
    }

    static <E> Deque<E> deque(Deque<E> deque, @NullableDecl Object object) {
        return new SynchronizedDeque<E>(deque, object);
    }

    private static <E> List<E> list(List<E> synchronizedList, @NullableDecl Object object) {
        synchronizedList = synchronizedList instanceof RandomAccess ? new SynchronizedRandomAccessList<E>(synchronizedList, object) : new SynchronizedList<E>(synchronizedList, object);
        return synchronizedList;
    }

    static <K, V> ListMultimap<K, V> listMultimap(ListMultimap<K, V> listMultimap, @NullableDecl Object object) {
        if (!(listMultimap instanceof SynchronizedListMultimap) && !(listMultimap instanceof BaseImmutableMultimap)) {
            return new SynchronizedListMultimap<K, V>(listMultimap, object);
        }
        return listMultimap;
    }

    static <K, V> Map<K, V> map(Map<K, V> map, @NullableDecl Object object) {
        return new SynchronizedMap<K, V>(map, object);
    }

    static <K, V> Multimap<K, V> multimap(Multimap<K, V> multimap, @NullableDecl Object object) {
        if (!(multimap instanceof SynchronizedMultimap) && !(multimap instanceof BaseImmutableMultimap)) {
            return new SynchronizedMultimap<K, V>(multimap, object);
        }
        return multimap;
    }

    static <E> Multiset<E> multiset(Multiset<E> multiset, @NullableDecl Object object) {
        if (!(multiset instanceof SynchronizedMultiset) && !(multiset instanceof ImmutableMultiset)) {
            return new SynchronizedMultiset<E>(multiset, object);
        }
        return multiset;
    }

    static <K, V> NavigableMap<K, V> navigableMap(NavigableMap<K, V> navigableMap) {
        return Synchronized.navigableMap(navigableMap, null);
    }

    static <K, V> NavigableMap<K, V> navigableMap(NavigableMap<K, V> navigableMap, @NullableDecl Object object) {
        return new SynchronizedNavigableMap<K, V>(navigableMap, object);
    }

    static <E> NavigableSet<E> navigableSet(NavigableSet<E> navigableSet) {
        return Synchronized.navigableSet(navigableSet, null);
    }

    static <E> NavigableSet<E> navigableSet(NavigableSet<E> navigableSet, @NullableDecl Object object) {
        return new SynchronizedNavigableSet<E>(navigableSet, object);
    }

    private static <K, V> Map.Entry<K, V> nullableSynchronizedEntry(@NullableDecl Map.Entry<K, V> entry, @NullableDecl Object object) {
        if (entry == null) {
            return null;
        }
        return new SynchronizedEntry<K, V>(entry, object);
    }

    static <E> Queue<E> queue(Queue<E> queue, @NullableDecl Object object) {
        if (!(queue instanceof SynchronizedQueue)) {
            queue = new SynchronizedQueue<E>(queue, object);
        }
        return queue;
    }

    static <E> Set<E> set(Set<E> set, @NullableDecl Object object) {
        return new SynchronizedSet<E>(set, object);
    }

    static <K, V> SetMultimap<K, V> setMultimap(SetMultimap<K, V> setMultimap, @NullableDecl Object object) {
        if (!(setMultimap instanceof SynchronizedSetMultimap) && !(setMultimap instanceof BaseImmutableMultimap)) {
            return new SynchronizedSetMultimap<K, V>(setMultimap, object);
        }
        return setMultimap;
    }

    static <K, V> SortedMap<K, V> sortedMap(SortedMap<K, V> sortedMap, @NullableDecl Object object) {
        return new SynchronizedSortedMap<K, V>(sortedMap, object);
    }

    private static <E> SortedSet<E> sortedSet(SortedSet<E> sortedSet, @NullableDecl Object object) {
        return new SynchronizedSortedSet<E>(sortedSet, object);
    }

    static <K, V> SortedSetMultimap<K, V> sortedSetMultimap(SortedSetMultimap<K, V> sortedSetMultimap, @NullableDecl Object object) {
        if (sortedSetMultimap instanceof SynchronizedSortedSetMultimap) {
            return sortedSetMultimap;
        }
        return new SynchronizedSortedSetMultimap<K, V>(sortedSetMultimap, object);
    }

    static <R, C, V> Table<R, C, V> table(Table<R, C, V> table, Object object) {
        return new SynchronizedTable<R, C, V>(table, object);
    }

    private static <E> Collection<E> typePreservingCollection(Collection<E> collection, @NullableDecl Object object) {
        if (collection instanceof SortedSet) {
            return Synchronized.sortedSet((SortedSet)collection, object);
        }
        if (collection instanceof Set) {
            return Synchronized.set((Set)collection, object);
        }
        if (collection instanceof List) {
            return Synchronized.list((List)collection, object);
        }
        return Synchronized.collection(collection, object);
    }

    private static <E> Set<E> typePreservingSet(Set<E> set, @NullableDecl Object object) {
        if (set instanceof SortedSet) {
            return Synchronized.sortedSet((SortedSet)set, object);
        }
        return Synchronized.set(set, object);
    }

    private static class SynchronizedAsMap<K, V>
    extends SynchronizedMap<K, Collection<V>> {
        private static final long serialVersionUID = 0L;
        @MonotonicNonNullDecl
        transient Set<Map.Entry<K, Collection<V>>> asMapEntrySet;
        @MonotonicNonNullDecl
        transient Collection<Collection<V>> asMapValues;

        SynchronizedAsMap(Map<K, Collection<V>> map, @NullableDecl Object object) {
            super(map, object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.values().contains(object);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Set<Map.Entry<K, Collection<V>>> entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.asMapEntrySet != null) return this.asMapEntrySet;
                Set set = new Set(this.delegate().entrySet(), this.mutex);
                this.asMapEntrySet = set;
                return this.asMapEntrySet;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Collection<V> get(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                object = (Collection)super.get(object);
                if (object != null) return Synchronized.typePreservingCollection((Collection)object, this.mutex);
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Collection<Collection<V>> values() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.asMapValues != null) return this.asMapValues;
                Collection collection = new Collection(this.delegate().values(), this.mutex);
                this.asMapValues = collection;
                return this.asMapValues;
            }
        }
    }

    private static class SynchronizedAsMapEntries<K, V>
    extends SynchronizedSet<Map.Entry<K, Collection<V>>> {
        private static final long serialVersionUID = 0L;

        SynchronizedAsMapEntries(Set<Map.Entry<K, Collection<V>>> set, @NullableDecl Object object) {
            super(set, object);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean contains(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Maps.containsEntryImpl(this.delegate(), object);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean containsAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return Collections2.containsAllImpl(this.delegate(), collection);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            Object object2 = this.mutex;
            synchronized (object2) {
                return Sets.equalsImpl(this.delegate(), object);
            }
        }

        @Override
        public Iterator<Map.Entry<K, Collection<V>>> iterator() {
            return new TransformedIterator<Map.Entry<K, Collection<V>>, Map.Entry<K, Collection<V>>>(super.iterator()){

                Map.Entry<K, Collection<V>> transform(final Map.Entry<K, Collection<V>> entry) {
                    return new ForwardingMapEntry<K, Collection<V>>(){

                        @Override
                        protected Map.Entry<K, Collection<V>> delegate() {
                            return entry;
                        }

                        @Override
                        public Collection<V> getValue() {
                            return Synchronized.typePreservingCollection((Collection)entry.getValue(), SynchronizedAsMapEntries.this.mutex);
                        }
                    };
                }
            };
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Maps.removeEntryImpl(this.delegate(), object);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return Iterators.removeAll(this.delegate().iterator(), collection);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return Iterators.retainAll(this.delegate().iterator(), collection);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return ObjectArrays.toArrayImpl(this.delegate());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <T> T[] toArray(T[] TArray) {
            Object object = this.mutex;
            synchronized (object) {
                return ObjectArrays.toArrayImpl(this.delegate(), TArray);
            }
        }
    }

    private static class SynchronizedAsMapValues<V>
    extends SynchronizedCollection<Collection<V>> {
        private static final long serialVersionUID = 0L;

        SynchronizedAsMapValues(Collection<Collection<V>> collection, @NullableDecl Object object) {
            super(collection, object);
        }

        @Override
        public Iterator<Collection<V>> iterator() {
            return new TransformedIterator<Collection<V>, Collection<V>>(super.iterator()){

                Collection<V> transform(Collection<V> collection) {
                    return Synchronized.typePreservingCollection(collection, SynchronizedAsMapValues.this.mutex);
                }
            };
        }
    }

    static class SynchronizedBiMap<K, V>
    extends SynchronizedMap<K, V>
    implements BiMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 0L;
        @MonotonicNonNullDecl
        private transient BiMap<V, K> inverse;
        @MonotonicNonNullDecl
        private transient Set<V> valueSet;

        private SynchronizedBiMap(BiMap<K, V> biMap, @NullableDecl Object object, @NullableDecl BiMap<V, K> biMap2) {
            super(biMap, object);
            this.inverse = biMap2;
        }

        @Override
        BiMap<K, V> delegate() {
            return (BiMap)super.delegate();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public V forcePut(K object, V v2) {
            Object object2 = this.mutex;
            synchronized (object2) {
                object = this.delegate().forcePut(object, v2);
                return (V)object;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public BiMap<V, K> inverse() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.inverse != null) return this.inverse;
                BiMap biMap = new BiMap(this.delegate().inverse(), this.mutex, this);
                this.inverse = biMap;
                return this.inverse;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Set<V> values() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.valueSet != null) return this.valueSet;
                this.valueSet = Synchronized.set(this.delegate().values(), this.mutex);
                return this.valueSet;
            }
        }
    }

    static class SynchronizedCollection<E>
    extends SynchronizedObject
    implements Collection<E> {
        private static final long serialVersionUID = 0L;

        private SynchronizedCollection(Collection<E> collection, @NullableDecl Object object) {
            super(collection, object);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean add(E e2) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().add(e2);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean addAll(Collection<? extends E> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().addAll(collection);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.delegate().clear();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean contains(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().contains(object);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean containsAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().containsAll(collection);
            }
        }

        @Override
        Collection<E> delegate() {
            return (Collection)super.delegate();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().isEmpty();
            }
        }

        @Override
        public Iterator<E> iterator() {
            return this.delegate().iterator();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().remove(object);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().removeAll(collection);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().retainAll(collection);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().size();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().toArray();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <T> T[] toArray(T[] TArray) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().toArray(TArray);
            }
        }
    }

    private static final class SynchronizedDeque<E>
    extends SynchronizedQueue<E>
    implements Deque<E> {
        private static final long serialVersionUID = 0L;

        SynchronizedDeque(Deque<E> deque, @NullableDecl Object object) {
            super(deque, object);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void addFirst(E e2) {
            Object object = this.mutex;
            synchronized (object) {
                this.delegate().addFirst(e2);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void addLast(E e2) {
            Object object = this.mutex;
            synchronized (object) {
                this.delegate().addLast(e2);
                return;
            }
        }

        @Override
        Deque<E> delegate() {
            return (Deque)super.delegate();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Iterator<E> descendingIterator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().descendingIterator();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E getFirst() {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().getFirst();
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E getLast() {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().getLast();
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean offerFirst(E e2) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().offerFirst(e2);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean offerLast(E e2) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().offerLast(e2);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E peekFirst() {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().peekFirst();
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E peekLast() {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().peekLast();
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E pollFirst() {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().pollFirst();
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E pollLast() {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().pollLast();
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E pop() {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().pop();
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void push(E e2) {
            Object object = this.mutex;
            synchronized (object) {
                this.delegate().push(e2);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E removeFirst() {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().removeFirst();
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean removeFirstOccurrence(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().removeFirstOccurrence(object);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E removeLast() {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().removeLast();
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean removeLastOccurrence(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().removeLastOccurrence(object);
            }
        }
    }

    private static class SynchronizedEntry<K, V>
    extends SynchronizedObject
    implements Map.Entry<K, V> {
        private static final long serialVersionUID = 0L;

        SynchronizedEntry(Map.Entry<K, V> entry, @NullableDecl Object object) {
            super(entry, object);
        }

        @Override
        Map.Entry<K, V> delegate() {
            return (Map.Entry)super.delegate();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().equals(object);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public K getKey() {
            Object object = this.mutex;
            synchronized (object) {
                Object k2 = this.delegate().getKey();
                return k2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public V getValue() {
            Object object = this.mutex;
            synchronized (object) {
                Object v2 = this.delegate().getValue();
                return v2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public V setValue(V v2) {
            Object object = this.mutex;
            synchronized (object) {
                v2 = this.delegate().setValue(v2);
                return v2;
            }
        }
    }

    private static class SynchronizedList<E>
    extends SynchronizedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = 0L;

        SynchronizedList(List<E> list, @NullableDecl Object object) {
            super(list, object);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void add(int n2, E e2) {
            Object object = this.mutex;
            synchronized (object) {
                this.delegate().add(n2, e2);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean addAll(int n2, Collection<? extends E> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().addAll(n2, collection);
            }
        }

        @Override
        List<E> delegate() {
            return (List)super.delegate();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().equals(object);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E get(int n2) {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().get(n2);
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int indexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().indexOf(object);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int lastIndexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().lastIndexOf(object);
            }
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.delegate().listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int n2) {
            return this.delegate().listIterator(n2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E remove(int n2) {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().remove(n2);
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E set(int n2, E e2) {
            Object object = this.mutex;
            synchronized (object) {
                e2 = this.delegate().set(n2, e2);
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<E> subList(int n2, int n3) {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.list(this.delegate().subList(n2, n3), this.mutex);
            }
        }
    }

    private static class SynchronizedListMultimap<K, V>
    extends SynchronizedMultimap<K, V>
    implements ListMultimap<K, V> {
        private static final long serialVersionUID = 0L;

        SynchronizedListMultimap(ListMultimap<K, V> listMultimap, @NullableDecl Object object) {
            super(listMultimap, object);
        }

        @Override
        ListMultimap<K, V> delegate() {
            return (ListMultimap)super.delegate();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<V> get(K object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.list(this.delegate().get(object), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<V> removeAll(Object list) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().removeAll(list);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<V> replaceValues(K object, Iterable<? extends V> iterable) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().replaceValues(object, iterable);
            }
        }
    }

    private static class SynchronizedMap<K, V>
    extends SynchronizedObject
    implements Map<K, V> {
        private static final long serialVersionUID = 0L;
        @MonotonicNonNullDecl
        transient Set<Map.Entry<K, V>> entrySet;
        @MonotonicNonNullDecl
        transient Set<K> keySet;
        @MonotonicNonNullDecl
        transient Collection<V> values;

        SynchronizedMap(Map<K, V> map, @NullableDecl Object object) {
            super(map, object);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.delegate().clear();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean containsKey(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().containsKey(object);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean containsValue(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().containsValue(object);
            }
        }

        @Override
        Map<K, V> delegate() {
            return (Map)super.delegate();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet != null) return this.entrySet;
                this.entrySet = Synchronized.set(this.delegate().entrySet(), this.mutex);
                return this.entrySet;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().equals(object);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public V get(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                object = this.delegate().get(object);
                return (V)object;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().isEmpty();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Set<K> keySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.keySet != null) return this.keySet;
                this.keySet = Synchronized.set(this.delegate().keySet(), this.mutex);
                return this.keySet;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public V put(K object, V v2) {
            Object object2 = this.mutex;
            synchronized (object2) {
                object = this.delegate().put(object, v2);
                return (V)object;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Object object = this.mutex;
            synchronized (object) {
                this.delegate().putAll(map);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public V remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                object = this.delegate().remove(object);
                return (V)object;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().size();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Collection<V> values() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.values != null) return this.values;
                this.values = Synchronized.collection(this.delegate().values(), this.mutex);
                return this.values;
            }
        }
    }

    private static class SynchronizedMultimap<K, V>
    extends SynchronizedObject
    implements Multimap<K, V> {
        private static final long serialVersionUID = 0L;
        @MonotonicNonNullDecl
        transient Map<K, Collection<V>> asMap;
        @MonotonicNonNullDecl
        transient Collection<Map.Entry<K, V>> entries;
        @MonotonicNonNullDecl
        transient Set<K> keySet;
        @MonotonicNonNullDecl
        transient Multiset<K> keys;
        @MonotonicNonNullDecl
        transient Collection<V> valuesCollection;

        SynchronizedMultimap(Multimap<K, V> multimap, @NullableDecl Object object) {
            super(multimap, object);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map<K, Collection<V>> asMap() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.asMap != null) return this.asMap;
                Map map = new Map(this.delegate().asMap(), this.mutex);
                this.asMap = map;
                return this.asMap;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.delegate().clear();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean containsEntry(Object object, Object object2) {
            Object object3 = this.mutex;
            synchronized (object3) {
                return this.delegate().containsEntry(object, object2);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean containsKey(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().containsKey(object);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean containsValue(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().containsValue(object);
            }
        }

        @Override
        Multimap<K, V> delegate() {
            return (Multimap)super.delegate();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Collection<Map.Entry<K, V>> entries() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.entries != null) return this.entries;
                this.entries = Synchronized.typePreservingCollection(this.delegate().entries(), this.mutex);
                return this.entries;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().equals(object);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Collection<V> get(K object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.typePreservingCollection(this.delegate().get(object), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().isEmpty();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Set<K> keySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.keySet != null) return this.keySet;
                this.keySet = Synchronized.typePreservingSet(this.delegate().keySet(), this.mutex);
                return this.keySet;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Multiset<K> keys() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.keys != null) return this.keys;
                this.keys = Synchronized.multiset(this.delegate().keys(), this.mutex);
                return this.keys;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean put(K k2, V v2) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().put(k2, v2);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().putAll(multimap);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean putAll(K k2, Iterable<? extends V> iterable) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().putAll(k2, iterable);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean remove(Object object, Object object2) {
            Object object3 = this.mutex;
            synchronized (object3) {
                return this.delegate().remove(object, object2);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Collection<V> removeAll(Object collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().removeAll(collection);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Collection<V> replaceValues(K object, Iterable<? extends V> iterable) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().replaceValues(object, iterable);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().size();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Collection<V> values() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.valuesCollection != null) return this.valuesCollection;
                this.valuesCollection = Synchronized.collection(this.delegate().values(), this.mutex);
                return this.valuesCollection;
            }
        }
    }

    private static class SynchronizedMultiset<E>
    extends SynchronizedCollection<E>
    implements Multiset<E> {
        private static final long serialVersionUID = 0L;
        @MonotonicNonNullDecl
        transient Set<E> elementSet;
        @MonotonicNonNullDecl
        transient Set<Multiset.Entry<E>> entrySet;

        SynchronizedMultiset(Multiset<E> multiset, @NullableDecl Object object) {
            super(multiset, object);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int add(E e2, int n2) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().add(e2, n2);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int count(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().count(object);
            }
        }

        @Override
        Multiset<E> delegate() {
            return (Multiset)super.delegate();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Set<E> elementSet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.elementSet != null) return this.elementSet;
                this.elementSet = Synchronized.typePreservingSet(this.delegate().elementSet(), this.mutex);
                return this.elementSet;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Set<Multiset.Entry<E>> entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet != null) return this.entrySet;
                this.entrySet = Synchronized.typePreservingSet(this.delegate().entrySet(), this.mutex);
                return this.entrySet;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().equals(object);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int remove(Object object, int n2) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().remove(object, n2);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int setCount(E e2, int n2) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().setCount(e2, n2);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean setCount(E e2, int n2, int n3) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().setCount(e2, n2, n3);
            }
        }
    }

    static class SynchronizedNavigableMap<K, V>
    extends SynchronizedSortedMap<K, V>
    implements NavigableMap<K, V> {
        private static final long serialVersionUID = 0L;
        @MonotonicNonNullDecl
        transient NavigableSet<K> descendingKeySet;
        @MonotonicNonNullDecl
        transient NavigableMap<K, V> descendingMap;
        @MonotonicNonNullDecl
        transient NavigableSet<K> navigableKeySet;

        SynchronizedNavigableMap(NavigableMap<K, V> navigableMap, @NullableDecl Object object) {
            super(navigableMap, object);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map.Entry<K, V> ceilingEntry(K object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.nullableSynchronizedEntry(this.delegate().ceilingEntry(object), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public K ceilingKey(K k2) {
            Object object = this.mutex;
            synchronized (object) {
                k2 = this.delegate().ceilingKey(k2);
                return k2;
            }
        }

        @Override
        NavigableMap<K, V> delegate() {
            return (NavigableMap)super.delegate();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public NavigableSet<K> descendingKeySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.descendingKeySet != null) return this.descendingKeySet;
                NavigableSet navigableSet = Synchronized.navigableSet(this.delegate().descendingKeySet(), this.mutex);
                this.descendingKeySet = navigableSet;
                return navigableSet;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public NavigableMap<K, V> descendingMap() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.descendingMap != null) return this.descendingMap;
                NavigableMap navigableMap = Synchronized.navigableMap(this.delegate().descendingMap(), this.mutex);
                this.descendingMap = navigableMap;
                return navigableMap;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map.Entry<K, V> firstEntry() {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.nullableSynchronizedEntry(this.delegate().firstEntry(), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map.Entry<K, V> floorEntry(K object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.nullableSynchronizedEntry(this.delegate().floorEntry(object), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public K floorKey(K k2) {
            Object object = this.mutex;
            synchronized (object) {
                k2 = this.delegate().floorKey(k2);
                return k2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public NavigableMap<K, V> headMap(K object, boolean bl) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.navigableMap(this.delegate().headMap(object, bl), this.mutex);
            }
        }

        @Override
        public SortedMap<K, V> headMap(K k2) {
            return this.headMap(k2, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map.Entry<K, V> higherEntry(K object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.nullableSynchronizedEntry(this.delegate().higherEntry(object), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public K higherKey(K k2) {
            Object object = this.mutex;
            synchronized (object) {
                k2 = this.delegate().higherKey(k2);
                return k2;
            }
        }

        @Override
        public Set<K> keySet() {
            return this.navigableKeySet();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map.Entry<K, V> lastEntry() {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.nullableSynchronizedEntry(this.delegate().lastEntry(), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map.Entry<K, V> lowerEntry(K object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.nullableSynchronizedEntry(this.delegate().lowerEntry(object), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public K lowerKey(K k2) {
            Object object = this.mutex;
            synchronized (object) {
                k2 = this.delegate().lowerKey(k2);
                return k2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public NavigableSet<K> navigableKeySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.navigableKeySet != null) return this.navigableKeySet;
                NavigableSet navigableSet = Synchronized.navigableSet(this.delegate().navigableKeySet(), this.mutex);
                this.navigableKeySet = navigableSet;
                return navigableSet;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.nullableSynchronizedEntry(this.delegate().pollFirstEntry(), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.nullableSynchronizedEntry(this.delegate().pollLastEntry(), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public NavigableMap<K, V> subMap(K object, boolean bl, K k2, boolean bl2) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.navigableMap(this.delegate().subMap(object, bl, k2, bl2), this.mutex);
            }
        }

        @Override
        public SortedMap<K, V> subMap(K k2, K k3) {
            return this.subMap(k2, true, k3, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public NavigableMap<K, V> tailMap(K object, boolean bl) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.navigableMap(this.delegate().tailMap(object, bl), this.mutex);
            }
        }

        @Override
        public SortedMap<K, V> tailMap(K k2) {
            return this.tailMap(k2, true);
        }
    }

    static class SynchronizedNavigableSet<E>
    extends SynchronizedSortedSet<E>
    implements NavigableSet<E> {
        private static final long serialVersionUID = 0L;
        @MonotonicNonNullDecl
        transient NavigableSet<E> descendingSet;

        SynchronizedNavigableSet(NavigableSet<E> navigableSet, @NullableDecl Object object) {
            super(navigableSet, object);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E ceiling(E e2) {
            Object object = this.mutex;
            synchronized (object) {
                e2 = this.delegate().ceiling(e2);
                return e2;
            }
        }

        @Override
        NavigableSet<E> delegate() {
            return (NavigableSet)super.delegate();
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.delegate().descendingIterator();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public NavigableSet<E> descendingSet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.descendingSet != null) return this.descendingSet;
                NavigableSet navigableSet = Synchronized.navigableSet(this.delegate().descendingSet(), this.mutex);
                this.descendingSet = navigableSet;
                return navigableSet;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E floor(E e2) {
            Object object = this.mutex;
            synchronized (object) {
                e2 = this.delegate().floor(e2);
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public NavigableSet<E> headSet(E object, boolean bl) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.navigableSet(this.delegate().headSet(object, bl), this.mutex);
            }
        }

        @Override
        public SortedSet<E> headSet(E e2) {
            return this.headSet(e2, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E higher(E e2) {
            Object object = this.mutex;
            synchronized (object) {
                e2 = this.delegate().higher(e2);
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E lower(E e2) {
            Object object = this.mutex;
            synchronized (object) {
                e2 = this.delegate().lower(e2);
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E pollFirst() {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().pollFirst();
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E pollLast() {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().pollLast();
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public NavigableSet<E> subSet(E object, boolean bl, E e2, boolean bl2) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.navigableSet(this.delegate().subSet(object, bl, e2, bl2), this.mutex);
            }
        }

        @Override
        public SortedSet<E> subSet(E e2, E e3) {
            return this.subSet(e2, true, e3, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public NavigableSet<E> tailSet(E object, boolean bl) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.navigableSet(this.delegate().tailSet(object, bl), this.mutex);
            }
        }

        @Override
        public SortedSet<E> tailSet(E e2) {
            return this.tailSet(e2, true);
        }
    }

    static class SynchronizedObject
    implements Serializable {
        private static final long serialVersionUID = 0L;
        final Object delegate;
        final Object mutex;

        SynchronizedObject(Object object, @NullableDecl Object object2) {
            this.delegate = Preconditions.checkNotNull(object);
            object = object2;
            if (object2 == null) {
                object = this;
            }
            this.mutex = object;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                objectOutputStream.defaultWriteObject();
                return;
            }
        }

        Object delegate() {
            return this.delegate;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate.toString();
            }
        }
    }

    private static class SynchronizedQueue<E>
    extends SynchronizedCollection<E>
    implements Queue<E> {
        private static final long serialVersionUID = 0L;

        SynchronizedQueue(Queue<E> queue, @NullableDecl Object object) {
            super(queue, object);
        }

        @Override
        Queue<E> delegate() {
            return (Queue)super.delegate();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E element() {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().element();
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean offer(E e2) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().offer(e2);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E peek() {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().peek();
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E poll() {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().poll();
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E remove() {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().remove();
                return e2;
            }
        }
    }

    private static class SynchronizedRandomAccessList<E>
    extends SynchronizedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 0L;

        SynchronizedRandomAccessList(List<E> list, @NullableDecl Object object) {
            super(list, object);
        }
    }

    static class SynchronizedSet<E>
    extends SynchronizedCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = 0L;

        SynchronizedSet(Set<E> set, @NullableDecl Object object) {
            super(set, object);
        }

        @Override
        Set<E> delegate() {
            return (Set)super.delegate();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().equals(object);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }
    }

    private static class SynchronizedSetMultimap<K, V>
    extends SynchronizedMultimap<K, V>
    implements SetMultimap<K, V> {
        private static final long serialVersionUID = 0L;
        @MonotonicNonNullDecl
        transient Set<Map.Entry<K, V>> entrySet;

        SynchronizedSetMultimap(SetMultimap<K, V> setMultimap, @NullableDecl Object object) {
            super(setMultimap, object);
        }

        @Override
        SetMultimap<K, V> delegate() {
            return (SetMultimap)super.delegate();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Set<Map.Entry<K, V>> entries() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet != null) return this.entrySet;
                this.entrySet = Synchronized.set(this.delegate().entries(), this.mutex);
                return this.entrySet;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Set<V> get(K object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.set(this.delegate().get(object), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Set<V> removeAll(Object set) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().removeAll(set);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Set<V> replaceValues(K object, Iterable<? extends V> iterable) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().replaceValues(object, iterable);
            }
        }
    }

    static class SynchronizedSortedMap<K, V>
    extends SynchronizedMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = 0L;

        SynchronizedSortedMap(SortedMap<K, V> sortedMap, @NullableDecl Object object) {
            super(sortedMap, object);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Comparator<? super K> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().comparator();
            }
        }

        @Override
        SortedMap<K, V> delegate() {
            return (SortedMap)super.delegate();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public K firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                Object k2 = this.delegate().firstKey();
                return k2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SortedMap<K, V> headMap(K object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.sortedMap(this.delegate().headMap(object), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public K lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                Object k2 = this.delegate().lastKey();
                return k2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SortedMap<K, V> subMap(K object, K k2) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.sortedMap(this.delegate().subMap(object, k2), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SortedMap<K, V> tailMap(K object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.sortedMap(this.delegate().tailMap(object), this.mutex);
            }
        }
    }

    static class SynchronizedSortedSet<E>
    extends SynchronizedSet<E>
    implements SortedSet<E> {
        private static final long serialVersionUID = 0L;

        SynchronizedSortedSet(SortedSet<E> sortedSet, @NullableDecl Object object) {
            super(sortedSet, object);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Comparator<? super E> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().comparator();
            }
        }

        @Override
        SortedSet<E> delegate() {
            return (SortedSet)super.delegate();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E first() {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().first();
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SortedSet<E> headSet(E object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.sortedSet(this.delegate().headSet(object), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E last() {
            Object object = this.mutex;
            synchronized (object) {
                Object e2 = this.delegate().last();
                return e2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SortedSet<E> subSet(E object, E e2) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.sortedSet(this.delegate().subSet(object, e2), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SortedSet<E> tailSet(E object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.sortedSet(this.delegate().tailSet(object), this.mutex);
            }
        }
    }

    private static class SynchronizedSortedSetMultimap<K, V>
    extends SynchronizedSetMultimap<K, V>
    implements SortedSetMultimap<K, V> {
        private static final long serialVersionUID = 0L;

        SynchronizedSortedSetMultimap(SortedSetMultimap<K, V> sortedSetMultimap, @NullableDecl Object object) {
            super(sortedSetMultimap, object);
        }

        @Override
        SortedSetMultimap<K, V> delegate() {
            return (SortedSetMultimap)super.delegate();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SortedSet<V> get(K object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.sortedSet(this.delegate().get(object), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SortedSet<V> removeAll(Object sortedSet) {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().removeAll(sortedSet);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SortedSet<V> replaceValues(K object, Iterable<? extends V> iterable) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().replaceValues(object, iterable);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Comparator<? super V> valueComparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().valueComparator();
            }
        }
    }

    private static final class SynchronizedTable<R, C, V>
    extends SynchronizedObject
    implements Table<R, C, V> {
        SynchronizedTable(Table<R, C, V> table, Object object) {
            super(table, object);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Set<Table.Cell<R, C, V>> cellSet() {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.set(this.delegate().cellSet(), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.delegate().clear();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map<R, V> column(@NullableDecl C object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.map(this.delegate().column(object), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Set<C> columnKeySet() {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.set(this.delegate().columnKeySet(), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map<C, Map<R, V>> columnMap() {
            Object object = this.mutex;
            synchronized (object) {
                Map map = this.delegate().columnMap();
                Function function = new Function<Map<R, V>, Map<R, V>>(){

                    @Override
                    public Map<R, V> apply(Map<R, V> map) {
                        return Synchronized.map(map, SynchronizedTable.this.mutex);
                    }
                };
                return Synchronized.map(Maps.transformValues(map, function), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean contains(@NullableDecl Object object, @NullableDecl Object object2) {
            Object object3 = this.mutex;
            synchronized (object3) {
                return this.delegate().contains(object, object2);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean containsColumn(@NullableDecl Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().containsColumn(object);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean containsRow(@NullableDecl Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().containsRow(object);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean containsValue(@NullableDecl Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().containsValue(object);
            }
        }

        @Override
        Table<R, C, V> delegate() {
            return (Table)super.delegate();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean equals(@NullableDecl Object object) {
            if (this == object) {
                return true;
            }
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.delegate().equals(object);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public V get(@NullableDecl Object object, @NullableDecl Object object2) {
            Object object3 = this.mutex;
            synchronized (object3) {
                object = this.delegate().get(object, object2);
                return (V)object;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().isEmpty();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public V put(@NullableDecl R object, @NullableDecl C c2, @NullableDecl V v2) {
            Object object2 = this.mutex;
            synchronized (object2) {
                object = this.delegate().put(object, c2, v2);
                return (V)object;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
            Object object = this.mutex;
            synchronized (object) {
                this.delegate().putAll(table);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public V remove(@NullableDecl Object object, @NullableDecl Object object2) {
            Object object3 = this.mutex;
            synchronized (object3) {
                object = this.delegate().remove(object, object2);
                return (V)object;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map<C, V> row(@NullableDecl R object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return Synchronized.map(this.delegate().row(object), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Set<R> rowKeySet() {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.set(this.delegate().rowKeySet(), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map<R, Map<C, V>> rowMap() {
            Object object = this.mutex;
            synchronized (object) {
                Map map = this.delegate().rowMap();
                Function function = new Function<Map<C, V>, Map<C, V>>(){

                    @Override
                    public Map<C, V> apply(Map<C, V> map) {
                        return Synchronized.map(map, SynchronizedTable.this.mutex);
                    }
                };
                return Synchronized.map(Maps.transformValues(map, function), this.mutex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().size();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Collection<V> values() {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.collection(this.delegate().values(), this.mutex);
            }
        }
    }
}

