/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.AbstractTable;
import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.GwtTransient;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

class StandardTable<R, C, V>
extends AbstractTable<R, C, V>
implements Serializable {
    private static final long serialVersionUID = 0L;
    @GwtTransient
    final Map<R, Map<C, V>> backingMap;
    @MonotonicNonNullDecl
    private transient Set<C> columnKeySet;
    @MonotonicNonNullDecl
    private transient ColumnMap columnMap;
    @GwtTransient
    final Supplier<? extends Map<C, V>> factory;
    @MonotonicNonNullDecl
    private transient Map<R, Map<C, V>> rowMap;

    StandardTable(Map<R, Map<C, V>> map, Supplier<? extends Map<C, V>> supplier) {
        this.backingMap = map;
        this.factory = supplier;
    }

    private boolean containsMapping(Object object, Object object2, Object object3) {
        boolean bl = object3 != null && object3.equals(this.get(object, object2));
        return bl;
    }

    private Map<C, V> getOrCreate(R r2) {
        Map<C, V> map;
        Map<C, V> map2 = map = this.backingMap.get(r2);
        if (map == null) {
            map2 = this.factory.get();
            this.backingMap.put(r2, map2);
        }
        return map2;
    }

    private Map<R, V> removeColumn(Object object) {
        LinkedHashMap<R, V> linkedHashMap = new LinkedHashMap<R, V>();
        Iterator<Map.Entry<R, Map<C, V>>> iterator2 = this.backingMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<R, Map<C, V>> entry = iterator2.next();
            V v2 = entry.getValue().remove(object);
            if (v2 == null) continue;
            linkedHashMap.put(entry.getKey(), v2);
            if (!entry.getValue().isEmpty()) continue;
            iterator2.remove();
        }
        return linkedHashMap;
    }

    private boolean removeMapping(Object object, Object object2, Object object3) {
        if (this.containsMapping(object, object2, object3)) {
            this.remove(object, object2);
            return true;
        }
        return false;
    }

    @Override
    Iterator<Table.Cell<R, C, V>> cellIterator() {
        return new CellIterator();
    }

    @Override
    public Set<Table.Cell<R, C, V>> cellSet() {
        return super.cellSet();
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public Map<R, V> column(C c2) {
        return new Column(c2);
    }

    @Override
    public Set<C> columnKeySet() {
        ColumnKeySet columnKeySet;
        ColumnKeySet columnKeySet2 = columnKeySet = this.columnKeySet;
        if (columnKeySet == null) {
            this.columnKeySet = columnKeySet2 = new ColumnKeySet();
        }
        return columnKeySet2;
    }

    @Override
    public Map<C, Map<R, V>> columnMap() {
        ColumnMap columnMap;
        ColumnMap columnMap2 = columnMap = this.columnMap;
        if (columnMap == null) {
            this.columnMap = columnMap2 = new ColumnMap();
        }
        return columnMap2;
    }

    @Override
    public boolean contains(@NullableDecl Object object, @NullableDecl Object object2) {
        boolean bl = object != null && object2 != null && super.contains(object, object2);
        return bl;
    }

    @Override
    public boolean containsColumn(@NullableDecl Object object) {
        if (object == null) {
            return false;
        }
        Iterator<Map<C, V>> iterator2 = this.backingMap.values().iterator();
        while (iterator2.hasNext()) {
            if (!Maps.safeContainsKey(iterator2.next(), object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsRow(@NullableDecl Object object) {
        boolean bl = object != null && Maps.safeContainsKey(this.backingMap, object);
        return bl;
    }

    @Override
    public boolean containsValue(@NullableDecl Object object) {
        boolean bl = object != null && super.containsValue(object);
        return bl;
    }

    Iterator<C> createColumnKeyIterator() {
        return new ColumnKeyIterator();
    }

    Map<R, Map<C, V>> createRowMap() {
        return new RowMap();
    }

    @Override
    public V get(@NullableDecl Object object, @NullableDecl Object object2) {
        object = object != null && object2 != null ? super.get(object, object2) : null;
        return (V)object;
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public V put(R r2, C c2, V v2) {
        Preconditions.checkNotNull(r2);
        Preconditions.checkNotNull(c2);
        Preconditions.checkNotNull(v2);
        return this.getOrCreate(r2).put(c2, v2);
    }

    @Override
    public V remove(@NullableDecl Object object, @NullableDecl Object object2) {
        if (object != null && object2 != null) {
            Map<C, V> map = Maps.safeGet(this.backingMap, object);
            if (map == null) {
                return null;
            }
            object2 = map.remove(object2);
            if (map.isEmpty()) {
                this.backingMap.remove(object);
            }
            return (V)object2;
        }
        return null;
    }

    @Override
    public Map<C, V> row(R r2) {
        return new Row(r2);
    }

    @Override
    public Set<R> rowKeySet() {
        return this.rowMap().keySet();
    }

    @Override
    public Map<R, Map<C, V>> rowMap() {
        Map<R, Map<C, Map<C, Map<C, Map<C, V>>>>> map;
        Map<R, Map<C, Map<C, Map<C, Map<C, V>>>>> map2 = map = this.rowMap;
        if (map == null) {
            map2 = this.createRowMap();
            this.rowMap = map2;
        }
        return map2;
    }

    @Override
    public int size() {
        Iterator<Map<C, V>> iterator2 = this.backingMap.values().iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            n2 += iterator2.next().size();
        }
        return n2;
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    private class CellIterator
    implements Iterator<Table.Cell<R, C, V>> {
        Iterator<Map.Entry<C, V>> columnIterator;
        @NullableDecl
        Map.Entry<R, Map<C, V>> rowEntry;
        final Iterator<Map.Entry<R, Map<C, V>>> rowIterator;

        private CellIterator() {
            this.rowIterator = StandardTable.this.backingMap.entrySet().iterator();
            this.columnIterator = Iterators.emptyModifiableIterator();
        }

        @Override
        public boolean hasNext() {
            boolean bl = this.rowIterator.hasNext() || this.columnIterator.hasNext();
            return bl;
        }

        @Override
        public Table.Cell<R, C, V> next() {
            if (!this.columnIterator.hasNext()) {
                this.rowEntry = this.rowIterator.next();
                this.columnIterator = this.rowEntry.getValue().entrySet().iterator();
            }
            Map.Entry entry = this.columnIterator.next();
            return Tables.immutableCell(this.rowEntry.getKey(), entry.getKey(), entry.getValue());
        }

        @Override
        public void remove() {
            this.columnIterator.remove();
            if (this.rowEntry.getValue().isEmpty()) {
                this.rowIterator.remove();
                this.rowEntry = null;
            }
        }
    }

    private class Column
    extends Maps.ViewCachingAbstractMap<R, V> {
        final C columnKey;

        Column(C c2) {
            this.columnKey = Preconditions.checkNotNull(c2);
        }

        @Override
        public boolean containsKey(Object object) {
            return StandardTable.this.contains(object, this.columnKey);
        }

        @Override
        Set<Map.Entry<R, V>> createEntrySet() {
            return new EntrySet();
        }

        @Override
        Set<R> createKeySet() {
            return new KeySet();
        }

        @Override
        Collection<V> createValues() {
            return new Values();
        }

        @Override
        public V get(Object object) {
            return StandardTable.this.get(object, this.columnKey);
        }

        @Override
        public V put(R r2, V v2) {
            return StandardTable.this.put(r2, this.columnKey, v2);
        }

        @Override
        public V remove(Object object) {
            return StandardTable.this.remove(object, this.columnKey);
        }

        boolean removeFromColumnIf(Predicate<? super Map.Entry<R, V>> predicate) {
            Iterator iterator2 = StandardTable.this.backingMap.entrySet().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                boolean bl2;
                Map.Entry entry = iterator2.next();
                Map map = entry.getValue();
                Object v2 = map.get(this.columnKey);
                if (v2 == null || !predicate.apply(Maps.immutableEntry(entry.getKey(), v2))) continue;
                map.remove(this.columnKey);
                bl = bl2 = true;
                if (!map.isEmpty()) continue;
                iterator2.remove();
                bl = bl2;
            }
            return bl;
        }

        private class EntrySet
        extends Sets.ImprovedAbstractSet<Map.Entry<R, V>> {
            private EntrySet() {
            }

            @Override
            public void clear() {
                Column.this.removeFromColumnIf(Predicates.alwaysTrue());
            }

            @Override
            public boolean contains(Object object) {
                if (object instanceof Map.Entry) {
                    object = (Map.Entry)object;
                    return StandardTable.this.containsMapping(object.getKey(), Column.this.columnKey, object.getValue());
                }
                return false;
            }

            @Override
            public boolean isEmpty() {
                return StandardTable.this.containsColumn(Column.this.columnKey) ^ true;
            }

            @Override
            public Iterator<Map.Entry<R, V>> iterator() {
                return new EntrySetIterator();
            }

            @Override
            public boolean remove(Object object) {
                if (object instanceof Map.Entry) {
                    object = (Map.Entry)object;
                    return StandardTable.this.removeMapping(object.getKey(), Column.this.columnKey, object.getValue());
                }
                return false;
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                return Column.this.removeFromColumnIf(Predicates.not(Predicates.in(collection)));
            }

            @Override
            public int size() {
                Iterator iterator2 = StandardTable.this.backingMap.values().iterator();
                int n2 = 0;
                while (iterator2.hasNext()) {
                    if (!iterator2.next().containsKey(Column.this.columnKey)) continue;
                    ++n2;
                }
                return n2;
            }
        }

        private class EntrySetIterator
        extends AbstractIterator<Map.Entry<R, V>> {
            final Iterator<Map.Entry<R, Map<C, V>>> iterator;

            private EntrySetIterator() {
                this.iterator = StandardTable.this.backingMap.entrySet().iterator();
            }

            @Override
            protected Map.Entry<R, V> computeNext() {
                while (this.iterator.hasNext()) {
                    Map.Entry entry = this.iterator.next();
                    if (!entry.getValue().containsKey(Column.this.columnKey)) continue;
                    return new 1EntryImpl(this, entry);
                }
                return (Map.Entry)this.endOfData();
            }

            static class 1EntryImpl
            extends AbstractMapEntry<R, V> {
                final /* synthetic */ EntrySetIterator this$2;
                final /* synthetic */ Map.Entry val$entry;

                1EntryImpl() {
                    this.this$2 = var1_1;
                    this.val$entry = var2_2;
                }

                @Override
                public R getKey() {
                    return this.val$entry.getKey();
                }

                @Override
                public V getValue() {
                    return ((Map)this.val$entry.getValue()).get(this.this$2.Column.this.columnKey);
                }

                @Override
                public V setValue(V v2) {
                    return ((Map)this.val$entry.getValue()).put(this.this$2.Column.this.columnKey, Preconditions.checkNotNull(v2));
                }
            }
        }

        private class KeySet
        extends Maps.KeySet<R, V> {
            KeySet() {
                super(Column.this);
            }

            @Override
            public boolean contains(Object object) {
                return StandardTable.this.contains(object, Column.this.columnKey);
            }

            @Override
            public boolean remove(Object object) {
                boolean bl = StandardTable.this.remove(object, Column.this.columnKey) != null;
                return bl;
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                return Column.this.removeFromColumnIf(Maps.keyPredicateOnEntries(Predicates.not(Predicates.in(collection))));
            }
        }

        private class Values
        extends Maps.Values<R, V> {
            Values() {
                super(Column.this);
            }

            @Override
            public boolean remove(Object object) {
                boolean bl = object != null && Column.this.removeFromColumnIf(Maps.valuePredicateOnEntries(Predicates.equalTo(object)));
                return bl;
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                return Column.this.removeFromColumnIf(Maps.valuePredicateOnEntries(Predicates.in(collection)));
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                return Column.this.removeFromColumnIf(Maps.valuePredicateOnEntries(Predicates.not(Predicates.in(collection))));
            }
        }
    }

    private class ColumnKeyIterator
    extends AbstractIterator<C> {
        Iterator<Map.Entry<C, V>> entryIterator;
        final Iterator<Map<C, V>> mapIterator;
        final Map<C, V> seen;

        private ColumnKeyIterator() {
            this.seen = StandardTable.this.factory.get();
            this.mapIterator = StandardTable.this.backingMap.values().iterator();
            this.entryIterator = Iterators.emptyIterator();
        }

        @Override
        protected C computeNext() {
            while (true) {
                if (this.entryIterator.hasNext()) {
                    Map.Entry entry = this.entryIterator.next();
                    if (this.seen.containsKey(entry.getKey())) continue;
                    this.seen.put(entry.getKey(), entry.getValue());
                    return entry.getKey();
                }
                if (!this.mapIterator.hasNext()) break;
                this.entryIterator = this.mapIterator.next().entrySet().iterator();
            }
            return this.endOfData();
        }
    }

    private class ColumnKeySet
    extends TableSet<C> {
        private ColumnKeySet() {
        }

        @Override
        public boolean contains(Object object) {
            return StandardTable.this.containsColumn(object);
        }

        @Override
        public Iterator<C> iterator() {
            return StandardTable.this.createColumnKeyIterator();
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = false;
            if (object == null) {
                return false;
            }
            Iterator iterator2 = StandardTable.this.backingMap.values().iterator();
            while (iterator2.hasNext()) {
                boolean bl2;
                Map map = iterator2.next();
                if (!map.keySet().remove(object)) continue;
                bl = bl2 = true;
                if (!map.isEmpty()) continue;
                iterator2.remove();
                bl = bl2;
            }
            return bl;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            Preconditions.checkNotNull(collection);
            Iterator iterator2 = StandardTable.this.backingMap.values().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                boolean bl2;
                Map map = iterator2.next();
                if (!Iterators.removeAll(map.keySet().iterator(), collection)) continue;
                bl = bl2 = true;
                if (!map.isEmpty()) continue;
                iterator2.remove();
                bl = bl2;
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            Preconditions.checkNotNull(collection);
            Iterator iterator2 = StandardTable.this.backingMap.values().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                boolean bl2;
                Map map = iterator2.next();
                if (!map.keySet().retainAll(collection)) continue;
                bl = bl2 = true;
                if (!map.isEmpty()) continue;
                iterator2.remove();
                bl = bl2;
            }
            return bl;
        }

        @Override
        public int size() {
            return Iterators.size(this.iterator());
        }
    }

    private class ColumnMap
    extends Maps.ViewCachingAbstractMap<C, Map<R, V>> {
        private ColumnMap() {
        }

        @Override
        public boolean containsKey(Object object) {
            return StandardTable.this.containsColumn(object);
        }

        @Override
        public Set<Map.Entry<C, Map<R, V>>> createEntrySet() {
            return new ColumnMapEntrySet();
        }

        @Override
        Collection<Map<R, V>> createValues() {
            return new ColumnMapValues();
        }

        @Override
        public Map<R, V> get(Object map) {
            map = StandardTable.this.containsColumn(map) ? StandardTable.this.column(map) : null;
            return map;
        }

        @Override
        public Set<C> keySet() {
            return StandardTable.this.columnKeySet();
        }

        @Override
        public Map<R, V> remove(Object map) {
            map = StandardTable.this.containsColumn(map) ? StandardTable.this.removeColumn(map) : null;
            return map;
        }

        class ColumnMapEntrySet
        extends TableSet<Map.Entry<C, Map<R, V>>> {
            ColumnMapEntrySet() {
            }

            @Override
            public boolean contains(Object object) {
                if (object instanceof Map.Entry && StandardTable.this.containsColumn((object = (Map.Entry)object).getKey())) {
                    Object k2 = object.getKey();
                    return ColumnMap.this.get(k2).equals(object.getValue());
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<C, Map<R, V>>> iterator() {
                return Maps.asMapEntryIterator(StandardTable.this.columnKeySet(), new Function<C, Map<R, V>>(){

                    @Override
                    public Map<R, V> apply(C c2) {
                        return StandardTable.this.column(c2);
                    }
                });
            }

            @Override
            public boolean remove(Object object) {
                if (this.contains(object)) {
                    object = (Map.Entry)object;
                    StandardTable.this.removeColumn(object.getKey());
                    return true;
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                Preconditions.checkNotNull(collection);
                return Sets.removeAllImpl(this, collection.iterator());
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                Preconditions.checkNotNull(collection);
                Iterator iterator2 = Lists.newArrayList(StandardTable.this.columnKeySet().iterator()).iterator();
                boolean bl = false;
                while (iterator2.hasNext()) {
                    Object c2 = iterator2.next();
                    if (collection.contains(Maps.immutableEntry(c2, StandardTable.this.column(c2)))) continue;
                    StandardTable.this.removeColumn(c2);
                    bl = true;
                }
                return bl;
            }

            @Override
            public int size() {
                return StandardTable.this.columnKeySet().size();
            }
        }

        private class ColumnMapValues
        extends Maps.Values<C, Map<R, V>> {
            ColumnMapValues() {
                super(ColumnMap.this);
            }

            @Override
            public boolean remove(Object object) {
                for (Map.Entry entry : ColumnMap.this.entrySet()) {
                    if (!((Map)entry.getValue()).equals(object)) continue;
                    StandardTable.this.removeColumn(entry.getKey());
                    return true;
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                Preconditions.checkNotNull(collection);
                Iterator iterator2 = Lists.newArrayList(StandardTable.this.columnKeySet().iterator()).iterator();
                boolean bl = false;
                while (iterator2.hasNext()) {
                    Object c2 = iterator2.next();
                    if (!collection.contains(StandardTable.this.column(c2))) continue;
                    StandardTable.this.removeColumn(c2);
                    bl = true;
                }
                return bl;
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                Preconditions.checkNotNull(collection);
                Iterator iterator2 = Lists.newArrayList(StandardTable.this.columnKeySet().iterator()).iterator();
                boolean bl = false;
                while (iterator2.hasNext()) {
                    Object c2 = iterator2.next();
                    if (collection.contains(StandardTable.this.column(c2))) continue;
                    StandardTable.this.removeColumn(c2);
                    bl = true;
                }
                return bl;
            }
        }
    }

    class Row
    extends Maps.IteratorBasedAbstractMap<C, V> {
        @NullableDecl
        Map<C, V> backingRowMap;
        final R rowKey;

        Row(R r2) {
            this.rowKey = Preconditions.checkNotNull(r2);
        }

        Map<C, V> backingRowMap() {
            Map map = this.backingRowMap;
            if (!(map == null || map.isEmpty() && StandardTable.this.backingMap.containsKey(this.rowKey))) {
                map = this.backingRowMap;
            } else {
                map = this.computeBackingRowMap();
                this.backingRowMap = map;
            }
            return map;
        }

        @Override
        public void clear() {
            Map map = this.backingRowMap();
            if (map != null) {
                map.clear();
            }
            this.maintainEmptyInvariant();
        }

        Map<C, V> computeBackingRowMap() {
            return StandardTable.this.backingMap.get(this.rowKey);
        }

        @Override
        public boolean containsKey(Object object) {
            Map map = this.backingRowMap();
            boolean bl = object != null && map != null && Maps.safeContainsKey(map, object);
            return bl;
        }

        @Override
        Iterator<Map.Entry<C, V>> entryIterator() {
            Map map = this.backingRowMap();
            if (map == null) {
                return Iterators.emptyModifiableIterator();
            }
            return new Iterator<Map.Entry<C, V>>(map.entrySet().iterator()){
                final /* synthetic */ Iterator val$iterator;
                {
                    this.val$iterator = iterator2;
                }

                @Override
                public boolean hasNext() {
                    return this.val$iterator.hasNext();
                }

                @Override
                public Map.Entry<C, V> next() {
                    return Row.this.wrapEntry((Map.Entry)this.val$iterator.next());
                }

                @Override
                public void remove() {
                    this.val$iterator.remove();
                    Row.this.maintainEmptyInvariant();
                }
            };
        }

        @Override
        public V get(Object object) {
            Map map = this.backingRowMap();
            object = object != null && map != null ? Maps.safeGet(map, object) : null;
            return object;
        }

        void maintainEmptyInvariant() {
            if (this.backingRowMap() != null && this.backingRowMap.isEmpty()) {
                StandardTable.this.backingMap.remove(this.rowKey);
                this.backingRowMap = null;
            }
        }

        @Override
        public V put(C c2, V v2) {
            Preconditions.checkNotNull(c2);
            Preconditions.checkNotNull(v2);
            Map map = this.backingRowMap;
            if (map != null && !map.isEmpty()) {
                return this.backingRowMap.put(c2, v2);
            }
            return StandardTable.this.put(this.rowKey, c2, v2);
        }

        @Override
        public V remove(Object object) {
            Map map = this.backingRowMap();
            if (map == null) {
                return null;
            }
            object = Maps.safeRemove(map, object);
            this.maintainEmptyInvariant();
            return object;
        }

        @Override
        public int size() {
            Map map = this.backingRowMap();
            int n2 = map == null ? 0 : map.size();
            return n2;
        }

        Map.Entry<C, V> wrapEntry(final Map.Entry<C, V> entry) {
            return new ForwardingMapEntry<C, V>(){

                @Override
                protected Map.Entry<C, V> delegate() {
                    return entry;
                }

                @Override
                public boolean equals(Object object) {
                    return this.standardEquals(object);
                }

                @Override
                public V setValue(V v2) {
                    return super.setValue(Preconditions.checkNotNull(v2));
                }
            };
        }
    }

    class RowMap
    extends Maps.ViewCachingAbstractMap<R, Map<C, V>> {
        RowMap() {
        }

        @Override
        public boolean containsKey(Object object) {
            return StandardTable.this.containsRow(object);
        }

        @Override
        protected Set<Map.Entry<R, Map<C, V>>> createEntrySet() {
            return new EntrySet();
        }

        @Override
        public Map<C, V> get(Object map) {
            map = StandardTable.this.containsRow(map) ? StandardTable.this.row(map) : null;
            return map;
        }

        @Override
        public Map<C, V> remove(Object map) {
            map = map == null ? null : StandardTable.this.backingMap.remove(map);
            return map;
        }

        class EntrySet
        extends TableSet<Map.Entry<R, Map<C, V>>> {
            EntrySet() {
            }

            @Override
            public boolean contains(Object object) {
                boolean bl;
                boolean bl2 = object instanceof Map.Entry;
                boolean bl3 = bl = false;
                if (bl2) {
                    object = (Map.Entry)object;
                    bl3 = bl;
                    if (object.getKey() != null) {
                        bl3 = bl;
                        if (object.getValue() instanceof Map) {
                            bl3 = bl;
                            if (Collections2.safeContains(StandardTable.this.backingMap.entrySet(), object)) {
                                bl3 = true;
                            }
                        }
                    }
                }
                return bl3;
            }

            @Override
            public Iterator<Map.Entry<R, Map<C, V>>> iterator() {
                return Maps.asMapEntryIterator(StandardTable.this.backingMap.keySet(), new Function<R, Map<C, V>>(){

                    @Override
                    public Map<C, V> apply(R r2) {
                        return StandardTable.this.row(r2);
                    }
                });
            }

            @Override
            public boolean remove(Object object) {
                boolean bl;
                boolean bl2 = object instanceof Map.Entry;
                boolean bl3 = bl = false;
                if (bl2) {
                    object = (Map.Entry)object;
                    bl3 = bl;
                    if (object.getKey() != null) {
                        bl3 = bl;
                        if (object.getValue() instanceof Map) {
                            bl3 = bl;
                            if (StandardTable.this.backingMap.entrySet().remove(object)) {
                                bl3 = true;
                            }
                        }
                    }
                }
                return bl3;
            }

            @Override
            public int size() {
                return StandardTable.this.backingMap.size();
            }
        }
    }

    private abstract class TableSet<T>
    extends Sets.ImprovedAbstractSet<T> {
        private TableSet() {
        }

        @Override
        public void clear() {
            StandardTable.this.backingMap.clear();
        }

        @Override
        public boolean isEmpty() {
            return StandardTable.this.backingMap.isEmpty();
        }
    }
}

