/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.RegularImmutableTable;
import com.google.common.collect.Table;
import com.google.errorprone.annotations.Immutable;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

@Immutable(containerOf={"R", "C", "V"})
final class SparseImmutableTable<R, C, V>
extends RegularImmutableTable<R, C, V> {
    static final ImmutableTable<Object, Object, Object> EMPTY = new SparseImmutableTable<Object, Object, Object>(ImmutableList.of(), ImmutableSet.of(), ImmutableSet.of());
    private final int[] cellColumnInRowIndices;
    private final int[] cellRowIndices;
    private final ImmutableMap<C, ImmutableMap<R, V>> columnMap;
    private final ImmutableMap<R, ImmutableMap<C, V>> rowMap;

    SparseImmutableTable(ImmutableList<Table.Cell<R, C, V>> builder, ImmutableSet<R> object, ImmutableSet<C> object22) {
        ImmutableMap immutableMap = Maps.indexMap(object);
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        object = ((ImmutableSet)object).iterator();
        while (object.hasNext()) {
            linkedHashMap.put(object.next(), new LinkedHashMap());
        }
        object = Maps.newLinkedHashMap();
        Iterator iterator2 = ((ImmutableSet)object22).iterator();
        while (iterator2.hasNext()) {
            object.put(iterator2.next(), new LinkedHashMap());
        }
        int[] nArray = new int[((AbstractCollection)((Object)builder)).size()];
        int[] nArray2 = new int[((AbstractCollection)((Object)builder)).size()];
        for (int i2 = 0; i2 < ((AbstractCollection)((Object)builder)).size(); ++i2) {
            Object object2 = (Table.Cell)builder.get(i2);
            Object r2 = object2.getRowKey();
            Object c2 = object2.getColumnKey();
            Object v2 = object2.getValue();
            nArray[i2] = (Integer)immutableMap.get(r2);
            object2 = (Map)linkedHashMap.get(r2);
            nArray2[i2] = object2.size();
            this.checkNoDuplicate(r2, c2, object2.put(c2, v2), v2);
            ((Map)object.get(c2)).put(r2, v2);
        }
        this.cellRowIndices = nArray;
        this.cellColumnInRowIndices = nArray2;
        builder = new ImmutableMap.Builder(linkedHashMap.size());
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            builder.put(entry.getKey(), ImmutableMap.copyOf((Map)entry.getValue()));
        }
        this.rowMap = builder.build();
        builder = new ImmutableMap.Builder(object.size());
        for (Map.Entry entry : object.entrySet()) {
            builder.put(entry.getKey(), ImmutableMap.copyOf((Map)entry.getValue()));
        }
        this.columnMap = builder.build();
    }

    @Override
    public ImmutableMap<C, Map<R, V>> columnMap() {
        return ImmutableMap.copyOf(this.columnMap);
    }

    @Override
    ImmutableTable.SerializedForm createSerializedForm() {
        ImmutableMap immutableMap = Maps.indexMap(this.columnKeySet());
        int[] nArray = new int[((AbstractCollection)((Object)this.cellSet())).size()];
        Iterator iterator2 = ((ImmutableSet)this.cellSet()).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            nArray[n2] = (Integer)immutableMap.get(((Table.Cell)iterator2.next()).getColumnKey());
            ++n2;
        }
        return ImmutableTable.SerializedForm.create(this, this.cellRowIndices, nArray);
    }

    @Override
    Table.Cell<R, C, V> getCell(int n2) {
        int n3 = this.cellRowIndices[n2];
        Map.Entry entry = (Map.Entry)((ImmutableSet)this.rowMap.entrySet()).asList().get(n3);
        Object object = (ImmutableMap)entry.getValue();
        n2 = this.cellColumnInRowIndices[n2];
        object = (Map.Entry)((ImmutableSet)((ImmutableMap)object).entrySet()).asList().get(n2);
        return SparseImmutableTable.cellOf(entry.getKey(), object.getKey(), object.getValue());
    }

    @Override
    V getValue(int n2) {
        int n3 = this.cellRowIndices[n2];
        ImmutableMap immutableMap = (ImmutableMap)((ImmutableCollection)this.rowMap.values()).asList().get(n3);
        n2 = this.cellColumnInRowIndices[n2];
        return (V)((ImmutableCollection)immutableMap.values()).asList().get(n2);
    }

    @Override
    public ImmutableMap<R, Map<C, V>> rowMap() {
        return ImmutableMap.copyOf(this.rowMap);
    }

    @Override
    public int size() {
        return this.cellRowIndices.length;
    }
}

