/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class SortedLists {
    private SortedLists() {
    }

    public static <E, K extends Comparable> int binarySearch(List<E> list, Function<? super E, K> function, @NullableDecl K k2, KeyPresentBehavior keyPresentBehavior, KeyAbsentBehavior keyAbsentBehavior) {
        return SortedLists.binarySearch(list, function, k2, Ordering.natural(), keyPresentBehavior, keyAbsentBehavior);
    }

    public static <E, K> int binarySearch(List<E> list, Function<? super E, K> function, @NullableDecl K k2, Comparator<? super K> comparator, KeyPresentBehavior keyPresentBehavior, KeyAbsentBehavior keyAbsentBehavior) {
        return SortedLists.binarySearch(Lists.transform(list, function), k2, comparator, keyPresentBehavior, keyAbsentBehavior);
    }

    public static <E extends Comparable> int binarySearch(List<? extends E> list, E e2, KeyPresentBehavior keyPresentBehavior, KeyAbsentBehavior keyAbsentBehavior) {
        Preconditions.checkNotNull(e2);
        return SortedLists.binarySearch(list, e2, Ordering.natural(), keyPresentBehavior, keyAbsentBehavior);
    }

    public static <E> int binarySearch(List<? extends E> list, @NullableDecl E e2, Comparator<? super E> comparator, KeyPresentBehavior keyPresentBehavior, KeyAbsentBehavior keyAbsentBehavior) {
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(list);
        Preconditions.checkNotNull(keyPresentBehavior);
        Preconditions.checkNotNull(keyAbsentBehavior);
        List<E> list2 = list;
        if (!(list instanceof RandomAccess)) {
            list2 = Lists.newArrayList(list);
        }
        int n2 = 0;
        int n3 = list2.size() - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            int n5 = comparator.compare(e2, list2.get(n4));
            if (n5 < 0) {
                n3 = n4 - 1;
                continue;
            }
            if (n5 > 0) {
                n2 = n4 + 1;
                continue;
            }
            return n2 + keyPresentBehavior.resultIndex(comparator, e2, list2.subList(n2, n3 + 1), n4 - n2);
        }
        return keyAbsentBehavior.resultIndex(n2);
    }

    static enum KeyAbsentBehavior {
        NEXT_LOWER{

            @Override
            int resultIndex(int n2) {
                return n2 - 1;
            }
        }
        ,
        NEXT_HIGHER{

            @Override
            public int resultIndex(int n2) {
                return n2;
            }
        }
        ,
        INVERTED_INSERTION_INDEX{

            @Override
            public int resultIndex(int n2) {
                return ~n2;
            }
        };


        abstract int resultIndex(int var1);
    }

    static enum KeyPresentBehavior {
        ANY_PRESENT{

            @Override
            <E> int resultIndex(Comparator<? super E> comparator, E e2, List<? extends E> list, int n2) {
                return n2;
            }
        }
        ,
        LAST_PRESENT{

            @Override
            <E> int resultIndex(Comparator<? super E> comparator, E e2, List<? extends E> list, int n2) {
                int n3 = list.size() - 1;
                while (n2 < n3) {
                    int n4 = n2 + n3 + 1 >>> 1;
                    if (comparator.compare(list.get(n4), e2) > 0) {
                        n3 = n4 - 1;
                        continue;
                    }
                    n2 = n4;
                }
                return n2;
            }
        }
        ,
        FIRST_PRESENT{

            @Override
            <E> int resultIndex(Comparator<? super E> comparator, E e2, List<? extends E> list, int n2) {
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = n3 + n2 >>> 1;
                    if (comparator.compare(list.get(n4), e2) < 0) {
                        n3 = n4 + 1;
                        continue;
                    }
                    n2 = n4;
                }
                return n3;
            }
        }
        ,
        FIRST_AFTER{

            @Override
            public <E> int resultIndex(Comparator<? super E> comparator, E e2, List<? extends E> list, int n2) {
                return LAST_PRESENT.resultIndex(comparator, e2, list, n2) + 1;
            }
        }
        ,
        LAST_BEFORE{

            @Override
            public <E> int resultIndex(Comparator<? super E> comparator, E e2, List<? extends E> list, int n2) {
                return FIRST_PRESENT.resultIndex(comparator, e2, list, n2) - 1;
            }
        };


        abstract <E> int resultIndex(Comparator<? super E> var1, E var2, List<? extends E> var3, int var4);
    }
}

