/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.concurrent.LazyInit;

final class SingletonImmutableSet<E>
extends ImmutableSet<E> {
    @LazyInit
    private transient int cachedHashCode;
    final transient E element;

    SingletonImmutableSet(E e2) {
        this.element = Preconditions.checkNotNull(e2);
    }

    SingletonImmutableSet(E e2, int n2) {
        this.element = e2;
        this.cachedHashCode = n2;
    }

    @Override
    public boolean contains(Object object) {
        return this.element.equals(object);
    }

    @Override
    int copyIntoArray(Object[] objectArray, int n2) {
        objectArray[n2] = this.element;
        return n2 + 1;
    }

    @Override
    ImmutableList<E> createAsList() {
        return ImmutableList.of(this.element);
    }

    @Override
    public final int hashCode() {
        int n2;
        int n3 = n2 = this.cachedHashCode;
        if (n2 == 0) {
            this.cachedHashCode = n3 = this.element.hashCode();
        }
        return n3;
    }

    @Override
    boolean isHashCodeFast() {
        boolean bl = this.cachedHashCode != 0;
        return bl;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(this.element.toString());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

