/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.BoundType;
import com.google.common.collect.CartesianList;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingNavigableSet;
import com.google.common.collect.ForwardingSortedSet;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableEnumSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.Synchronized;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.math.IntMath;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Sets {
    private Sets() {
    }

    public static <B> Set<List<B>> cartesianProduct(List<? extends Set<? extends B>> list) {
        return CartesianSet.create(list);
    }

    @SafeVarargs
    public static <B> Set<List<B>> cartesianProduct(Set<? extends B> ... setArray) {
        return Sets.cartesianProduct(Arrays.asList(setArray));
    }

    public static <E> Set<Set<E>> combinations(Set<E> object, final int n2) {
        object = Maps.indexMap(object);
        CollectPreconditions.checkNonnegative((int)n2, (String)"size");
        boolean bl = n2 <= object.size();
        Preconditions.checkArgument(bl, "size (%s) must be <= set.size() (%s)", n2, object.size());
        if (n2 == 0) {
            return ImmutableSet.of(ImmutableSet.of());
        }
        if (n2 == object.size()) {
            return ImmutableSet.of(((ImmutableMap)object).keySet());
        }
        return new AbstractSet<Set<E>>((ImmutableMap)object){
            final /* synthetic */ ImmutableMap val$index;
            {
                this.val$index = immutableMap;
            }

            @Override
            public boolean contains(@NullableDecl Object object) {
                boolean bl;
                boolean bl2 = object instanceof Set;
                boolean bl3 = bl = false;
                if (bl2) {
                    object = (Set)object;
                    bl3 = bl;
                    if (object.size() == n2) {
                        bl3 = bl;
                        if (((AbstractCollection)((Object)this.val$index.keySet())).containsAll((Collection<?>)object)) {
                            bl3 = true;
                        }
                    }
                }
                return bl3;
            }

            @Override
            public Iterator<Set<E>> iterator() {
                return new AbstractIterator<Set<E>>(){
                    final BitSet bits;
                    {
                        this.bits = new BitSet(val$index.size());
                    }

                    @Override
                    protected Set<E> computeNext() {
                        if (this.bits.isEmpty()) {
                            this.bits.set(0, n2);
                        } else {
                            int n2 = this.bits.nextSetBit(0);
                            int n3 = this.bits.nextClearBit(n2);
                            if (n3 == val$index.size()) {
                                return (Set)this.endOfData();
                            }
                            BitSet bitSet = this.bits;
                            n2 = n3 - n2 - 1;
                            bitSet.set(0, n2);
                            this.bits.clear(n2, n3);
                            this.bits.set(n3);
                        }
                        return new AbstractSet<E>((BitSet)this.bits.clone()){
                            final /* synthetic */ BitSet val$copy;
                            {
                                this.val$copy = bitSet;
                            }

                            @Override
                            public boolean contains(@NullableDecl Object object) {
                                boolean bl = (object = (Integer)val$index.get(object)) != null && this.val$copy.get((Integer)object);
                                return bl;
                            }

                            @Override
                            public Iterator<E> iterator() {
                                return new AbstractIterator<E>(){
                                    int i = -1;

                                    @Override
                                    protected E computeNext() {
                                        this.i = val$copy.nextSetBit(this.i + 1);
                                        if (this.i == -1) {
                                            return this.endOfData();
                                        }
                                        return ((ImmutableSet)val$index.keySet()).asList().get(this.i);
                                    }
                                };
                            }

                            @Override
                            public int size() {
                                return n2;
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return IntMath.binomial((int)this.val$index.size(), (int)n2);
            }

            @Override
            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Sets.combinations(");
                stringBuilder.append(this.val$index.keySet());
                stringBuilder.append(", ");
                stringBuilder.append(n2);
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
        };
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(Collection<E> collection) {
        if (collection instanceof EnumSet) {
            return EnumSet.complementOf((EnumSet)collection);
        }
        Preconditions.checkArgument(collection.isEmpty() ^ true, "collection is empty; use the other version of this method");
        return Sets.makeComplementByHand(collection, ((Enum)collection.iterator().next()).getDeclaringClass());
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(Collection<E> collection, Class<E> clazz) {
        Preconditions.checkNotNull(collection);
        collection = collection instanceof EnumSet ? EnumSet.complementOf((EnumSet)collection) : Sets.makeComplementByHand(collection, clazz);
        return collection;
    }

    public static <E> SetView<E> difference(final Set<E> set, final Set<?> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>(){

            @Override
            public boolean contains(Object object) {
                boolean bl = set.contains(object) && !set2.contains(object);
                return bl;
            }

            @Override
            public boolean isEmpty() {
                return set2.containsAll(set);
            }

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(){
                    final Iterator<E> itr;
                    {
                        this.itr = set.iterator();
                    }

                    @Override
                    protected E computeNext() {
                        while (this.itr.hasNext()) {
                            Object e2 = this.itr.next();
                            if (set2.contains(e2)) continue;
                            return e2;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                Iterator iterator2 = set.iterator();
                int n2 = 0;
                while (iterator2.hasNext()) {
                    Object e2 = iterator2.next();
                    if (set2.contains(e2)) continue;
                    ++n2;
                }
                return n2;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean equalsImpl(Set<?> set, @NullableDecl Object object) {
        boolean bl = true;
        if (set == object) {
            return true;
        }
        if (!(object instanceof Set)) return false;
        object = (Set)object;
        try {
            if (set.size() != object.size()) return false;
            boolean bl2 = set.containsAll((Collection<?>)object);
            if (!bl2) return false;
            return bl;
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    public static <E> NavigableSet<E> filter(NavigableSet<E> set, Predicate<? super E> predicate) {
        if (set instanceof FilteredSet) {
            set = (FilteredSet)set;
            predicate = Predicates.and(((FilteredSet)set).predicate, predicate);
            return new FilteredNavigableSet<E>((NavigableSet)((FilteredSet)set).unfiltered, predicate);
        }
        return new FilteredNavigableSet<E>(Preconditions.checkNotNull(set), Preconditions.checkNotNull(predicate));
    }

    public static <E> Set<E> filter(Set<E> filteredSet, Predicate<? super E> predicate) {
        if (filteredSet instanceof SortedSet) {
            return Sets.filter((SortedSet)((Object)filteredSet), predicate);
        }
        if (filteredSet instanceof FilteredSet) {
            filteredSet = filteredSet;
            predicate = Predicates.and(filteredSet.predicate, predicate);
            return new FilteredSet<E>((Set)filteredSet.unfiltered, predicate);
        }
        return new FilteredSet<E>(Preconditions.checkNotNull(filteredSet), Preconditions.checkNotNull(predicate));
    }

    public static <E> SortedSet<E> filter(SortedSet<E> set, Predicate<? super E> predicate) {
        if (set instanceof FilteredSet) {
            set = (FilteredSet)set;
            predicate = Predicates.and(((FilteredSet)set).predicate, predicate);
            return new FilteredSortedSet<E>((SortedSet)((FilteredSet)set).unfiltered, predicate);
        }
        return new FilteredSortedSet<E>(Preconditions.checkNotNull(set), Preconditions.checkNotNull(predicate));
    }

    static int hashCodeImpl(Set<?> object) {
        object = object.iterator();
        int n2 = 0;
        while (object.hasNext()) {
            Object e2 = object.next();
            int n3 = e2 != null ? e2.hashCode() : 0;
            n2 = ~(~(n2 + n3));
        }
        return n2;
    }

    public static <E extends Enum<E>> ImmutableSet<E> immutableEnumSet(E e2, E ... EArray) {
        return ImmutableEnumSet.asImmutable(EnumSet.of(e2, EArray));
    }

    public static <E extends Enum<E>> ImmutableSet<E> immutableEnumSet(Iterable<E> enumSet) {
        if (enumSet instanceof ImmutableEnumSet) {
            return (ImmutableEnumSet)((Object)enumSet);
        }
        if (enumSet instanceof Collection) {
            if ((enumSet = (EnumSet<Enum>)enumSet).isEmpty()) {
                return ImmutableSet.of();
            }
            return ImmutableEnumSet.asImmutable(EnumSet.copyOf(enumSet));
        }
        Iterator<E> iterator2 = enumSet.iterator();
        if (iterator2.hasNext()) {
            enumSet = EnumSet.of((Enum)iterator2.next());
            Iterators.addAll(enumSet, iterator2);
            return ImmutableEnumSet.asImmutable(enumSet);
        }
        return ImmutableSet.of();
    }

    public static <E> SetView<E> intersection(final Set<E> set, final Set<?> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>(){

            @Override
            public boolean contains(Object object) {
                boolean bl = set.contains(object) && set2.contains(object);
                return bl;
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                boolean bl = set.containsAll(collection) && set2.containsAll(collection);
                return bl;
            }

            @Override
            public boolean isEmpty() {
                return Collections.disjoint(set2, set);
            }

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(){
                    final Iterator<E> itr;
                    {
                        this.itr = set.iterator();
                    }

                    @Override
                    protected E computeNext() {
                        while (this.itr.hasNext()) {
                            Object e2 = this.itr.next();
                            if (!set2.contains(e2)) continue;
                            return e2;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                Iterator iterator2 = set.iterator();
                int n2 = 0;
                while (iterator2.hasNext()) {
                    Object e2 = iterator2.next();
                    if (!set2.contains(e2)) continue;
                    ++n2;
                }
                return n2;
            }
        };
    }

    private static <E extends Enum<E>> EnumSet<E> makeComplementByHand(Collection<E> collection, Class<E> serializable) {
        serializable = EnumSet.allOf(serializable);
        ((AbstractSet)((Object)serializable)).removeAll(collection);
        return serializable;
    }

    public static <E> Set<E> newConcurrentHashSet() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public static <E> Set<E> newConcurrentHashSet(Iterable<? extends E> iterable) {
        Set<E> set = Sets.newConcurrentHashSet();
        Iterables.addAll(set, iterable);
        return set;
    }

    public static <E> CopyOnWriteArraySet<E> newCopyOnWriteArraySet() {
        return new CopyOnWriteArraySet();
    }

    public static <E> CopyOnWriteArraySet<E> newCopyOnWriteArraySet(Iterable<? extends E> iterable) {
        iterable = iterable instanceof Collection ? Collections2.cast(iterable) : Lists.newArrayList(iterable);
        return new CopyOnWriteArraySet<E>(iterable);
    }

    public static <E extends Enum<E>> EnumSet<E> newEnumSet(Iterable<E> iterable, Class<E> serializable) {
        serializable = EnumSet.noneOf(serializable);
        Iterables.addAll(serializable, iterable);
        return serializable;
    }

    public static <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    public static <E> HashSet<E> newHashSet(Iterable<? extends E> iterable) {
        iterable = iterable instanceof Collection ? new HashSet<E>(Collections2.cast(iterable)) : Sets.newHashSet(iterable.iterator());
        return iterable;
    }

    public static <E> HashSet<E> newHashSet(Iterator<? extends E> iterator2) {
        HashSet<E> hashSet = Sets.newHashSet();
        Iterators.addAll(hashSet, iterator2);
        return hashSet;
    }

    public static <E> HashSet<E> newHashSet(E ... EArray) {
        HashSet<E> hashSet = Sets.newHashSetWithExpectedSize(EArray.length);
        Collections.addAll(hashSet, EArray);
        return hashSet;
    }

    public static <E> HashSet<E> newHashSetWithExpectedSize(int n2) {
        return new HashSet(Maps.capacity(n2));
    }

    public static <E> Set<E> newIdentityHashSet() {
        return Collections.newSetFromMap(Maps.newIdentityHashMap());
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(Iterable<? extends E> iterable) {
        if (iterable instanceof Collection) {
            return new LinkedHashSet<E>(Collections2.cast(iterable));
        }
        LinkedHashSet<E> linkedHashSet = Sets.newLinkedHashSet();
        Iterables.addAll(linkedHashSet, iterable);
        return linkedHashSet;
    }

    public static <E> LinkedHashSet<E> newLinkedHashSetWithExpectedSize(int n2) {
        return new LinkedHashSet(Maps.capacity(n2));
    }

    @Deprecated
    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return Collections.newSetFromMap(map);
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet() {
        return new TreeSet();
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet(Iterable<? extends E> iterable) {
        TreeSet<E> treeSet = Sets.newTreeSet();
        Iterables.addAll(treeSet, iterable);
        return treeSet;
    }

    public static <E> TreeSet<E> newTreeSet(Comparator<? super E> comparator) {
        return new TreeSet<E>(Preconditions.checkNotNull(comparator));
    }

    public static <E> Set<Set<E>> powerSet(Set<E> set) {
        return new PowerSet<E>(set);
    }

    static boolean removeAllImpl(Set<?> set, Collection<?> collection) {
        Preconditions.checkNotNull(collection);
        Collection<?> collection2 = collection;
        if (collection instanceof Multiset) {
            collection2 = ((Multiset)collection).elementSet();
        }
        if (collection2 instanceof Set && collection2.size() > set.size()) {
            return Iterators.removeAll(set.iterator(), collection2);
        }
        return Sets.removeAllImpl(set, collection2.iterator());
    }

    static boolean removeAllImpl(Set<?> set, Iterator<?> iterator2) {
        boolean bl = false;
        while (iterator2.hasNext()) {
            bl |= set.remove(iterator2.next());
        }
        return bl;
    }

    public static <K extends Comparable<? super K>> NavigableSet<K> subSet(NavigableSet<K> navigableSet, Range<K> range) {
        boolean bl;
        Comparator<Object> comparator = navigableSet.comparator();
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        if (comparator != null && navigableSet.comparator() != Ordering.natural() && range.hasLowerBound() && range.hasUpperBound()) {
            bl = navigableSet.comparator().compare(range.lowerEndpoint(), range.upperEndpoint()) <= 0;
            Preconditions.checkArgument(bl, "set is using a custom comparator which is inconsistent with the natural ordering.");
        }
        if (range.hasLowerBound() && range.hasUpperBound()) {
            comparator = range.lowerEndpoint();
            bl = range.lowerBoundType() == BoundType.CLOSED;
            K k2 = range.upperEndpoint();
            if (range.upperBoundType() != BoundType.CLOSED) {
                bl4 = false;
            }
            return navigableSet.subSet(comparator, bl, k2, bl4);
        }
        if (range.hasLowerBound()) {
            comparator = range.lowerEndpoint();
            bl = range.lowerBoundType() == BoundType.CLOSED ? bl2 : false;
            return navigableSet.tailSet(comparator, bl);
        }
        if (range.hasUpperBound()) {
            comparator = range.upperEndpoint();
            bl = range.upperBoundType() == BoundType.CLOSED ? bl3 : false;
            return navigableSet.headSet(comparator, bl);
        }
        return Preconditions.checkNotNull(navigableSet);
    }

    public static <E> SetView<E> symmetricDifference(final Set<? extends E> set, final Set<? extends E> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>(){

            @Override
            public boolean contains(Object object) {
                boolean bl = set.contains(object);
                return set2.contains(object) ^ bl;
            }

            @Override
            public boolean isEmpty() {
                return set.equals(set2);
            }

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(set.iterator(), set2.iterator()){
                    final /* synthetic */ Iterator val$itr1;
                    final /* synthetic */ Iterator val$itr2;
                    {
                        this.val$itr1 = iterator2;
                        this.val$itr2 = iterator3;
                    }

                    @Override
                    public E computeNext() {
                        Object e2;
                        while (this.val$itr1.hasNext()) {
                            e2 = this.val$itr1.next();
                            if (set2.contains(e2)) continue;
                            return e2;
                        }
                        while (this.val$itr2.hasNext()) {
                            e2 = this.val$itr2.next();
                            if (set.contains(e2)) continue;
                            return e2;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                Iterator iterator2 = set.iterator();
                int n2 = 0;
                while (iterator2.hasNext()) {
                    Object e2 = iterator2.next();
                    if (set2.contains(e2)) continue;
                    ++n2;
                }
                for (Object e2 : set2) {
                    if (set.contains(e2)) continue;
                    ++n2;
                }
                return n2;
            }
        };
    }

    public static <E> NavigableSet<E> synchronizedNavigableSet(NavigableSet<E> navigableSet) {
        return Synchronized.navigableSet(navigableSet);
    }

    public static <E> SetView<E> union(final Set<? extends E> set, final Set<? extends E> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>(){

            @Override
            public boolean contains(Object object) {
                boolean bl = set.contains(object) || set2.contains(object);
                return bl;
            }

            @Override
            public <S extends Set<E>> S copyInto(S s2) {
                s2.addAll(set);
                s2.addAll(set2);
                return s2;
            }

            @Override
            public ImmutableSet<E> immutableCopy() {
                return ((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().addAll((Iterable)set)).addAll((Iterable)set2)).build();
            }

            @Override
            public boolean isEmpty() {
                boolean bl = set.isEmpty() && set2.isEmpty();
                return bl;
            }

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(){
                    final Iterator<? extends E> itr1;
                    final Iterator<? extends E> itr2;
                    {
                        this.itr1 = set.iterator();
                        this.itr2 = set2.iterator();
                    }

                    @Override
                    protected E computeNext() {
                        if (this.itr1.hasNext()) {
                            return this.itr1.next();
                        }
                        while (this.itr2.hasNext()) {
                            Object e2 = this.itr2.next();
                            if (set.contains(e2)) continue;
                            return e2;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                int n2 = set.size();
                for (Object e2 : set2) {
                    if (set.contains(e2)) continue;
                    ++n2;
                }
                return n2;
            }
        };
    }

    public static <E> NavigableSet<E> unmodifiableNavigableSet(NavigableSet<E> navigableSet) {
        if (!(navigableSet instanceof ImmutableCollection) && !(navigableSet instanceof UnmodifiableNavigableSet)) {
            return new UnmodifiableNavigableSet<E>(navigableSet);
        }
        return navigableSet;
    }

    private static final class CartesianSet<E>
    extends ForwardingCollection<List<E>>
    implements Set<List<E>> {
        private final transient ImmutableList<ImmutableSet<E>> axes;
        private final transient CartesianList<E> delegate;

        private CartesianSet(ImmutableList<ImmutableSet<E>> immutableList, CartesianList<E> cartesianList) {
            this.axes = immutableList;
            this.delegate = cartesianList;
        }

        static <E> Set<List<E>> create(List<? extends Set<? extends E>> object) {
            ImmutableList.Builder builder = new ImmutableList.Builder(object.size());
            object = object.iterator();
            while (object.hasNext()) {
                ImmutableSet immutableSet = ImmutableSet.copyOf((Set)object.next());
                if (immutableSet.isEmpty()) {
                    return ImmutableSet.of();
                }
                builder.add(immutableSet);
            }
            object = builder.build();
            return new CartesianSet(object, new CartesianList(new ImmutableList<List<E>>((ImmutableList)object){
                final /* synthetic */ ImmutableList val$axes;
                {
                    this.val$axes = immutableList;
                }

                @Override
                public List<E> get(int n2) {
                    return ((ImmutableSet)this.val$axes.get(n2)).asList();
                }

                @Override
                boolean isPartialView() {
                    return true;
                }

                @Override
                public int size() {
                    return this.val$axes.size();
                }
            }));
        }

        @Override
        protected Collection<List<E>> delegate() {
            return this.delegate;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof CartesianSet) {
                object = (CartesianSet)object;
                return this.axes.equals(((CartesianSet)object).axes);
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2;
            int n3 = this.size();
            int n4 = 1;
            --n3;
            for (n2 = 0; n2 < this.axes.size(); ++n2) {
                n3 = ~(~(n3 * 31));
            }
            Iterator iterator2 = this.axes.iterator();
            n2 = n4;
            while (iterator2.hasNext()) {
                Set set = (Set)iterator2.next();
                n2 = ~(~(n2 * 31 + this.size() / set.size() * set.hashCode()));
            }
            return ~(~(n2 + n3));
        }
    }

    static class DescendingSet<E>
    extends ForwardingNavigableSet<E> {
        private final NavigableSet<E> forward;

        DescendingSet(NavigableSet<E> navigableSet) {
            this.forward = navigableSet;
        }

        private static <T> Ordering<T> reverse(Comparator<T> comparator) {
            return Ordering.from(comparator).reverse();
        }

        public E ceiling(E e2) {
            return this.forward.floor(e2);
        }

        public Comparator<? super E> comparator() {
            Comparator comparator = this.forward.comparator();
            if (comparator == null) {
                return Ordering.natural().reverse();
            }
            return DescendingSet.reverse(comparator);
        }

        protected NavigableSet<E> delegate() {
            return this.forward;
        }

        public Iterator<E> descendingIterator() {
            return this.forward.iterator();
        }

        public NavigableSet<E> descendingSet() {
            return this.forward;
        }

        public E first() {
            return this.forward.last();
        }

        public E floor(E e2) {
            return this.forward.ceiling(e2);
        }

        public NavigableSet<E> headSet(E e2, boolean bl) {
            return this.forward.tailSet(e2, bl).descendingSet();
        }

        public SortedSet<E> headSet(E e2) {
            return this.standardHeadSet(e2);
        }

        public E higher(E e2) {
            return this.forward.lower(e2);
        }

        public Iterator<E> iterator() {
            return this.forward.descendingIterator();
        }

        public E last() {
            return this.forward.first();
        }

        public E lower(E e2) {
            return this.forward.higher(e2);
        }

        public E pollFirst() {
            return this.forward.pollLast();
        }

        public E pollLast() {
            return this.forward.pollFirst();
        }

        public NavigableSet<E> subSet(E e2, boolean bl, E e3, boolean bl2) {
            return this.forward.subSet(e3, bl2, e2, bl).descendingSet();
        }

        public SortedSet<E> subSet(E e2, E e3) {
            return this.standardSubSet(e2, e3);
        }

        public NavigableSet<E> tailSet(E e2, boolean bl) {
            return this.forward.headSet(e2, bl).descendingSet();
        }

        public SortedSet<E> tailSet(E e2) {
            return this.standardTailSet(e2);
        }

        public Object[] toArray() {
            return this.standardToArray();
        }

        public <T> T[] toArray(T[] TArray) {
            return this.standardToArray(TArray);
        }

        public String toString() {
            return this.standardToString();
        }
    }

    private static class FilteredNavigableSet<E>
    extends FilteredSortedSet<E>
    implements NavigableSet<E> {
        FilteredNavigableSet(NavigableSet<E> navigableSet, Predicate<? super E> predicate) {
            super(navigableSet, predicate);
        }

        @Override
        public E ceiling(E e2) {
            return Iterables.find(this.unfiltered().tailSet(e2, true), this.predicate, null);
        }

        @Override
        public Iterator<E> descendingIterator() {
            return Iterators.filter(this.unfiltered().descendingIterator(), this.predicate);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return Sets.filter(this.unfiltered().descendingSet(), this.predicate);
        }

        @Override
        @NullableDecl
        public E floor(E e2) {
            return Iterators.find(this.unfiltered().headSet(e2, true).descendingIterator(), this.predicate, null);
        }

        @Override
        public NavigableSet<E> headSet(E e2, boolean bl) {
            return Sets.filter(this.unfiltered().headSet(e2, bl), this.predicate);
        }

        @Override
        public E higher(E e2) {
            return Iterables.find(this.unfiltered().tailSet(e2, false), this.predicate, null);
        }

        @Override
        public E last() {
            return Iterators.find(this.unfiltered().descendingIterator(), this.predicate);
        }

        @Override
        @NullableDecl
        public E lower(E e2) {
            return Iterators.find(this.unfiltered().headSet(e2, false).descendingIterator(), this.predicate, null);
        }

        @Override
        public E pollFirst() {
            return Iterables.removeFirstMatching(this.unfiltered(), this.predicate);
        }

        @Override
        public E pollLast() {
            return Iterables.removeFirstMatching(this.unfiltered().descendingSet(), this.predicate);
        }

        @Override
        public NavigableSet<E> subSet(E e2, boolean bl, E e3, boolean bl2) {
            return Sets.filter(this.unfiltered().subSet(e2, bl, e3, bl2), this.predicate);
        }

        @Override
        public NavigableSet<E> tailSet(E e2, boolean bl) {
            return Sets.filter(this.unfiltered().tailSet(e2, bl), this.predicate);
        }

        NavigableSet<E> unfiltered() {
            return (NavigableSet)this.unfiltered;
        }
    }

    private static class FilteredSet<E>
    extends Collections2.FilteredCollection<E>
    implements Set<E> {
        FilteredSet(Set<E> set, Predicate<? super E> predicate) {
            super(set, predicate);
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            return Sets.equalsImpl(this, object);
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }
    }

    private static class FilteredSortedSet<E>
    extends FilteredSet<E>
    implements SortedSet<E> {
        FilteredSortedSet(SortedSet<E> sortedSet, Predicate<? super E> predicate) {
            super(sortedSet, predicate);
        }

        @Override
        public Comparator<? super E> comparator() {
            return ((SortedSet)this.unfiltered).comparator();
        }

        @Override
        public E first() {
            return Iterators.find(this.unfiltered.iterator(), this.predicate);
        }

        @Override
        public SortedSet<E> headSet(E e2) {
            return new FilteredSortedSet<E>(((SortedSet)this.unfiltered).headSet(e2), this.predicate);
        }

        @Override
        public E last() {
            SortedSet sortedSet = (SortedSet)this.unfiltered;
            Object e2;
            while (!this.predicate.apply(e2 = sortedSet.last())) {
                sortedSet = sortedSet.headSet(e2);
            }
            return e2;
        }

        @Override
        public SortedSet<E> subSet(E e2, E e3) {
            return new FilteredSortedSet<E>(((SortedSet)this.unfiltered).subSet(e2, e3), this.predicate);
        }

        @Override
        public SortedSet<E> tailSet(E e2) {
            return new FilteredSortedSet<E>(((SortedSet)this.unfiltered).tailSet(e2), this.predicate);
        }
    }

    static abstract class ImprovedAbstractSet<E>
    extends AbstractSet<E> {
        ImprovedAbstractSet() {
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return Sets.removeAllImpl(this, collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return super.retainAll(Preconditions.checkNotNull(collection));
        }
    }

    private static final class PowerSet<E>
    extends AbstractSet<Set<E>> {
        final ImmutableMap<E, Integer> inputSet;

        PowerSet(Set<E> set) {
            boolean bl = set.size() <= 30;
            Preconditions.checkArgument(bl, "Too many elements to create power set: %s > 30", set.size());
            this.inputSet = Maps.indexMap(set);
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            if (object instanceof Set) {
                object = (Set)object;
                return ((AbstractCollection)((Object)this.inputSet.keySet())).containsAll((Collection<?>)object);
            }
            return false;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof PowerSet) {
                object = (PowerSet)object;
                return this.inputSet.equals(((PowerSet)object).inputSet);
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            return ((ImmutableSet)this.inputSet.keySet()).hashCode() << this.inputSet.size() - 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<Set<E>> iterator() {
            return new AbstractIndexedListIterator<Set<E>>(this.size()){

                protected Set<E> get(int n2) {
                    return new SubSet(PowerSet.this.inputSet, n2);
                }
            };
        }

        @Override
        public int size() {
            return 1 << this.inputSet.size();
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("powerSet(");
            stringBuilder.append(this.inputSet);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    public static abstract class SetView<E>
    extends AbstractSet<E> {
        private SetView() {
        }

        @Override
        @Deprecated
        public final boolean add(E e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final void clear() {
            throw new UnsupportedOperationException();
        }

        public <S extends Set<E>> S copyInto(S s2) {
            s2.addAll(this);
            return s2;
        }

        public ImmutableSet<E> immutableCopy() {
            return ImmutableSet.copyOf(this);
        }

        @Override
        public abstract UnmodifiableIterator<E> iterator();

        @Override
        @Deprecated
        public final boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class SubSet<E>
    extends AbstractSet<E> {
        private final ImmutableMap<E, Integer> inputSet;
        private final int mask;

        SubSet(ImmutableMap<E, Integer> immutableMap, int n2) {
            this.inputSet = immutableMap;
            this.mask = n2;
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            boolean bl;
            block3: {
                block2: {
                    object = this.inputSet.get(object);
                    bl = true;
                    if (object == null) break block2;
                    int n2 = this.mask;
                    if ((1 << (Integer)object & n2) != 0) break block3;
                }
                bl = false;
            }
            return bl;
        }

        @Override
        public Iterator<E> iterator() {
            return new UnmodifiableIterator<E>(){
                final ImmutableList<E> elements;
                int remainingSetBits;
                {
                    this.elements = ((ImmutableSet)SubSet.this.inputSet.keySet()).asList();
                    this.remainingSetBits = SubSet.this.mask;
                }

                @Override
                public boolean hasNext() {
                    boolean bl = this.remainingSetBits != 0;
                    return bl;
                }

                @Override
                public E next() {
                    int n2 = Integer.numberOfTrailingZeros(this.remainingSetBits);
                    if (n2 != 32) {
                        this.remainingSetBits &= ~(1 << n2);
                        return this.elements.get(n2);
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public int size() {
            return Integer.bitCount(this.mask);
        }
    }

    static final class UnmodifiableNavigableSet<E>
    extends ForwardingSortedSet<E>
    implements NavigableSet<E>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final NavigableSet<E> delegate;
        @MonotonicNonNullDecl
        private transient UnmodifiableNavigableSet<E> descendingSet;
        private final SortedSet<E> unmodifiableDelegate;

        UnmodifiableNavigableSet(NavigableSet<E> navigableSet) {
            this.delegate = Preconditions.checkNotNull(navigableSet);
            this.unmodifiableDelegate = Collections.unmodifiableSortedSet(navigableSet);
        }

        @Override
        public E ceiling(E e2) {
            return this.delegate.ceiling(e2);
        }

        @Override
        protected SortedSet<E> delegate() {
            return this.unmodifiableDelegate;
        }

        @Override
        public Iterator<E> descendingIterator() {
            return Iterators.unmodifiableIterator(this.delegate.descendingIterator());
        }

        @Override
        public NavigableSet<E> descendingSet() {
            UnmodifiableNavigableSet<E> unmodifiableNavigableSet;
            UnmodifiableNavigableSet<E> unmodifiableNavigableSet2 = unmodifiableNavigableSet = this.descendingSet;
            if (unmodifiableNavigableSet == null) {
                this.descendingSet = unmodifiableNavigableSet2 = new UnmodifiableNavigableSet<E>(this.delegate.descendingSet());
                unmodifiableNavigableSet2.descendingSet = this;
            }
            return unmodifiableNavigableSet2;
        }

        @Override
        public E floor(E e2) {
            return this.delegate.floor(e2);
        }

        @Override
        public NavigableSet<E> headSet(E e2, boolean bl) {
            return Sets.unmodifiableNavigableSet(this.delegate.headSet(e2, bl));
        }

        @Override
        public E higher(E e2) {
            return this.delegate.higher(e2);
        }

        @Override
        public E lower(E e2) {
            return this.delegate.lower(e2);
        }

        @Override
        public E pollFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E pollLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableSet<E> subSet(E e2, boolean bl, E e3, boolean bl2) {
            return Sets.unmodifiableNavigableSet(this.delegate.subSet(e2, bl, e3, bl2));
        }

        @Override
        public NavigableSet<E> tailSet(E e2, boolean bl) {
            return Sets.unmodifiableNavigableSet(this.delegate.tailSet(e2, bl));
        }
    }
}

