/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.DenseImmutableTable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.IndexedImmutableSet;
import com.google.common.collect.SparseImmutableTable;
import com.google.common.collect.Table;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class RegularImmutableTable<R, C, V>
extends ImmutableTable<R, C, V> {
    RegularImmutableTable() {
    }

    static <R, C, V> RegularImmutableTable<R, C, V> forCells(Iterable<Table.Cell<R, C, V>> iterable) {
        return RegularImmutableTable.forCellsInternal(iterable, null, null);
    }

    static <R, C, V> RegularImmutableTable<R, C, V> forCells(List<Table.Cell<R, C, V>> list, final @NullableDecl Comparator<? super R> comparator, final @NullableDecl Comparator<? super C> comparator2) {
        Preconditions.checkNotNull(list);
        if (comparator != null || comparator2 != null) {
            Collections.sort(list, new Comparator<Table.Cell<R, C, V>>(){

                @Override
                public int compare(Table.Cell<R, C, V> cell, Table.Cell<R, C, V> cell2) {
                    Comparator comparator3 = comparator;
                    int n2 = 0;
                    int n3 = comparator3 == null ? 0 : comparator3.compare(cell.getRowKey(), cell2.getRowKey());
                    if (n3 != 0) {
                        return n3;
                    }
                    comparator3 = comparator2;
                    n3 = comparator3 == null ? n2 : comparator3.compare(cell.getColumnKey(), cell2.getColumnKey());
                    return n3;
                }
            });
        }
        return RegularImmutableTable.forCellsInternal(list, comparator, comparator2);
    }

    /*
     * WARNING - void declaration
     */
    private static <R, C, V> RegularImmutableTable<R, C, V> forCellsInternal(Iterable<Table.Cell<R, C, V>> immutableSet3, @NullableDecl Comparator<? super R> immutableSet2, @NullableDecl Comparator<? super C> comparator) {
        void var0_5;
        void var2_7;
        ImmutableSet immutableSet;
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        LinkedHashSet linkedHashSet2 = new LinkedHashSet();
        ImmutableList<Object> immutableList = ImmutableList.copyOf(immutableSet3);
        for (Table.Cell cell : immutableSet3) {
            linkedHashSet.add(cell.getRowKey());
            linkedHashSet2.add(cell.getColumnKey());
        }
        if (immutableSet == null) {
            ImmutableSet immutableSet4 = ImmutableSet.copyOf(linkedHashSet);
        } else {
            ImmutableSet immutableSet5 = ImmutableSet.copyOf(ImmutableList.sortedCopyOf(immutableSet, linkedHashSet));
        }
        immutableSet = var2_7 == null ? ImmutableSet.copyOf(linkedHashSet2) : ImmutableSet.copyOf(ImmutableList.sortedCopyOf(var2_7, linkedHashSet2));
        return RegularImmutableTable.forOrderedComponents(immutableList, var0_5, immutableSet);
    }

    static <R, C, V> RegularImmutableTable<R, C, V> forOrderedComponents(ImmutableList<Table.Cell<R, C, V>> serializable, ImmutableSet<R> immutableSet, ImmutableSet<C> immutableSet2) {
        serializable = (long)serializable.size() > (long)immutableSet.size() * (long)immutableSet2.size() / 2L ? new DenseImmutableTable<R, C, V>(serializable, immutableSet, immutableSet2) : new SparseImmutableTable<R, C, V>(serializable, immutableSet, immutableSet2);
        return serializable;
    }

    final void checkNoDuplicate(R r2, C c2, V v2, V v3) {
        boolean bl = v2 == null;
        Preconditions.checkArgument(bl, "Duplicate key: (row=%s, column=%s), values: [%s, %s].", r2, c2, v3, v2);
    }

    @Override
    final ImmutableSet<Table.Cell<R, C, V>> createCellSet() {
        CellSet cellSet = this.isEmpty() ? ImmutableSet.of() : new CellSet();
        return cellSet;
    }

    @Override
    final ImmutableCollection<V> createValues() {
        Values values = this.isEmpty() ? ImmutableList.of() : new Values();
        return values;
    }

    abstract Table.Cell<R, C, V> getCell(int var1);

    abstract V getValue(int var1);

    private final class CellSet
    extends IndexedImmutableSet<Table.Cell<R, C, V>> {
        private CellSet() {
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            boolean bl;
            boolean bl2 = object instanceof Table.Cell;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (Table.Cell)object;
                Object object2 = RegularImmutableTable.this.get(object.getRowKey(), object.getColumnKey());
                bl3 = bl;
                if (object2 != null) {
                    bl3 = bl;
                    if (object2.equals(object.getValue())) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        @Override
        Table.Cell<R, C, V> get(int n2) {
            return RegularImmutableTable.this.getCell(n2);
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        public int size() {
            return RegularImmutableTable.this.size();
        }
    }

    private final class Values
    extends ImmutableList<V> {
        private Values() {
        }

        @Override
        public V get(int n2) {
            return RegularImmutableTable.this.getValue(n2);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return RegularImmutableTable.this.size();
        }
    }
}

