/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.SortedIterables;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class RegularImmutableSortedSet<E>
extends ImmutableSortedSet<E> {
    static final RegularImmutableSortedSet<Comparable> NATURAL_EMPTY_SET = new RegularImmutableSortedSet(ImmutableList.of(), Ordering.natural());
    final transient ImmutableList<E> elements;

    RegularImmutableSortedSet(ImmutableList<E> immutableList, Comparator<? super E> comparator) {
        super(comparator);
        this.elements = immutableList;
    }

    private int unsafeBinarySearch(Object object) throws ClassCastException {
        return Collections.binarySearch(this.elements, object, this.unsafeComparator());
    }

    @Override
    public ImmutableList<E> asList() {
        return this.elements;
    }

    @Override
    public E ceiling(E object) {
        int n2 = this.tailIndex(object, true);
        object = n2 == this.size() ? null : this.elements.get(n2);
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contains(@NullableDecl Object object) {
        boolean bl;
        boolean bl2 = bl = false;
        if (object == null) return bl2;
        try {
            int n2 = this.unsafeBinarySearch(object);
            bl2 = bl;
            if (n2 < 0) return bl2;
            return true;
        }
        catch (ClassCastException classCastException) {
            return bl;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean containsAll(Collection<?> collection) {
        void var2_8;
        Collection<Object> collection2 = collection;
        if (collection instanceof Multiset) {
            Set set = ((Multiset)collection).elementSet();
        }
        if (!SortedIterables.hasSameComparator(this.comparator(), (Iterable)var2_8)) return super.containsAll((Collection<?>)var2_8);
        if (var2_8.size() <= 1) {
            return super.containsAll((Collection<?>)var2_8);
        }
        Iterator iterator2 = this.iterator();
        Iterator iterator3 = var2_8.iterator();
        if (!iterator2.hasNext()) {
            return false;
        }
        Object e2 = iterator3.next();
        Object e3 = iterator2.next();
        try {
            while (true) {
                void var2_10;
                void var1_3;
                int n2;
                if ((n2 = this.unsafeCompare(var1_3, var2_10)) < 0) {
                    if (!iterator2.hasNext()) {
                        return false;
                    }
                    Object e4 = iterator2.next();
                    continue;
                }
                if (n2 == 0) {
                    if (!iterator3.hasNext()) {
                        return true;
                    }
                    Object e5 = iterator3.next();
                    continue;
                }
                if (n2 > 0) break;
            }
            return false;
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    @Override
    int copyIntoArray(Object[] objectArray, int n2) {
        return this.elements.copyIntoArray(objectArray, n2);
    }

    @Override
    ImmutableSortedSet<E> createDescendingSet() {
        RegularImmutableSortedSet<Object> regularImmutableSortedSet = Collections.reverseOrder(this.comparator);
        regularImmutableSortedSet = this.isEmpty() ? RegularImmutableSortedSet.emptySet(regularImmutableSortedSet) : new RegularImmutableSortedSet<E>(this.elements.reverse(), regularImmutableSortedSet);
        return regularImmutableSortedSet;
    }

    @Override
    public UnmodifiableIterator<E> descendingIterator() {
        return this.elements.reverse().iterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(@NullableDecl Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        object = (Set)object;
        if (this.size() != object.size()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        if (!SortedIterables.hasSameComparator((Comparator)this.comparator, (Iterable)object)) {
            return this.containsAll((Collection<?>)object);
        }
        Iterator iterator2 = object.iterator();
        try {
            Object e2;
            int n2;
            Object e3;
            object = this.iterator();
            do {
                if (!object.hasNext()) {
                    return true;
                }
                e2 = object.next();
            } while ((e3 = iterator2.next()) != null && (n2 = this.unsafeCompare(e2, e3)) == 0);
            return false;
        }
        catch (ClassCastException | NoSuchElementException runtimeException) {
            return false;
        }
    }

    @Override
    public E first() {
        if (!this.isEmpty()) {
            return this.elements.get(0);
        }
        throw new NoSuchElementException();
    }

    @Override
    public E floor(E object) {
        int n2 = this.headIndex(object, true) - 1;
        object = n2 == -1 ? null : this.elements.get(n2);
        return object;
    }

    RegularImmutableSortedSet<E> getSubSet(int n2, int n3) {
        if (n2 == 0 && n3 == this.size()) {
            return this;
        }
        if (n2 < n3) {
            return new RegularImmutableSortedSet<E>(this.elements.subList(n2, n3), this.comparator);
        }
        return RegularImmutableSortedSet.emptySet(this.comparator);
    }

    int headIndex(E e2, boolean bl) {
        int n2 = Collections.binarySearch(this.elements, Preconditions.checkNotNull(e2), this.comparator());
        if (n2 >= 0) {
            int n3 = n2;
            if (bl) {
                n3 = n2 + 1;
            }
            return n3;
        }
        return ~n2;
    }

    @Override
    ImmutableSortedSet<E> headSetImpl(E e2, boolean bl) {
        return this.getSubSet(0, this.headIndex(e2, bl));
    }

    @Override
    public E higher(E object) {
        int n2 = this.tailIndex(object, false);
        object = n2 == this.size() ? null : this.elements.get(n2);
        return object;
    }

    @Override
    int indexOf(@NullableDecl Object object) {
        if (object == null) {
            return -1;
        }
        try {
            int n2 = Collections.binarySearch(this.elements, object, this.unsafeComparator());
            if (n2 < 0) {
                n2 = -1;
            }
            return n2;
        }
        catch (ClassCastException classCastException) {
            return -1;
        }
    }

    @Override
    Object[] internalArray() {
        return this.elements.internalArray();
    }

    @Override
    int internalArrayEnd() {
        return this.elements.internalArrayEnd();
    }

    @Override
    int internalArrayStart() {
        return this.elements.internalArrayStart();
    }

    @Override
    boolean isPartialView() {
        return this.elements.isPartialView();
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public E last() {
        if (!this.isEmpty()) {
            return this.elements.get(this.size() - 1);
        }
        throw new NoSuchElementException();
    }

    @Override
    public E lower(E object) {
        int n2 = this.headIndex(object, false) - 1;
        object = n2 == -1 ? null : this.elements.get(n2);
        return object;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    ImmutableSortedSet<E> subSetImpl(E e2, boolean bl, E e3, boolean bl2) {
        return this.tailSetImpl(e2, bl).headSetImpl(e3, bl2);
    }

    int tailIndex(E e2, boolean bl) {
        int n2 = Collections.binarySearch(this.elements, Preconditions.checkNotNull(e2), this.comparator());
        if (n2 >= 0) {
            if (!bl) {
                ++n2;
            }
            return n2;
        }
        return ~n2;
    }

    @Override
    ImmutableSortedSet<E> tailSetImpl(E e2, boolean bl) {
        return this.getSubSet(this.tailIndex(e2, bl), this.size());
    }

    Comparator<Object> unsafeComparator() {
        return this.comparator;
    }
}

