/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.primitives.Ints;
import java.util.Comparator;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class RegularImmutableSortedMultiset<E>
extends ImmutableSortedMultiset<E> {
    static final ImmutableSortedMultiset<Comparable> NATURAL_EMPTY_MULTISET;
    private static final long[] ZERO_CUMULATIVE_COUNTS;
    private final transient long[] cumulativeCounts;
    final transient RegularImmutableSortedSet<E> elementSet;
    private final transient int length;
    private final transient int offset;

    static {
        ZERO_CUMULATIVE_COUNTS = new long[]{0L};
        NATURAL_EMPTY_MULTISET = new RegularImmutableSortedMultiset(Ordering.natural());
    }

    RegularImmutableSortedMultiset(RegularImmutableSortedSet<E> regularImmutableSortedSet, long[] lArray, int n2, int n3) {
        this.elementSet = regularImmutableSortedSet;
        this.cumulativeCounts = lArray;
        this.offset = n2;
        this.length = n3;
    }

    RegularImmutableSortedMultiset(Comparator<? super E> comparator) {
        this.elementSet = ImmutableSortedSet.emptySet(comparator);
        this.cumulativeCounts = ZERO_CUMULATIVE_COUNTS;
        this.offset = 0;
        this.length = 0;
    }

    private int getCount(int n2) {
        long[] lArray = this.cumulativeCounts;
        int n3 = this.offset;
        return (int)(lArray[n3 + n2 + 1] - lArray[n3 + n2]);
    }

    @Override
    public int count(@NullableDecl Object object) {
        int n2 = this.elementSet.indexOf(object);
        n2 = n2 >= 0 ? this.getCount(n2) : 0;
        return n2;
    }

    @Override
    public ImmutableSortedSet<E> elementSet() {
        return this.elementSet;
    }

    @Override
    public Multiset.Entry<E> firstEntry() {
        Multiset.Entry<E> entry = this.isEmpty() ? null : this.getEntry(0);
        return entry;
    }

    @Override
    Multiset.Entry<E> getEntry(int n2) {
        return Multisets.immutableEntry(this.elementSet.asList().get(n2), this.getCount(n2));
    }

    ImmutableSortedMultiset<E> getSubMultiset(int n2, int n3) {
        Preconditions.checkPositionIndexes(n2, n3, this.length);
        if (n2 == n3) {
            return RegularImmutableSortedMultiset.emptyMultiset(this.comparator());
        }
        if (n2 == 0 && n3 == this.length) {
            return this;
        }
        return new RegularImmutableSortedMultiset<E>(this.elementSet.getSubSet(n2, n3), this.cumulativeCounts, this.offset + n2, n3 - n2);
    }

    @Override
    public ImmutableSortedMultiset<E> headMultiset(E e2, BoundType boundType) {
        RegularImmutableSortedSet<E> regularImmutableSortedSet = this.elementSet;
        boolean bl = Preconditions.checkNotNull(boundType) == BoundType.CLOSED;
        return this.getSubMultiset(0, regularImmutableSortedSet.headIndex(e2, bl));
    }

    @Override
    boolean isPartialView() {
        boolean bl;
        int n2 = this.offset;
        boolean bl2 = bl = true;
        if (n2 <= 0) {
            bl2 = this.length < this.cumulativeCounts.length - 1 ? bl : false;
        }
        return bl2;
    }

    @Override
    public Multiset.Entry<E> lastEntry() {
        Multiset.Entry<E> entry = this.isEmpty() ? null : this.getEntry(this.length - 1);
        return entry;
    }

    @Override
    public int size() {
        long[] lArray = this.cumulativeCounts;
        int n2 = this.offset;
        return Ints.saturatedCast(lArray[this.length + n2] - lArray[n2]);
    }

    @Override
    public ImmutableSortedMultiset<E> tailMultiset(E e2, BoundType boundType) {
        RegularImmutableSortedSet<E> regularImmutableSortedSet = this.elementSet;
        boolean bl = Preconditions.checkNotNull(boundType) == BoundType.CLOSED;
        return this.getSubMultiset(regularImmutableSortedSet.tailIndex(e2, bl), this.length);
    }
}

