/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class RegularImmutableSet<E>
extends ImmutableSet<E> {
    static final RegularImmutableSet<Object> EMPTY = new RegularImmutableSet(new Object[0], 0, null, 0, 0);
    final transient Object[] elements;
    private final transient int hashCode;
    private final transient int mask;
    private final transient int size;
    final transient Object[] table;

    RegularImmutableSet(Object[] objectArray, int n2, Object[] objectArray2, int n3, int n4) {
        this.elements = objectArray;
        this.table = objectArray2;
        this.mask = n3;
        this.hashCode = n2;
        this.size = n4;
    }

    @Override
    public boolean contains(@NullableDecl Object object) {
        Object[] objectArray = this.table;
        if (object != null && objectArray != null) {
            int n2 = Hashing.smearedHash(object);
            while (true) {
                Object object2;
                if ((object2 = objectArray[n2 &= this.mask]) == null) {
                    return false;
                }
                if (object2.equals(object)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    int copyIntoArray(Object[] objectArray, int n2) {
        System.arraycopy(this.elements, 0, objectArray, n2, this.size);
        return n2 + this.size;
    }

    @Override
    ImmutableList<E> createAsList() {
        return ImmutableList.asImmutableList(this.elements, this.size);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    Object[] internalArray() {
        return this.elements;
    }

    @Override
    int internalArrayEnd() {
        return this.size;
    }

    @Override
    int internalArrayStart() {
        return 0;
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.asList().iterator();
    }

    @Override
    public int size() {
        return this.size;
    }
}

