/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.IndexedImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.ObjectCountHashMap;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.Serializable;
import java.util.Iterator;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

class RegularImmutableMultiset<E>
extends ImmutableMultiset<E> {
    static final RegularImmutableMultiset<Object> EMPTY = new RegularImmutableMultiset(ObjectCountHashMap.create());
    final transient ObjectCountHashMap<E> contents;
    @LazyInit
    private transient ImmutableSet<E> elementSet;
    private final transient int size;

    RegularImmutableMultiset(ObjectCountHashMap<E> objectCountHashMap) {
        this.contents = objectCountHashMap;
        long l2 = 0L;
        for (int i2 = 0; i2 < objectCountHashMap.size(); ++i2) {
            l2 += (long)objectCountHashMap.getValue(i2);
        }
        this.size = Ints.saturatedCast(l2);
    }

    @Override
    public int count(@NullableDecl Object object) {
        return this.contents.get(object);
    }

    @Override
    public ImmutableSet<E> elementSet() {
        ElementSet elementSet;
        ElementSet elementSet2 = elementSet = this.elementSet;
        if (elementSet == null) {
            this.elementSet = elementSet2 = new ElementSet();
        }
        return elementSet2;
    }

    @Override
    Multiset.Entry<E> getEntry(int n2) {
        return this.contents.getEntry(n2);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this);
    }

    private final class ElementSet
    extends IndexedImmutableSet<E> {
        private ElementSet() {
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            return RegularImmutableMultiset.this.contains(object);
        }

        @Override
        E get(int n2) {
            return RegularImmutableMultiset.this.contents.getKey(n2);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return RegularImmutableMultiset.this.contents.size();
        }
    }

    private static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 0L;
        final int[] counts;
        final Object[] elements;

        SerializedForm(Multiset<?> object) {
            int n2 = object.entrySet().size();
            this.elements = new Object[n2];
            this.counts = new int[n2];
            Iterator<Multiset.Entry<?>> iterator2 = object.entrySet().iterator();
            n2 = 0;
            while (iterator2.hasNext()) {
                object = iterator2.next();
                this.elements[n2] = object.getElement();
                this.counts[n2] = object.getCount();
                ++n2;
            }
        }

        Object readResolve() {
            Object[] objectArray;
            ImmutableMultiset.Builder<Object> builder = new ImmutableMultiset.Builder<Object>(this.elements.length);
            for (int i2 = 0; i2 < (objectArray = this.elements).length; ++i2) {
                builder.addCopies(objectArray[i2], this.counts[i2]);
            }
            return builder.build();
        }
    }
}

