/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private static final int ABSENT = -1;
    static final ImmutableMap<Object, Object> EMPTY = new RegularImmutableMap<Object, Object>(null, new Object[0], 0);
    private static final long serialVersionUID = 0L;
    final transient Object[] alternatingKeysAndValues;
    private final transient int[] hashTable;
    private final transient int size;

    private RegularImmutableMap(int[] nArray, Object[] objectArray, int n2) {
        this.hashTable = nArray;
        this.alternatingKeysAndValues = objectArray;
        this.size = n2;
    }

    static <K, V> RegularImmutableMap<K, V> create(int n2, Object[] objectArray) {
        if (n2 == 0) {
            return (RegularImmutableMap)EMPTY;
        }
        if (n2 == 1) {
            CollectPreconditions.checkEntryNotNull((Object)objectArray[0], (Object)objectArray[1]);
            return new RegularImmutableMap<K, V>(null, objectArray, 1);
        }
        Preconditions.checkPositionIndex(n2, objectArray.length >> 1);
        return new RegularImmutableMap<K, V>(RegularImmutableMap.createHashTable(objectArray, n2, ImmutableSet.chooseTableSize(n2), 0), objectArray, n2);
    }

    static int[] createHashTable(Object[] objectArray, int n2, int n3, int n4) {
        if (n2 == 1) {
            CollectPreconditions.checkEntryNotNull((Object)objectArray[n4], (Object)objectArray[n4 ^ 1]);
            return null;
        }
        Object object = new int[n3];
        Arrays.fill((int[])object, -1);
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            int n5;
            int n6 = i2 * 2;
            int n7 = n6 + n4;
            Object object2 = objectArray[n7];
            Object object3 = objectArray[n6 + (n4 ^ 1)];
            CollectPreconditions.checkEntryNotNull((Object)object2, (Object)object3);
            n6 = Hashing.smear(object2.hashCode());
            while (true) {
                if ((n5 = object[n6 &= n3 - 1]) == -1) {
                    object[n6] = n7;
                    continue block0;
                }
                if (objectArray[n5].equals(object2)) break;
                ++n6;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Multiple entries with same key: ");
            ((StringBuilder)object).append(object2);
            ((StringBuilder)object).append("=");
            ((StringBuilder)object).append(object3);
            ((StringBuilder)object).append(" and ");
            ((StringBuilder)object).append(objectArray[n5]);
            ((StringBuilder)object).append("=");
            ((StringBuilder)object).append(objectArray[n5 ^ 1]);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        return object;
    }

    static Object get(@NullableDecl int[] object, @NullableDecl Object[] objectArray, int n2, int n3, @NullableDecl Object object2) {
        Object var5_5 = null;
        if (object2 == null) {
            return null;
        }
        if (n2 == 1) {
            object = var5_5;
            if (objectArray[n3].equals(object2)) {
                object = objectArray[n3 ^ 1];
            }
            return object;
        }
        if (object == null) {
            return null;
        }
        n3 = ((int[])object).length;
        n2 = Hashing.smear(object2.hashCode());
        int n4;
        while ((n4 = object[n2 &= n3 - 1]) != -1) {
            if (objectArray[n4].equals(object2)) {
                return objectArray[n4 ^ 1];
            }
            ++n2;
        }
        return null;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new EntrySet(this, this.alternatingKeysAndValues, 0, this.size);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new KeySet<Object>(this, new KeysOrValuesAsList(this.alternatingKeysAndValues, 0, this.size));
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new KeysOrValuesAsList(this.alternatingKeysAndValues, 1, this.size);
    }

    @Override
    @NullableDecl
    public V get(@NullableDecl Object object) {
        return (V)RegularImmutableMap.get(this.hashTable, this.alternatingKeysAndValues, this.size, 0, object);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    static class EntrySet<K, V>
    extends ImmutableSet<Map.Entry<K, V>> {
        private final transient Object[] alternatingKeysAndValues;
        private final transient int keyOffset;
        private final transient ImmutableMap<K, V> map;
        private final transient int size;

        EntrySet(ImmutableMap<K, V> immutableMap, Object[] objectArray, int n2, int n3) {
            this.map = immutableMap;
            this.alternatingKeysAndValues = objectArray;
            this.keyOffset = n2;
            this.size = n3;
        }

        @Override
        public boolean contains(Object object) {
            boolean bl;
            boolean bl2 = object instanceof Map.Entry;
            boolean bl3 = bl = false;
            if (bl2) {
                Map.Entry entry = (Map.Entry)object;
                object = entry.getKey();
                entry = entry.getValue();
                bl3 = bl;
                if (entry != null) {
                    bl3 = bl;
                    if (((Object)entry).equals(this.map.get(object))) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        @Override
        int copyIntoArray(Object[] objectArray, int n2) {
            return this.asList().copyIntoArray(objectArray, n2);
        }

        @Override
        ImmutableList<Map.Entry<K, V>> createAsList() {
            return new ImmutableList<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> get(int n2) {
                    Preconditions.checkElementIndex(n2, EntrySet.this.size);
                    Object[] objectArray = EntrySet.this.alternatingKeysAndValues;
                    return new AbstractMap.SimpleImmutableEntry<Object, Object>(objectArray[EntrySet.this.keyOffset + (n2 *= 2)], EntrySet.this.alternatingKeysAndValues[n2 + (EntrySet.this.keyOffset ^ 1)]);
                }

                @Override
                public boolean isPartialView() {
                    return true;
                }

                @Override
                public int size() {
                    return EntrySet.this.size;
                }
            };
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.asList().iterator();
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    static final class KeySet<K>
    extends ImmutableSet<K> {
        private final transient ImmutableList<K> list;
        private final transient ImmutableMap<K, ?> map;

        KeySet(ImmutableMap<K, ?> immutableMap, ImmutableList<K> immutableList) {
            this.map = immutableMap;
            this.list = immutableList;
        }

        @Override
        public ImmutableList<K> asList() {
            return this.list;
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            boolean bl = this.map.get(object) != null;
            return bl;
        }

        @Override
        int copyIntoArray(Object[] objectArray, int n2) {
            return this.asList().copyIntoArray(objectArray, n2);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public UnmodifiableIterator<K> iterator() {
            return this.asList().iterator();
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    static final class KeysOrValuesAsList
    extends ImmutableList<Object> {
        private final transient Object[] alternatingKeysAndValues;
        private final transient int offset;
        private final transient int size;

        KeysOrValuesAsList(Object[] objectArray, int n2, int n3) {
            this.alternatingKeysAndValues = objectArray;
            this.offset = n2;
            this.size = n3;
        }

        @Override
        public Object get(int n2) {
            Preconditions.checkElementIndex(n2, this.size);
            return this.alternatingKeysAndValues[n2 * 2 + this.offset];
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

