/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.RegularImmutableMap;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class RegularImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    static final RegularImmutableBiMap<Object, Object> EMPTY = new RegularImmutableBiMap();
    final transient Object[] alternatingKeysAndValues;
    private final transient RegularImmutableBiMap<V, K> inverse;
    private final transient int[] keyHashTable;
    private final transient int keyOffset;
    private final transient int size;

    private RegularImmutableBiMap() {
        this.keyHashTable = null;
        this.alternatingKeysAndValues = new Object[0];
        this.keyOffset = 0;
        this.size = 0;
        this.inverse = this;
    }

    private RegularImmutableBiMap(int[] nArray, Object[] objectArray, int n2, RegularImmutableBiMap<V, K> regularImmutableBiMap) {
        this.keyHashTable = nArray;
        this.alternatingKeysAndValues = objectArray;
        this.keyOffset = 1;
        this.size = n2;
        this.inverse = regularImmutableBiMap;
    }

    RegularImmutableBiMap(Object[] objectArray, int n2) {
        this.alternatingKeysAndValues = objectArray;
        this.size = n2;
        this.keyOffset = 0;
        int n3 = n2 >= 2 ? ImmutableSet.chooseTableSize(n2) : 0;
        this.keyHashTable = RegularImmutableMap.createHashTable(objectArray, n2, n3, 0);
        this.inverse = new RegularImmutableBiMap<K, V>(RegularImmutableMap.createHashTable(objectArray, n2, n3, 1), objectArray, n2, this);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new RegularImmutableMap.EntrySet(this, this.alternatingKeysAndValues, this.keyOffset, this.size);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new RegularImmutableMap.KeySet<Object>(this, new RegularImmutableMap.KeysOrValuesAsList(this.alternatingKeysAndValues, this.keyOffset, this.size));
    }

    @Override
    public V get(@NullableDecl Object object) {
        return (V)RegularImmutableMap.get(this.keyHashTable, this.alternatingKeysAndValues, this.size, this.keyOffset, object);
    }

    @Override
    public ImmutableBiMap<V, K> inverse() {
        return this.inverse;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }
}

