/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.BoundType;
import com.google.common.collect.Collections2;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.EmptyContiguousSet;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class RegularContiguousSet<C extends Comparable>
extends ContiguousSet<C> {
    private static final long serialVersionUID = 0L;
    private final Range<C> range;

    RegularContiguousSet(Range<C> range, DiscreteDomain<C> discreteDomain) {
        super(discreteDomain);
        this.range = range;
    }

    private static boolean equalsOrThrow(Comparable<?> comparable, @NullableDecl Comparable<?> comparable2) {
        boolean bl = comparable2 != null && Range.compareOrThrow(comparable, comparable2) == 0;
        return bl;
    }

    private ContiguousSet<C> intersectionInCurrentDomain(Range<C> serializable) {
        serializable = this.range.isConnected((Range<C>)serializable) ? ContiguousSet.create(this.range.intersection((Range<C>)serializable), this.domain) : new EmptyContiguousSet(this.domain);
        return serializable;
    }

    @Override
    public boolean contains(@NullableDecl Object object) {
        if (object == null) {
            return false;
        }
        try {
            boolean bl = this.range.contains((Comparable)object);
            return bl;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return Collections2.containsAllImpl(this, collection);
    }

    @Override
    ImmutableList<C> createAsList() {
        if (this.domain.supportsFastOffset) {
            return new ImmutableAsList<C>(){

                ImmutableSortedSet<C> delegateCollection() {
                    return RegularContiguousSet.this;
                }

                public C get(int n2) {
                    Preconditions.checkElementIndex(n2, this.size());
                    return RegularContiguousSet.this.domain.offset((Comparable)RegularContiguousSet.this.first(), (long)n2);
                }
            };
        }
        return super.createAsList();
    }

    @Override
    public UnmodifiableIterator<C> descendingIterator() {
        return new AbstractSequentialIterator<C>((Comparable)this.last()){
            final C first;
            {
                this.first = RegularContiguousSet.this.first();
            }

            @Override
            protected C computeNext(C object) {
                object = RegularContiguousSet.equalsOrThrow(object, this.first) ? null : RegularContiguousSet.this.domain.previous(object);
                return object;
            }
        };
    }

    @Override
    public boolean equals(@NullableDecl Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (object instanceof RegularContiguousSet) {
            RegularContiguousSet regularContiguousSet = (RegularContiguousSet)object;
            if (this.domain.equals(regularContiguousSet.domain)) {
                if (!this.first().equals(regularContiguousSet.first()) || !this.last().equals(regularContiguousSet.last())) {
                    bl = false;
                }
                return bl;
            }
        }
        return super.equals(object);
    }

    @Override
    public C first() {
        return this.range.lowerBound.leastValueAbove(this.domain);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    ContiguousSet<C> headSetImpl(C c2, boolean bl) {
        return this.intersectionInCurrentDomain(Range.upTo(c2, BoundType.forBoolean((boolean)bl)));
    }

    @Override
    int indexOf(Object object) {
        int n2 = this.contains(object) ? (int)this.domain.distance((Comparable)this.first(), (Comparable)object) : -1;
        return n2;
    }

    @Override
    public ContiguousSet<C> intersection(ContiguousSet<C> contiguousSet) {
        Preconditions.checkNotNull(contiguousSet);
        Preconditions.checkArgument(this.domain.equals(contiguousSet.domain));
        if (((AbstractCollection)contiguousSet).isEmpty()) {
            return contiguousSet;
        }
        Comparable comparable = (Comparable)Ordering.natural().max(this.first(), ((ImmutableSortedSet)contiguousSet).first());
        contiguousSet = comparable.compareTo(contiguousSet = (Comparable)Ordering.natural().min(this.last(), ((ImmutableSortedSet)contiguousSet).last())) <= 0 ? ContiguousSet.create(Range.closed(comparable, contiguousSet), this.domain) : new EmptyContiguousSet(this.domain);
        return contiguousSet;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public UnmodifiableIterator<C> iterator() {
        return new AbstractSequentialIterator<C>((Comparable)this.first()){
            final C last;
            {
                this.last = RegularContiguousSet.this.last();
            }

            @Override
            protected C computeNext(C object) {
                object = RegularContiguousSet.equalsOrThrow(object, this.last) ? null : RegularContiguousSet.this.domain.next(object);
                return object;
            }
        };
    }

    @Override
    public C last() {
        return this.range.upperBound.greatestValueBelow(this.domain);
    }

    @Override
    public Range<C> range() {
        return this.range(BoundType.CLOSED, BoundType.CLOSED);
    }

    @Override
    public Range<C> range(BoundType boundType, BoundType boundType2) {
        return Range.create(this.range.lowerBound.withLowerBoundType(boundType, this.domain), this.range.upperBound.withUpperBoundType(boundType2, this.domain));
    }

    @Override
    public int size() {
        long l2 = this.domain.distance((Comparable)this.first(), (Comparable)this.last());
        int n2 = l2 >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2 + 1;
        return n2;
    }

    @Override
    ContiguousSet<C> subSetImpl(C c2, boolean bl, C c3, boolean bl2) {
        if (c2.compareTo(c3) == 0 && !bl && !bl2) {
            return new EmptyContiguousSet(this.domain);
        }
        return this.intersectionInCurrentDomain(Range.range(c2, BoundType.forBoolean((boolean)bl), c3, BoundType.forBoolean((boolean)bl2)));
    }

    @Override
    ContiguousSet<C> tailSetImpl(C c2, boolean bl) {
        return this.intersectionInCurrentDomain(Range.downTo(c2, BoundType.forBoolean((boolean)bl)));
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this.range, this.domain);
    }

    private static final class SerializedForm<C extends Comparable>
    implements Serializable {
        final DiscreteDomain<C> domain;
        final Range<C> range;

        private SerializedForm(Range<C> range, DiscreteDomain<C> discreteDomain) {
            this.range = range;
            this.domain = discreteDomain;
        }

        private Object readResolve() {
            return new RegularContiguousSet<C>(this.range, this.domain);
        }
    }
}

