/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.BoundType;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Cut;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.RangeGwtSerializationDependencies;
import java.io.Serializable;
import java.util.Comparator;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Range<C extends Comparable>
extends RangeGwtSerializationDependencies
implements Predicate<C>,
Serializable {
    private static final Range<Comparable> ALL = new Range(Cut.belowAll(), Cut.aboveAll());
    private static final long serialVersionUID = 0L;
    final Cut<C> lowerBound;
    final Cut<C> upperBound;

    private Range(Cut<C> cut, Cut<C> cut2) {
        this.lowerBound = Preconditions.checkNotNull(cut);
        this.upperBound = Preconditions.checkNotNull(cut2);
        if (cut.compareTo(cut2) <= 0 && cut != Cut.aboveAll() && cut2 != Cut.belowAll()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Invalid range: ");
        stringBuilder.append(Range.toString(cut, cut2));
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static <C extends Comparable<?>> Range<C> all() {
        return ALL;
    }

    public static <C extends Comparable<?>> Range<C> atLeast(C c2) {
        return Range.create(Cut.belowValue(c2), Cut.aboveAll());
    }

    public static <C extends Comparable<?>> Range<C> atMost(C c2) {
        return Range.create(Cut.belowAll(), Cut.aboveValue(c2));
    }

    private static <T> SortedSet<T> cast(Iterable<T> iterable) {
        return (SortedSet)iterable;
    }

    public static <C extends Comparable<?>> Range<C> closed(C c2, C c3) {
        return Range.create(Cut.belowValue(c2), Cut.aboveValue(c3));
    }

    public static <C extends Comparable<?>> Range<C> closedOpen(C c2, C c3) {
        return Range.create(Cut.belowValue(c2), Cut.belowValue(c3));
    }

    static int compareOrThrow(Comparable comparable, Comparable comparable2) {
        return comparable.compareTo(comparable2);
    }

    static <C extends Comparable<?>> Range<C> create(Cut<C> cut, Cut<C> cut2) {
        return new Range<C>(cut, cut2);
    }

    public static <C extends Comparable<?>> Range<C> downTo(C c2, BoundType boundType) {
        int n2 = 1.$SwitchMap$com$google$common$collect$BoundType[boundType.ordinal()];
        if (n2 != 1) {
            if (n2 == 2) {
                return Range.atLeast(c2);
            }
            throw new AssertionError();
        }
        return Range.greaterThan(c2);
    }

    public static <C extends Comparable<?>> Range<C> encloseAll(Iterable<C> object) {
        Object object2;
        Object object3;
        Preconditions.checkNotNull(object);
        if (object instanceof SortedSet) {
            object3 = Range.cast(object);
            object2 = object3.comparator();
            if (Ordering.natural().equals(object2) || object2 == null) {
                return Range.closed((Comparable)object3.first(), (Comparable)object3.last());
            }
        }
        object2 = object.iterator();
        object = object3 = (Comparable)Preconditions.checkNotNull(object2.next());
        while (object2.hasNext()) {
            Comparable comparable = (Comparable)Preconditions.checkNotNull(object2.next());
            object3 = Ordering.natural().min(object3, comparable);
            object = Ordering.natural().max(object, comparable);
        }
        return Range.closed(object3, object);
    }

    public static <C extends Comparable<?>> Range<C> greaterThan(C c2) {
        return Range.create(Cut.aboveValue(c2), Cut.aboveAll());
    }

    public static <C extends Comparable<?>> Range<C> lessThan(C c2) {
        return Range.create(Cut.belowAll(), Cut.belowValue(c2));
    }

    static <C extends Comparable<?>> Function<Range<C>, Cut<C>> lowerBoundFn() {
        return LowerBoundFn.INSTANCE;
    }

    public static <C extends Comparable<?>> Range<C> open(C c2, C c3) {
        return Range.create(Cut.aboveValue(c2), Cut.belowValue(c3));
    }

    public static <C extends Comparable<?>> Range<C> openClosed(C c2, C c3) {
        return Range.create(Cut.aboveValue(c2), Cut.aboveValue(c3));
    }

    public static <C extends Comparable<?>> Range<C> range(C object, BoundType object2, C c2, BoundType boundType) {
        Preconditions.checkNotNull(object2);
        Preconditions.checkNotNull(boundType);
        object = object2 == BoundType.OPEN ? Cut.aboveValue(object) : Cut.belowValue(object);
        object2 = boundType == BoundType.OPEN ? Cut.belowValue(c2) : Cut.aboveValue(c2);
        return Range.create(object, object2);
    }

    static <C extends Comparable<?>> Ordering<Range<C>> rangeLexOrdering() {
        return RangeLexOrdering.INSTANCE;
    }

    public static <C extends Comparable<?>> Range<C> singleton(C c2) {
        return Range.closed(c2, c2);
    }

    private static String toString(Cut<?> cut, Cut<?> cut2) {
        StringBuilder stringBuilder = new StringBuilder(16);
        cut.describeAsLowerBound(stringBuilder);
        stringBuilder.append("..");
        cut2.describeAsUpperBound(stringBuilder);
        return stringBuilder.toString();
    }

    public static <C extends Comparable<?>> Range<C> upTo(C c2, BoundType boundType) {
        int n2 = 1.$SwitchMap$com$google$common$collect$BoundType[boundType.ordinal()];
        if (n2 != 1) {
            if (n2 == 2) {
                return Range.atMost(c2);
            }
            throw new AssertionError();
        }
        return Range.lessThan(c2);
    }

    static <C extends Comparable<?>> Function<Range<C>, Cut<C>> upperBoundFn() {
        return UpperBoundFn.INSTANCE;
    }

    @Override
    @Deprecated
    public boolean apply(C c2) {
        return this.contains(c2);
    }

    public Range<C> canonical(DiscreteDomain<C> object) {
        Preconditions.checkNotNull(object);
        Cut<C> cut = this.lowerBound.canonical((DiscreteDomain<C>)object);
        object = this.upperBound.canonical((DiscreteDomain<C>)object);
        object = cut == this.lowerBound && object == this.upperBound ? this : Range.create(cut, object);
        return object;
    }

    public boolean contains(C c2) {
        Preconditions.checkNotNull(c2);
        boolean bl = this.lowerBound.isLessThan(c2) && !this.upperBound.isLessThan(c2);
        return bl;
    }

    public boolean containsAll(Iterable<? extends C> object) {
        boolean bl = Iterables.isEmpty(object);
        boolean bl2 = true;
        if (bl) {
            return true;
        }
        if (object instanceof SortedSet) {
            SortedSet<C> sortedSet = Range.cast(object);
            Comparator<? extends C> comparator = sortedSet.comparator();
            if (Ordering.natural().equals(comparator) || comparator == null) {
                if (!this.contains((Comparable)sortedSet.first()) || !this.contains((Comparable)sortedSet.last())) {
                    bl2 = false;
                }
                return bl2;
            }
        }
        object = object.iterator();
        while (object.hasNext()) {
            if (this.contains((Comparable)object.next())) continue;
            return false;
        }
        return true;
    }

    public boolean encloses(Range<C> range) {
        boolean bl = this.lowerBound.compareTo(range.lowerBound) <= 0 && this.upperBound.compareTo(range.upperBound) >= 0;
        return bl;
    }

    @Override
    public boolean equals(@NullableDecl Object object) {
        boolean bl;
        boolean bl2 = object instanceof Range;
        boolean bl3 = bl = false;
        if (bl2) {
            object = (Range)object;
            bl3 = bl;
            if (this.lowerBound.equals(((Range)object).lowerBound)) {
                bl3 = bl;
                if (this.upperBound.equals(((Range)object).upperBound)) {
                    bl3 = true;
                }
            }
        }
        return bl3;
    }

    public Range<C> gap(Range<C> range) {
        boolean bl = this.lowerBound.compareTo(range.lowerBound) < 0;
        Range<C> range2 = bl ? this : range;
        if (!bl) {
            range = this;
        }
        return Range.create(range2.upperBound, range.lowerBound);
    }

    public boolean hasLowerBound() {
        boolean bl = this.lowerBound != Cut.belowAll();
        return bl;
    }

    public boolean hasUpperBound() {
        boolean bl = this.upperBound != Cut.aboveAll();
        return bl;
    }

    public int hashCode() {
        return this.lowerBound.hashCode() * 31 + this.upperBound.hashCode();
    }

    public Range<C> intersection(Range<C> serializable) {
        int n2 = this.lowerBound.compareTo(serializable.lowerBound);
        int n3 = this.upperBound.compareTo(serializable.upperBound);
        if (n2 >= 0 && n3 <= 0) {
            return this;
        }
        if (n2 <= 0 && n3 >= 0) {
            return serializable;
        }
        Cut<C> cut = n2 >= 0 ? this.lowerBound : serializable.lowerBound;
        serializable = n3 <= 0 ? this.upperBound : serializable.upperBound;
        return Range.create(cut, serializable);
    }

    public boolean isConnected(Range<C> range) {
        boolean bl = this.lowerBound.compareTo(range.upperBound) <= 0 && range.lowerBound.compareTo(this.upperBound) <= 0;
        return bl;
    }

    public boolean isEmpty() {
        return this.lowerBound.equals(this.upperBound);
    }

    public BoundType lowerBoundType() {
        return this.lowerBound.typeAsLowerBound();
    }

    public C lowerEndpoint() {
        return this.lowerBound.endpoint();
    }

    Object readResolve() {
        if (this.equals(ALL)) {
            return Range.all();
        }
        return this;
    }

    public Range<C> span(Range<C> serializable) {
        int n2 = this.lowerBound.compareTo(serializable.lowerBound);
        int n3 = this.upperBound.compareTo(serializable.upperBound);
        if (n2 <= 0 && n3 >= 0) {
            return this;
        }
        if (n2 >= 0 && n3 <= 0) {
            return serializable;
        }
        Cut<C> cut = n2 <= 0 ? this.lowerBound : serializable.lowerBound;
        serializable = n3 >= 0 ? this.upperBound : serializable.upperBound;
        return Range.create(cut, serializable);
    }

    public String toString() {
        return Range.toString(this.lowerBound, this.upperBound);
    }

    public BoundType upperBoundType() {
        return this.upperBound.typeAsUpperBound();
    }

    public C upperEndpoint() {
        return this.upperBound.endpoint();
    }

    static class LowerBoundFn
    implements Function<Range, Cut> {
        static final LowerBoundFn INSTANCE = new LowerBoundFn();

        LowerBoundFn() {
        }

        @Override
        public Cut apply(Range range) {
            return range.lowerBound;
        }
    }

    private static class RangeLexOrdering
    extends Ordering<Range<?>>
    implements Serializable {
        static final Ordering<Range<?>> INSTANCE = new RangeLexOrdering();
        private static final long serialVersionUID = 0L;

        private RangeLexOrdering() {
        }

        @Override
        public int compare(Range<?> range, Range<?> range2) {
            return ComparisonChain.start().compare(range.lowerBound, range2.lowerBound).compare(range.upperBound, range2.upperBound).result();
        }
    }

    static class UpperBoundFn
    implements Function<Range, Cut> {
        static final UpperBoundFn INSTANCE = new UpperBoundFn();

        UpperBoundFn() {
        }

        @Override
        public Cut apply(Range range) {
            return range.upperBound;
        }
    }
}

