/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.AllEqualOrdering;
import com.google.common.collect.ByFunctionOrdering;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ComparatorOrdering;
import com.google.common.collect.CompoundOrdering;
import com.google.common.collect.ExplicitOrdering;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LexicographicalOrdering;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.NaturalOrdering;
import com.google.common.collect.NullsFirstOrdering;
import com.google.common.collect.NullsLastOrdering;
import com.google.common.collect.Platform;
import com.google.common.collect.ReverseOrdering;
import com.google.common.collect.TopKSelector;
import com.google.common.collect.UsingToStringOrdering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class Ordering<T>
implements Comparator<T> {
    static final int LEFT_IS_GREATER = 1;
    static final int RIGHT_IS_GREATER = -1;

    protected Ordering() {
    }

    public static Ordering<Object> allEqual() {
        return AllEqualOrdering.INSTANCE;
    }

    public static Ordering<Object> arbitrary() {
        return ArbitraryOrderingHolder.ARBITRARY_ORDERING;
    }

    public static <T> Ordering<T> compound(Iterable<? extends Comparator<? super T>> iterable) {
        return new CompoundOrdering(iterable);
    }

    public static <T> Ordering<T> explicit(T t2, T ... TArray) {
        return Ordering.explicit(Lists.asList(t2, TArray));
    }

    public static <T> Ordering<T> explicit(List<T> list) {
        return new ExplicitOrdering<T>(list);
    }

    @Deprecated
    public static <T> Ordering<T> from(Ordering<T> ordering) {
        return Preconditions.checkNotNull(ordering);
    }

    public static <T> Ordering<T> from(Comparator<T> comparatorOrdering) {
        comparatorOrdering = comparatorOrdering instanceof Ordering ? (ComparatorOrdering)comparatorOrdering : new ComparatorOrdering(comparatorOrdering);
        return comparatorOrdering;
    }

    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    public static Ordering<Object> usingToString() {
        return UsingToStringOrdering.INSTANCE;
    }

    @Deprecated
    public int binarySearch(List<? extends T> list, @NullableDecl T t2) {
        return Collections.binarySearch(list, t2, this);
    }

    @Override
    public abstract int compare(@NullableDecl T var1, @NullableDecl T var2);

    public <U extends T> Ordering<U> compound(Comparator<? super U> comparator) {
        return new CompoundOrdering((Comparator)this, Preconditions.checkNotNull(comparator));
    }

    public <E extends T> List<E> greatestOf(Iterable<E> iterable, int n2) {
        return this.reverse().leastOf(iterable, n2);
    }

    public <E extends T> List<E> greatestOf(Iterator<E> iterator2, int n2) {
        return this.reverse().leastOf(iterator2, n2);
    }

    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> iterable) {
        return ImmutableList.sortedCopyOf(this, iterable);
    }

    public boolean isOrdered(Iterable<? extends T> iterable) {
        Iterator<T> iterator2 = iterable.iterator();
        if (iterator2.hasNext()) {
            iterable = iterator2.next();
            while (iterator2.hasNext()) {
                T t2 = iterator2.next();
                if (this.compare(iterable, t2) > 0) {
                    return false;
                }
                iterable = t2;
            }
        }
        return true;
    }

    public boolean isStrictlyOrdered(Iterable<? extends T> iterable) {
        Iterator<T> iterator2 = iterable.iterator();
        if (iterator2.hasNext()) {
            iterable = iterator2.next();
            while (iterator2.hasNext()) {
                T t2 = iterator2.next();
                if (this.compare(iterable, t2) >= 0) {
                    return false;
                }
                iterable = t2;
            }
        }
        return true;
    }

    public <E extends T> List<E> leastOf(Iterable<E> objectArray, int n2) {
        Object[] objectArray2;
        if (objectArray instanceof Collection && (long)(objectArray2 = (Object[])objectArray).size() <= (long)n2 * 2L) {
            objectArray2 = objectArray2.toArray();
            Arrays.sort(objectArray2, this);
            objectArray = objectArray2;
            if (objectArray2.length > n2) {
                objectArray = Arrays.copyOf(objectArray2, n2);
            }
            return Collections.unmodifiableList(Arrays.asList(objectArray));
        }
        return this.leastOf(objectArray.iterator(), n2);
    }

    public <E extends T> List<E> leastOf(Iterator<E> object, int n2) {
        Preconditions.checkNotNull(object);
        CollectPreconditions.checkNonnegative((int)n2, (String)"k");
        if (n2 != 0 && object.hasNext()) {
            if (n2 >= 0x3FFFFFFF) {
                object = Lists.newArrayList(object);
                Collections.sort(object, this);
                if (((ArrayList)object).size() > n2) {
                    ((ArrayList)object).subList(n2, ((ArrayList)object).size()).clear();
                }
                ((ArrayList)object).trimToSize();
                return Collections.unmodifiableList(object);
            }
            TopKSelector topKSelector = TopKSelector.least(n2, this);
            topKSelector.offerAll(object);
            return topKSelector.topK();
        }
        return Collections.emptyList();
    }

    public <S extends T> Ordering<Iterable<S>> lexicographical() {
        return new LexicographicalOrdering(this);
    }

    public <E extends T> E max(Iterable<E> iterable) {
        return this.max(iterable.iterator());
    }

    public <E extends T> E max(@NullableDecl E e2, @NullableDecl E e3) {
        if (this.compare(e2, e3) < 0) {
            e2 = e3;
        }
        return e2;
    }

    public <E extends T> E max(@NullableDecl E e2, @NullableDecl E e3, @NullableDecl E e4, E ... EArray) {
        e2 = this.max(this.max(e2, e3), e4);
        int n2 = EArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            e2 = this.max(e2, EArray[i2]);
        }
        return e2;
    }

    public <E extends T> E max(Iterator<E> iterator2) {
        E e2 = iterator2.next();
        while (iterator2.hasNext()) {
            e2 = this.max(e2, iterator2.next());
        }
        return e2;
    }

    public <E extends T> E min(Iterable<E> iterable) {
        return this.min(iterable.iterator());
    }

    public <E extends T> E min(@NullableDecl E e2, @NullableDecl E e3) {
        if (this.compare(e2, e3) > 0) {
            e2 = e3;
        }
        return e2;
    }

    public <E extends T> E min(@NullableDecl E e2, @NullableDecl E e3, @NullableDecl E e4, E ... EArray) {
        e2 = this.min(this.min(e2, e3), e4);
        int n2 = EArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            e2 = this.min(e2, EArray[i2]);
        }
        return e2;
    }

    public <E extends T> E min(Iterator<E> iterator2) {
        E e2 = iterator2.next();
        while (iterator2.hasNext()) {
            e2 = this.min(e2, iterator2.next());
        }
        return e2;
    }

    public <S extends T> Ordering<S> nullsFirst() {
        return new NullsFirstOrdering(this);
    }

    public <S extends T> Ordering<S> nullsLast() {
        return new NullsLastOrdering(this);
    }

    <T2 extends T> Ordering<Map.Entry<T2, ?>> onKeys() {
        return this.onResultOf(Maps.keyFunction());
    }

    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        return new ByFunctionOrdering<F, T>(function, this);
    }

    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    public <E extends T> List<E> sortedCopy(Iterable<E> objectArray) {
        objectArray = Iterables.toArray(objectArray);
        Arrays.sort(objectArray, this);
        return Lists.newArrayList(Arrays.asList(objectArray));
    }

    static class ArbitraryOrdering
    extends Ordering<Object> {
        private final AtomicInteger counter = new AtomicInteger(0);
        private final ConcurrentMap<Object, Integer> uids = Platform.tryWeakKeys((MapMaker)new MapMaker()).makeMap();

        ArbitraryOrdering() {
        }

        private Integer getUid(Object object) {
            Integer n2 = (Integer)this.uids.get(object);
            Object object2 = n2;
            if (n2 == null && (object = this.uids.putIfAbsent(object, (Integer)(object2 = Integer.valueOf(this.counter.getAndIncrement())))) != null) {
                object2 = object;
            }
            return object2;
        }

        @Override
        public int compare(Object object, Object object2) {
            int n2;
            if (object == object2) {
                return 0;
            }
            int n3 = -1;
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            int n4 = this.identityHashCode(object);
            if (n4 != (n2 = this.identityHashCode(object2))) {
                if (n4 >= n2) {
                    n3 = 1;
                }
                return n3;
            }
            n3 = this.getUid(object).compareTo(this.getUid(object2));
            if (n3 != 0) {
                return n3;
            }
            throw new AssertionError();
        }

        int identityHashCode(Object object) {
            return System.identityHashCode(object);
        }

        public String toString() {
            return "Ordering.arbitrary()";
        }
    }

    private static class ArbitraryOrderingHolder {
        static final Ordering<Object> ARBITRARY_ORDERING = new ArbitraryOrdering();

        private ArbitraryOrderingHolder() {
        }
    }

    static class IncomparableValueException
    extends ClassCastException {
        private static final long serialVersionUID = 0L;
        final Object value;

        IncomparableValueException(Object object) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot compare value: ");
            stringBuilder.append(object);
            super(stringBuilder.toString());
            this.value = object;
        }
    }
}

