/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.Arrays;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

class ObjectCountHashMap<K> {
    static final float DEFAULT_LOAD_FACTOR = 1.0f;
    static final int DEFAULT_SIZE = 3;
    private static final long HASH_MASK = -4294967296L;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final long NEXT_MASK = 0xFFFFFFFFL;
    static final int UNSET = -1;
    transient long[] entries;
    transient Object[] keys;
    private transient float loadFactor;
    transient int modCount;
    transient int size;
    private transient int[] table;
    private transient int threshold;
    transient int[] values;

    ObjectCountHashMap() {
        this.init(3, 1.0f);
    }

    ObjectCountHashMap(int n2) {
        this(n2, 1.0f);
    }

    ObjectCountHashMap(int n2, float f2) {
        this.init(n2, f2);
    }

    ObjectCountHashMap(ObjectCountHashMap<? extends K> objectCountHashMap) {
        this.init(objectCountHashMap.size(), 1.0f);
        int n2 = objectCountHashMap.firstIndex();
        while (n2 != -1) {
            this.put(objectCountHashMap.getKey(n2), objectCountHashMap.getValue(n2));
            n2 = objectCountHashMap.nextIndex(n2);
        }
    }

    public static <K> ObjectCountHashMap<K> create() {
        return new ObjectCountHashMap<K>();
    }

    public static <K> ObjectCountHashMap<K> createWithExpectedSize(int n2) {
        return new ObjectCountHashMap<K>(n2);
    }

    private static int getHash(long l2) {
        return (int)(l2 >>> 32);
    }

    private static int getNext(long l2) {
        return (int)l2;
    }

    private int hashTableMask() {
        return this.table.length - 1;
    }

    private static long[] newEntries(int n2) {
        long[] lArray = new long[n2];
        Arrays.fill(lArray, -1L);
        return lArray;
    }

    private static int[] newTable(int n2) {
        int[] nArray = new int[n2];
        Arrays.fill(nArray, -1);
        return nArray;
    }

    private int remove(@NullableDecl Object object, int n2) {
        int n3 = this.hashTableMask() & n2;
        int n4 = this.table[n3];
        if (n4 == -1) {
            return 0;
        }
        int n5 = -1;
        while (true) {
            if (ObjectCountHashMap.getHash(this.entries[n4]) == n2 && Objects.equal(object, this.keys[n4])) {
                n2 = this.values[n4];
                if (n5 == -1) {
                    this.table[n3] = ObjectCountHashMap.getNext(this.entries[n4]);
                } else {
                    object = this.entries;
                    object[n5] = ObjectCountHashMap.swapNext((long)object[n5], ObjectCountHashMap.getNext((long)object[n4]));
                }
                this.moveLastEntry(n4);
                --this.size;
                ++this.modCount;
                return n2;
            }
            int n6 = ObjectCountHashMap.getNext(this.entries[n4]);
            if (n6 == -1) {
                return 0;
            }
            n5 = n4;
            n4 = n6;
        }
    }

    private void resizeMeMaybe(int n2) {
        int n3 = this.entries.length;
        if (n2 > n3) {
            int n4;
            n2 = n4 = Math.max(1, n3 >>> 1) + n3;
            if (n4 < 0) {
                n2 = Integer.MAX_VALUE;
            }
            if (n2 != n3) {
                this.resizeEntries(n2);
            }
        }
    }

    private void resizeTable(int n2) {
        if (this.table.length >= 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int n3 = (int)((float)n2 * this.loadFactor);
        int[] nArray = ObjectCountHashMap.newTable(n2);
        long[] lArray = this.entries;
        int n4 = nArray.length;
        for (n2 = 0; n2 < this.size; ++n2) {
            int n5 = ObjectCountHashMap.getHash(lArray[n2]);
            int n6 = n5 & n4 - 1;
            int n7 = nArray[n6];
            nArray[n6] = n2;
            lArray[n2] = (long)n5 << 32 | 0xFFFFFFFFL & (long)n7;
        }
        this.threshold = n3 + 1;
        this.table = nArray;
    }

    private static long swapNext(long l2, int n2) {
        return l2 & 0xFFFFFFFF00000000L | (long)n2 & 0xFFFFFFFFL;
    }

    public void clear() {
        ++this.modCount;
        Arrays.fill(this.keys, 0, this.size, null);
        Arrays.fill(this.values, 0, this.size, 0);
        Arrays.fill(this.table, -1);
        Arrays.fill(this.entries, -1L);
        this.size = 0;
    }

    public boolean containsKey(@NullableDecl Object object) {
        boolean bl = this.indexOf(object) != -1;
        return bl;
    }

    void ensureCapacity(int n2) {
        if (n2 > this.entries.length) {
            this.resizeEntries(n2);
        }
        if (n2 >= this.threshold) {
            this.resizeTable(Math.max(2, Integer.highestOneBit(n2 - 1) << 1));
        }
    }

    int firstIndex() {
        int n2 = this.size == 0 ? -1 : 0;
        return n2;
    }

    public int get(@NullableDecl Object object) {
        int n2 = this.indexOf(object);
        n2 = n2 == -1 ? 0 : this.values[n2];
        return n2;
    }

    Multiset.Entry<K> getEntry(int n2) {
        Preconditions.checkElementIndex(n2, this.size);
        return new MapEntry(n2);
    }

    K getKey(int n2) {
        Preconditions.checkElementIndex(n2, this.size);
        return (K)this.keys[n2];
    }

    int getValue(int n2) {
        Preconditions.checkElementIndex(n2, this.size);
        return this.values[n2];
    }

    int indexOf(@NullableDecl Object object) {
        int n2 = Hashing.smearedHash(object);
        int n3 = this.table[this.hashTableMask() & n2];
        while (n3 != -1) {
            long l2 = this.entries[n3];
            if (ObjectCountHashMap.getHash(l2) == n2 && Objects.equal(object, this.keys[n3])) {
                return n3;
            }
            n3 = ObjectCountHashMap.getNext(l2);
        }
        return -1;
    }

    void init(int n2, float f2) {
        boolean bl = false;
        boolean bl2 = n2 >= 0;
        Preconditions.checkArgument(bl2, "Initial capacity must be non-negative");
        bl2 = bl;
        if (f2 > 0.0f) {
            bl2 = true;
        }
        Preconditions.checkArgument(bl2, "Illegal load factor");
        int n3 = Hashing.closedTableSize(n2, f2);
        this.table = ObjectCountHashMap.newTable(n3);
        this.loadFactor = f2;
        this.keys = new Object[n2];
        this.values = new int[n2];
        this.entries = ObjectCountHashMap.newEntries(n2);
        this.threshold = Math.max(1, (int)((float)n3 * f2));
    }

    void insertEntry(int n2, @NullableDecl K k2, int n3, int n4) {
        this.entries[n2] = (long)n4 << 32 | 0xFFFFFFFFL;
        this.keys[n2] = k2;
        this.values[n2] = n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void moveLastEntry(int n2) {
        int n3 = this.size() - 1;
        if (n2 < n3) {
            int n4;
            long l2;
            Object[] objectArray = this.keys;
            objectArray[n2] = objectArray[n3];
            int[] nArray = this.values;
            nArray[n2] = nArray[n3];
            objectArray[n3] = null;
            nArray[n3] = 0;
            long[] lArray = this.entries;
            lArray[n2] = l2 = lArray[n3];
            lArray[n3] = -1L;
            int n5 = ObjectCountHashMap.getHash(l2) & this.hashTableMask();
            int[] nArray2 = this.table;
            int n6 = n4 = nArray2[n5];
            if (n4 == n3) {
                nArray2[n5] = n2;
                return;
            }
            while (true) {
                int n7;
                if ((n7 = ObjectCountHashMap.getNext(l2 = this.entries[n6])) == n3) {
                    this.entries[n6] = ObjectCountHashMap.swapNext(l2, n2);
                    return;
                }
                n6 = n7;
            }
        }
        this.keys[n2] = null;
        this.values[n2] = 0;
        this.entries[n2] = -1L;
    }

    int nextIndex(int n2) {
        if (++n2 >= this.size) {
            n2 = -1;
        }
        return n2;
    }

    int nextIndexAfterRemove(int n2, int n3) {
        return n2 - 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int put(@NullableDecl K k2, int n2) {
        int n3;
        CollectPreconditions.checkPositive((int)n2, (String)"count");
        long[] lArray = this.entries;
        Object[] objectArray = this.keys;
        int[] nArray = this.values;
        int n4 = Hashing.smearedHash(k2);
        int n5 = this.hashTableMask() & n4;
        int n6 = this.size;
        int[] nArray2 = this.table;
        int n7 = n3 = nArray2[n5];
        if (n3 == -1) {
            nArray2[n5] = n6;
        } else {
            while (true) {
                long l2;
                if (ObjectCountHashMap.getHash(l2 = lArray[n7]) == n4 && Objects.equal(k2, objectArray[n7])) {
                    n3 = nArray[n7];
                    nArray[n7] = n2;
                    return n3;
                }
                n3 = ObjectCountHashMap.getNext(l2);
                if (n3 == -1) {
                    lArray[n7] = ObjectCountHashMap.swapNext(l2, n6);
                    break;
                }
                n7 = n3;
            }
        }
        if (n6 == Integer.MAX_VALUE) {
            throw new IllegalStateException("Cannot contain more than Integer.MAX_VALUE elements!");
        }
        n7 = n6 + 1;
        this.resizeMeMaybe(n7);
        this.insertEntry(n6, k2, n2, n4);
        this.size = n7;
        if (n6 >= this.threshold) {
            this.resizeTable(this.table.length * 2);
        }
        ++this.modCount;
        return 0;
    }

    public int remove(@NullableDecl Object object) {
        return this.remove(object, Hashing.smearedHash(object));
    }

    int removeEntry(int n2) {
        return this.remove(this.keys[n2], ObjectCountHashMap.getHash(this.entries[n2]));
    }

    void resizeEntries(int n2) {
        this.keys = Arrays.copyOf(this.keys, n2);
        this.values = Arrays.copyOf(this.values, n2);
        long[] lArray = this.entries;
        int n3 = lArray.length;
        lArray = Arrays.copyOf(lArray, n2);
        if (n2 > n3) {
            Arrays.fill(lArray, n3, n2, -1L);
        }
        this.entries = lArray;
    }

    void setValue(int n2, int n3) {
        Preconditions.checkElementIndex(n2, this.size);
        this.values[n2] = n3;
    }

    int size() {
        return this.size;
    }

    class MapEntry
    extends Multisets.AbstractEntry<K> {
        @NullableDecl
        final K key;
        int lastKnownIndex;

        MapEntry(int n2) {
            this.key = ObjectCountHashMap.this.keys[n2];
            this.lastKnownIndex = n2;
        }

        @Override
        public int getCount() {
            this.updateLastKnownIndex();
            int n2 = this.lastKnownIndex == -1 ? 0 : ObjectCountHashMap.this.values[this.lastKnownIndex];
            return n2;
        }

        @Override
        public K getElement() {
            return this.key;
        }

        public int setCount(int n2) {
            this.updateLastKnownIndex();
            if (this.lastKnownIndex == -1) {
                ObjectCountHashMap.this.put(this.key, n2);
                return 0;
            }
            int n3 = ObjectCountHashMap.this.values[this.lastKnownIndex];
            ObjectCountHashMap.this.values[this.lastKnownIndex] = n2;
            return n3;
        }

        void updateLastKnownIndex() {
            int n2 = this.lastKnownIndex;
            if (n2 == -1 || n2 >= ObjectCountHashMap.this.size() || !Objects.equal(this.key, ObjectCountHashMap.this.keys[this.lastKnownIndex])) {
                this.lastKnownIndex = ObjectCountHashMap.this.indexOf(this.key);
            }
        }
    }
}

