/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Platform;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class ObjectArrays {
    private ObjectArrays() {
    }

    static Object checkElementNotNull(Object object, int n2) {
        if (object != null) {
            return object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("at index ");
        ((StringBuilder)object).append(n2);
        throw new NullPointerException(((StringBuilder)object).toString());
    }

    static Object[] checkElementsNotNull(Object ... objectArray) {
        return ObjectArrays.checkElementsNotNull(objectArray, objectArray.length);
    }

    static Object[] checkElementsNotNull(Object[] objectArray, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            ObjectArrays.checkElementNotNull(objectArray[i2], i2);
        }
        return objectArray;
    }

    public static <T> T[] concat(@NullableDecl T t2, T[] TArray) {
        T[] TArray2 = ObjectArrays.newArray(TArray, TArray.length + 1);
        TArray2[0] = t2;
        System.arraycopy(TArray, 0, TArray2, 1, TArray.length);
        return TArray2;
    }

    public static <T> T[] concat(T[] TArray, @NullableDecl T t2) {
        T[] TArray2 = Arrays.copyOf(TArray, TArray.length + 1);
        TArray2[TArray.length] = t2;
        return TArray2;
    }

    public static <T> T[] concat(T[] TArray, T[] TArray2, Class<T> TArray3) {
        TArray3 = ObjectArrays.newArray(TArray3, TArray.length + TArray2.length);
        System.arraycopy(TArray, 0, TArray3, 0, TArray.length);
        System.arraycopy(TArray2, 0, TArray3, TArray.length, TArray2.length);
        return TArray3;
    }

    static Object[] copyAsObjectArray(Object[] objectArray, int n2, int n3) {
        Preconditions.checkPositionIndexes(n2, n2 + n3, objectArray.length);
        if (n3 == 0) {
            return new Object[0];
        }
        Object[] objectArray2 = new Object[n3];
        System.arraycopy(objectArray, n2, objectArray2, 0, n3);
        return objectArray2;
    }

    private static Object[] fillArray(Iterable<?> object, Object[] objectArray) {
        object = object.iterator();
        int n2 = 0;
        while (object.hasNext()) {
            objectArray[n2] = object.next();
            ++n2;
        }
        return objectArray;
    }

    public static <T> T[] newArray(Class<T> clazz, int n2) {
        return (Object[])Array.newInstance(clazz, n2);
    }

    public static <T> T[] newArray(T[] TArray, int n2) {
        return Platform.newArray((Object[])TArray, (int)n2);
    }

    static void swap(Object[] objectArray, int n2, int n3) {
        Object object = objectArray[n2];
        objectArray[n2] = objectArray[n3];
        objectArray[n3] = object;
    }

    static Object[] toArrayImpl(Collection<?> collection) {
        return ObjectArrays.fillArray(collection, new Object[collection.size()]);
    }

    static <T> T[] toArrayImpl(Collection<?> collection, T[] TArray) {
        int n2 = collection.size();
        Object[] objectArray = TArray;
        if (TArray.length < n2) {
            objectArray = ObjectArrays.newArray(TArray, n2);
        }
        ObjectArrays.fillArray(collection, objectArray);
        if (objectArray.length > n2) {
            objectArray[n2] = null;
        }
        return objectArray;
    }

    static <T> T[] toArrayImpl(Object[] objectArray, int n2, int n3, T[] TArray) {
        T[] TArray2;
        Preconditions.checkPositionIndexes(n2, n2 + n3, objectArray.length);
        if (TArray.length < n3) {
            TArray2 = ObjectArrays.newArray(TArray, n3);
        } else {
            TArray2 = TArray;
            if (TArray.length > n3) {
                TArray[n3] = null;
                TArray2 = TArray;
            }
        }
        System.arraycopy(objectArray, n2, TArray2, 0, n3);
        return TArray2;
    }
}

