/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.AbstractMapBasedMultiset;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ForwardingMultiset;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.TransformedIterator;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.UnmodifiableSortedMultiset;
import com.google.common.math.IntMath;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Multisets {
    private Multisets() {
    }

    private static <E> boolean addAllImpl(Multiset<E> multiset, AbstractMapBasedMultiset<? extends E> abstractMapBasedMultiset) {
        if (abstractMapBasedMultiset.isEmpty()) {
            return false;
        }
        abstractMapBasedMultiset.addTo(multiset);
        return true;
    }

    private static <E> boolean addAllImpl(Multiset<E> multiset, Multiset<? extends E> object2) {
        if (object2 instanceof AbstractMapBasedMultiset) {
            return Multisets.addAllImpl(multiset, (AbstractMapBasedMultiset)object2);
        }
        if (object2.isEmpty()) {
            return false;
        }
        for (Multiset.Entry entry : object2.entrySet()) {
            multiset.add(entry.getElement(), entry.getCount());
        }
        return true;
    }

    static <E> boolean addAllImpl(Multiset<E> multiset, Collection<? extends E> collection) {
        Preconditions.checkNotNull(multiset);
        Preconditions.checkNotNull(collection);
        if (collection instanceof Multiset) {
            return Multisets.addAllImpl(multiset, Multisets.cast(collection));
        }
        if (collection.isEmpty()) {
            return false;
        }
        return Iterators.addAll(multiset, collection.iterator());
    }

    static <T> Multiset<T> cast(Iterable<T> iterable) {
        return (Multiset)iterable;
    }

    public static boolean containsOccurrences(Multiset<?> multiset, Multiset<?> entry2) {
        Preconditions.checkNotNull(multiset);
        Preconditions.checkNotNull(entry2);
        for (Multiset.Entry<?> entry2 : entry2.entrySet()) {
            if (multiset.count(entry2.getElement()) >= entry2.getCount()) continue;
            return false;
        }
        return true;
    }

    public static <E> ImmutableMultiset<E> copyHighestCountFirst(Multiset<E> entryArray) {
        entryArray = entryArray.entrySet().toArray(new Multiset.Entry[0]);
        Arrays.sort(entryArray, DecreasingCount.INSTANCE);
        return ImmutableMultiset.copyFromEntries(Arrays.asList(entryArray));
    }

    public static <E> Multiset<E> difference(final Multiset<E> multiset, final Multiset<?> multiset2) {
        Preconditions.checkNotNull(multiset);
        Preconditions.checkNotNull(multiset2);
        return new ViewMultiset<E>(){

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int count(@NullableDecl Object object) {
                int n2 = multiset.count(object);
                int n3 = 0;
                if (n2 != 0) {
                    n3 = Math.max(0, n2 - multiset2.count(object));
                }
                return n3;
            }

            @Override
            int distinctElements() {
                return Iterators.size(this.entryIterator());
            }

            @Override
            Iterator<E> elementIterator() {
                return new AbstractIterator<E>(multiset.entrySet().iterator()){
                    final /* synthetic */ Iterator val$iterator1;
                    {
                        this.val$iterator1 = iterator2;
                    }

                    @Override
                    protected E computeNext() {
                        while (this.val$iterator1.hasNext()) {
                            Multiset.Entry entry = (Multiset.Entry)this.val$iterator1.next();
                            Object e2 = entry.getElement();
                            if (entry.getCount() <= multiset2.count(e2)) continue;
                            return e2;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            Iterator<Multiset.Entry<E>> entryIterator() {
                return new AbstractIterator<Multiset.Entry<E>>(multiset.entrySet().iterator()){
                    final /* synthetic */ Iterator val$iterator1;
                    {
                        this.val$iterator1 = iterator2;
                    }

                    @Override
                    protected Multiset.Entry<E> computeNext() {
                        while (this.val$iterator1.hasNext()) {
                            Multiset.Entry entry = (Multiset.Entry)this.val$iterator1.next();
                            Object e2 = entry.getElement();
                            int n2 = entry.getCount() - multiset2.count(e2);
                            if (n2 <= 0) continue;
                            return Multisets.immutableEntry(e2, n2);
                        }
                        return (Multiset.Entry)this.endOfData();
                    }
                };
            }
        };
    }

    static <E> Iterator<E> elementIterator(Iterator<Multiset.Entry<E>> iterator2) {
        return new TransformedIterator<Multiset.Entry<E>, E>(iterator2){

            E transform(Multiset.Entry<E> entry) {
                return entry.getElement();
            }
        };
    }

    static boolean equalsImpl(Multiset<?> multiset, @NullableDecl Object entry2) {
        if (entry2 == multiset) {
            return true;
        }
        if (entry2 instanceof Multiset) {
            entry2 = (Multiset)((Object)entry2);
            if (multiset.size() == entry2.size() && multiset.entrySet().size() == entry2.entrySet().size()) {
                for (Multiset.Entry entry2 : entry2.entrySet()) {
                    if (multiset.count(entry2.getElement()) == entry2.getCount()) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static <E> Multiset<E> filter(Multiset<E> filteredMultiset, Predicate<? super E> predicate) {
        if (filteredMultiset instanceof FilteredMultiset) {
            filteredMultiset = filteredMultiset;
            predicate = Predicates.and(filteredMultiset.predicate, predicate);
            return new FilteredMultiset<E>(filteredMultiset.unfiltered, predicate);
        }
        return new FilteredMultiset<E>(filteredMultiset, predicate);
    }

    public static <E> Multiset.Entry<E> immutableEntry(@NullableDecl E e2, int n2) {
        return new ImmutableEntry<E>(e2, n2);
    }

    static int inferDistinctElements(Iterable<?> iterable) {
        if (iterable instanceof Multiset) {
            return ((Multiset)iterable).elementSet().size();
        }
        return 11;
    }

    public static <E> Multiset<E> intersection(final Multiset<E> multiset, final Multiset<?> multiset2) {
        Preconditions.checkNotNull(multiset);
        Preconditions.checkNotNull(multiset2);
        return new ViewMultiset<E>(){

            @Override
            public int count(Object object) {
                int n2 = multiset.count(object);
                n2 = n2 == 0 ? 0 : Math.min(n2, multiset2.count(object));
                return n2;
            }

            @Override
            Set<E> createElementSet() {
                return Sets.intersection(multiset.elementSet(), multiset2.elementSet());
            }

            @Override
            Iterator<E> elementIterator() {
                throw new AssertionError((Object)"should never be called");
            }

            @Override
            Iterator<Multiset.Entry<E>> entryIterator() {
                return new AbstractIterator<Multiset.Entry<E>>(multiset.entrySet().iterator()){
                    final /* synthetic */ Iterator val$iterator1;
                    {
                        this.val$iterator1 = iterator2;
                    }

                    @Override
                    protected Multiset.Entry<E> computeNext() {
                        while (this.val$iterator1.hasNext()) {
                            Multiset.Entry entry = (Multiset.Entry)this.val$iterator1.next();
                            Object e2 = entry.getElement();
                            int n2 = Math.min(entry.getCount(), multiset2.count(e2));
                            if (n2 <= 0) continue;
                            return Multisets.immutableEntry(e2, n2);
                        }
                        return (Multiset.Entry)this.endOfData();
                    }
                };
            }
        };
    }

    static <E> Iterator<E> iteratorImpl(Multiset<E> multiset) {
        return new MultisetIteratorImpl<E>(multiset, multiset.entrySet().iterator());
    }

    static int linearTimeSizeImpl(Multiset<?> object) {
        object = object.entrySet().iterator();
        long l2 = 0L;
        while (object.hasNext()) {
            l2 += (long)((Multiset.Entry)object.next()).getCount();
        }
        return Ints.saturatedCast(l2);
    }

    static boolean removeAllImpl(Multiset<?> multiset, Collection<?> collection) {
        Collection<?> collection2 = collection;
        if (collection instanceof Multiset) {
            collection2 = ((Multiset)collection).elementSet();
        }
        return multiset.elementSet().removeAll(collection2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean removeOccurrences(Multiset<?> multiset, Multiset<?> multiset2) {
        Preconditions.checkNotNull(multiset);
        Preconditions.checkNotNull(multiset2);
        Iterator<Multiset.Entry<?>> iterator2 = multiset.entrySet().iterator();
        boolean bl = false;
        while (iterator2.hasNext()) {
            Multiset.Entry<?> entry = iterator2.next();
            int n2 = multiset2.count(entry.getElement());
            if (n2 >= entry.getCount()) {
                iterator2.remove();
            } else {
                if (n2 <= 0) continue;
                multiset.remove(entry.getElement(), n2);
            }
            bl = true;
        }
        return bl;
    }

    public static boolean removeOccurrences(Multiset<?> multiset, Iterable<?> object) {
        if (object instanceof Multiset) {
            return Multisets.removeOccurrences(multiset, (Multiset)object);
        }
        Preconditions.checkNotNull(multiset);
        Preconditions.checkNotNull(object);
        boolean bl = false;
        object = object.iterator();
        while (object.hasNext()) {
            bl |= multiset.remove(object.next());
        }
        return bl;
    }

    static boolean retainAllImpl(Multiset<?> multiset, Collection<?> collection) {
        Preconditions.checkNotNull(collection);
        Collection<?> collection2 = collection;
        if (collection instanceof Multiset) {
            collection2 = ((Multiset)collection).elementSet();
        }
        return multiset.elementSet().retainAll(collection2);
    }

    public static boolean retainOccurrences(Multiset<?> multiset, Multiset<?> multiset2) {
        return Multisets.retainOccurrencesImpl(multiset, multiset2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static <E> boolean retainOccurrencesImpl(Multiset<E> multiset, Multiset<?> multiset2) {
        Preconditions.checkNotNull(multiset);
        Preconditions.checkNotNull(multiset2);
        Iterator<Multiset.Entry<E>> iterator2 = multiset.entrySet().iterator();
        boolean bl = false;
        while (iterator2.hasNext()) {
            Multiset.Entry<E> entry = iterator2.next();
            int n2 = multiset2.count(entry.getElement());
            if (n2 == 0) {
                iterator2.remove();
            } else {
                if (n2 >= entry.getCount()) continue;
                multiset.setCount(entry.getElement(), n2);
            }
            bl = true;
        }
        return bl;
    }

    static <E> int setCountImpl(Multiset<E> multiset, E e2, int n2) {
        CollectPreconditions.checkNonnegative((int)n2, (String)"count");
        int n3 = multiset.count(e2);
        if ((n2 -= n3) > 0) {
            multiset.add(e2, n2);
        } else if (n2 < 0) {
            multiset.remove(e2, -n2);
        }
        return n3;
    }

    static <E> boolean setCountImpl(Multiset<E> multiset, E e2, int n2, int n3) {
        CollectPreconditions.checkNonnegative((int)n2, (String)"oldCount");
        CollectPreconditions.checkNonnegative((int)n3, (String)"newCount");
        if (multiset.count(e2) == n2) {
            multiset.setCount(e2, n3);
            return true;
        }
        return false;
    }

    public static <E> Multiset<E> sum(final Multiset<? extends E> multiset, final Multiset<? extends E> multiset2) {
        Preconditions.checkNotNull(multiset);
        Preconditions.checkNotNull(multiset2);
        return new ViewMultiset<E>(){

            @Override
            public boolean contains(@NullableDecl Object object) {
                boolean bl = multiset.contains(object) || multiset2.contains(object);
                return bl;
            }

            @Override
            public int count(Object object) {
                return multiset.count(object) + multiset2.count(object);
            }

            @Override
            Set<E> createElementSet() {
                return Sets.union(multiset.elementSet(), multiset2.elementSet());
            }

            @Override
            Iterator<E> elementIterator() {
                throw new AssertionError((Object)"should never be called");
            }

            @Override
            Iterator<Multiset.Entry<E>> entryIterator() {
                return new AbstractIterator<Multiset.Entry<E>>(multiset.entrySet().iterator(), multiset2.entrySet().iterator()){
                    final /* synthetic */ Iterator val$iterator1;
                    final /* synthetic */ Iterator val$iterator2;
                    {
                        this.val$iterator1 = iterator2;
                        this.val$iterator2 = iterator3;
                    }

                    @Override
                    protected Multiset.Entry<E> computeNext() {
                        if (this.val$iterator1.hasNext()) {
                            Multiset.Entry entry = (Multiset.Entry)this.val$iterator1.next();
                            Object e2 = entry.getElement();
                            return Multisets.immutableEntry(e2, entry.getCount() + multiset2.count(e2));
                        }
                        while (this.val$iterator2.hasNext()) {
                            Multiset.Entry entry = (Multiset.Entry)this.val$iterator2.next();
                            Object e3 = entry.getElement();
                            if (multiset.contains(e3)) continue;
                            return Multisets.immutableEntry(e3, entry.getCount());
                        }
                        return (Multiset.Entry)this.endOfData();
                    }
                };
            }

            @Override
            public boolean isEmpty() {
                boolean bl = multiset.isEmpty() && multiset2.isEmpty();
                return bl;
            }

            @Override
            public int size() {
                return IntMath.saturatedAdd((int)multiset.size(), (int)multiset2.size());
            }
        };
    }

    public static <E> Multiset<E> union(final Multiset<? extends E> multiset, final Multiset<? extends E> multiset2) {
        Preconditions.checkNotNull(multiset);
        Preconditions.checkNotNull(multiset2);
        return new ViewMultiset<E>(){

            @Override
            public boolean contains(@NullableDecl Object object) {
                boolean bl = multiset.contains(object) || multiset2.contains(object);
                return bl;
            }

            @Override
            public int count(Object object) {
                return Math.max(multiset.count(object), multiset2.count(object));
            }

            @Override
            Set<E> createElementSet() {
                return Sets.union(multiset.elementSet(), multiset2.elementSet());
            }

            @Override
            Iterator<E> elementIterator() {
                throw new AssertionError((Object)"should never be called");
            }

            @Override
            Iterator<Multiset.Entry<E>> entryIterator() {
                return new AbstractIterator<Multiset.Entry<E>>(multiset.entrySet().iterator(), multiset2.entrySet().iterator()){
                    final /* synthetic */ Iterator val$iterator1;
                    final /* synthetic */ Iterator val$iterator2;
                    {
                        this.val$iterator1 = iterator2;
                        this.val$iterator2 = iterator3;
                    }

                    @Override
                    protected Multiset.Entry<E> computeNext() {
                        if (this.val$iterator1.hasNext()) {
                            Multiset.Entry entry = (Multiset.Entry)this.val$iterator1.next();
                            Object e2 = entry.getElement();
                            return Multisets.immutableEntry(e2, Math.max(entry.getCount(), multiset2.count(e2)));
                        }
                        while (this.val$iterator2.hasNext()) {
                            Multiset.Entry entry = (Multiset.Entry)this.val$iterator2.next();
                            Object e3 = entry.getElement();
                            if (multiset.contains(e3)) continue;
                            return Multisets.immutableEntry(e3, entry.getCount());
                        }
                        return (Multiset.Entry)this.endOfData();
                    }
                };
            }

            @Override
            public boolean isEmpty() {
                boolean bl = multiset.isEmpty() && multiset2.isEmpty();
                return bl;
            }
        };
    }

    @Deprecated
    public static <E> Multiset<E> unmodifiableMultiset(ImmutableMultiset<E> immutableMultiset) {
        return Preconditions.checkNotNull(immutableMultiset);
    }

    public static <E> Multiset<E> unmodifiableMultiset(Multiset<? extends E> multiset) {
        if (!(multiset instanceof UnmodifiableMultiset) && !(multiset instanceof ImmutableMultiset)) {
            return new UnmodifiableMultiset<E>(Preconditions.checkNotNull(multiset));
        }
        return multiset;
    }

    public static <E> SortedMultiset<E> unmodifiableSortedMultiset(SortedMultiset<E> sortedMultiset) {
        return new UnmodifiableSortedMultiset<E>(Preconditions.checkNotNull(sortedMultiset));
    }

    static abstract class AbstractEntry<E>
    implements Multiset.Entry<E> {
        AbstractEntry() {
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            boolean bl;
            boolean bl2 = object instanceof Multiset.Entry;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (Multiset.Entry)object;
                bl3 = bl;
                if (this.getCount() == object.getCount()) {
                    bl3 = bl;
                    if (Objects.equal(this.getElement(), object.getElement())) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        @Override
        public int hashCode() {
            Object e2 = this.getElement();
            int n2 = e2 == null ? 0 : e2.hashCode();
            return n2 ^ this.getCount();
        }

        @Override
        public String toString() {
            String string2 = String.valueOf(this.getElement());
            int n2 = this.getCount();
            if (n2 != 1) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string2);
                stringBuilder.append(" x ");
                stringBuilder.append(n2);
                string2 = stringBuilder.toString();
            }
            return string2;
        }
    }

    private static final class DecreasingCount
    implements Comparator<Multiset.Entry<?>> {
        static final DecreasingCount INSTANCE = new DecreasingCount();

        private DecreasingCount() {
        }

        @Override
        public int compare(Multiset.Entry<?> entry, Multiset.Entry<?> entry2) {
            return entry2.getCount() - entry.getCount();
        }
    }

    static abstract class ElementSet<E>
    extends Sets.ImprovedAbstractSet<E> {
        ElementSet() {
        }

        @Override
        public void clear() {
            this.multiset().clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.multiset().contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.multiset().containsAll(collection);
        }

        @Override
        public boolean isEmpty() {
            return this.multiset().isEmpty();
        }

        @Override
        public abstract Iterator<E> iterator();

        abstract Multiset<E> multiset();

        @Override
        public boolean remove(Object object) {
            boolean bl = this.multiset().remove(object, Integer.MAX_VALUE) > 0;
            return bl;
        }

        @Override
        public int size() {
            return this.multiset().entrySet().size();
        }
    }

    static abstract class EntrySet<E>
    extends Sets.ImprovedAbstractSet<Multiset.Entry<E>> {
        EntrySet() {
        }

        @Override
        public void clear() {
            this.multiset().clear();
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            boolean bl;
            boolean bl2 = object instanceof Multiset.Entry;
            boolean bl3 = bl = false;
            if (bl2) {
                if ((object = (Multiset.Entry)object).getCount() <= 0) {
                    return false;
                }
                bl3 = bl;
                if (this.multiset().count(object.getElement()) == object.getCount()) {
                    bl3 = true;
                }
            }
            return bl3;
        }

        abstract Multiset<E> multiset();

        @Override
        public boolean remove(Object object) {
            if (object instanceof Multiset.Entry) {
                object = (Multiset.Entry)object;
                Object e2 = object.getElement();
                int n2 = object.getCount();
                if (n2 != 0) {
                    return this.multiset().setCount(e2, n2, 0);
                }
            }
            return false;
        }
    }

    private static final class FilteredMultiset<E>
    extends ViewMultiset<E> {
        final Predicate<? super E> predicate;
        final Multiset<E> unfiltered;

        FilteredMultiset(Multiset<E> multiset, Predicate<? super E> predicate) {
            this.unfiltered = Preconditions.checkNotNull(multiset);
            this.predicate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public int add(@NullableDecl E e2, int n2) {
            Preconditions.checkArgument(this.predicate.apply(e2), "Element %s does not match predicate %s", e2, this.predicate);
            return this.unfiltered.add(e2, n2);
        }

        @Override
        public int count(@NullableDecl Object object) {
            int n2 = this.unfiltered.count(object);
            if (n2 > 0) {
                if (!this.predicate.apply(object)) {
                    n2 = 0;
                }
                return n2;
            }
            return 0;
        }

        @Override
        Set<E> createElementSet() {
            return Sets.filter(this.unfiltered.elementSet(), this.predicate);
        }

        @Override
        Set<Multiset.Entry<E>> createEntrySet() {
            return Sets.filter(this.unfiltered.entrySet(), new Predicate<Multiset.Entry<E>>(){

                @Override
                public boolean apply(Multiset.Entry<E> entry) {
                    return FilteredMultiset.this.predicate.apply(entry.getElement());
                }
            });
        }

        @Override
        Iterator<E> elementIterator() {
            throw new AssertionError((Object)"should never be called");
        }

        @Override
        Iterator<Multiset.Entry<E>> entryIterator() {
            throw new AssertionError((Object)"should never be called");
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return Iterators.filter(this.unfiltered.iterator(), this.predicate);
        }

        @Override
        public int remove(@NullableDecl Object object, int n2) {
            CollectPreconditions.checkNonnegative((int)n2, (String)"occurrences");
            if (n2 == 0) {
                return this.count(object);
            }
            n2 = this.contains(object) ? this.unfiltered.remove(object, n2) : 0;
            return n2;
        }
    }

    static class ImmutableEntry<E>
    extends AbstractEntry<E>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final int count;
        @NullableDecl
        private final E element;

        ImmutableEntry(@NullableDecl E e2, int n2) {
            this.element = e2;
            this.count = n2;
            CollectPreconditions.checkNonnegative((int)n2, (String)"count");
        }

        @Override
        public final int getCount() {
            return this.count;
        }

        @Override
        @NullableDecl
        public final E getElement() {
            return this.element;
        }

        public ImmutableEntry<E> nextInBucket() {
            return null;
        }
    }

    static final class MultisetIteratorImpl<E>
    implements Iterator<E> {
        private boolean canRemove;
        @MonotonicNonNullDecl
        private Multiset.Entry<E> currentEntry;
        private final Iterator<Multiset.Entry<E>> entryIterator;
        private int laterCount;
        private final Multiset<E> multiset;
        private int totalCount;

        MultisetIteratorImpl(Multiset<E> multiset, Iterator<Multiset.Entry<E>> iterator2) {
            this.multiset = multiset;
            this.entryIterator = iterator2;
        }

        @Override
        public boolean hasNext() {
            boolean bl = this.laterCount > 0 || this.entryIterator.hasNext();
            return bl;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                if (this.laterCount == 0) {
                    int n2;
                    this.currentEntry = this.entryIterator.next();
                    this.laterCount = n2 = this.currentEntry.getCount();
                    this.totalCount = n2;
                }
                --this.laterCount;
                this.canRemove = true;
                return this.currentEntry.getElement();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            CollectPreconditions.checkRemove((boolean)this.canRemove);
            if (this.totalCount == 1) {
                this.entryIterator.remove();
            } else {
                this.multiset.remove(this.currentEntry.getElement());
            }
            --this.totalCount;
            this.canRemove = false;
        }
    }

    static class UnmodifiableMultiset<E>
    extends ForwardingMultiset<E>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        final Multiset<? extends E> delegate;
        @MonotonicNonNullDecl
        transient Set<E> elementSet;
        @MonotonicNonNullDecl
        transient Set<Multiset.Entry<E>> entrySet;

        UnmodifiableMultiset(Multiset<? extends E> multiset) {
            this.delegate = multiset;
        }

        @Override
        public int add(E e2, int n2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(E e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        Set<E> createElementSet() {
            return Collections.unmodifiableSet(this.delegate.elementSet());
        }

        @Override
        protected Multiset<E> delegate() {
            return this.delegate;
        }

        @Override
        public Set<E> elementSet() {
            Set<E> set;
            Set<E> set2 = set = this.elementSet;
            if (set == null) {
                this.elementSet = set2 = this.createElementSet();
            }
            return set2;
        }

        @Override
        public Set<Multiset.Entry<E>> entrySet() {
            Set<Multiset.Entry<Multiset.Entry<E>>> set;
            Set<Multiset.Entry<Multiset.Entry<E>>> set2 = set = this.entrySet;
            if (set == null) {
                set2 = Collections.unmodifiableSet(this.delegate.entrySet());
                this.entrySet = set2;
            }
            return set2;
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.unmodifiableIterator(this.delegate.iterator());
        }

        @Override
        public int remove(Object object, int n2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int setCount(E e2, int n2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setCount(E e2, int n2, int n3) {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class ViewMultiset<E>
    extends AbstractMultiset<E> {
        private ViewMultiset() {
        }

        @Override
        public void clear() {
            this.elementSet().clear();
        }

        @Override
        int distinctElements() {
            return this.elementSet().size();
        }

        @Override
        public Iterator<E> iterator() {
            return Multisets.iteratorImpl(this);
        }

        @Override
        public int size() {
            return Multisets.linearTimeSizeImpl(this);
        }
    }
}

