/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Ordering;
import com.google.common.math.IntMath;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class MinMaxPriorityQueue<E>
extends AbstractQueue<E> {
    private static final int DEFAULT_CAPACITY = 11;
    private static final int EVEN_POWERS_OF_TWO = 0x55555555;
    private static final int ODD_POWERS_OF_TWO = -1431655766;
    private final Heap maxHeap;
    final int maximumSize;
    private final Heap minHeap;
    private int modCount;
    private Object[] queue;
    private int size;

    private MinMaxPriorityQueue(Builder<? super E> builder, int n2) {
        Heap heap;
        Object object = ((Builder)builder).ordering();
        this.minHeap = new Heap(object);
        this.maxHeap = new Heap(((Ordering)object).reverse());
        object = this.minHeap;
        ((Heap)object).otherHeap = heap = this.maxHeap;
        heap.otherHeap = object;
        this.maximumSize = ((Builder)builder).maximumSize;
        this.queue = new Object[n2];
    }

    private int calculateNewCapacity() {
        int n2 = this.queue.length;
        n2 = n2 < 64 ? (n2 + 1) * 2 : IntMath.checkedMultiply((int)(n2 / 2), (int)3);
        return MinMaxPriorityQueue.capAtMaximumSize(n2, this.maximumSize);
    }

    private static int capAtMaximumSize(int n2, int n3) {
        return Math.min(n2 - 1, n3) + 1;
    }

    public static <E extends Comparable<E>> MinMaxPriorityQueue<E> create() {
        return new Builder(Ordering.natural()).create();
    }

    public static <E extends Comparable<E>> MinMaxPriorityQueue<E> create(Iterable<? extends E> iterable) {
        return new Builder(Ordering.natural()).create(iterable);
    }

    public static Builder<Comparable> expectedSize(int n2) {
        return new Builder(Ordering.natural()).expectedSize(n2);
    }

    private MoveDesc<E> fillHole(int n2, E object) {
        int n3;
        Heap heap = this.heapForIndex(n2);
        int n4 = heap.bubbleUpAlternatingLevels(n3 = heap.fillHoleAt(n2), object);
        if (n4 == n3) {
            return heap.tryCrossOverAndBubbleUp(n2, n3, object);
        }
        object = n4 < n2 ? new MoveDesc<E>(object, this.elementData(n2)) : null;
        return object;
    }

    private int getMaxElementIndex() {
        int n2 = this.size;
        int n3 = 1;
        if (n2 != 1) {
            int n4 = n3;
            if (n2 != 2) {
                n4 = this.maxHeap.compareElements(1, 2) <= 0 ? n3 : 2;
            }
            return n4;
        }
        return 0;
    }

    private void growIfNeeded() {
        if (this.size > this.queue.length) {
            Object[] objectArray = new Object[this.calculateNewCapacity()];
            Object[] objectArray2 = this.queue;
            System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
            this.queue = objectArray;
        }
    }

    private Heap heapForIndex(int n2) {
        Heap heap = MinMaxPriorityQueue.isEvenLevel(n2) ? this.minHeap : this.maxHeap;
        return heap;
    }

    static int initialQueueSize(int n2, int n3, Iterable<?> iterable) {
        int n4 = n2;
        if (n2 == -1) {
            n4 = 11;
        }
        n2 = n4;
        if (iterable instanceof Collection) {
            n2 = Math.max(n4, ((Collection)iterable).size());
        }
        return MinMaxPriorityQueue.capAtMaximumSize(n2, n3);
    }

    static boolean isEvenLevel(int n2) {
        boolean bl = true;
        boolean bl2 = (n2 = ~(~(n2 + 1))) > 0;
        Preconditions.checkState(bl2, "negative index");
        bl2 = (0x55555555 & n2) > (n2 & 0xAAAAAAAA) ? bl : false;
        return bl2;
    }

    public static Builder<Comparable> maximumSize(int n2) {
        return new Builder(Ordering.natural()).maximumSize(n2);
    }

    public static <B> Builder<B> orderedBy(Comparator<B> comparator) {
        return new Builder(comparator);
    }

    private E removeAndGet(int n2) {
        E e2 = this.elementData(n2);
        this.removeAt(n2);
        return e2;
    }

    @Override
    public boolean add(E e2) {
        this.offer(e2);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> object) {
        object = object.iterator();
        boolean bl = false;
        while (object.hasNext()) {
            this.offer(object.next());
            bl = true;
        }
        return bl;
    }

    int capacity() {
        return this.queue.length;
    }

    @Override
    public void clear() {
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.queue[i2] = null;
        }
        this.size = 0;
    }

    public Comparator<? super E> comparator() {
        return this.minHeap.ordering;
    }

    E elementData(int n2) {
        return (E)this.queue[n2];
    }

    boolean isIntact() {
        for (int i2 = 1; i2 < this.size; ++i2) {
            if (this.heapForIndex(i2).verifyIndex(i2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new QueueIterator();
    }

    @Override
    public boolean offer(E e2) {
        Preconditions.checkNotNull(e2);
        int n2 = this.modCount;
        boolean bl = true;
        this.modCount = n2 + 1;
        n2 = this.size;
        this.size = n2 + 1;
        this.growIfNeeded();
        this.heapForIndex(n2).bubbleUp(n2, e2);
        boolean bl2 = bl;
        if (this.size > this.maximumSize) {
            bl2 = this.pollLast() != e2 ? bl : false;
        }
        return bl2;
    }

    @Override
    public E peek() {
        E e2 = this.isEmpty() ? null : (E)this.elementData(0);
        return e2;
    }

    public E peekFirst() {
        return this.peek();
    }

    public E peekLast() {
        E e2 = this.isEmpty() ? null : (E)this.elementData(this.getMaxElementIndex());
        return e2;
    }

    @Override
    public E poll() {
        E e2 = this.isEmpty() ? null : (E)this.removeAndGet(0);
        return e2;
    }

    public E pollFirst() {
        return this.poll();
    }

    public E pollLast() {
        E e2 = this.isEmpty() ? null : (E)this.removeAndGet(this.getMaxElementIndex());
        return e2;
    }

    MoveDesc<E> removeAt(int n2) {
        Preconditions.checkPositionIndex(n2, this.size);
        ++this.modCount;
        --this.size;
        int n3 = this.size;
        if (n3 == n2) {
            this.queue[n3] = null;
            return null;
        }
        E e2 = this.elementData(n3);
        n3 = this.heapForIndex(this.size).swapWithConceptuallyLastElement(e2);
        if (n3 == n2) {
            this.queue[this.size] = null;
            return null;
        }
        E e3 = this.elementData(this.size);
        this.queue[this.size] = null;
        MoveDesc<E> moveDesc = this.fillHole(n2, e3);
        if (n3 < n2) {
            if (moveDesc == null) {
                return new MoveDesc<E>(e2, e3);
            }
            return new MoveDesc<E>(e2, moveDesc.replaced);
        }
        return moveDesc;
    }

    public E removeFirst() {
        return this.remove();
    }

    public E removeLast() {
        if (!this.isEmpty()) {
            return this.removeAndGet(this.getMaxElementIndex());
        }
        throw new NoSuchElementException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        int n2 = this.size;
        Object[] objectArray = new Object[n2];
        System.arraycopy(this.queue, 0, objectArray, 0, n2);
        return objectArray;
    }

    public static final class Builder<B> {
        private static final int UNSET_EXPECTED_SIZE = -1;
        private final Comparator<B> comparator;
        private int expectedSize = -1;
        private int maximumSize = Integer.MAX_VALUE;

        private Builder(Comparator<B> comparator) {
            this.comparator = Preconditions.checkNotNull(comparator);
        }

        private <T extends B> Ordering<T> ordering() {
            return Ordering.from(this.comparator);
        }

        public <T extends B> MinMaxPriorityQueue<T> create() {
            return this.create(Collections.emptySet());
        }

        public <T extends B> MinMaxPriorityQueue<T> create(Iterable<? extends T> object) {
            MinMaxPriorityQueue minMaxPriorityQueue = new MinMaxPriorityQueue(this, MinMaxPriorityQueue.initialQueueSize(this.expectedSize, this.maximumSize, object));
            object = object.iterator();
            while (object.hasNext()) {
                minMaxPriorityQueue.offer(object.next());
            }
            return minMaxPriorityQueue;
        }

        public Builder<B> expectedSize(int n2) {
            boolean bl = n2 >= 0;
            Preconditions.checkArgument(bl);
            this.expectedSize = n2;
            return this;
        }

        public Builder<B> maximumSize(int n2) {
            boolean bl = n2 > 0;
            Preconditions.checkArgument(bl);
            this.maximumSize = n2;
            return this;
        }
    }

    private class Heap {
        final Ordering<E> ordering;
        @MonotonicNonNullDecl
        Heap otherHeap;

        Heap(Ordering<E> ordering) {
            this.ordering = ordering;
        }

        private int getGrandparentIndex(int n2) {
            return this.getParentIndex(this.getParentIndex(n2));
        }

        private int getLeftChildIndex(int n2) {
            return n2 * 2 + 1;
        }

        private int getParentIndex(int n2) {
            return (n2 - 1) / 2;
        }

        private int getRightChildIndex(int n2) {
            return n2 * 2 + 2;
        }

        private boolean verifyIndex(int n2) {
            if (this.getLeftChildIndex(n2) < MinMaxPriorityQueue.this.size && this.compareElements(n2, this.getLeftChildIndex(n2)) > 0) {
                return false;
            }
            if (this.getRightChildIndex(n2) < MinMaxPriorityQueue.this.size && this.compareElements(n2, this.getRightChildIndex(n2)) > 0) {
                return false;
            }
            if (n2 > 0 && this.compareElements(n2, this.getParentIndex(n2)) > 0) {
                return false;
            }
            return n2 <= 2 || this.compareElements(this.getGrandparentIndex(n2), n2) <= 0;
        }

        void bubbleUp(int n2, E e2) {
            Heap heap;
            int n3 = this.crossOverUp(n2, e2);
            if (n3 == n2) {
                heap = this;
            } else {
                heap = this.otherHeap;
                n2 = n3;
            }
            heap.bubbleUpAlternatingLevels(n2, e2);
        }

        int bubbleUpAlternatingLevels(int n2, E e2) {
            int n3;
            Object e3;
            while (n2 > 2 && this.ordering.compare(e3 = MinMaxPriorityQueue.this.elementData(n3 = this.getGrandparentIndex(n2)), e2) > 0) {
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[n2] = e3;
                n2 = n3;
            }
            ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[n2] = e2;
            return n2;
        }

        int compareElements(int n2, int n3) {
            return this.ordering.compare(MinMaxPriorityQueue.this.elementData(n2), MinMaxPriorityQueue.this.elementData(n3));
        }

        int crossOver(int n2, E e2) {
            int n3 = this.findMinChild(n2);
            if (n3 > 0 && this.ordering.compare(MinMaxPriorityQueue.this.elementData(n3), e2) < 0) {
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[n2] = MinMaxPriorityQueue.this.elementData(n3);
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[n3] = e2;
                return n3;
            }
            return this.crossOverUp(n2, e2);
        }

        int crossOverUp(int n2, E e2) {
            if (n2 == 0) {
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[0] = e2;
                return 0;
            }
            int n3 = this.getParentIndex(n2);
            Object e3 = MinMaxPriorityQueue.this.elementData(n3);
            int n4 = n3;
            Object e4 = e3;
            if (n3 != 0) {
                int n5 = this.getRightChildIndex(this.getParentIndex(n3));
                n4 = n3;
                e4 = e3;
                if (n5 != n3) {
                    n4 = n3;
                    e4 = e3;
                    if (this.getLeftChildIndex(n5) >= MinMaxPriorityQueue.this.size) {
                        Object e5 = MinMaxPriorityQueue.this.elementData(n5);
                        n4 = n3;
                        e4 = e3;
                        if (this.ordering.compare(e5, e3) < 0) {
                            n4 = n5;
                            e4 = e5;
                        }
                    }
                }
            }
            if (this.ordering.compare(e4, e2) < 0) {
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[n2] = e4;
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[n4] = e2;
                return n4;
            }
            ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[n2] = e2;
            return n2;
        }

        int fillHoleAt(int n2) {
            int n3;
            while ((n3 = this.findMinGrandChild(n2)) > 0) {
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[n2] = MinMaxPriorityQueue.this.elementData(n3);
                n2 = n3;
            }
            return n2;
        }

        int findMin(int n2, int n3) {
            if (n2 >= MinMaxPriorityQueue.this.size) {
                return -1;
            }
            boolean bl = n2 > 0;
            Preconditions.checkState(bl);
            int n4 = Math.min(n2, MinMaxPriorityQueue.this.size - n3);
            for (int i2 = n2 + 1; i2 < n4 + n3; ++i2) {
                int n5 = n2;
                if (this.compareElements(i2, n2) < 0) {
                    n5 = i2;
                }
                n2 = n5;
            }
            return n2;
        }

        int findMinChild(int n2) {
            return this.findMin(this.getLeftChildIndex(n2), 2);
        }

        int findMinGrandChild(int n2) {
            if ((n2 = this.getLeftChildIndex(n2)) < 0) {
                return -1;
            }
            return this.findMin(this.getLeftChildIndex(n2), 4);
        }

        int swapWithConceptuallyLastElement(E e2) {
            Object e3;
            int n2;
            int n3 = this.getParentIndex(MinMaxPriorityQueue.this.size);
            if (n3 != 0 && (n2 = this.getRightChildIndex(this.getParentIndex(n3))) != n3 && this.getLeftChildIndex(n2) >= MinMaxPriorityQueue.this.size && this.ordering.compare(e3 = MinMaxPriorityQueue.this.elementData(n2), e2) < 0) {
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[n2] = e2;
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[((MinMaxPriorityQueue)MinMaxPriorityQueue.this).size] = e3;
                return n2;
            }
            return MinMaxPriorityQueue.this.size;
        }

        MoveDesc<E> tryCrossOverAndBubbleUp(int n2, int n3, E e2) {
            int n4 = this.crossOver(n3, e2);
            if (n4 == n3) {
                return null;
            }
            Object e3 = n4 < n2 ? MinMaxPriorityQueue.this.elementData(n2) : MinMaxPriorityQueue.this.elementData(this.getParentIndex(n2));
            if (this.otherHeap.bubbleUpAlternatingLevels(n4, e2) < n2) {
                return new MoveDesc(e2, e3);
            }
            return null;
        }
    }

    static class MoveDesc<E> {
        final E replaced;
        final E toTrickle;

        MoveDesc(E e2, E e3) {
            this.toTrickle = e2;
            this.replaced = e3;
        }
    }

    private class QueueIterator
    implements Iterator<E> {
        private boolean canRemove;
        private int cursor = -1;
        private int expectedModCount = MinMaxPriorityQueue.access$700(MinMaxPriorityQueue.this);
        @MonotonicNonNullDecl
        private Queue<E> forgetMeNot;
        @NullableDecl
        private E lastFromForgetMeNot;
        private int nextCursor = -1;
        @MonotonicNonNullDecl
        private List<E> skipMe;

        private QueueIterator() {
        }

        private void checkModCount() {
            if (MinMaxPriorityQueue.this.modCount == this.expectedModCount) {
                return;
            }
            throw new ConcurrentModificationException();
        }

        private boolean foundAndRemovedExactReference(Iterable<E> object, E e2) {
            object = object.iterator();
            while (object.hasNext()) {
                if (object.next() != e2) continue;
                object.remove();
                return true;
            }
            return false;
        }

        private void nextNotInSkipMe(int n2) {
            if (this.nextCursor < n2) {
                int n3 = n2;
                if (this.skipMe != null) {
                    while (true) {
                        n3 = n2;
                        if (n2 >= MinMaxPriorityQueue.this.size()) break;
                        n3 = n2;
                        if (!this.foundAndRemovedExactReference(this.skipMe, MinMaxPriorityQueue.this.elementData(n2))) break;
                        ++n2;
                    }
                }
                this.nextCursor = n3;
            }
        }

        private boolean removeExact(Object object) {
            for (int i2 = 0; i2 < MinMaxPriorityQueue.this.size; ++i2) {
                if (MinMaxPriorityQueue.this.queue[i2] != object) continue;
                MinMaxPriorityQueue.this.removeAt(i2);
                return true;
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            this.checkModCount();
            int n2 = this.cursor;
            boolean bl = true;
            this.nextNotInSkipMe(n2 + 1);
            boolean bl2 = bl;
            if (this.nextCursor >= MinMaxPriorityQueue.this.size()) {
                Queue queue = this.forgetMeNot;
                bl2 = queue != null && !queue.isEmpty() ? bl : false;
            }
            return bl2;
        }

        @Override
        public E next() {
            this.checkModCount();
            this.nextNotInSkipMe(this.cursor + 1);
            if (this.nextCursor < MinMaxPriorityQueue.this.size()) {
                this.cursor = this.nextCursor;
                this.canRemove = true;
                return MinMaxPriorityQueue.this.elementData(this.cursor);
            }
            if (this.forgetMeNot != null) {
                this.cursor = MinMaxPriorityQueue.this.size();
                this.lastFromForgetMeNot = this.forgetMeNot.poll();
                Object e2 = this.lastFromForgetMeNot;
                if (e2 != null) {
                    this.canRemove = true;
                    return e2;
                }
            }
            throw new NoSuchElementException("iterator moved past last element in queue.");
        }

        @Override
        public void remove() {
            CollectPreconditions.checkRemove((boolean)this.canRemove);
            this.checkModCount();
            this.canRemove = false;
            ++this.expectedModCount;
            if (this.cursor < MinMaxPriorityQueue.this.size()) {
                MoveDesc moveDesc = MinMaxPriorityQueue.this.removeAt(this.cursor);
                if (moveDesc != null) {
                    if (this.forgetMeNot == null) {
                        this.forgetMeNot = new ArrayDeque();
                        this.skipMe = new ArrayList(3);
                    }
                    if (!this.foundAndRemovedExactReference(this.skipMe, moveDesc.toTrickle)) {
                        this.forgetMeNot.add(moveDesc.toTrickle);
                    }
                    if (!this.foundAndRemovedExactReference(this.forgetMeNot, moveDesc.replaced)) {
                        this.skipMe.add(moveDesc.replaced);
                    }
                }
                --this.cursor;
                --this.nextCursor;
            } else {
                Preconditions.checkState(this.removeExact(this.lastFromForgetMeNot));
                this.lastFromForgetMeNot = null;
            }
        }
    }
}

