/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ForwardingConcurrentMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.MapMaker;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

class MapMakerInternalMap<K, V, E extends InternalEntry<K, V, E>, S extends Segment<K, V, E, S>>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    static final long CLEANUP_EXECUTOR_DELAY_SECS = 60L;
    static final int CONTAINS_VALUE_RETRIES = 3;
    static final int DRAIN_MAX = 16;
    static final int DRAIN_THRESHOLD = 63;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final WeakValueReference<Object, Object, DummyInternalEntry> UNSET_WEAK_VALUE_REFERENCE = new WeakValueReference<Object, Object, DummyInternalEntry>(){

        @Override
        public void clear() {
        }

        @Override
        public WeakValueReference<Object, Object, DummyInternalEntry> copyFor(ReferenceQueue<Object> referenceQueue, DummyInternalEntry dummyInternalEntry) {
            return this;
        }

        @Override
        public Object get() {
            return null;
        }

        @Override
        public DummyInternalEntry getEntry() {
            return null;
        }
    };
    private static final long serialVersionUID = 5L;
    final int concurrencyLevel;
    final transient InternalEntryHelper<K, V, E, S> entryHelper;
    @MonotonicNonNullDecl
    transient Set<Map.Entry<K, V>> entrySet;
    final Equivalence<Object> keyEquivalence;
    @MonotonicNonNullDecl
    transient Set<K> keySet;
    final transient int segmentMask;
    final transient int segmentShift;
    final transient Segment<K, V, E, S>[] segments;
    @MonotonicNonNullDecl
    transient Collection<V> values;

    private MapMakerInternalMap(MapMaker segmentArray, InternalEntryHelper<K, V, E, S> internalEntryHelper) {
        int n2;
        this.concurrencyLevel = Math.min(segmentArray.getConcurrencyLevel(), 65536);
        this.keyEquivalence = segmentArray.getKeyEquivalence();
        this.entryHelper = internalEntryHelper;
        int n3 = Math.min(segmentArray.getInitialCapacity(), 0x40000000);
        int n4 = 0;
        int n5 = 1;
        int n6 = 0;
        for (n2 = 1; n2 < this.concurrencyLevel; n2 <<= 1) {
            ++n6;
        }
        this.segmentShift = 32 - n6;
        this.segmentMask = n2 - 1;
        this.segments = this.newSegmentArray(n2);
        int n7 = n3 / n2;
        int n8 = n5;
        n6 = n7;
        if (n2 * n7 < n3) {
            n6 = n7 + 1;
            n8 = n5;
        }
        while (true) {
            if (n8 >= n6) break;
            n8 <<= 1;
        }
        for (n2 = n4; n2 < (segmentArray = this.segments).length; ++n2) {
            segmentArray[n2] = this.createSegment(n8, -1);
        }
    }

    static <K, V> MapMakerInternalMap<K, V, ? extends InternalEntry<K, V, ?>, ?> create(MapMaker mapMaker) {
        if (mapMaker.getKeyStrength() == Strength.STRONG && mapMaker.getValueStrength() == Strength.STRONG) {
            return new MapMakerInternalMap(mapMaker, StrongKeyStrongValueEntry.Helper.instance());
        }
        if (mapMaker.getKeyStrength() == Strength.STRONG && mapMaker.getValueStrength() == Strength.WEAK) {
            return new MapMakerInternalMap(mapMaker, StrongKeyWeakValueEntry.Helper.instance());
        }
        if (mapMaker.getKeyStrength() == Strength.WEAK && mapMaker.getValueStrength() == Strength.STRONG) {
            return new MapMakerInternalMap(mapMaker, WeakKeyStrongValueEntry.Helper.instance());
        }
        if (mapMaker.getKeyStrength() == Strength.WEAK && mapMaker.getValueStrength() == Strength.WEAK) {
            return new MapMakerInternalMap(mapMaker, WeakKeyWeakValueEntry.Helper.instance());
        }
        throw new AssertionError();
    }

    static <K> MapMakerInternalMap<K, MapMaker.Dummy, ? extends InternalEntry<K, MapMaker.Dummy, ?>, ?> createWithDummyValues(MapMaker mapMaker) {
        if (mapMaker.getKeyStrength() == Strength.STRONG && mapMaker.getValueStrength() == Strength.STRONG) {
            return new MapMakerInternalMap(mapMaker, StrongKeyDummyValueEntry.Helper.instance());
        }
        if (mapMaker.getKeyStrength() == Strength.WEAK && mapMaker.getValueStrength() == Strength.STRONG) {
            return new MapMakerInternalMap(mapMaker, WeakKeyDummyValueEntry.Helper.instance());
        }
        if (mapMaker.getValueStrength() == Strength.WEAK) {
            throw new IllegalArgumentException("Map cannot have both weak and dummy values");
        }
        throw new AssertionError();
    }

    static int rehash(int n2) {
        n2 += n2 << 15 ^ 0xFFFFCD7D;
        n2 ^= n2 >>> 10;
        n2 += n2 << 3;
        n2 ^= n2 >>> 6;
        n2 += (n2 << 2) + (n2 << 14);
        return n2 ^ n2 >>> 16;
    }

    private static <E> ArrayList<E> toArrayList(Collection<E> collection) {
        ArrayList arrayList = new ArrayList(collection.size());
        Iterators.addAll(arrayList, collection.iterator());
        return arrayList;
    }

    static <K, V, E extends InternalEntry<K, V, E>> WeakValueReference<K, V, E> unsetWeakValueReference() {
        return UNSET_WEAK_VALUE_REFERENCE;
    }

    @Override
    public void clear() {
        Segment<K, V, E, S>[] segmentArray = this.segments;
        int n2 = segmentArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            segmentArray[i2].clear();
        }
    }

    @Override
    public boolean containsKey(@NullableDecl Object object) {
        if (object == null) {
            return false;
        }
        int n2 = this.hash(object);
        return this.segmentFor(n2).containsKey(object, n2);
    }

    @Override
    public boolean containsValue(@NullableDecl Object object) {
        if (object == null) {
            return false;
        }
        Segment<K, V, E, S>[] segmentArray = this.segments;
        long l2 = -1L;
        for (int i2 = 0; i2 < 3; ++i2) {
            int n2 = segmentArray.length;
            long l3 = 0L;
            for (int i3 = 0; i3 < n2; ++i3) {
                Segment<K, V, InternalEntry, S> segment = segmentArray[i3];
                int n3 = segment.count;
                AtomicReferenceArray atomicReferenceArray = segment.table;
                for (n3 = 0; n3 < atomicReferenceArray.length(); ++n3) {
                    for (InternalEntry internalEntry = (InternalEntry)atomicReferenceArray.get(n3); internalEntry != null; internalEntry = internalEntry.getNext()) {
                        V v2 = segment.getLiveValue(internalEntry);
                        if (v2 == null || !this.valueEquivalence().equivalent(object, v2)) continue;
                        return true;
                    }
                }
                l3 += (long)segment.modCount;
            }
            if (l3 == l2) break;
            l2 = l3;
        }
        return false;
    }

    E copyEntry(E e2, E e3) {
        return this.segmentFor(e2.getHash()).copyEntry(e2, e3);
    }

    Segment<K, V, E, S> createSegment(int n2, int n3) {
        return this.entryHelper.newSegment(this, n2, n3);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        if (entrySet == null) {
            this.entrySet = entrySet = new EntrySet();
        }
        return entrySet;
    }

    @Override
    public V get(@NullableDecl Object object) {
        if (object == null) {
            return null;
        }
        int n2 = this.hash(object);
        return this.segmentFor(n2).get(object, n2);
    }

    E getEntry(@NullableDecl Object object) {
        if (object == null) {
            return null;
        }
        int n2 = this.hash(object);
        return this.segmentFor(n2).getEntry(object, n2);
    }

    V getLiveValue(E object) {
        if (object.getKey() == null) {
            return null;
        }
        if ((object = object.getValue()) == null) {
            return null;
        }
        return (V)object;
    }

    int hash(Object object) {
        return MapMakerInternalMap.rehash(this.keyEquivalence.hash(object));
    }

    @Override
    public boolean isEmpty() {
        int n2;
        Segment<K, V, E, S>[] segmentArray = this.segments;
        long l2 = 0L;
        for (n2 = 0; n2 < segmentArray.length; ++n2) {
            if (segmentArray[n2].count != 0) {
                return false;
            }
            l2 += (long)segmentArray[n2].modCount;
        }
        if (l2 != 0L) {
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                if (segmentArray[n2].count != 0) {
                    return false;
                }
                l2 -= (long)segmentArray[n2].modCount;
            }
            if (l2 != 0L) {
                return false;
            }
        }
        return true;
    }

    boolean isLiveForTesting(InternalEntry<K, V, ?> internalEntry) {
        boolean bl = this.segmentFor(internalEntry.getHash()).getLiveValueForTesting(internalEntry) != null;
        return bl;
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        if (keySet == null) {
            this.keySet = keySet = new KeySet();
        }
        return keySet;
    }

    Strength keyStrength() {
        return this.entryHelper.keyStrength();
    }

    final Segment<K, V, E, S>[] newSegmentArray(int n2) {
        return new Segment[n2];
    }

    @Override
    public V put(K k2, V v2) {
        Preconditions.checkNotNull(k2);
        Preconditions.checkNotNull(v2);
        int n2 = this.hash(k2);
        return this.segmentFor(n2).put(k2, n2, v2, false);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> object) {
        for (Map.Entry entry : object.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V putIfAbsent(K k2, V v2) {
        Preconditions.checkNotNull(k2);
        Preconditions.checkNotNull(v2);
        int n2 = this.hash(k2);
        return this.segmentFor(n2).put(k2, n2, v2, true);
    }

    void reclaimKey(E e2) {
        int n2 = e2.getHash();
        this.segmentFor(n2).reclaimKey(e2, n2);
    }

    void reclaimValue(WeakValueReference<K, V, E> weakValueReference) {
        E e2 = weakValueReference.getEntry();
        int n2 = e2.getHash();
        this.segmentFor(n2).reclaimValue(e2.getKey(), n2, weakValueReference);
    }

    @Override
    public V remove(@NullableDecl Object object) {
        if (object == null) {
            return null;
        }
        int n2 = this.hash(object);
        return this.segmentFor(n2).remove(object, n2);
    }

    @Override
    public boolean remove(@NullableDecl Object object, @NullableDecl Object object2) {
        if (object != null && object2 != null) {
            int n2 = this.hash(object);
            return this.segmentFor(n2).remove(object, n2, object2);
        }
        return false;
    }

    @Override
    public V replace(K k2, V v2) {
        Preconditions.checkNotNull(k2);
        Preconditions.checkNotNull(v2);
        int n2 = this.hash(k2);
        return this.segmentFor(n2).replace(k2, n2, v2);
    }

    @Override
    public boolean replace(K k2, @NullableDecl V v2, V v3) {
        Preconditions.checkNotNull(k2);
        Preconditions.checkNotNull(v3);
        if (v2 == null) {
            return false;
        }
        int n2 = this.hash(k2);
        return this.segmentFor(n2).replace(k2, n2, v2, v3);
    }

    Segment<K, V, E, S> segmentFor(int n2) {
        return this.segments[n2 >>> this.segmentShift & this.segmentMask];
    }

    @Override
    public int size() {
        Segment<K, V, E, S>[] segmentArray = this.segments;
        long l2 = 0L;
        for (int i2 = 0; i2 < segmentArray.length; ++i2) {
            l2 += (long)segmentArray[i2].count;
        }
        return Ints.saturatedCast(l2);
    }

    Equivalence<Object> valueEquivalence() {
        return this.entryHelper.valueStrength().defaultEquivalence();
    }

    Strength valueStrength() {
        return this.entryHelper.valueStrength();
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        if (values == null) {
            this.values = values = new Values();
        }
        return values;
    }

    Object writeReplace() {
        return new SerializationProxy(this.entryHelper.keyStrength(), this.entryHelper.valueStrength(), this.keyEquivalence, this.entryHelper.valueStrength().defaultEquivalence(), this.concurrencyLevel, this);
    }

    static abstract class AbstractSerializationProxy<K, V>
    extends ForwardingConcurrentMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 3L;
        final int concurrencyLevel;
        transient ConcurrentMap<K, V> delegate;
        final Equivalence<Object> keyEquivalence;
        final Strength keyStrength;
        final Equivalence<Object> valueEquivalence;
        final Strength valueStrength;

        AbstractSerializationProxy(Strength strength, Strength strength2, Equivalence<Object> equivalence, Equivalence<Object> equivalence2, int n2, ConcurrentMap<K, V> concurrentMap) {
            this.keyStrength = strength;
            this.valueStrength = strength2;
            this.keyEquivalence = equivalence;
            this.valueEquivalence = equivalence2;
            this.concurrencyLevel = n2;
            this.delegate = concurrentMap;
        }

        protected ConcurrentMap<K, V> delegate() {
            return this.delegate;
        }

        void readEntries(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            Object object;
            while ((object = objectInputStream.readObject()) != null) {
                Object object2 = objectInputStream.readObject();
                this.delegate.put(object, object2);
            }
            return;
        }

        MapMaker readMapMaker(ObjectInputStream objectInputStream) throws IOException {
            int n2 = objectInputStream.readInt();
            return new MapMaker().initialCapacity(n2).setKeyStrength(this.keyStrength).setValueStrength(this.valueStrength).keyEquivalence(this.keyEquivalence).concurrencyLevel(this.concurrencyLevel);
        }

        void writeMapTo(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeInt(this.delegate.size());
            for (Map.Entry entry : this.delegate.entrySet()) {
                objectOutputStream.writeObject(entry.getKey());
                objectOutputStream.writeObject(entry.getValue());
            }
            objectOutputStream.writeObject(null);
        }
    }

    static abstract class AbstractStrongKeyEntry<K, V, E extends InternalEntry<K, V, E>>
    implements InternalEntry<K, V, E> {
        final int hash;
        final K key;
        @NullableDecl
        final E next;

        AbstractStrongKeyEntry(K k2, int n2, @NullableDecl E e2) {
            this.key = k2;
            this.hash = n2;
            this.next = e2;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public E getNext() {
            return this.next;
        }
    }

    static abstract class AbstractWeakKeyEntry<K, V, E extends InternalEntry<K, V, E>>
    extends WeakReference<K>
    implements InternalEntry<K, V, E> {
        final int hash;
        @NullableDecl
        final E next;

        AbstractWeakKeyEntry(ReferenceQueue<K> referenceQueue, K k2, int n2, @NullableDecl E e2) {
            super(k2, referenceQueue);
            this.hash = n2;
            this.next = e2;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public K getKey() {
            return (K)this.get();
        }

        @Override
        public E getNext() {
            return this.next;
        }
    }

    static final class CleanupMapTask
    implements Runnable {
        final WeakReference<MapMakerInternalMap<?, ?, ?, ?>> mapReference;

        public CleanupMapTask(MapMakerInternalMap<?, ?, ?, ?> mapMakerInternalMap) {
            this.mapReference = new WeakReference(mapMakerInternalMap);
        }

        @Override
        public void run() {
            Object object = (Segment<K, V, E, S>[])this.mapReference.get();
            if (object != null) {
                object = object.segments;
                int n2 = ((Segment<K, V, E, S>[])object).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    object[i2].runCleanup();
                }
                return;
            }
            object = new CancellationException();
            throw object;
        }
    }

    static final class DummyInternalEntry
    implements InternalEntry<Object, Object, DummyInternalEntry> {
        private DummyInternalEntry() {
            throw new AssertionError();
        }

        @Override
        public int getHash() {
            throw new AssertionError();
        }

        @Override
        public Object getKey() {
            throw new AssertionError();
        }

        @Override
        public DummyInternalEntry getNext() {
            throw new AssertionError();
        }

        @Override
        public Object getValue() {
            throw new AssertionError();
        }
    }

    final class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    final class EntrySet
    extends SafeToArraySet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public void clear() {
            MapMakerInternalMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = object instanceof Map.Entry;
            boolean bl2 = false;
            if (!bl) {
                return false;
            }
            Object object2 = (object = (Map.Entry)object).getKey();
            if (object2 == null) {
                return false;
            }
            object2 = MapMakerInternalMap.this.get(object2);
            bl = bl2;
            if (object2 != null) {
                bl = bl2;
                if (MapMakerInternalMap.this.valueEquivalence().equivalent(object.getValue(), object2)) {
                    bl = true;
                }
            }
            return bl;
        }

        @Override
        public boolean isEmpty() {
            return MapMakerInternalMap.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = object instanceof Map.Entry;
            boolean bl2 = false;
            if (!bl) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            object = entry.getKey();
            bl = bl2;
            if (object != null) {
                bl = bl2;
                if (MapMakerInternalMap.this.remove(object, entry.getValue())) {
                    bl = true;
                }
            }
            return bl;
        }

        @Override
        public int size() {
            return MapMakerInternalMap.this.size();
        }
    }

    abstract class HashIterator<T>
    implements Iterator<T> {
        @MonotonicNonNullDecl
        Segment<K, V, E, S> currentSegment;
        @MonotonicNonNullDecl
        AtomicReferenceArray<E> currentTable;
        @NullableDecl
        WriteThroughEntry lastReturned;
        @NullableDecl
        E nextEntry;
        @NullableDecl
        WriteThroughEntry nextExternal;
        int nextSegmentIndex;
        int nextTableIndex;

        HashIterator() {
            this.nextSegmentIndex = MapMakerInternalMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        final void advance() {
            this.nextExternal = null;
            if (this.nextInChain()) {
                return;
            }
            if (this.nextInTable()) {
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment<K, V, E, S>[] segmentArray = MapMakerInternalMap.this.segments;
                int n2 = this.nextSegmentIndex;
                this.nextSegmentIndex = n2 - 1;
                this.currentSegment = segmentArray[n2];
                if (this.currentSegment.count == 0) continue;
                this.currentTable = this.currentSegment.table;
                this.nextTableIndex = this.currentTable.length() - 1;
                if (!this.nextInTable()) continue;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean advanceTo(E object) {
            try {
                boolean bl;
                Object k2 = object.getKey();
                Object v2 = MapMakerInternalMap.this.getLiveValue(object);
                if (v2 != null) {
                    WriteThroughEntry writeThroughEntry;
                    this.nextExternal = writeThroughEntry = new WriteThroughEntry(k2, v2);
                    bl = true;
                    return bl;
                } else {
                    bl = false;
                }
                return bl;
            }
            finally {
                this.currentSegment.postReadCleanup();
            }
        }

        @Override
        public boolean hasNext() {
            boolean bl = this.nextExternal != null;
            return bl;
        }

        @Override
        public abstract T next();

        WriteThroughEntry nextEntry() {
            WriteThroughEntry writeThroughEntry = this.nextExternal;
            if (writeThroughEntry != null) {
                this.lastReturned = writeThroughEntry;
                this.advance();
                return this.lastReturned;
            }
            throw new NoSuchElementException();
        }

        boolean nextInChain() {
            Object e2 = this.nextEntry;
            if (e2 != null) {
                while ((e2 = (this.nextEntry = e2.getNext())) != null) {
                    if (this.advanceTo(e2)) {
                        return true;
                    }
                    e2 = this.nextEntry;
                }
            }
            return false;
        }

        boolean nextInTable() {
            int n2;
            while ((n2 = this.nextTableIndex) >= 0) {
                Object object = this.currentTable;
                this.nextTableIndex = n2 - 1;
                object = (InternalEntry)((AtomicReferenceArray)object).get(n2);
                this.nextEntry = object;
                if (object == null || !this.advanceTo(this.nextEntry) && !this.nextInChain()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void remove() {
            boolean bl = this.lastReturned != null;
            CollectPreconditions.checkRemove((boolean)bl);
            MapMakerInternalMap.this.remove(this.lastReturned.getKey());
            this.lastReturned = null;
        }
    }

    static interface InternalEntry<K, V, E extends InternalEntry<K, V, E>> {
        public int getHash();

        public K getKey();

        public E getNext();

        public V getValue();
    }

    static interface InternalEntryHelper<K, V, E extends InternalEntry<K, V, E>, S extends Segment<K, V, E, S>> {
        public E copy(S var1, E var2, @NullableDecl E var3);

        public Strength keyStrength();

        public E newEntry(S var1, K var2, int var3, @NullableDecl E var4);

        public S newSegment(MapMakerInternalMap<K, V, E, S> var1, int var2, int var3);

        public void setValue(S var1, E var2, V var3);

        public Strength valueStrength();
    }

    final class KeyIterator
    extends HashIterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    final class KeySet
    extends SafeToArraySet<K> {
        KeySet() {
        }

        @Override
        public void clear() {
            MapMakerInternalMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return MapMakerInternalMap.this.containsKey(object);
        }

        @Override
        public boolean isEmpty() {
            return MapMakerInternalMap.this.isEmpty();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = MapMakerInternalMap.this.remove(object) != null;
            return bl;
        }

        @Override
        public int size() {
            return MapMakerInternalMap.this.size();
        }
    }

    private static abstract class SafeToArraySet<E>
    extends AbstractSet<E> {
        private SafeToArraySet() {
        }

        @Override
        public Object[] toArray() {
            return MapMakerInternalMap.toArrayList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return MapMakerInternalMap.toArrayList(this).toArray(TArray);
        }
    }

    static abstract class Segment<K, V, E extends InternalEntry<K, V, E>, S extends Segment<K, V, E, S>>
    extends ReentrantLock {
        volatile int count;
        final MapMakerInternalMap<K, V, E, S> map;
        final int maxSegmentSize;
        int modCount;
        final AtomicInteger readCount = new AtomicInteger();
        @MonotonicNonNullDecl
        volatile AtomicReferenceArray<E> table;
        int threshold;

        Segment(MapMakerInternalMap<K, V, E, S> mapMakerInternalMap, int n2, int n3) {
            this.map = mapMakerInternalMap;
            this.maxSegmentSize = n3;
            this.initTable(this.newEntryArray(n2));
        }

        static <K, V, E extends InternalEntry<K, V, E>> boolean isCollected(E e2) {
            boolean bl = e2.getValue() == null;
            return bl;
        }

        abstract E castForTesting(InternalEntry<K, V, ?> var1);

        void clear() {
            if (this.count != 0) {
                this.lock();
                AtomicReferenceArray<E> atomicReferenceArray = this.table;
                int n2 = 0;
                while (true) {
                    if (n2 >= atomicReferenceArray.length()) break;
                    atomicReferenceArray.set(n2, null);
                    ++n2;
                    continue;
                    break;
                }
                try {
                    this.maybeClearReferenceQueues();
                    this.readCount.set(0);
                    ++this.modCount;
                    this.count = 0;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.unlock();
                }
            }
        }

        <T> void clearReferenceQueue(ReferenceQueue<T> referenceQueue) {
            while (referenceQueue.poll() != null) {
            }
        }

        boolean clearValueForTesting(K k2, int n2, WeakValueReference<K, V, ? extends InternalEntry<K, V, ?>> weakValueReference) {
            InternalEntry internalEntry;
            int n3;
            AtomicReferenceArray<InternalEntry> atomicReferenceArray;
            this.lock();
            try {
                atomicReferenceArray = this.table;
                n3 = atomicReferenceArray.length() - 1 & n2;
            }
            catch (Throwable throwable) {
                this.unlock();
                throw throwable;
            }
            for (InternalEntry internalEntry2 = internalEntry = (InternalEntry)atomicReferenceArray.get(n3); internalEntry2 != null; internalEntry2 = internalEntry2.getNext()) {
                block6: {
                    block7: {
                        Object k3 = internalEntry2.getKey();
                        if (internalEntry2.getHash() != n2 || k3 == null) break block6;
                        if (!this.map.keyEquivalence.equivalent(k2, k3)) break block6;
                        if (((WeakValueEntry)internalEntry2).getValueReference() != weakValueReference) break block7;
                        atomicReferenceArray.set(n3, this.removeFromChain(internalEntry, internalEntry2));
                        this.unlock();
                        return true;
                    }
                    this.unlock();
                    return false;
                }
                continue;
            }
            this.unlock();
            return false;
        }

        boolean containsKey(Object object, int n2) {
            block4: {
                boolean bl;
                block5: {
                    boolean bl2;
                    try {
                        int n3 = this.count;
                        bl2 = false;
                        if (n3 == 0) break block4;
                    }
                    catch (Throwable throwable) {
                        this.postReadCleanup();
                        throw throwable;
                    }
                    object = this.getLiveEntry(object, n2);
                    bl = bl2;
                    if (object == null) break block5;
                    object = object.getValue();
                    bl = bl2;
                    if (object == null) break block5;
                    bl = true;
                }
                this.postReadCleanup();
                return bl;
            }
            this.postReadCleanup();
            return false;
        }

        /*
         * WARNING - void declaration
         */
        boolean containsValue(Object object) {
            block8: {
                int n2;
                AtomicReferenceArray<E> atomicReferenceArray;
                try {
                    if (this.count == 0) break block8;
                    atomicReferenceArray = this.table;
                    n2 = atomicReferenceArray.length();
                }
                catch (Throwable throwable) {
                    this.postReadCleanup();
                    throw throwable;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    void var5_6;
                    InternalEntry internalEntry = (InternalEntry)atomicReferenceArray.get(i2);
                    while (var5_6 != null) {
                        block9: {
                            V v2 = this.getLiveValue(var5_6);
                            if (v2 == null) break block9;
                            boolean bl = this.map.valueEquivalence().equivalent(object, v2);
                            if (!bl) break block9;
                            this.postReadCleanup();
                            return true;
                        }
                        Object e2 = var5_6.getNext();
                    }
                }
            }
            this.postReadCleanup();
            return false;
        }

        E copyEntry(E e2, E e3) {
            return this.map.entryHelper.copy(this.self(), e2, e3);
        }

        E copyForTesting(InternalEntry<K, V, ?> internalEntry, @NullableDecl InternalEntry<K, V, ?> internalEntry2) {
            return this.map.entryHelper.copy(this.self(), this.castForTesting(internalEntry), this.castForTesting(internalEntry2));
        }

        void drainKeyReferenceQueue(ReferenceQueue<K> referenceQueue) {
            Object object;
            int n2 = 0;
            while ((object = referenceQueue.poll()) != null) {
                int n3;
                object = (InternalEntry)object;
                this.map.reclaimKey(object);
                n2 = n3 = n2 + 1;
                if (n3 != 16) continue;
            }
        }

        void drainValueReferenceQueue(ReferenceQueue<V> referenceQueue) {
            Object object;
            int n2 = 0;
            while ((object = referenceQueue.poll()) != null) {
                int n3;
                object = (WeakValueReference)object;
                this.map.reclaimValue((WeakValueReference<K, V, E>)object);
                n2 = n3 = n2 + 1;
                if (n3 != 16) continue;
            }
        }

        void expand() {
            AtomicReferenceArray<E> atomicReferenceArray = this.table;
            int n2 = atomicReferenceArray.length();
            if (n2 >= 0x40000000) {
                return;
            }
            int n3 = this.count;
            AtomicReferenceArray atomicReferenceArray2 = this.newEntryArray(n2 << 1);
            this.threshold = atomicReferenceArray2.length() * 3 / 4;
            int n4 = atomicReferenceArray2.length() - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                InternalEntry internalEntry = (InternalEntry)atomicReferenceArray.get(i2);
                int n5 = n3;
                if (internalEntry != null) {
                    Object object;
                    n5 = internalEntry.getHash() & n4;
                    if (object == null) {
                        atomicReferenceArray2.set(n5, internalEntry);
                        n5 = n3;
                    } else {
                        InternalEntry internalEntry2 = internalEntry;
                        for (object = internalEntry.getNext(); object != null; object = object.getNext()) {
                            int n6 = object.getHash() & n4;
                            int n7 = n5;
                            if (n6 != n5) {
                                internalEntry2 = object;
                                n7 = n6;
                            }
                            n5 = n7;
                        }
                        atomicReferenceArray2.set(n5, internalEntry2);
                        while (true) {
                            n5 = n3;
                            if (internalEntry == internalEntry2) break;
                            n5 = internalEntry.getHash() & n4;
                            object = this.copyEntry(internalEntry, (InternalEntry)atomicReferenceArray2.get(n5));
                            if (object != null) {
                                atomicReferenceArray2.set(n5, object);
                            } else {
                                --n3;
                            }
                            internalEntry = internalEntry.getNext();
                        }
                    }
                }
                n3 = n5;
            }
            this.table = atomicReferenceArray2;
            this.count = n3;
        }

        V get(Object object, int n2) {
            block6: {
                block5: {
                    object = this.getLiveEntry(object, n2);
                    if (object != null) break block5;
                    this.postReadCleanup();
                    return null;
                }
                object = object.getValue();
                if (object != null) break block6;
                this.tryDrainReferenceQueues();
            }
            return (V)object;
            finally {
                this.postReadCleanup();
            }
        }

        E getEntry(Object object, int n2) {
            if (this.count != 0) {
                for (E e2 = this.getFirst(n2); e2 != null; e2 = e2.getNext()) {
                    if (e2.getHash() != n2) continue;
                    Object k2 = e2.getKey();
                    if (k2 == null) {
                        this.tryDrainReferenceQueues();
                        continue;
                    }
                    if (!this.map.keyEquivalence.equivalent(object, k2)) continue;
                    return e2;
                }
            }
            return null;
        }

        E getFirst(int n2) {
            AtomicReferenceArray<E> atomicReferenceArray = this.table;
            return (E)((InternalEntry)atomicReferenceArray.get(n2 & atomicReferenceArray.length() - 1));
        }

        ReferenceQueue<K> getKeyReferenceQueueForTesting() {
            throw new AssertionError();
        }

        E getLiveEntry(Object object, int n2) {
            return this.getEntry(object, n2);
        }

        @NullableDecl
        V getLiveValue(E object) {
            if (object.getKey() == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            if ((object = object.getValue()) == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            return (V)object;
        }

        @NullableDecl
        V getLiveValueForTesting(InternalEntry<K, V, ?> internalEntry) {
            return this.getLiveValue(this.castForTesting(internalEntry));
        }

        ReferenceQueue<V> getValueReferenceQueueForTesting() {
            throw new AssertionError();
        }

        WeakValueReference<K, V, E> getWeakValueReferenceForTesting(InternalEntry<K, V, ?> internalEntry) {
            throw new AssertionError();
        }

        void initTable(AtomicReferenceArray<E> atomicReferenceArray) {
            this.threshold = atomicReferenceArray.length() * 3 / 4;
            int n2 = this.threshold;
            if (n2 == this.maxSegmentSize) {
                this.threshold = n2 + 1;
            }
            this.table = atomicReferenceArray;
        }

        void maybeClearReferenceQueues() {
        }

        void maybeDrainReferenceQueues() {
        }

        AtomicReferenceArray<E> newEntryArray(int n2) {
            return new AtomicReferenceArray(n2);
        }

        E newEntryForTesting(K k2, int n2, @NullableDecl InternalEntry<K, V, ?> internalEntry) {
            return this.map.entryHelper.newEntry(this.self(), k2, n2, this.castForTesting(internalEntry));
        }

        WeakValueReference<K, V, E> newWeakValueReferenceForTesting(InternalEntry<K, V, ?> internalEntry, V v2) {
            throw new AssertionError();
        }

        void postReadCleanup() {
            if ((this.readCount.incrementAndGet() & 0x3F) == 0) {
                this.runCleanup();
            }
        }

        void preWriteCleanup() {
            this.runLockedCleanup();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        V put(K object, int n2, V v2, boolean bl) {
            this.lock();
            try {
                int n3;
                this.preWriteCleanup();
                int n4 = n3 = this.count + 1;
                if (n3 > this.threshold) {
                    this.expand();
                    n4 = this.count + 1;
                }
                AtomicReferenceArray<K> atomicReferenceArray = this.table;
                n3 = atomicReferenceArray.length() - 1 & n2;
                InternalEntry internalEntry = (InternalEntry)atomicReferenceArray.get(n3);
                for (InternalEntry internalEntry2 = internalEntry; internalEntry2 != null; internalEntry2 = internalEntry2.getNext()) {
                    Object k2 = internalEntry2.getKey();
                    if (internalEntry2.getHash() != n2 || k2 == null || !this.map.keyEquivalence.equivalent(object, k2)) continue;
                    object = internalEntry2.getValue();
                    if (object == null) {
                        ++this.modCount;
                        this.setValue(internalEntry2, v2);
                        this.count = this.count;
                        return null;
                    }
                    if (bl) {
                        return (V)object;
                    }
                    ++this.modCount;
                    this.setValue(internalEntry2, v2);
                    return (V)object;
                }
                ++this.modCount;
                object = this.map.entryHelper.newEntry(this.self(), object, n2, internalEntry);
                this.setValue(object, v2);
                atomicReferenceArray.set(n3, object);
                this.count = n4;
                return null;
            }
            finally {
                this.unlock();
            }
        }

        boolean reclaimKey(E object, int n2) {
            InternalEntry internalEntry;
            AtomicReferenceArray<E> atomicReferenceArray;
            int n3;
            this.lock();
            try {
                n3 = this.count;
                atomicReferenceArray = this.table;
            }
            catch (Throwable throwable) {
                this.unlock();
                throw throwable;
            }
            for (InternalEntry internalEntry2 = internalEntry = (InternalEntry)atomicReferenceArray.get(n2 &= atomicReferenceArray.length() - 1); internalEntry2 != null; internalEntry2 = internalEntry2.getNext()) {
                if (internalEntry2 == object) {
                    ++this.modCount;
                    object = this.removeFromChain(internalEntry, internalEntry2);
                    n3 = this.count;
                    atomicReferenceArray.set(n2, object);
                    this.count = n3 - 1;
                    this.unlock();
                    return true;
                }
                continue;
            }
            this.unlock();
            return false;
        }

        boolean reclaimValue(K object, int n2, WeakValueReference<K, V, E> weakValueReference) {
            InternalEntry internalEntry;
            AtomicReferenceArray<K> atomicReferenceArray;
            int n3;
            this.lock();
            try {
                n3 = this.count;
                atomicReferenceArray = this.table;
                n3 = atomicReferenceArray.length() - 1 & n2;
            }
            catch (Throwable throwable) {
                this.unlock();
                throw throwable;
            }
            for (InternalEntry internalEntry2 = internalEntry = (InternalEntry)atomicReferenceArray.get(n3); internalEntry2 != null; internalEntry2 = internalEntry2.getNext()) {
                block6: {
                    block7: {
                        Object k2 = internalEntry2.getKey();
                        if (internalEntry2.getHash() != n2 || k2 == null) break block6;
                        if (!this.map.keyEquivalence.equivalent(object, k2)) break block6;
                        if (((WeakValueEntry)internalEntry2).getValueReference() != weakValueReference) break block7;
                        ++this.modCount;
                        object = this.removeFromChain(internalEntry, internalEntry2);
                        n2 = this.count;
                        atomicReferenceArray.set(n3, object);
                        this.count = n2 - 1;
                        this.unlock();
                        return true;
                    }
                    this.unlock();
                    return false;
                }
                continue;
            }
            this.unlock();
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        V remove(Object object, int n2) {
            this.lock();
            try {
                this.preWriteCleanup();
                int n3 = this.count;
                AtomicReferenceArray atomicReferenceArray = this.table;
                n3 = atomicReferenceArray.length() - 1 & n2;
                InternalEntry internalEntry = (InternalEntry)atomicReferenceArray.get(n3);
                for (InternalEntry internalEntry2 = internalEntry; internalEntry2 != null; internalEntry2 = internalEntry2.getNext()) {
                    Object k2 = internalEntry2.getKey();
                    if (internalEntry2.getHash() != n2 || k2 == null || !this.map.keyEquivalence.equivalent(object, k2)) continue;
                    object = internalEntry2.getValue();
                    if (object != null || Segment.isCollected(internalEntry2)) {
                        ++this.modCount;
                        internalEntry2 = this.removeFromChain(internalEntry, internalEntry2);
                        n2 = this.count;
                        atomicReferenceArray.set(n3, internalEntry2);
                        this.count = n2 - 1;
                        return (V)object;
                    }
                    return null;
                }
                return null;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean remove(Object internalEntry, int n2, Object object) {
            this.lock();
            try {
                this.preWriteCleanup();
                int n3 = this.count;
                AtomicReferenceArray atomicReferenceArray = this.table;
                n3 = atomicReferenceArray.length() - 1 & n2;
                InternalEntry internalEntry2 = (InternalEntry)atomicReferenceArray.get(n3);
                InternalEntry internalEntry3 = internalEntry2;
                while (true) {
                    block7: {
                        block10: {
                            boolean bl;
                            block9: {
                                block8: {
                                    bl = false;
                                    if (internalEntry3 == null) break;
                                    Object k2 = internalEntry3.getKey();
                                    if (internalEntry3.getHash() != n2 || k2 == null || !this.map.keyEquivalence.equivalent(internalEntry, k2)) break block7;
                                    internalEntry = internalEntry3.getValue();
                                    if (!this.map.valueEquivalence().equivalent(object, internalEntry)) break block8;
                                    bl = true;
                                    break block9;
                                }
                                if (!Segment.isCollected(internalEntry3)) break block10;
                            }
                            ++this.modCount;
                            internalEntry = this.removeFromChain(internalEntry2, internalEntry3);
                            n2 = this.count;
                            atomicReferenceArray.set(n3, internalEntry);
                            this.count = n2 - 1;
                            return bl;
                        }
                        return false;
                    }
                    internalEntry3 = internalEntry3.getNext();
                }
                return false;
            }
            finally {
                this.unlock();
            }
        }

        boolean removeEntryForTesting(E object) {
            InternalEntry internalEntry;
            int n2 = object.getHash();
            int n3 = this.count;
            AtomicReferenceArray<E> atomicReferenceArray = this.table;
            n3 = n2 & atomicReferenceArray.length() - 1;
            for (InternalEntry internalEntry2 = internalEntry = (InternalEntry)atomicReferenceArray.get(n3); internalEntry2 != null; internalEntry2 = internalEntry2.getNext()) {
                if (internalEntry2 != object) continue;
                ++this.modCount;
                object = this.removeFromChain(internalEntry, internalEntry2);
                n2 = this.count;
                atomicReferenceArray.set(n3, object);
                this.count = n2 - 1;
                return true;
            }
            return false;
        }

        E removeFromChain(E e2, E e3) {
            int n2 = this.count;
            Object e4 = e3.getNext();
            while (e2 != e3) {
                E e5 = this.copyEntry(e2, e4);
                if (e5 != null) {
                    e4 = e5;
                } else {
                    --n2;
                }
                e2 = e2.getNext();
            }
            this.count = n2;
            return e4;
        }

        E removeFromChainForTesting(InternalEntry<K, V, ?> internalEntry, InternalEntry<K, V, ?> internalEntry2) {
            return this.removeFromChain(this.castForTesting(internalEntry), this.castForTesting(internalEntry2));
        }

        boolean removeTableEntryForTesting(InternalEntry<K, V, ?> internalEntry) {
            return this.removeEntryForTesting(this.castForTesting(internalEntry));
        }

        V replace(K object, int n2, V v2) {
            InternalEntry internalEntry;
            int n3;
            AtomicReferenceArray<K> atomicReferenceArray;
            this.lock();
            try {
                this.preWriteCleanup();
                atomicReferenceArray = this.table;
                n3 = atomicReferenceArray.length() - 1 & n2;
                internalEntry = (InternalEntry)atomicReferenceArray.get(n3);
            }
            catch (Throwable throwable) {
                this.unlock();
                throw throwable;
            }
            for (InternalEntry internalEntry2 = internalEntry; internalEntry2 != null; internalEntry2 = internalEntry2.getNext()) {
                block8: {
                    block9: {
                        block10: {
                            Object k2 = internalEntry2.getKey();
                            if (internalEntry2.getHash() != n2 || k2 == null) break block8;
                            if (!this.map.keyEquivalence.equivalent(object, k2)) break block8;
                            object = internalEntry2.getValue();
                            if (object != null) break block9;
                            if (!Segment.isCollected(internalEntry2)) break block10;
                            n2 = this.count;
                            ++this.modCount;
                            object = this.removeFromChain(internalEntry, internalEntry2);
                            n2 = this.count;
                            atomicReferenceArray.set(n3, object);
                            this.count = n2 - 1;
                        }
                        this.unlock();
                        return null;
                    }
                    ++this.modCount;
                    this.setValue(internalEntry2, v2);
                    this.unlock();
                    return (V)object;
                }
                continue;
            }
            this.unlock();
            return null;
        }

        boolean replace(K object, int n2, V v2, V v3) {
            InternalEntry internalEntry;
            int n3;
            AtomicReferenceArray<K> atomicReferenceArray;
            this.lock();
            try {
                this.preWriteCleanup();
                atomicReferenceArray = this.table;
                n3 = atomicReferenceArray.length() - 1 & n2;
                internalEntry = (InternalEntry)atomicReferenceArray.get(n3);
            }
            catch (Throwable throwable) {
                this.unlock();
                throw throwable;
            }
            for (InternalEntry internalEntry2 = internalEntry; internalEntry2 != null; internalEntry2 = internalEntry2.getNext()) {
                block8: {
                    block11: {
                        block9: {
                            block10: {
                                Object k2 = internalEntry2.getKey();
                                if (internalEntry2.getHash() != n2 || k2 == null) break block8;
                                if (!this.map.keyEquivalence.equivalent(object, k2)) break block8;
                                object = internalEntry2.getValue();
                                if (object != null) break block9;
                                if (!Segment.isCollected(internalEntry2)) break block10;
                                n2 = this.count;
                                ++this.modCount;
                                object = this.removeFromChain(internalEntry, internalEntry2);
                                n2 = this.count;
                                atomicReferenceArray.set(n3, object);
                                this.count = n2 - 1;
                            }
                            this.unlock();
                            return false;
                        }
                        if (!this.map.valueEquivalence().equivalent(v2, object)) break block11;
                        ++this.modCount;
                        this.setValue(internalEntry2, v3);
                        this.unlock();
                        return true;
                    }
                    this.unlock();
                    return false;
                }
                continue;
            }
            this.unlock();
            return false;
        }

        void runCleanup() {
            this.runLockedCleanup();
        }

        void runLockedCleanup() {
            if (this.tryLock()) {
                try {
                    this.maybeDrainReferenceQueues();
                    this.readCount.set(0);
                }
                finally {
                    this.unlock();
                }
            }
        }

        abstract S self();

        void setTableEntryForTesting(int n2, InternalEntry<K, V, ?> internalEntry) {
            this.table.set(n2, this.castForTesting(internalEntry));
        }

        void setValue(E e2, V v2) {
            this.map.entryHelper.setValue(this.self(), e2, v2);
        }

        void setValueForTesting(InternalEntry<K, V, ?> internalEntry, V v2) {
            this.map.entryHelper.setValue(this.self(), this.castForTesting(internalEntry), v2);
        }

        void setWeakValueReferenceForTesting(InternalEntry<K, V, ?> internalEntry, WeakValueReference<K, V, ? extends InternalEntry<K, V, ?>> weakValueReference) {
            throw new AssertionError();
        }

        void tryDrainReferenceQueues() {
            if (this.tryLock()) {
                try {
                    this.maybeDrainReferenceQueues();
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    private static final class SerializationProxy<K, V>
    extends AbstractSerializationProxy<K, V> {
        private static final long serialVersionUID = 3L;

        SerializationProxy(Strength strength, Strength strength2, Equivalence<Object> equivalence, Equivalence<Object> equivalence2, int n2, ConcurrentMap<K, V> concurrentMap) {
            super(strength, strength2, equivalence, equivalence2, n2, concurrentMap);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.delegate = this.readMapMaker(objectInputStream).makeMap();
            this.readEntries(objectInputStream);
        }

        private Object readResolve() {
            return this.delegate;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            this.writeMapTo(objectOutputStream);
        }
    }

    static enum Strength {
        STRONG{

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalence.equals();
            }
        }
        ,
        WEAK{

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalence.identity();
            }
        };


        abstract Equivalence<Object> defaultEquivalence();
    }

    static final class StrongKeyDummyValueEntry<K>
    extends AbstractStrongKeyEntry<K, MapMaker.Dummy, StrongKeyDummyValueEntry<K>>
    implements StrongValueEntry<K, MapMaker.Dummy, StrongKeyDummyValueEntry<K>> {
        StrongKeyDummyValueEntry(K k2, int n2, @NullableDecl StrongKeyDummyValueEntry<K> strongKeyDummyValueEntry) {
            super(k2, n2, strongKeyDummyValueEntry);
        }

        StrongKeyDummyValueEntry<K> copy(StrongKeyDummyValueEntry<K> strongKeyDummyValueEntry) {
            return new StrongKeyDummyValueEntry<Object>(this.key, this.hash, strongKeyDummyValueEntry);
        }

        @Override
        public MapMaker.Dummy getValue() {
            return MapMaker.Dummy.VALUE;
        }

        void setValue(MapMaker.Dummy dummy) {
        }

        static final class Helper<K>
        implements InternalEntryHelper<K, MapMaker.Dummy, StrongKeyDummyValueEntry<K>, StrongKeyDummyValueSegment<K>> {
            private static final Helper<?> INSTANCE = new Helper();

            Helper() {
            }

            static <K> Helper<K> instance() {
                return INSTANCE;
            }

            @Override
            public StrongKeyDummyValueEntry<K> copy(StrongKeyDummyValueSegment<K> strongKeyDummyValueSegment, StrongKeyDummyValueEntry<K> strongKeyDummyValueEntry, @NullableDecl StrongKeyDummyValueEntry<K> strongKeyDummyValueEntry2) {
                return strongKeyDummyValueEntry.copy(strongKeyDummyValueEntry2);
            }

            @Override
            public Strength keyStrength() {
                return Strength.STRONG;
            }

            @Override
            public StrongKeyDummyValueEntry<K> newEntry(StrongKeyDummyValueSegment<K> strongKeyDummyValueSegment, K k2, int n2, @NullableDecl StrongKeyDummyValueEntry<K> strongKeyDummyValueEntry) {
                return new StrongKeyDummyValueEntry<K>(k2, n2, strongKeyDummyValueEntry);
            }

            @Override
            public StrongKeyDummyValueSegment<K> newSegment(MapMakerInternalMap<K, MapMaker.Dummy, StrongKeyDummyValueEntry<K>, StrongKeyDummyValueSegment<K>> mapMakerInternalMap, int n2, int n3) {
                return new StrongKeyDummyValueSegment<K>(mapMakerInternalMap, n2, n3);
            }

            @Override
            public void setValue(StrongKeyDummyValueSegment<K> strongKeyDummyValueSegment, StrongKeyDummyValueEntry<K> strongKeyDummyValueEntry, MapMaker.Dummy dummy) {
            }

            @Override
            public Strength valueStrength() {
                return Strength.STRONG;
            }
        }
    }

    static final class StrongKeyDummyValueSegment<K>
    extends Segment<K, MapMaker.Dummy, StrongKeyDummyValueEntry<K>, StrongKeyDummyValueSegment<K>> {
        StrongKeyDummyValueSegment(MapMakerInternalMap<K, MapMaker.Dummy, StrongKeyDummyValueEntry<K>, StrongKeyDummyValueSegment<K>> mapMakerInternalMap, int n2, int n3) {
            super(mapMakerInternalMap, n2, n3);
        }

        @Override
        public StrongKeyDummyValueEntry<K> castForTesting(InternalEntry<K, MapMaker.Dummy, ?> internalEntry) {
            return (StrongKeyDummyValueEntry)internalEntry;
        }

        @Override
        StrongKeyDummyValueSegment<K> self() {
            return this;
        }
    }

    static final class StrongKeyStrongValueEntry<K, V>
    extends AbstractStrongKeyEntry<K, V, StrongKeyStrongValueEntry<K, V>>
    implements StrongValueEntry<K, V, StrongKeyStrongValueEntry<K, V>> {
        @NullableDecl
        private volatile V value = null;

        StrongKeyStrongValueEntry(K k2, int n2, @NullableDecl StrongKeyStrongValueEntry<K, V> strongKeyStrongValueEntry) {
            super(k2, n2, strongKeyStrongValueEntry);
        }

        StrongKeyStrongValueEntry<K, V> copy(StrongKeyStrongValueEntry<K, V> strongKeyStrongValueEntry) {
            strongKeyStrongValueEntry = new StrongKeyStrongValueEntry<Object, V>(this.key, this.hash, strongKeyStrongValueEntry);
            strongKeyStrongValueEntry.value = this.value;
            return strongKeyStrongValueEntry;
        }

        @Override
        @NullableDecl
        public V getValue() {
            return this.value;
        }

        void setValue(V v2) {
            this.value = v2;
        }

        static final class Helper<K, V>
        implements InternalEntryHelper<K, V, StrongKeyStrongValueEntry<K, V>, StrongKeyStrongValueSegment<K, V>> {
            private static final Helper<?, ?> INSTANCE = new Helper();

            Helper() {
            }

            static <K, V> Helper<K, V> instance() {
                return INSTANCE;
            }

            @Override
            public StrongKeyStrongValueEntry<K, V> copy(StrongKeyStrongValueSegment<K, V> strongKeyStrongValueSegment, StrongKeyStrongValueEntry<K, V> strongKeyStrongValueEntry, @NullableDecl StrongKeyStrongValueEntry<K, V> strongKeyStrongValueEntry2) {
                return strongKeyStrongValueEntry.copy(strongKeyStrongValueEntry2);
            }

            @Override
            public Strength keyStrength() {
                return Strength.STRONG;
            }

            @Override
            public StrongKeyStrongValueEntry<K, V> newEntry(StrongKeyStrongValueSegment<K, V> strongKeyStrongValueSegment, K k2, int n2, @NullableDecl StrongKeyStrongValueEntry<K, V> strongKeyStrongValueEntry) {
                return new StrongKeyStrongValueEntry<K, V>(k2, n2, strongKeyStrongValueEntry);
            }

            @Override
            public StrongKeyStrongValueSegment<K, V> newSegment(MapMakerInternalMap<K, V, StrongKeyStrongValueEntry<K, V>, StrongKeyStrongValueSegment<K, V>> mapMakerInternalMap, int n2, int n3) {
                return new StrongKeyStrongValueSegment<K, V>(mapMakerInternalMap, n2, n3);
            }

            @Override
            public void setValue(StrongKeyStrongValueSegment<K, V> strongKeyStrongValueSegment, StrongKeyStrongValueEntry<K, V> strongKeyStrongValueEntry, V v2) {
                strongKeyStrongValueEntry.setValue(v2);
            }

            @Override
            public Strength valueStrength() {
                return Strength.STRONG;
            }
        }
    }

    static final class StrongKeyStrongValueSegment<K, V>
    extends Segment<K, V, StrongKeyStrongValueEntry<K, V>, StrongKeyStrongValueSegment<K, V>> {
        StrongKeyStrongValueSegment(MapMakerInternalMap<K, V, StrongKeyStrongValueEntry<K, V>, StrongKeyStrongValueSegment<K, V>> mapMakerInternalMap, int n2, int n3) {
            super(mapMakerInternalMap, n2, n3);
        }

        @Override
        public StrongKeyStrongValueEntry<K, V> castForTesting(InternalEntry<K, V, ?> internalEntry) {
            return (StrongKeyStrongValueEntry)internalEntry;
        }

        @Override
        StrongKeyStrongValueSegment<K, V> self() {
            return this;
        }
    }

    static final class StrongKeyWeakValueEntry<K, V>
    extends AbstractStrongKeyEntry<K, V, StrongKeyWeakValueEntry<K, V>>
    implements WeakValueEntry<K, V, StrongKeyWeakValueEntry<K, V>> {
        private volatile WeakValueReference<K, V, StrongKeyWeakValueEntry<K, V>> valueReference = MapMakerInternalMap.unsetWeakValueReference();

        StrongKeyWeakValueEntry(K k2, int n2, @NullableDecl StrongKeyWeakValueEntry<K, V> strongKeyWeakValueEntry) {
            super(k2, n2, strongKeyWeakValueEntry);
        }

        static /* synthetic */ WeakValueReference access$602(StrongKeyWeakValueEntry strongKeyWeakValueEntry, WeakValueReference weakValueReference) {
            strongKeyWeakValueEntry.valueReference = weakValueReference;
            return weakValueReference;
        }

        @Override
        public void clearValue() {
            this.valueReference.clear();
        }

        StrongKeyWeakValueEntry<K, V> copy(ReferenceQueue<V> referenceQueue, StrongKeyWeakValueEntry<K, V> strongKeyWeakValueEntry) {
            strongKeyWeakValueEntry = new StrongKeyWeakValueEntry<Object, V>(this.key, this.hash, strongKeyWeakValueEntry);
            strongKeyWeakValueEntry.valueReference = this.valueReference.copyFor(referenceQueue, strongKeyWeakValueEntry);
            return strongKeyWeakValueEntry;
        }

        @Override
        public V getValue() {
            return this.valueReference.get();
        }

        @Override
        public WeakValueReference<K, V, StrongKeyWeakValueEntry<K, V>> getValueReference() {
            return this.valueReference;
        }

        void setValue(V v2, ReferenceQueue<V> referenceQueue) {
            WeakValueReference<K, V, StrongKeyWeakValueEntry<K, V>> weakValueReference = this.valueReference;
            this.valueReference = new WeakValueReferenceImpl(referenceQueue, v2, this);
            weakValueReference.clear();
        }

        static final class Helper<K, V>
        implements InternalEntryHelper<K, V, StrongKeyWeakValueEntry<K, V>, StrongKeyWeakValueSegment<K, V>> {
            private static final Helper<?, ?> INSTANCE = new Helper();

            Helper() {
            }

            static <K, V> Helper<K, V> instance() {
                return INSTANCE;
            }

            @Override
            public StrongKeyWeakValueEntry<K, V> copy(StrongKeyWeakValueSegment<K, V> strongKeyWeakValueSegment, StrongKeyWeakValueEntry<K, V> strongKeyWeakValueEntry, @NullableDecl StrongKeyWeakValueEntry<K, V> strongKeyWeakValueEntry2) {
                if (Segment.isCollected(strongKeyWeakValueEntry)) {
                    return null;
                }
                return strongKeyWeakValueEntry.copy(((StrongKeyWeakValueSegment)strongKeyWeakValueSegment).queueForValues, strongKeyWeakValueEntry2);
            }

            @Override
            public Strength keyStrength() {
                return Strength.STRONG;
            }

            @Override
            public StrongKeyWeakValueEntry<K, V> newEntry(StrongKeyWeakValueSegment<K, V> strongKeyWeakValueSegment, K k2, int n2, @NullableDecl StrongKeyWeakValueEntry<K, V> strongKeyWeakValueEntry) {
                return new StrongKeyWeakValueEntry<K, V>(k2, n2, strongKeyWeakValueEntry);
            }

            @Override
            public StrongKeyWeakValueSegment<K, V> newSegment(MapMakerInternalMap<K, V, StrongKeyWeakValueEntry<K, V>, StrongKeyWeakValueSegment<K, V>> mapMakerInternalMap, int n2, int n3) {
                return new StrongKeyWeakValueSegment<K, V>(mapMakerInternalMap, n2, n3);
            }

            @Override
            public void setValue(StrongKeyWeakValueSegment<K, V> strongKeyWeakValueSegment, StrongKeyWeakValueEntry<K, V> strongKeyWeakValueEntry, V v2) {
                strongKeyWeakValueEntry.setValue(v2, ((StrongKeyWeakValueSegment)strongKeyWeakValueSegment).queueForValues);
            }

            @Override
            public Strength valueStrength() {
                return Strength.WEAK;
            }
        }
    }

    static final class StrongKeyWeakValueSegment<K, V>
    extends Segment<K, V, StrongKeyWeakValueEntry<K, V>, StrongKeyWeakValueSegment<K, V>> {
        private final ReferenceQueue<V> queueForValues = new ReferenceQueue();

        StrongKeyWeakValueSegment(MapMakerInternalMap<K, V, StrongKeyWeakValueEntry<K, V>, StrongKeyWeakValueSegment<K, V>> mapMakerInternalMap, int n2, int n3) {
            super(mapMakerInternalMap, n2, n3);
        }

        @Override
        public StrongKeyWeakValueEntry<K, V> castForTesting(InternalEntry<K, V, ?> internalEntry) {
            return (StrongKeyWeakValueEntry)internalEntry;
        }

        @Override
        ReferenceQueue<V> getValueReferenceQueueForTesting() {
            return this.queueForValues;
        }

        @Override
        public WeakValueReference<K, V, StrongKeyWeakValueEntry<K, V>> getWeakValueReferenceForTesting(InternalEntry<K, V, ?> internalEntry) {
            return ((StrongKeyWeakValueEntry)this.castForTesting((InternalEntry)internalEntry)).getValueReference();
        }

        @Override
        void maybeClearReferenceQueues() {
            this.clearReferenceQueue(this.queueForValues);
        }

        @Override
        void maybeDrainReferenceQueues() {
            this.drainValueReferenceQueue(this.queueForValues);
        }

        @Override
        public WeakValueReference<K, V, StrongKeyWeakValueEntry<K, V>> newWeakValueReferenceForTesting(InternalEntry<K, V, ?> internalEntry, V v2) {
            return new WeakValueReferenceImpl(this.queueForValues, v2, this.castForTesting((InternalEntry)internalEntry));
        }

        @Override
        StrongKeyWeakValueSegment<K, V> self() {
            return this;
        }

        @Override
        public void setWeakValueReferenceForTesting(InternalEntry<K, V, ?> internalEntry, WeakValueReference<K, V, ? extends InternalEntry<K, V, ?>> weakValueReference) {
            internalEntry = this.castForTesting(internalEntry);
            WeakValueReference weakValueReference2 = ((StrongKeyWeakValueEntry)internalEntry).valueReference;
            StrongKeyWeakValueEntry.access$602((StrongKeyWeakValueEntry)internalEntry, weakValueReference);
            weakValueReference2.clear();
        }
    }

    static interface StrongValueEntry<K, V, E extends InternalEntry<K, V, E>>
    extends InternalEntry<K, V, E> {
    }

    final class ValueIterator
    extends HashIterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public void clear() {
            MapMakerInternalMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return MapMakerInternalMap.this.containsValue(object);
        }

        @Override
        public boolean isEmpty() {
            return MapMakerInternalMap.this.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return MapMakerInternalMap.this.size();
        }

        @Override
        public Object[] toArray() {
            return MapMakerInternalMap.toArrayList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return MapMakerInternalMap.toArrayList(this).toArray(TArray);
        }
    }

    static final class WeakKeyDummyValueEntry<K>
    extends AbstractWeakKeyEntry<K, MapMaker.Dummy, WeakKeyDummyValueEntry<K>>
    implements StrongValueEntry<K, MapMaker.Dummy, WeakKeyDummyValueEntry<K>> {
        WeakKeyDummyValueEntry(ReferenceQueue<K> referenceQueue, K k2, int n2, @NullableDecl WeakKeyDummyValueEntry<K> weakKeyDummyValueEntry) {
            super(referenceQueue, k2, n2, weakKeyDummyValueEntry);
        }

        WeakKeyDummyValueEntry<K> copy(ReferenceQueue<K> referenceQueue, WeakKeyDummyValueEntry<K> weakKeyDummyValueEntry) {
            return new WeakKeyDummyValueEntry<K>(referenceQueue, this.getKey(), this.hash, weakKeyDummyValueEntry);
        }

        @Override
        public MapMaker.Dummy getValue() {
            return MapMaker.Dummy.VALUE;
        }

        void setValue(MapMaker.Dummy dummy) {
        }

        static final class Helper<K>
        implements InternalEntryHelper<K, MapMaker.Dummy, WeakKeyDummyValueEntry<K>, WeakKeyDummyValueSegment<K>> {
            private static final Helper<?> INSTANCE = new Helper();

            Helper() {
            }

            static <K> Helper<K> instance() {
                return INSTANCE;
            }

            @Override
            public WeakKeyDummyValueEntry<K> copy(WeakKeyDummyValueSegment<K> weakKeyDummyValueSegment, WeakKeyDummyValueEntry<K> weakKeyDummyValueEntry, @NullableDecl WeakKeyDummyValueEntry<K> weakKeyDummyValueEntry2) {
                if (weakKeyDummyValueEntry.getKey() == null) {
                    return null;
                }
                return weakKeyDummyValueEntry.copy(((WeakKeyDummyValueSegment)weakKeyDummyValueSegment).queueForKeys, weakKeyDummyValueEntry2);
            }

            @Override
            public Strength keyStrength() {
                return Strength.WEAK;
            }

            @Override
            public WeakKeyDummyValueEntry<K> newEntry(WeakKeyDummyValueSegment<K> weakKeyDummyValueSegment, K k2, int n2, @NullableDecl WeakKeyDummyValueEntry<K> weakKeyDummyValueEntry) {
                return new WeakKeyDummyValueEntry<K>(((WeakKeyDummyValueSegment)weakKeyDummyValueSegment).queueForKeys, k2, n2, weakKeyDummyValueEntry);
            }

            @Override
            public WeakKeyDummyValueSegment<K> newSegment(MapMakerInternalMap<K, MapMaker.Dummy, WeakKeyDummyValueEntry<K>, WeakKeyDummyValueSegment<K>> mapMakerInternalMap, int n2, int n3) {
                return new WeakKeyDummyValueSegment<K>(mapMakerInternalMap, n2, n3);
            }

            @Override
            public void setValue(WeakKeyDummyValueSegment<K> weakKeyDummyValueSegment, WeakKeyDummyValueEntry<K> weakKeyDummyValueEntry, MapMaker.Dummy dummy) {
            }

            @Override
            public Strength valueStrength() {
                return Strength.STRONG;
            }
        }
    }

    static final class WeakKeyDummyValueSegment<K>
    extends Segment<K, MapMaker.Dummy, WeakKeyDummyValueEntry<K>, WeakKeyDummyValueSegment<K>> {
        private final ReferenceQueue<K> queueForKeys = new ReferenceQueue();

        WeakKeyDummyValueSegment(MapMakerInternalMap<K, MapMaker.Dummy, WeakKeyDummyValueEntry<K>, WeakKeyDummyValueSegment<K>> mapMakerInternalMap, int n2, int n3) {
            super(mapMakerInternalMap, n2, n3);
        }

        @Override
        public WeakKeyDummyValueEntry<K> castForTesting(InternalEntry<K, MapMaker.Dummy, ?> internalEntry) {
            return (WeakKeyDummyValueEntry)internalEntry;
        }

        @Override
        ReferenceQueue<K> getKeyReferenceQueueForTesting() {
            return this.queueForKeys;
        }

        @Override
        void maybeClearReferenceQueues() {
            this.clearReferenceQueue(this.queueForKeys);
        }

        @Override
        void maybeDrainReferenceQueues() {
            this.drainKeyReferenceQueue(this.queueForKeys);
        }

        @Override
        WeakKeyDummyValueSegment<K> self() {
            return this;
        }
    }

    static final class WeakKeyStrongValueEntry<K, V>
    extends AbstractWeakKeyEntry<K, V, WeakKeyStrongValueEntry<K, V>>
    implements StrongValueEntry<K, V, WeakKeyStrongValueEntry<K, V>> {
        @NullableDecl
        private volatile V value = null;

        WeakKeyStrongValueEntry(ReferenceQueue<K> referenceQueue, K k2, int n2, @NullableDecl WeakKeyStrongValueEntry<K, V> weakKeyStrongValueEntry) {
            super(referenceQueue, k2, n2, weakKeyStrongValueEntry);
        }

        WeakKeyStrongValueEntry<K, V> copy(ReferenceQueue<K> object, WeakKeyStrongValueEntry<K, V> weakKeyStrongValueEntry) {
            object = new WeakKeyStrongValueEntry<K, V>(object, this.getKey(), this.hash, weakKeyStrongValueEntry);
            ((WeakKeyStrongValueEntry)object).setValue(this.value);
            return object;
        }

        @Override
        @NullableDecl
        public V getValue() {
            return this.value;
        }

        void setValue(V v2) {
            this.value = v2;
        }

        static final class Helper<K, V>
        implements InternalEntryHelper<K, V, WeakKeyStrongValueEntry<K, V>, WeakKeyStrongValueSegment<K, V>> {
            private static final Helper<?, ?> INSTANCE = new Helper();

            Helper() {
            }

            static <K, V> Helper<K, V> instance() {
                return INSTANCE;
            }

            @Override
            public WeakKeyStrongValueEntry<K, V> copy(WeakKeyStrongValueSegment<K, V> weakKeyStrongValueSegment, WeakKeyStrongValueEntry<K, V> weakKeyStrongValueEntry, @NullableDecl WeakKeyStrongValueEntry<K, V> weakKeyStrongValueEntry2) {
                if (weakKeyStrongValueEntry.getKey() == null) {
                    return null;
                }
                return weakKeyStrongValueEntry.copy(((WeakKeyStrongValueSegment)weakKeyStrongValueSegment).queueForKeys, weakKeyStrongValueEntry2);
            }

            @Override
            public Strength keyStrength() {
                return Strength.WEAK;
            }

            @Override
            public WeakKeyStrongValueEntry<K, V> newEntry(WeakKeyStrongValueSegment<K, V> weakKeyStrongValueSegment, K k2, int n2, @NullableDecl WeakKeyStrongValueEntry<K, V> weakKeyStrongValueEntry) {
                return new WeakKeyStrongValueEntry<K, V>(((WeakKeyStrongValueSegment)weakKeyStrongValueSegment).queueForKeys, k2, n2, weakKeyStrongValueEntry);
            }

            @Override
            public WeakKeyStrongValueSegment<K, V> newSegment(MapMakerInternalMap<K, V, WeakKeyStrongValueEntry<K, V>, WeakKeyStrongValueSegment<K, V>> mapMakerInternalMap, int n2, int n3) {
                return new WeakKeyStrongValueSegment<K, V>(mapMakerInternalMap, n2, n3);
            }

            @Override
            public void setValue(WeakKeyStrongValueSegment<K, V> weakKeyStrongValueSegment, WeakKeyStrongValueEntry<K, V> weakKeyStrongValueEntry, V v2) {
                weakKeyStrongValueEntry.setValue(v2);
            }

            @Override
            public Strength valueStrength() {
                return Strength.STRONG;
            }
        }
    }

    static final class WeakKeyStrongValueSegment<K, V>
    extends Segment<K, V, WeakKeyStrongValueEntry<K, V>, WeakKeyStrongValueSegment<K, V>> {
        private final ReferenceQueue<K> queueForKeys = new ReferenceQueue();

        WeakKeyStrongValueSegment(MapMakerInternalMap<K, V, WeakKeyStrongValueEntry<K, V>, WeakKeyStrongValueSegment<K, V>> mapMakerInternalMap, int n2, int n3) {
            super(mapMakerInternalMap, n2, n3);
        }

        @Override
        public WeakKeyStrongValueEntry<K, V> castForTesting(InternalEntry<K, V, ?> internalEntry) {
            return (WeakKeyStrongValueEntry)internalEntry;
        }

        @Override
        ReferenceQueue<K> getKeyReferenceQueueForTesting() {
            return this.queueForKeys;
        }

        @Override
        void maybeClearReferenceQueues() {
            this.clearReferenceQueue(this.queueForKeys);
        }

        @Override
        void maybeDrainReferenceQueues() {
            this.drainKeyReferenceQueue(this.queueForKeys);
        }

        @Override
        WeakKeyStrongValueSegment<K, V> self() {
            return this;
        }
    }

    static final class WeakKeyWeakValueEntry<K, V>
    extends AbstractWeakKeyEntry<K, V, WeakKeyWeakValueEntry<K, V>>
    implements WeakValueEntry<K, V, WeakKeyWeakValueEntry<K, V>> {
        private volatile WeakValueReference<K, V, WeakKeyWeakValueEntry<K, V>> valueReference = MapMakerInternalMap.unsetWeakValueReference();

        WeakKeyWeakValueEntry(ReferenceQueue<K> referenceQueue, K k2, int n2, @NullableDecl WeakKeyWeakValueEntry<K, V> weakKeyWeakValueEntry) {
            super(referenceQueue, k2, n2, weakKeyWeakValueEntry);
        }

        static /* synthetic */ WeakValueReference access$702(WeakKeyWeakValueEntry weakKeyWeakValueEntry, WeakValueReference weakValueReference) {
            weakKeyWeakValueEntry.valueReference = weakValueReference;
            return weakValueReference;
        }

        @Override
        public void clearValue() {
            this.valueReference.clear();
        }

        WeakKeyWeakValueEntry<K, V> copy(ReferenceQueue<K> object, ReferenceQueue<V> referenceQueue, WeakKeyWeakValueEntry<K, V> weakKeyWeakValueEntry) {
            object = new WeakKeyWeakValueEntry<K, V>(object, this.getKey(), this.hash, weakKeyWeakValueEntry);
            ((WeakKeyWeakValueEntry)object).valueReference = this.valueReference.copyFor(referenceQueue, (WeakKeyWeakValueEntry<K, V>)object);
            return object;
        }

        @Override
        public V getValue() {
            return this.valueReference.get();
        }

        @Override
        public WeakValueReference<K, V, WeakKeyWeakValueEntry<K, V>> getValueReference() {
            return this.valueReference;
        }

        void setValue(V v2, ReferenceQueue<V> referenceQueue) {
            WeakValueReference<K, V, WeakKeyWeakValueEntry<K, V>> weakValueReference = this.valueReference;
            this.valueReference = new WeakValueReferenceImpl(referenceQueue, v2, this);
            weakValueReference.clear();
        }

        static final class Helper<K, V>
        implements InternalEntryHelper<K, V, WeakKeyWeakValueEntry<K, V>, WeakKeyWeakValueSegment<K, V>> {
            private static final Helper<?, ?> INSTANCE = new Helper();

            Helper() {
            }

            static <K, V> Helper<K, V> instance() {
                return INSTANCE;
            }

            @Override
            public WeakKeyWeakValueEntry<K, V> copy(WeakKeyWeakValueSegment<K, V> weakKeyWeakValueSegment, WeakKeyWeakValueEntry<K, V> weakKeyWeakValueEntry, @NullableDecl WeakKeyWeakValueEntry<K, V> weakKeyWeakValueEntry2) {
                if (weakKeyWeakValueEntry.getKey() == null) {
                    return null;
                }
                if (Segment.isCollected(weakKeyWeakValueEntry)) {
                    return null;
                }
                return weakKeyWeakValueEntry.copy(((WeakKeyWeakValueSegment)weakKeyWeakValueSegment).queueForKeys, ((WeakKeyWeakValueSegment)weakKeyWeakValueSegment).queueForValues, weakKeyWeakValueEntry2);
            }

            @Override
            public Strength keyStrength() {
                return Strength.WEAK;
            }

            @Override
            public WeakKeyWeakValueEntry<K, V> newEntry(WeakKeyWeakValueSegment<K, V> weakKeyWeakValueSegment, K k2, int n2, @NullableDecl WeakKeyWeakValueEntry<K, V> weakKeyWeakValueEntry) {
                return new WeakKeyWeakValueEntry<K, V>(((WeakKeyWeakValueSegment)weakKeyWeakValueSegment).queueForKeys, k2, n2, weakKeyWeakValueEntry);
            }

            @Override
            public WeakKeyWeakValueSegment<K, V> newSegment(MapMakerInternalMap<K, V, WeakKeyWeakValueEntry<K, V>, WeakKeyWeakValueSegment<K, V>> mapMakerInternalMap, int n2, int n3) {
                return new WeakKeyWeakValueSegment<K, V>(mapMakerInternalMap, n2, n3);
            }

            @Override
            public void setValue(WeakKeyWeakValueSegment<K, V> weakKeyWeakValueSegment, WeakKeyWeakValueEntry<K, V> weakKeyWeakValueEntry, V v2) {
                weakKeyWeakValueEntry.setValue(v2, ((WeakKeyWeakValueSegment)weakKeyWeakValueSegment).queueForValues);
            }

            @Override
            public Strength valueStrength() {
                return Strength.WEAK;
            }
        }
    }

    static final class WeakKeyWeakValueSegment<K, V>
    extends Segment<K, V, WeakKeyWeakValueEntry<K, V>, WeakKeyWeakValueSegment<K, V>> {
        private final ReferenceQueue<K> queueForKeys = new ReferenceQueue();
        private final ReferenceQueue<V> queueForValues = new ReferenceQueue();

        WeakKeyWeakValueSegment(MapMakerInternalMap<K, V, WeakKeyWeakValueEntry<K, V>, WeakKeyWeakValueSegment<K, V>> mapMakerInternalMap, int n2, int n3) {
            super(mapMakerInternalMap, n2, n3);
        }

        @Override
        public WeakKeyWeakValueEntry<K, V> castForTesting(InternalEntry<K, V, ?> internalEntry) {
            return (WeakKeyWeakValueEntry)internalEntry;
        }

        @Override
        ReferenceQueue<K> getKeyReferenceQueueForTesting() {
            return this.queueForKeys;
        }

        @Override
        ReferenceQueue<V> getValueReferenceQueueForTesting() {
            return this.queueForValues;
        }

        @Override
        public WeakValueReference<K, V, WeakKeyWeakValueEntry<K, V>> getWeakValueReferenceForTesting(InternalEntry<K, V, ?> internalEntry) {
            return ((WeakKeyWeakValueEntry)this.castForTesting((InternalEntry)internalEntry)).getValueReference();
        }

        @Override
        void maybeClearReferenceQueues() {
            this.clearReferenceQueue(this.queueForKeys);
        }

        @Override
        void maybeDrainReferenceQueues() {
            this.drainKeyReferenceQueue(this.queueForKeys);
            this.drainValueReferenceQueue(this.queueForValues);
        }

        @Override
        public WeakValueReference<K, V, WeakKeyWeakValueEntry<K, V>> newWeakValueReferenceForTesting(InternalEntry<K, V, ?> internalEntry, V v2) {
            return new WeakValueReferenceImpl(this.queueForValues, v2, this.castForTesting((InternalEntry)internalEntry));
        }

        @Override
        WeakKeyWeakValueSegment<K, V> self() {
            return this;
        }

        @Override
        public void setWeakValueReferenceForTesting(InternalEntry<K, V, ?> internalEntry, WeakValueReference<K, V, ? extends InternalEntry<K, V, ?>> weakValueReference) {
            internalEntry = this.castForTesting(internalEntry);
            WeakValueReference weakValueReference2 = ((WeakKeyWeakValueEntry)internalEntry).valueReference;
            WeakKeyWeakValueEntry.access$702((WeakKeyWeakValueEntry)internalEntry, weakValueReference);
            weakValueReference2.clear();
        }
    }

    static interface WeakValueEntry<K, V, E extends InternalEntry<K, V, E>>
    extends InternalEntry<K, V, E> {
        public void clearValue();

        public WeakValueReference<K, V, E> getValueReference();
    }

    static interface WeakValueReference<K, V, E extends InternalEntry<K, V, E>> {
        public void clear();

        public WeakValueReference<K, V, E> copyFor(ReferenceQueue<V> var1, E var2);

        @NullableDecl
        public V get();

        public E getEntry();
    }

    static final class WeakValueReferenceImpl<K, V, E extends InternalEntry<K, V, E>>
    extends WeakReference<V>
    implements WeakValueReference<K, V, E> {
        final E entry;

        WeakValueReferenceImpl(ReferenceQueue<V> referenceQueue, V v2, E e2) {
            super(v2, referenceQueue);
            this.entry = e2;
        }

        @Override
        public WeakValueReference<K, V, E> copyFor(ReferenceQueue<V> referenceQueue, E e2) {
            return new WeakValueReferenceImpl<K, V, E>(referenceQueue, this.get(), e2);
        }

        @Override
        public E getEntry() {
            return this.entry;
        }
    }

    final class WriteThroughEntry
    extends AbstractMapEntry<K, V> {
        final K key;
        V value;

        WriteThroughEntry(K k2, V v2) {
            this.key = k2;
            this.value = v2;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            boolean bl;
            boolean bl2 = object instanceof Map.Entry;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (Map.Entry)object;
                bl3 = bl;
                if (this.key.equals(object.getKey())) {
                    bl3 = bl;
                    if (this.value.equals(object.getValue())) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        @Override
        public V setValue(V v2) {
            Object v3 = MapMakerInternalMap.this.put(this.key, v2);
            this.value = v2;
            return v3;
        }
    }
}

