/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.CartesianList;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.TransformedListIterator;
import com.google.common.math.IntMath;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.math.RoundingMode;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.concurrent.CopyOnWriteArrayList;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Lists {
    private Lists() {
    }

    static <E> boolean addAllImpl(List<E> object, int n2, Iterable<? extends E> object2) {
        object = object.listIterator(n2);
        object2 = object2.iterator();
        boolean bl = false;
        while (object2.hasNext()) {
            object.add(object2.next());
            bl = true;
        }
        return bl;
    }

    public static <E> List<E> asList(@NullableDecl E e2, @NullableDecl E e3, E[] EArray) {
        return new TwoPlusArrayList<E>(e2, e3, EArray);
    }

    public static <E> List<E> asList(@NullableDecl E e2, E[] EArray) {
        return new OnePlusArrayList<E>(e2, EArray);
    }

    public static <B> List<List<B>> cartesianProduct(List<? extends List<? extends B>> list) {
        return CartesianList.create(list);
    }

    @SafeVarargs
    public static <B> List<List<B>> cartesianProduct(List<? extends B> ... listArray) {
        return Lists.cartesianProduct(Arrays.asList(listArray));
    }

    static <T> List<T> cast(Iterable<T> iterable) {
        return (List)iterable;
    }

    public static ImmutableList<Character> charactersOf(String string2) {
        return new StringAsImmutableList(Preconditions.checkNotNull(string2));
    }

    public static List<Character> charactersOf(CharSequence charSequence) {
        return new CharSequenceAsList(Preconditions.checkNotNull(charSequence));
    }

    static int computeArrayListCapacity(int n2) {
        CollectPreconditions.checkNonnegative((int)n2, (String)"arraySize");
        return Ints.saturatedCast((long)n2 + 5L + (long)(n2 / 10));
    }

    static boolean equalsImpl(List<?> list, @NullableDecl Object object) {
        if (object == Preconditions.checkNotNull(list)) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        object = (List)object;
        int n2 = list.size();
        if (n2 != object.size()) {
            return false;
        }
        if (list instanceof RandomAccess && object instanceof RandomAccess) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (Objects.equal(list.get(i2), object.get(i2))) continue;
                return false;
            }
            return true;
        }
        return Iterators.elementsEqual(list.iterator(), object.iterator());
    }

    static int hashCodeImpl(List<?> object) {
        object = object.iterator();
        int n2 = 1;
        while (object.hasNext()) {
            Object e2 = object.next();
            int n3 = e2 == null ? 0 : e2.hashCode();
            n2 = ~(~(n2 * 31 + n3));
        }
        return n2;
    }

    static int indexOfImpl(List<?> object, @NullableDecl Object object2) {
        if (object instanceof RandomAccess) {
            return Lists.indexOfRandomAccess(object, object2);
        }
        object = object.listIterator();
        while (object.hasNext()) {
            if (!Objects.equal(object2, object.next())) continue;
            return object.previousIndex();
        }
        return -1;
    }

    private static int indexOfRandomAccess(List<?> list, @NullableDecl Object object) {
        int n2;
        int n3 = list.size();
        int n4 = 0;
        if (object == null) {
            for (n2 = n4; n2 < n3; ++n2) {
                if (list.get(n2) != null) continue;
                return n2;
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                if (!object.equals(list.get(n2))) continue;
                return n2;
            }
        }
        return -1;
    }

    static int lastIndexOfImpl(List<?> object, @NullableDecl Object object2) {
        if (object instanceof RandomAccess) {
            return Lists.lastIndexOfRandomAccess(object, object2);
        }
        object = object.listIterator(object.size());
        while (object.hasPrevious()) {
            if (!Objects.equal(object2, object.previous())) continue;
            return object.nextIndex();
        }
        return -1;
    }

    private static int lastIndexOfRandomAccess(List<?> list, @NullableDecl Object object) {
        if (object == null) {
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                if (list.get(i2) != null) continue;
                return i2;
            }
        } else {
            for (int i3 = list.size() - 1; i3 >= 0; --i3) {
                if (!object.equals(list.get(i3))) continue;
                return i3;
            }
        }
        return -1;
    }

    static <E> ListIterator<E> listIteratorImpl(List<E> list, int n2) {
        return new AbstractListWrapper<E>(list).listIterator(n2);
    }

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> iterable) {
        Preconditions.checkNotNull(iterable);
        iterable = iterable instanceof Collection ? new ArrayList<E>(Collections2.cast(iterable)) : Lists.newArrayList(iterable.iterator());
        return iterable;
    }

    public static <E> ArrayList<E> newArrayList(Iterator<? extends E> iterator2) {
        ArrayList<E> arrayList = Lists.newArrayList();
        Iterators.addAll(arrayList, iterator2);
        return arrayList;
    }

    @SafeVarargs
    public static <E> ArrayList<E> newArrayList(E ... EArray) {
        Preconditions.checkNotNull(EArray);
        ArrayList arrayList = new ArrayList(Lists.computeArrayListCapacity(EArray.length));
        Collections.addAll(arrayList, EArray);
        return arrayList;
    }

    public static <E> ArrayList<E> newArrayListWithCapacity(int n2) {
        CollectPreconditions.checkNonnegative((int)n2, (String)"initialArraySize");
        return new ArrayList(n2);
    }

    public static <E> ArrayList<E> newArrayListWithExpectedSize(int n2) {
        return new ArrayList(Lists.computeArrayListCapacity(n2));
    }

    public static <E> CopyOnWriteArrayList<E> newCopyOnWriteArrayList() {
        return new CopyOnWriteArrayList();
    }

    public static <E> CopyOnWriteArrayList<E> newCopyOnWriteArrayList(Iterable<? extends E> iterable) {
        iterable = iterable instanceof Collection ? Collections2.cast(iterable) : Lists.newArrayList(iterable);
        return new CopyOnWriteArrayList<E>(iterable);
    }

    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    public static <E> LinkedList<E> newLinkedList(Iterable<? extends E> iterable) {
        LinkedList<E> linkedList = Lists.newLinkedList();
        Iterables.addAll(linkedList, iterable);
        return linkedList;
    }

    public static <T> List<List<T>> partition(List<T> partition, int n2) {
        Preconditions.checkNotNull(partition);
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl);
        partition = partition instanceof RandomAccess ? new RandomAccessPartition<T>(partition, n2) : new Partition<T>(partition, n2);
        return partition;
    }

    public static <T> List<T> reverse(List<T> list) {
        if (list instanceof ImmutableList) {
            return ((ImmutableList)list).reverse();
        }
        if (list instanceof ReverseList) {
            return ((ReverseList)list).getForwardList();
        }
        if (list instanceof RandomAccess) {
            return new RandomAccessReverseList<T>(list);
        }
        return new ReverseList<T>(list);
    }

    static <E> List<E> subListImpl(List<E> abstractListWrapper, int n2, int n3) {
        abstractListWrapper = abstractListWrapper instanceof RandomAccess ? new RandomAccessListWrapper<E>((List)abstractListWrapper){
            private static final long serialVersionUID = 0L;

            @Override
            public ListIterator<E> listIterator(int n2) {
                return this.backingList.listIterator(n2);
            }
        } : new AbstractListWrapper<E>((List)abstractListWrapper){
            private static final long serialVersionUID = 0L;

            @Override
            public ListIterator<E> listIterator(int n2) {
                return this.backingList.listIterator(n2);
            }
        };
        return abstractListWrapper.subList(n2, n3);
    }

    public static <F, T> List<T> transform(List<F> abstractList, Function<? super F, ? extends T> function) {
        abstractList = abstractList instanceof RandomAccess ? new TransformingRandomAccessList<F, F>(abstractList, function) : new TransformingSequentialList<F, F>(abstractList, function);
        return abstractList;
    }

    private static class AbstractListWrapper<E>
    extends AbstractList<E> {
        final List<E> backingList;

        AbstractListWrapper(List<E> list) {
            this.backingList = Preconditions.checkNotNull(list);
        }

        @Override
        public void add(int n2, E e2) {
            this.backingList.add(n2, e2);
        }

        @Override
        public boolean addAll(int n2, Collection<? extends E> collection) {
            return this.backingList.addAll(n2, collection);
        }

        @Override
        public boolean contains(Object object) {
            return this.backingList.contains(object);
        }

        @Override
        public E get(int n2) {
            return this.backingList.get(n2);
        }

        @Override
        public E remove(int n2) {
            return this.backingList.remove(n2);
        }

        @Override
        public E set(int n2, E e2) {
            return this.backingList.set(n2, e2);
        }

        @Override
        public int size() {
            return this.backingList.size();
        }
    }

    private static final class CharSequenceAsList
    extends AbstractList<Character> {
        private final CharSequence sequence;

        CharSequenceAsList(CharSequence charSequence) {
            this.sequence = charSequence;
        }

        @Override
        public Character get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return Character.valueOf(this.sequence.charAt(n2));
        }

        @Override
        public int size() {
            return this.sequence.length();
        }
    }

    private static class OnePlusArrayList<E>
    extends AbstractList<E>
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 0L;
        @NullableDecl
        final E first;
        final E[] rest;

        OnePlusArrayList(@NullableDecl E e2, E[] EArray) {
            this.first = e2;
            this.rest = Preconditions.checkNotNull(EArray);
        }

        @Override
        public E get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            E e2 = n2 == 0 ? this.first : this.rest[n2 - 1];
            return e2;
        }

        @Override
        public int size() {
            return IntMath.saturatedAdd((int)this.rest.length, (int)1);
        }
    }

    private static class Partition<T>
    extends AbstractList<List<T>> {
        final List<T> list;
        final int size;

        Partition(List<T> list, int n2) {
            this.list = list;
            this.size = n2;
        }

        @Override
        public List<T> get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            int n3 = this.size;
            n2 *= n3;
            n3 = Math.min(n3 + n2, this.list.size());
            return this.list.subList(n2, n3);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public int size() {
            return IntMath.divide((int)this.list.size(), (int)this.size, (RoundingMode)RoundingMode.CEILING);
        }
    }

    private static class RandomAccessListWrapper<E>
    extends AbstractListWrapper<E>
    implements RandomAccess {
        RandomAccessListWrapper(List<E> list) {
            super(list);
        }
    }

    private static class RandomAccessPartition<T>
    extends Partition<T>
    implements RandomAccess {
        RandomAccessPartition(List<T> list, int n2) {
            super(list, n2);
        }
    }

    private static class RandomAccessReverseList<T>
    extends ReverseList<T>
    implements RandomAccess {
        RandomAccessReverseList(List<T> list) {
            super(list);
        }
    }

    private static class ReverseList<T>
    extends AbstractList<T> {
        private final List<T> forwardList;

        ReverseList(List<T> list) {
            this.forwardList = Preconditions.checkNotNull(list);
        }

        private int reverseIndex(int n2) {
            int n3 = this.size();
            Preconditions.checkElementIndex(n2, n3);
            return n3 - 1 - n2;
        }

        private int reversePosition(int n2) {
            int n3 = this.size();
            Preconditions.checkPositionIndex(n2, n3);
            return n3 - n2;
        }

        @Override
        public void add(int n2, @NullableDecl T t2) {
            this.forwardList.add(this.reversePosition(n2), t2);
        }

        @Override
        public void clear() {
            this.forwardList.clear();
        }

        @Override
        public T get(int n2) {
            return this.forwardList.get(this.reverseIndex(n2));
        }

        List<T> getForwardList() {
            return this.forwardList;
        }

        @Override
        public Iterator<T> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int n2) {
            n2 = this.reversePosition(n2);
            return new ListIterator<T>(this.forwardList.listIterator(n2)){
                boolean canRemoveOrSet;
                final /* synthetic */ ListIterator val$forwardIterator;
                {
                    this.val$forwardIterator = listIterator;
                }

                @Override
                public void add(T t2) {
                    this.val$forwardIterator.add(t2);
                    this.val$forwardIterator.previous();
                    this.canRemoveOrSet = false;
                }

                @Override
                public boolean hasNext() {
                    return this.val$forwardIterator.hasPrevious();
                }

                @Override
                public boolean hasPrevious() {
                    return this.val$forwardIterator.hasNext();
                }

                @Override
                public T next() {
                    if (this.hasNext()) {
                        this.canRemoveOrSet = true;
                        return this.val$forwardIterator.previous();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public int nextIndex() {
                    return ReverseList.this.reversePosition(this.val$forwardIterator.nextIndex());
                }

                @Override
                public T previous() {
                    if (this.hasPrevious()) {
                        this.canRemoveOrSet = true;
                        return this.val$forwardIterator.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public int previousIndex() {
                    return this.nextIndex() - 1;
                }

                @Override
                public void remove() {
                    CollectPreconditions.checkRemove((boolean)this.canRemoveOrSet);
                    this.val$forwardIterator.remove();
                    this.canRemoveOrSet = false;
                }

                @Override
                public void set(T t2) {
                    Preconditions.checkState(this.canRemoveOrSet);
                    this.val$forwardIterator.set(t2);
                }
            };
        }

        @Override
        public T remove(int n2) {
            return this.forwardList.remove(this.reverseIndex(n2));
        }

        @Override
        protected void removeRange(int n2, int n3) {
            this.subList(n2, n3).clear();
        }

        @Override
        public T set(int n2, @NullableDecl T t2) {
            return this.forwardList.set(this.reverseIndex(n2), t2);
        }

        @Override
        public int size() {
            return this.forwardList.size();
        }

        @Override
        public List<T> subList(int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n3, this.size());
            return Lists.reverse(this.forwardList.subList(this.reversePosition(n3), this.reversePosition(n2)));
        }
    }

    private static final class StringAsImmutableList
    extends ImmutableList<Character> {
        private final String string;

        StringAsImmutableList(String string2) {
            this.string = string2;
        }

        @Override
        public Character get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return Character.valueOf(this.string.charAt(n2));
        }

        @Override
        public int indexOf(@NullableDecl Object object) {
            int n2 = object instanceof Character ? this.string.indexOf(((Character)object).charValue()) : -1;
            return n2;
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        public int lastIndexOf(@NullableDecl Object object) {
            int n2 = object instanceof Character ? this.string.lastIndexOf(((Character)object).charValue()) : -1;
            return n2;
        }

        @Override
        public int size() {
            return this.string.length();
        }

        @Override
        public ImmutableList<Character> subList(int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n3, this.size());
            return Lists.charactersOf(this.string.substring(n2, n3));
        }
    }

    private static class TransformingRandomAccessList<F, T>
    extends AbstractList<T>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 0L;
        final List<F> fromList;
        final Function<? super F, ? extends T> function;

        TransformingRandomAccessList(List<F> list, Function<? super F, ? extends T> function) {
            this.fromList = Preconditions.checkNotNull(list);
            this.function = Preconditions.checkNotNull(function);
        }

        @Override
        public void clear() {
            this.fromList.clear();
        }

        @Override
        public T get(int n2) {
            return this.function.apply(this.fromList.get(n2));
        }

        @Override
        public boolean isEmpty() {
            return this.fromList.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int n2) {
            return new TransformedListIterator<F, T>(this.fromList.listIterator(n2)){

                T transform(F f2) {
                    return TransformingRandomAccessList.this.function.apply(f2);
                }
            };
        }

        @Override
        public T remove(int n2) {
            return this.function.apply(this.fromList.remove(n2));
        }

        @Override
        public int size() {
            return this.fromList.size();
        }
    }

    private static class TransformingSequentialList<F, T>
    extends AbstractSequentialList<T>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        final List<F> fromList;
        final Function<? super F, ? extends T> function;

        TransformingSequentialList(List<F> list, Function<? super F, ? extends T> function) {
            this.fromList = Preconditions.checkNotNull(list);
            this.function = Preconditions.checkNotNull(function);
        }

        @Override
        public void clear() {
            this.fromList.clear();
        }

        @Override
        public ListIterator<T> listIterator(int n2) {
            return new TransformedListIterator<F, T>(this.fromList.listIterator(n2)){

                T transform(F f2) {
                    return TransformingSequentialList.this.function.apply(f2);
                }
            };
        }

        @Override
        public int size() {
            return this.fromList.size();
        }
    }

    private static class TwoPlusArrayList<E>
    extends AbstractList<E>
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 0L;
        @NullableDecl
        final E first;
        final E[] rest;
        @NullableDecl
        final E second;

        TwoPlusArrayList(@NullableDecl E e2, @NullableDecl E e3, E[] EArray) {
            this.first = e2;
            this.second = e3;
            this.rest = Preconditions.checkNotNull(EArray);
        }

        @Override
        public E get(int n2) {
            if (n2 != 0) {
                if (n2 != 1) {
                    Preconditions.checkElementIndex(n2, this.size());
                    return this.rest[n2 - 2];
                }
                return this.second;
            }
            return this.first;
        }

        @Override
        public int size() {
            return IntMath.saturatedAdd((int)this.rest.length, (int)2);
        }
    }
}

