/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.AbstractMapBasedMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multisets;
import com.google.common.collect.ObjectCountLinkedHashMap;

public final class LinkedHashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    LinkedHashMultiset(int n2) {
        super(n2);
    }

    public static <E> LinkedHashMultiset<E> create() {
        return LinkedHashMultiset.create(3);
    }

    public static <E> LinkedHashMultiset<E> create(int n2) {
        return new LinkedHashMultiset<E>(n2);
    }

    public static <E> LinkedHashMultiset<E> create(Iterable<? extends E> iterable) {
        LinkedHashMultiset<E> linkedHashMultiset = LinkedHashMultiset.create(Multisets.inferDistinctElements(iterable));
        Iterables.addAll(linkedHashMultiset, iterable);
        return linkedHashMultiset;
    }

    @Override
    void init(int n2) {
        this.backingMap = new ObjectCountLinkedHashMap(n2);
    }
}

