/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Objects;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableEntry;
import com.google.common.collect.LinkedHashMultimapGwtSerializationDependencies;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Platform;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class LinkedHashMultimap<K, V>
extends LinkedHashMultimapGwtSerializationDependencies<K, V> {
    private static final int DEFAULT_KEY_CAPACITY = 16;
    private static final int DEFAULT_VALUE_SET_CAPACITY = 2;
    static final double VALUE_SET_LOAD_FACTOR = 1.0;
    private static final long serialVersionUID = 1L;
    private transient ValueEntry<K, V> multimapHeaderEntry;
    transient int valueSetCapacity = 2;

    private LinkedHashMultimap(int n2, int n3) {
        super(Platform.newLinkedHashMapWithExpectedSize((int)n2));
        CollectPreconditions.checkNonnegative((int)n3, (String)"expectedValuesPerKey");
        this.valueSetCapacity = n3;
        ValueEntry<K, V> valueEntry = this.multimapHeaderEntry = new ValueEntry<Object, Object>(null, null, 0, null);
        LinkedHashMultimap.succeedsInMultimap(valueEntry, valueEntry);
    }

    public static <K, V> LinkedHashMultimap<K, V> create() {
        return new LinkedHashMultimap<K, V>(16, 2);
    }

    public static <K, V> LinkedHashMultimap<K, V> create(int n2, int n3) {
        return new LinkedHashMultimap<K, V>(Maps.capacity(n2), Maps.capacity(n3));
    }

    public static <K, V> LinkedHashMultimap<K, V> create(Multimap<? extends K, ? extends V> multimap) {
        LinkedHashMultimap<K, V> linkedHashMultimap = LinkedHashMultimap.create(multimap.keySet().size(), 2);
        linkedHashMultimap.putAll((Multimap)multimap);
        return linkedHashMultimap;
    }

    private static <K, V> void deleteFromMultimap(ValueEntry<K, V> valueEntry) {
        LinkedHashMultimap.succeedsInMultimap(valueEntry.getPredecessorInMultimap(), valueEntry.getSuccessorInMultimap());
    }

    private static <K, V> void deleteFromValueSet(ValueSetLink<K, V> valueSetLink) {
        LinkedHashMultimap.succeedsInValueSet(valueSetLink.getPredecessorInValueSet(), valueSetLink.getSuccessorInValueSet());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        int n2;
        objectInputStream.defaultReadObject();
        int n3 = 0;
        this.multimapHeaderEntry = new ValueEntry<Object, Object>(null, null, 0, null);
        Object object2 = this.multimapHeaderEntry;
        LinkedHashMultimap.succeedsInMultimap(object2, object2);
        this.valueSetCapacity = 2;
        int n4 = objectInputStream.readInt();
        object2 = Platform.newLinkedHashMapWithExpectedSize((int)12);
        for (n2 = 0; n2 < n4; ++n2) {
            object = objectInputStream.readObject();
            object2.put(object, this.createCollection(object));
        }
        n4 = objectInputStream.readInt();
        for (n2 = n3; n2 < n4; ++n2) {
            Object object3 = objectInputStream.readObject();
            object = objectInputStream.readObject();
            ((Collection)object2.get(object3)).add(object);
        }
        this.setMap(object2);
    }

    private static <K, V> void succeedsInMultimap(ValueEntry<K, V> valueEntry, ValueEntry<K, V> valueEntry2) {
        valueEntry.setSuccessorInMultimap(valueEntry2);
        valueEntry2.setPredecessorInMultimap(valueEntry);
    }

    private static <K, V> void succeedsInValueSet(ValueSetLink<K, V> valueSetLink, ValueSetLink<K, V> valueSetLink2) {
        valueSetLink.setSuccessorInValueSet(valueSetLink2);
        valueSetLink2.setPredecessorInValueSet(valueSetLink);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.keySet().size());
        Object object2 = this.keySet().iterator();
        while (object2.hasNext()) {
            objectOutputStream.writeObject(object2.next());
        }
        objectOutputStream.writeInt(this.size());
        for (Object object2 : this.entries()) {
            objectOutputStream.writeObject(object2.getKey());
            objectOutputStream.writeObject(object2.getValue());
        }
    }

    @Override
    public void clear() {
        super.clear();
        ValueEntry<K, V> valueEntry = this.multimapHeaderEntry;
        LinkedHashMultimap.succeedsInMultimap(valueEntry, valueEntry);
    }

    @Override
    Collection<V> createCollection(K k2) {
        return new ValueSet(k2, this.valueSetCapacity);
    }

    @Override
    Set<V> createCollection() {
        return Platform.newLinkedHashSetWithExpectedSize((int)this.valueSetCapacity);
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        return super.entries();
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        return new Iterator<Map.Entry<K, V>>(){
            ValueEntry<K, V> nextEntry;
            @NullableDecl
            ValueEntry<K, V> toRemove;
            {
                this.nextEntry = ((LinkedHashMultimap)LinkedHashMultimap.this).multimapHeaderEntry.successorInMultimap;
            }

            @Override
            public boolean hasNext() {
                boolean bl = this.nextEntry != LinkedHashMultimap.this.multimapHeaderEntry;
                return bl;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.hasNext()) {
                    ValueEntry valueEntry = this.nextEntry;
                    this.toRemove = valueEntry;
                    this.nextEntry = valueEntry.successorInMultimap;
                    return valueEntry;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                boolean bl = this.toRemove != null;
                CollectPreconditions.checkRemove((boolean)bl);
                LinkedHashMultimap.this.remove(this.toRemove.getKey(), this.toRemove.getValue());
                this.toRemove = null;
            }
        };
    }

    @Override
    public Set<K> keySet() {
        return super.keySet();
    }

    @Override
    public Set<V> replaceValues(@NullableDecl K k2, Iterable<? extends V> iterable) {
        return super.replaceValues((Object)k2, (Iterable)iterable);
    }

    @Override
    Iterator<V> valueIterator() {
        return Maps.valueIterator(this.entryIterator());
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    static final class ValueEntry<K, V>
    extends ImmutableEntry<K, V>
    implements ValueSetLink<K, V> {
        @NullableDecl
        ValueEntry<K, V> nextInValueBucket;
        @NullableDecl
        ValueEntry<K, V> predecessorInMultimap;
        @NullableDecl
        ValueSetLink<K, V> predecessorInValueSet;
        final int smearedValueHash;
        @NullableDecl
        ValueEntry<K, V> successorInMultimap;
        @NullableDecl
        ValueSetLink<K, V> successorInValueSet;

        ValueEntry(@NullableDecl K k2, @NullableDecl V v2, int n2, @NullableDecl ValueEntry<K, V> valueEntry) {
            super(k2, v2);
            this.smearedValueHash = n2;
            this.nextInValueBucket = valueEntry;
        }

        public ValueEntry<K, V> getPredecessorInMultimap() {
            return this.predecessorInMultimap;
        }

        @Override
        public ValueSetLink<K, V> getPredecessorInValueSet() {
            return this.predecessorInValueSet;
        }

        public ValueEntry<K, V> getSuccessorInMultimap() {
            return this.successorInMultimap;
        }

        @Override
        public ValueSetLink<K, V> getSuccessorInValueSet() {
            return this.successorInValueSet;
        }

        boolean matchesValue(@NullableDecl Object object, int n2) {
            boolean bl = this.smearedValueHash == n2 && Objects.equal(this.getValue(), object);
            return bl;
        }

        public void setPredecessorInMultimap(ValueEntry<K, V> valueEntry) {
            this.predecessorInMultimap = valueEntry;
        }

        @Override
        public void setPredecessorInValueSet(ValueSetLink<K, V> valueSetLink) {
            this.predecessorInValueSet = valueSetLink;
        }

        public void setSuccessorInMultimap(ValueEntry<K, V> valueEntry) {
            this.successorInMultimap = valueEntry;
        }

        @Override
        public void setSuccessorInValueSet(ValueSetLink<K, V> valueSetLink) {
            this.successorInValueSet = valueSetLink;
        }
    }

    final class ValueSet
    extends Sets.ImprovedAbstractSet<V>
    implements ValueSetLink<K, V> {
        private ValueSetLink<K, V> firstEntry;
        ValueEntry<K, V>[] hashTable;
        private final K key;
        private ValueSetLink<K, V> lastEntry;
        private int modCount = 0;
        private int size = 0;

        ValueSet(K k2, int n2) {
            this.key = k2;
            this.firstEntry = this;
            this.lastEntry = this;
            this.hashTable = new ValueEntry[Hashing.closedTableSize(n2, 1.0)];
        }

        private int mask() {
            return this.hashTable.length - 1;
        }

        private void rehashIfNecessary() {
            if (Hashing.needsResizing(this.size, this.hashTable.length, 1.0)) {
                ValueEntry[] valueEntryArray = new ValueEntry[this.hashTable.length * 2];
                this.hashTable = valueEntryArray;
                int n2 = valueEntryArray.length;
                for (ValueSetLink valueSetLink = this.firstEntry; valueSetLink != this; valueSetLink = valueSetLink.getSuccessorInValueSet()) {
                    ValueEntry valueEntry = (ValueEntry)valueSetLink;
                    int n3 = valueEntry.smearedValueHash & n2 - 1;
                    valueEntry.nextInValueBucket = valueEntryArray[n3];
                    valueEntryArray[n3] = valueEntry;
                }
            }
        }

        @Override
        public boolean add(@NullableDecl V object) {
            ValueEntry valueEntry;
            int n2 = Hashing.smearedHash(object);
            int n3 = this.mask() & n2;
            ValueEntry valueEntry2 = valueEntry = this.hashTable[n3];
            while (valueEntry2 != null) {
                if (valueEntry2.matchesValue(object, n2)) {
                    return false;
                }
                valueEntry2 = valueEntry2.nextInValueBucket;
            }
            object = new ValueEntry(this.key, object, n2, valueEntry);
            LinkedHashMultimap.succeedsInValueSet(this.lastEntry, object);
            LinkedHashMultimap.succeedsInValueSet(object, this);
            LinkedHashMultimap.succeedsInMultimap(LinkedHashMultimap.this.multimapHeaderEntry.getPredecessorInMultimap(), object);
            LinkedHashMultimap.succeedsInMultimap(object, LinkedHashMultimap.this.multimapHeaderEntry);
            this.hashTable[n3] = object;
            ++this.size;
            ++this.modCount;
            this.rehashIfNecessary();
            return true;
        }

        @Override
        public void clear() {
            Arrays.fill(this.hashTable, null);
            this.size = 0;
            for (ValueSetLink valueSetLink = this.firstEntry; valueSetLink != this; valueSetLink = valueSetLink.getSuccessorInValueSet()) {
                LinkedHashMultimap.deleteFromMultimap((ValueEntry)valueSetLink);
            }
            LinkedHashMultimap.succeedsInValueSet(this, this);
            ++this.modCount;
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            int n2 = Hashing.smearedHash(object);
            ValueEntry valueEntry = this.hashTable[this.mask() & n2];
            while (valueEntry != null) {
                if (valueEntry.matchesValue(object, n2)) {
                    return true;
                }
                valueEntry = valueEntry.nextInValueBucket;
            }
            return false;
        }

        @Override
        public ValueSetLink<K, V> getPredecessorInValueSet() {
            return this.lastEntry;
        }

        @Override
        public ValueSetLink<K, V> getSuccessorInValueSet() {
            return this.firstEntry;
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                int expectedModCount;
                ValueSetLink<K, V> nextEntry;
                @NullableDecl
                ValueEntry<K, V> toRemove;
                {
                    this.nextEntry = ValueSet.this.firstEntry;
                    this.expectedModCount = ValueSet.this.modCount;
                }

                private void checkForComodification() {
                    if (ValueSet.this.modCount == this.expectedModCount) {
                        return;
                    }
                    throw new ConcurrentModificationException();
                }

                @Override
                public boolean hasNext() {
                    this.checkForComodification();
                    boolean bl = this.nextEntry != ValueSet.this;
                    return bl;
                }

                @Override
                public V next() {
                    if (this.hasNext()) {
                        ValueEntry valueEntry = (ValueEntry)this.nextEntry;
                        Object v2 = valueEntry.getValue();
                        this.toRemove = valueEntry;
                        this.nextEntry = valueEntry.getSuccessorInValueSet();
                        return v2;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    this.checkForComodification();
                    boolean bl = this.toRemove != null;
                    CollectPreconditions.checkRemove((boolean)bl);
                    ValueSet.this.remove(this.toRemove.getValue());
                    this.expectedModCount = ValueSet.this.modCount;
                    this.toRemove = null;
                }
            };
        }

        @Override
        public boolean remove(@NullableDecl Object object) {
            int n2 = Hashing.smearedHash(object);
            int n3 = this.mask() & n2;
            ValueEntry valueEntry = this.hashTable[n3];
            ValueEntry valueEntry2 = null;
            while (true) {
                ValueEntry valueEntry3 = valueEntry2;
                valueEntry2 = valueEntry;
                if (valueEntry2 == null) break;
                if (valueEntry2.matchesValue(object, n2)) {
                    if (valueEntry3 == null) {
                        this.hashTable[n3] = valueEntry2.nextInValueBucket;
                    } else {
                        valueEntry3.nextInValueBucket = valueEntry2.nextInValueBucket;
                    }
                    LinkedHashMultimap.deleteFromValueSet(valueEntry2);
                    LinkedHashMultimap.deleteFromMultimap(valueEntry2);
                    --this.size;
                    ++this.modCount;
                    return true;
                }
                valueEntry = valueEntry2.nextInValueBucket;
            }
            return false;
        }

        @Override
        public void setPredecessorInValueSet(ValueSetLink<K, V> valueSetLink) {
            this.lastEntry = valueSetLink;
        }

        @Override
        public void setSuccessorInValueSet(ValueSetLink<K, V> valueSetLink) {
            this.firstEntry = valueSetLink;
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    private static interface ValueSetLink<K, V> {
        public ValueSetLink<K, V> getPredecessorInValueSet();

        public ValueSetLink<K, V> getSuccessorInValueSet();

        public void setPredecessorInValueSet(ValueSetLink<K, V> var1);

        public void setSuccessorInValueSet(ValueSetLink<K, V> var1);
    }
}

