/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.Comparator;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class LexicographicalOrdering<T>
extends Ordering<Iterable<T>>
implements Serializable {
    private static final long serialVersionUID = 0L;
    final Comparator<? super T> elementOrder;

    LexicographicalOrdering(Comparator<? super T> comparator) {
        this.elementOrder = comparator;
    }

    @Override
    public int compare(Iterable<T> object, Iterable<T> object2) {
        object = object.iterator();
        object2 = object2.iterator();
        while (object.hasNext()) {
            if (!object2.hasNext()) {
                return 1;
            }
            int n2 = this.elementOrder.compare(object.next(), object2.next());
            if (n2 == 0) continue;
            return n2;
        }
        if (object2.hasNext()) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean equals(@NullableDecl Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof LexicographicalOrdering) {
            object = (LexicographicalOrdering)object;
            return this.elementOrder.equals(((LexicographicalOrdering)object).elementOrder);
        }
        return false;
    }

    public int hashCode() {
        return this.elementOrder.hashCode() ^ 0x7BB78CF5;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.elementOrder);
        stringBuilder.append(".lexicographical()");
        return stringBuilder.toString();
    }
}

