/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.TransformedIterator;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.UnmodifiableListIterator;
import com.google.common.primitives.Ints;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Iterators {
    private Iterators() {
    }

    public static <T> boolean addAll(Collection<T> collection, Iterator<? extends T> iterator2) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkNotNull(iterator2);
        boolean bl = false;
        while (iterator2.hasNext()) {
            bl |= collection.add(iterator2.next());
        }
        return bl;
    }

    public static int advance(Iterator<?> iterator2, int n2) {
        int n3;
        Preconditions.checkNotNull(iterator2);
        boolean bl = n2 >= 0;
        Preconditions.checkArgument(bl, "numberToAdvance must be nonnegative");
        for (n3 = 0; n3 < n2 && iterator2.hasNext(); ++n3) {
            iterator2.next();
        }
        return n3;
    }

    public static <T> boolean all(Iterator<T> iterator2, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        while (iterator2.hasNext()) {
            if (predicate.apply(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean any(Iterator<T> iterator2, Predicate<? super T> predicate) {
        boolean bl = Iterators.indexOf(iterator2, predicate) != -1;
        return bl;
    }

    public static <T> Enumeration<T> asEnumeration(final Iterator<T> iterator2) {
        Preconditions.checkNotNull(iterator2);
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return iterator2.hasNext();
            }

            @Override
            public T nextElement() {
                return iterator2.next();
            }
        };
    }

    static <T> ListIterator<T> cast(Iterator<T> iterator2) {
        return (ListIterator)iterator2;
    }

    static void checkNonnegative(int n2) {
        if (n2 >= 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("position (");
        stringBuilder.append(n2);
        stringBuilder.append(") must not be negative");
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    static void clear(Iterator<?> iterator2) {
        Preconditions.checkNotNull(iterator2);
        while (iterator2.hasNext()) {
            iterator2.next();
            iterator2.remove();
        }
    }

    public static <T> Iterator<T> concat(Iterator<? extends Iterator<? extends T>> iterator2) {
        return new ConcatenatedIterator(iterator2);
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> iterator2, Iterator<? extends T> iterator3) {
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkNotNull(iterator3);
        return Iterators.concat(Iterators.consumingForArray(iterator2, iterator3));
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> iterator2, Iterator<? extends T> iterator3, Iterator<? extends T> iterator4) {
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkNotNull(iterator3);
        Preconditions.checkNotNull(iterator4);
        return Iterators.concat(Iterators.consumingForArray(iterator2, iterator3, iterator4));
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> iterator2, Iterator<? extends T> iterator3, Iterator<? extends T> iterator4, Iterator<? extends T> iterator5) {
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkNotNull(iterator3);
        Preconditions.checkNotNull(iterator4);
        Preconditions.checkNotNull(iterator5);
        return Iterators.concat(Iterators.consumingForArray(iterator2, iterator3, iterator4, iterator5));
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> ... iteratorArray) {
        return Iterators.concatNoDefensiveCopy(Arrays.copyOf(iteratorArray, iteratorArray.length));
    }

    static <T> Iterator<T> concatNoDefensiveCopy(Iterator<? extends T> ... iteratorArray) {
        Iterator<? extends T>[] iteratorArray2 = Preconditions.checkNotNull(iteratorArray);
        int n2 = iteratorArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Preconditions.checkNotNull(iteratorArray2[i2]);
        }
        return Iterators.concat(Iterators.consumingForArray(iteratorArray));
    }

    private static <T> Iterator<T> consumingForArray(final T ... TArray) {
        return new UnmodifiableIterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                boolean bl = this.index < TArray.length;
                return bl;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    Object[] objectArray = TArray;
                    int n2 = this.index;
                    Object object = objectArray[n2];
                    objectArray[n2] = null;
                    this.index = n2 + 1;
                    return object;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static <T> Iterator<T> consumingIterator(final Iterator<T> iterator2) {
        Preconditions.checkNotNull(iterator2);
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public T next() {
                Object e2 = iterator2.next();
                iterator2.remove();
                return e2;
            }

            public String toString() {
                return "Iterators.consumingIterator(...)";
            }
        };
    }

    public static boolean contains(Iterator<?> iterator2, @NullableDecl Object object) {
        if (object == null) {
            while (iterator2.hasNext()) {
                if (iterator2.next() != null) continue;
                return true;
            }
        } else {
            while (iterator2.hasNext()) {
                if (!object.equals(iterator2.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> Iterator<T> cycle(final Iterable<T> iterable) {
        Preconditions.checkNotNull(iterable);
        return new Iterator<T>(){
            Iterator<T> iterator = Iterators.emptyModifiableIterator();

            @Override
            public boolean hasNext() {
                boolean bl = this.iterator.hasNext() || iterable.iterator().hasNext();
                return bl;
            }

            @Override
            public T next() {
                if (!this.iterator.hasNext()) {
                    this.iterator = iterable.iterator();
                    if (!this.iterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                }
                return this.iterator.next();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> cycle(T ... TArray) {
        return Iterators.cycle(Lists.newArrayList(TArray));
    }

    public static boolean elementsEqual(Iterator<?> iterator2, Iterator<?> iterator3) {
        while (iterator2.hasNext()) {
            if (!iterator3.hasNext()) {
                return false;
            }
            if (Objects.equal(iterator2.next(), iterator3.next())) continue;
            return false;
        }
        return iterator3.hasNext() ^ true;
    }

    static <T> UnmodifiableIterator<T> emptyIterator() {
        return Iterators.emptyListIterator();
    }

    static <T> UnmodifiableListIterator<T> emptyListIterator() {
        return ArrayItr.EMPTY;
    }

    static <T> Iterator<T> emptyModifiableIterator() {
        return EmptyModifiableIterator.INSTANCE;
    }

    public static <T> UnmodifiableIterator<T> filter(final Iterator<T> iterator2, final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkNotNull(predicate);
        return new AbstractIterator<T>(){

            @Override
            protected T computeNext() {
                while (iterator2.hasNext()) {
                    Object e2 = iterator2.next();
                    if (!predicate.apply(e2)) continue;
                    return e2;
                }
                return this.endOfData();
            }
        };
    }

    public static <T> UnmodifiableIterator<T> filter(Iterator<?> iterator2, Class<T> clazz) {
        return Iterators.filter(iterator2, Predicates.instanceOf(clazz));
    }

    public static <T> T find(Iterator<T> object, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(predicate);
        while (object.hasNext()) {
            T t2 = object.next();
            if (!predicate.apply(t2)) continue;
            return t2;
        }
        object = new NoSuchElementException();
        throw object;
    }

    @NullableDecl
    public static <T> T find(Iterator<? extends T> iterator2, Predicate<? super T> predicate, @NullableDecl T t2) {
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkNotNull(predicate);
        while (iterator2.hasNext()) {
            T t3 = iterator2.next();
            if (!predicate.apply(t3)) continue;
            return t3;
        }
        return t2;
    }

    @SafeVarargs
    public static <T> UnmodifiableIterator<T> forArray(T ... TArray) {
        return Iterators.forArray(TArray, 0, TArray.length, 0);
    }

    static <T> UnmodifiableListIterator<T> forArray(T[] TArray, int n2, int n3, int n4) {
        boolean bl = n3 >= 0;
        Preconditions.checkArgument(bl);
        Preconditions.checkPositionIndexes(n2, n2 + n3, TArray.length);
        Preconditions.checkPositionIndex(n4, n3);
        if (n3 == 0) {
            return Iterators.emptyListIterator();
        }
        return new ArrayItr<T>(TArray, n2, n3, n4);
    }

    public static <T> UnmodifiableIterator<T> forEnumeration(final Enumeration<T> enumeration) {
        Preconditions.checkNotNull(enumeration);
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }
        };
    }

    public static int frequency(Iterator<?> iterator2, @NullableDecl Object object) {
        int n2 = 0;
        while (Iterators.contains(iterator2, object)) {
            ++n2;
        }
        return n2;
    }

    public static <T> T get(Iterator<T> object, int n2) {
        Iterators.checkNonnegative(n2);
        int n3 = Iterators.advance(object, n2);
        if (object.hasNext()) {
            return object.next();
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("position (");
        ((StringBuilder)object).append(n2);
        ((StringBuilder)object).append(") must be less than the number of elements that remained (");
        ((StringBuilder)object).append(n3);
        ((StringBuilder)object).append(")");
        throw new IndexOutOfBoundsException(((StringBuilder)object).toString());
    }

    @NullableDecl
    public static <T> T get(Iterator<? extends T> iterator2, int n2, @NullableDecl T t2) {
        Iterators.checkNonnegative(n2);
        Iterators.advance(iterator2, n2);
        return Iterators.getNext(iterator2, t2);
    }

    public static <T> T getLast(Iterator<T> iterator2) {
        T t2;
        do {
            t2 = iterator2.next();
        } while (iterator2.hasNext());
        return t2;
    }

    @NullableDecl
    public static <T> T getLast(Iterator<? extends T> iterator2, @NullableDecl T t2) {
        if (iterator2.hasNext()) {
            t2 = Iterators.getLast(iterator2);
        }
        return t2;
    }

    @NullableDecl
    public static <T> T getNext(Iterator<? extends T> iterator2, @NullableDecl T t2) {
        if (iterator2.hasNext()) {
            t2 = iterator2.next();
        }
        return t2;
    }

    public static <T> T getOnlyElement(Iterator<T> object) {
        T t2 = object.next();
        if (!object.hasNext()) {
            return t2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("expected one element but was: <");
        stringBuilder.append(t2);
        for (int i2 = 0; i2 < 4 && object.hasNext(); ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(object.next());
        }
        if (object.hasNext()) {
            stringBuilder.append(", ...");
        }
        stringBuilder.append('>');
        object = new IllegalArgumentException(stringBuilder.toString());
        throw object;
    }

    @NullableDecl
    public static <T> T getOnlyElement(Iterator<? extends T> iterator2, @NullableDecl T t2) {
        if (iterator2.hasNext()) {
            t2 = Iterators.getOnlyElement(iterator2);
        }
        return t2;
    }

    public static <T> int indexOf(Iterator<T> iterator2, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate, "predicate");
        int n2 = 0;
        while (iterator2.hasNext()) {
            if (predicate.apply(iterator2.next())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static <T> Iterator<T> limit(final Iterator<T> iterator2, final int n2) {
        Preconditions.checkNotNull(iterator2);
        boolean bl = n2 >= 0;
        Preconditions.checkArgument(bl, "limit is negative");
        return new Iterator<T>(){
            private int count;

            @Override
            public boolean hasNext() {
                boolean bl = this.count < n2 && iterator2.hasNext();
                return bl;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    ++this.count;
                    return iterator2.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
    }

    public static <T> UnmodifiableIterator<T> mergeSorted(Iterable<? extends Iterator<? extends T>> iterable, Comparator<? super T> comparator) {
        Preconditions.checkNotNull(iterable, "iterators");
        Preconditions.checkNotNull(comparator, "comparator");
        return new MergingIterator<T>(iterable, comparator);
    }

    public static <T> UnmodifiableIterator<List<T>> paddedPartition(Iterator<T> iterator2, int n2) {
        return Iterators.partitionImpl(iterator2, n2, true);
    }

    public static <T> UnmodifiableIterator<List<T>> partition(Iterator<T> iterator2, int n2) {
        return Iterators.partitionImpl(iterator2, n2, false);
    }

    private static <T> UnmodifiableIterator<List<T>> partitionImpl(final Iterator<T> iterator2, final int n2, final boolean bl) {
        Preconditions.checkNotNull(iterator2);
        boolean bl2 = n2 > 0;
        Preconditions.checkArgument(bl2);
        return new UnmodifiableIterator<List<T>>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public List<T> next() {
                if (this.hasNext()) {
                    int n22;
                    Object object = new Object[n2];
                    for (n22 = 0; n22 < n2 && iterator2.hasNext(); ++n22) {
                        object[n22] = iterator2.next();
                    }
                    for (int i2 = n22; i2 < n2; ++i2) {
                        object[i2] = null;
                    }
                    List<Object> list = Collections.unmodifiableList(Arrays.asList(object));
                    object = list;
                    if (!bl) {
                        object = n22 == n2 ? list : list.subList(0, n22);
                    }
                    return object;
                }
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                throw noSuchElementException;
            }
        };
    }

    @Deprecated
    public static <T> PeekingIterator<T> peekingIterator(PeekingIterator<T> peekingIterator) {
        return Preconditions.checkNotNull(peekingIterator);
    }

    public static <T> PeekingIterator<T> peekingIterator(Iterator<? extends T> iterator2) {
        if (iterator2 instanceof PeekingImpl) {
            return (PeekingImpl)iterator2;
        }
        return new PeekingImpl<T>(iterator2);
    }

    @NullableDecl
    static <T> T pollNext(Iterator<T> iterator2) {
        if (iterator2.hasNext()) {
            T t2 = iterator2.next();
            iterator2.remove();
            return t2;
        }
        return null;
    }

    public static boolean removeAll(Iterator<?> iterator2, Collection<?> collection) {
        Preconditions.checkNotNull(collection);
        boolean bl = false;
        while (iterator2.hasNext()) {
            if (!collection.contains(iterator2.next())) continue;
            iterator2.remove();
            bl = true;
        }
        return bl;
    }

    public static <T> boolean removeIf(Iterator<T> iterator2, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        boolean bl = false;
        while (iterator2.hasNext()) {
            if (!predicate.apply(iterator2.next())) continue;
            iterator2.remove();
            bl = true;
        }
        return bl;
    }

    public static boolean retainAll(Iterator<?> iterator2, Collection<?> collection) {
        Preconditions.checkNotNull(collection);
        boolean bl = false;
        while (iterator2.hasNext()) {
            if (collection.contains(iterator2.next())) continue;
            iterator2.remove();
            bl = true;
        }
        return bl;
    }

    public static <T> UnmodifiableIterator<T> singletonIterator(final @NullableDecl T t2) {
        return new UnmodifiableIterator<T>(){
            boolean done;

            @Override
            public boolean hasNext() {
                return this.done ^ true;
            }

            @Override
            public T next() {
                if (!this.done) {
                    this.done = true;
                    return t2;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static int size(Iterator<?> iterator2) {
        long l2 = 0L;
        while (iterator2.hasNext()) {
            iterator2.next();
            ++l2;
        }
        return Ints.saturatedCast(l2);
    }

    public static <T> T[] toArray(Iterator<? extends T> iterator2, Class<T> clazz) {
        return Iterables.toArray(Lists.newArrayList(iterator2), clazz);
    }

    public static String toString(Iterator<?> iterator2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        boolean bl = true;
        while (iterator2.hasNext()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append(iterator2.next());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static <F, T> Iterator<T> transform(Iterator<F> iterator2, final Function<? super F, ? extends T> function) {
        Preconditions.checkNotNull(function);
        return new TransformedIterator<F, T>(iterator2){

            T transform(F f2) {
                return function.apply(f2);
            }
        };
    }

    public static <T> Optional<T> tryFind(Iterator<T> iterator2, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkNotNull(predicate);
        while (iterator2.hasNext()) {
            T t2 = iterator2.next();
            if (!predicate.apply(t2)) continue;
            return Optional.of(t2);
        }
        return Optional.absent();
    }

    @Deprecated
    public static <T> UnmodifiableIterator<T> unmodifiableIterator(UnmodifiableIterator<T> unmodifiableIterator) {
        return Preconditions.checkNotNull(unmodifiableIterator);
    }

    public static <T> UnmodifiableIterator<T> unmodifiableIterator(final Iterator<? extends T> iterator2) {
        Preconditions.checkNotNull(iterator2);
        if (iterator2 instanceof UnmodifiableIterator) {
            return (UnmodifiableIterator)iterator2;
        }
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public T next() {
                return iterator2.next();
            }
        };
    }

    private static final class ArrayItr<T>
    extends AbstractIndexedListIterator<T> {
        static final UnmodifiableListIterator<Object> EMPTY = new ArrayItr<Object>(new Object[0], 0, 0, 0);
        private final T[] array;
        private final int offset;

        ArrayItr(T[] TArray, int n2, int n3, int n4) {
            super(n3, n4);
            this.array = TArray;
            this.offset = n2;
        }

        protected T get(int n2) {
            return this.array[this.offset + n2];
        }
    }

    private static class ConcatenatedIterator<T>
    implements Iterator<T> {
        private Iterator<? extends T> iterator = Iterators.emptyIterator();
        @NullableDecl
        private Deque<Iterator<? extends Iterator<? extends T>>> metaIterators;
        @NullableDecl
        private Iterator<? extends T> toRemove;
        private Iterator<? extends Iterator<? extends T>> topMetaIterator;

        ConcatenatedIterator(Iterator<? extends Iterator<? extends T>> iterator2) {
            this.topMetaIterator = Preconditions.checkNotNull(iterator2);
        }

        @NullableDecl
        private Iterator<? extends Iterator<? extends T>> getTopMetaIterator() {
            while (true) {
                Deque<Iterator<? extends Iterator<? extends T>>> deque;
                if ((deque = this.topMetaIterator) != null && deque.hasNext()) {
                    return this.topMetaIterator;
                }
                deque = this.metaIterators;
                if (deque == null || deque.isEmpty()) break;
                this.topMetaIterator = this.metaIterators.removeFirst();
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            while (!Preconditions.checkNotNull(this.iterator).hasNext()) {
                this.topMetaIterator = this.getTopMetaIterator();
                Iterator<T> iterator2 = this.topMetaIterator;
                if (iterator2 == null) {
                    return false;
                }
                this.iterator = iterator2.next();
                iterator2 = this.iterator;
                if (!(iterator2 instanceof ConcatenatedIterator)) continue;
                iterator2 = iterator2;
                this.iterator = iterator2.iterator;
                if (this.metaIterators == null) {
                    this.metaIterators = new ArrayDeque<Iterator<? extends Iterator<? extends T>>>();
                }
                this.metaIterators.addFirst(this.topMetaIterator);
                if (iterator2.metaIterators != null) {
                    while (!iterator2.metaIterators.isEmpty()) {
                        this.metaIterators.addFirst(iterator2.metaIterators.removeLast());
                    }
                }
                this.topMetaIterator = iterator2.topMetaIterator;
            }
            return true;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                Iterator<T> iterator2 = this.iterator;
                this.toRemove = iterator2;
                return iterator2.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            boolean bl = this.toRemove != null;
            CollectPreconditions.checkRemove((boolean)bl);
            this.toRemove.remove();
            this.toRemove = null;
        }
    }

    private static enum EmptyModifiableIterator implements Iterator<Object>
    {
        INSTANCE;


        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            CollectPreconditions.checkRemove((boolean)false);
        }
    }

    private static class MergingIterator<T>
    extends UnmodifiableIterator<T> {
        final Queue<PeekingIterator<T>> queue;

        public MergingIterator(Iterable<? extends Iterator<? extends T>> object, Comparator<? super T> object2) {
            this.queue = new PriorityQueue<PeekingIterator<T>>(2, new Comparator<PeekingIterator<T>>((Comparator)object2){
                final /* synthetic */ Comparator val$itemComparator;
                {
                    this.val$itemComparator = comparator;
                }

                @Override
                public int compare(PeekingIterator<T> peekingIterator, PeekingIterator<T> peekingIterator2) {
                    return this.val$itemComparator.compare(peekingIterator.peek(), peekingIterator2.peek());
                }
            });
            object2 = object.iterator();
            while (object2.hasNext()) {
                object = (Iterator)object2.next();
                if (!object.hasNext()) continue;
                this.queue.add(Iterators.peekingIterator(object));
            }
        }

        @Override
        public boolean hasNext() {
            return this.queue.isEmpty() ^ true;
        }

        @Override
        public T next() {
            PeekingIterator<T> peekingIterator = this.queue.remove();
            T t2 = peekingIterator.next();
            if (peekingIterator.hasNext()) {
                this.queue.add(peekingIterator);
            }
            return t2;
        }
    }

    private static class PeekingImpl<E>
    implements PeekingIterator<E> {
        private boolean hasPeeked;
        private final Iterator<? extends E> iterator;
        @NullableDecl
        private E peekedElement;

        public PeekingImpl(Iterator<? extends E> iterator2) {
            this.iterator = Preconditions.checkNotNull(iterator2);
        }

        @Override
        public boolean hasNext() {
            boolean bl = this.hasPeeked || this.iterator.hasNext();
            return bl;
        }

        @Override
        public E next() {
            if (!this.hasPeeked) {
                return this.iterator.next();
            }
            E e2 = this.peekedElement;
            this.hasPeeked = false;
            this.peekedElement = null;
            return e2;
        }

        @Override
        public E peek() {
            if (!this.hasPeeked) {
                this.peekedElement = this.iterator.next();
                this.hasPeeked = true;
            }
            return this.peekedElement;
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.hasPeeked ^ true, "Can't remove after you've peeked at next");
            this.iterator.remove();
        }
    }
}

