/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ConsumingQueueIterator;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.ObjectArrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Iterables {
    private Iterables() {
    }

    public static <T> boolean addAll(Collection<T> collection, Iterable<? extends T> iterable) {
        if (iterable instanceof Collection) {
            return collection.addAll(Collections2.cast(iterable));
        }
        return Iterators.addAll(collection, Preconditions.checkNotNull(iterable).iterator());
    }

    public static <T> boolean all(Iterable<T> iterable, Predicate<? super T> predicate) {
        return Iterators.all(iterable.iterator(), predicate);
    }

    public static <T> boolean any(Iterable<T> iterable, Predicate<? super T> predicate) {
        return Iterators.any(iterable.iterator(), predicate);
    }

    private static <E> Collection<E> castOrCopyToCollection(Iterable<E> arrayList) {
        arrayList = arrayList instanceof Collection ? (ArrayList<E>)arrayList : Lists.newArrayList(arrayList.iterator());
        return arrayList;
    }

    public static <T> Iterable<T> concat(Iterable<? extends Iterable<? extends T>> iterable) {
        return FluentIterable.concat(iterable);
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> iterable, Iterable<? extends T> iterable2) {
        return FluentIterable.concat(iterable, iterable2);
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> iterable, Iterable<? extends T> iterable2, Iterable<? extends T> iterable3) {
        return FluentIterable.concat(iterable, iterable2, iterable3);
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> iterable, Iterable<? extends T> iterable2, Iterable<? extends T> iterable3, Iterable<? extends T> iterable4) {
        return FluentIterable.concat(iterable, iterable2, iterable3, iterable4);
    }

    @SafeVarargs
    public static <T> Iterable<T> concat(Iterable<? extends T> ... iterableArray) {
        return FluentIterable.concat(iterableArray);
    }

    public static <T> Iterable<T> consumingIterable(final Iterable<T> iterable) {
        Preconditions.checkNotNull(iterable);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                Object object = iterable;
                object = object instanceof Queue ? new ConsumingQueueIterator((Queue)object) : Iterators.consumingIterator(object.iterator());
                return object;
            }

            @Override
            public String toString() {
                return "Iterables.consumingIterable(...)";
            }
        };
    }

    public static boolean contains(Iterable<?> iterable, @NullableDecl Object object) {
        if (iterable instanceof Collection) {
            return Collections2.safeContains((Collection)iterable, object);
        }
        return Iterators.contains(iterable.iterator(), object);
    }

    public static <T> Iterable<T> cycle(final Iterable<T> iterable) {
        Preconditions.checkNotNull(iterable);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.cycle(iterable);
            }

            @Override
            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(iterable.toString());
                stringBuilder.append(" (cycled)");
                return stringBuilder.toString();
            }
        };
    }

    @SafeVarargs
    public static <T> Iterable<T> cycle(T ... TArray) {
        return Iterables.cycle(Lists.newArrayList(TArray));
    }

    public static boolean elementsEqual(Iterable<?> iterable, Iterable<?> iterable2) {
        if (iterable instanceof Collection && iterable2 instanceof Collection) {
            Collection collection = (Collection)iterable;
            Collection collection2 = (Collection)iterable2;
            if (collection.size() != collection2.size()) {
                return false;
            }
        }
        return Iterators.elementsEqual(iterable.iterator(), iterable2.iterator());
    }

    public static <T> Iterable<T> filter(final Iterable<T> iterable, final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterable);
        Preconditions.checkNotNull(predicate);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.filter(iterable.iterator(), predicate);
            }
        };
    }

    public static <T> Iterable<T> filter(Iterable<?> iterable, Class<T> clazz) {
        Preconditions.checkNotNull(iterable);
        Preconditions.checkNotNull(clazz);
        return Iterables.filter(iterable, Predicates.instanceOf(clazz));
    }

    public static <T> T find(Iterable<T> iterable, Predicate<? super T> predicate) {
        return Iterators.find(iterable.iterator(), predicate);
    }

    @NullableDecl
    public static <T> T find(Iterable<? extends T> iterable, Predicate<? super T> predicate, @NullableDecl T t2) {
        return Iterators.find(iterable.iterator(), predicate, t2);
    }

    public static int frequency(Iterable<?> iterable, @NullableDecl Object object) {
        if (iterable instanceof Multiset) {
            return ((Multiset)iterable).count(object);
        }
        if (iterable instanceof Set) {
            return ((Set)iterable).contains(object) ? 1 : 0;
        }
        return Iterators.frequency(iterable.iterator(), object);
    }

    public static <T> T get(Iterable<T> iterable, int n2) {
        Preconditions.checkNotNull(iterable);
        iterable = iterable instanceof List ? ((List)iterable).get(n2) : Iterators.get(iterable.iterator(), n2);
        return (T)iterable;
    }

    @NullableDecl
    public static <T> T get(Iterable<? extends T> object, int n2, @NullableDecl T object2) {
        Preconditions.checkNotNull(object);
        Iterators.checkNonnegative(n2);
        if (object instanceof List) {
            if (n2 < (object = Lists.cast(object)).size()) {
                object2 = object.get(n2);
            }
            return object2;
        }
        object = object.iterator();
        Iterators.advance(object, n2);
        return Iterators.getNext(object, object2);
    }

    @NullableDecl
    public static <T> T getFirst(Iterable<? extends T> iterable, @NullableDecl T t2) {
        return Iterators.getNext(iterable.iterator(), t2);
    }

    public static <T> T getLast(Iterable<T> list) {
        if (list instanceof List) {
            if (!(list = (List)list).isEmpty()) {
                return Iterables.getLastInNonemptyList(list);
            }
            throw new NoSuchElementException();
        }
        return Iterators.getLast(list.iterator());
    }

    @NullableDecl
    public static <T> T getLast(Iterable<? extends T> iterable, @NullableDecl T t2) {
        if (iterable instanceof Collection) {
            if (Collections2.cast(iterable).isEmpty()) {
                return t2;
            }
            if (iterable instanceof List) {
                return Iterables.getLastInNonemptyList(Lists.cast(iterable));
            }
        }
        return Iterators.getLast(iterable.iterator(), t2);
    }

    private static <T> T getLastInNonemptyList(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> T getOnlyElement(Iterable<T> iterable) {
        return Iterators.getOnlyElement(iterable.iterator());
    }

    @NullableDecl
    public static <T> T getOnlyElement(Iterable<? extends T> iterable, @NullableDecl T t2) {
        return Iterators.getOnlyElement(iterable.iterator(), t2);
    }

    public static <T> int indexOf(Iterable<T> iterable, Predicate<? super T> predicate) {
        return Iterators.indexOf(iterable.iterator(), predicate);
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return iterable.iterator().hasNext() ^ true;
    }

    public static <T> Iterable<T> limit(final Iterable<T> iterable, final int n2) {
        Preconditions.checkNotNull(iterable);
        boolean bl = n2 >= 0;
        Preconditions.checkArgument(bl, "limit is negative");
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.limit(iterable.iterator(), n2);
            }
        };
    }

    public static <T> Iterable<T> mergeSorted(final Iterable<? extends Iterable<? extends T>> iterable, final Comparator<? super T> comparator) {
        Preconditions.checkNotNull(iterable, "iterables");
        Preconditions.checkNotNull(comparator, "comparator");
        return new UnmodifiableIterable(new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.mergeSorted(Iterables.transform(iterable, Iterables.toIterator()), comparator);
            }
        });
    }

    public static <T> Iterable<List<T>> paddedPartition(final Iterable<T> iterable, final int n2) {
        Preconditions.checkNotNull(iterable);
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl);
        return new FluentIterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return Iterators.paddedPartition(iterable.iterator(), n2);
            }
        };
    }

    public static <T> Iterable<List<T>> partition(final Iterable<T> iterable, final int n2) {
        Preconditions.checkNotNull(iterable);
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl);
        return new FluentIterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return Iterators.partition(iterable.iterator(), n2);
            }
        };
    }

    public static boolean removeAll(Iterable<?> iterable, Collection<?> collection) {
        boolean bl = iterable instanceof Collection ? ((Collection)iterable).removeAll(Preconditions.checkNotNull(collection)) : Iterators.removeAll(iterable.iterator(), collection);
        return bl;
    }

    @NullableDecl
    static <T> T removeFirstMatching(Iterable<T> iterable, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        Iterator<T> iterator2 = iterable.iterator();
        while (iterator2.hasNext()) {
            iterable = iterator2.next();
            if (!predicate.apply(iterable)) continue;
            iterator2.remove();
            return (T)iterable;
        }
        return null;
    }

    public static <T> boolean removeIf(Iterable<T> iterable, Predicate<? super T> predicate) {
        if (iterable instanceof RandomAccess && iterable instanceof List) {
            return Iterables.removeIfFromRandomAccessList((List)iterable, Preconditions.checkNotNull(predicate));
        }
        return Iterators.removeIf(iterable.iterator(), predicate);
    }

    private static <T> boolean removeIfFromRandomAccessList(List<T> list, Predicate<? super T> predicate) {
        int n2;
        boolean bl = false;
        int n3 = 0;
        for (n2 = 0; n2 < list.size(); ++n2) {
            T t2 = list.get(n2);
            int n4 = n3;
            if (!predicate.apply(t2)) {
                if (n2 > n3) {
                    try {
                        list.set(n3, t2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Iterables.slowRemoveIfForRemainingElements(list, predicate, n3, n2);
                        return true;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        Iterables.slowRemoveIfForRemainingElements(list, predicate, n3, n2);
                        return true;
                    }
                }
                n4 = n3 + 1;
            }
            n3 = n4;
        }
        list.subList(n3, list.size()).clear();
        if (n2 != n3) {
            bl = true;
        }
        return bl;
    }

    public static boolean retainAll(Iterable<?> iterable, Collection<?> collection) {
        boolean bl = iterable instanceof Collection ? ((Collection)iterable).retainAll(Preconditions.checkNotNull(collection)) : Iterators.retainAll(iterable.iterator(), collection);
        return bl;
    }

    public static int size(Iterable<?> iterable) {
        int n2 = iterable instanceof Collection ? ((Collection)iterable).size() : Iterators.size(iterable.iterator());
        return n2;
    }

    public static <T> Iterable<T> skip(final Iterable<T> iterable, final int n2) {
        Preconditions.checkNotNull(iterable);
        boolean bl = n2 >= 0;
        Preconditions.checkArgument(bl, "number to skip cannot be negative");
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                Object object = iterable;
                if (object instanceof List) {
                    object = (List)object;
                    return object.subList(Math.min(object.size(), n2), object.size()).iterator();
                }
                object = object.iterator();
                Iterators.advance(object, n2);
                return new Iterator<T>((Iterator)object){
                    boolean atStart = true;
                    final /* synthetic */ Iterator val$iterator;
                    {
                        this.val$iterator = iterator2;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.val$iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        Object e2 = this.val$iterator.next();
                        this.atStart = false;
                        return e2;
                    }

                    @Override
                    public void remove() {
                        CollectPreconditions.checkRemove((boolean)(this.atStart ^ true));
                        this.val$iterator.remove();
                    }
                };
            }
        };
    }

    private static <T> void slowRemoveIfForRemainingElements(List<T> list, Predicate<? super T> predicate, int n2, int n3) {
        for (int i2 = list.size() - 1; i2 > n3; --i2) {
            if (!predicate.apply(list.get(i2))) continue;
            list.remove(i2);
        }
        --n3;
        while (n3 >= n2) {
            list.remove(n3);
            --n3;
        }
    }

    static Object[] toArray(Iterable<?> iterable) {
        return Iterables.castOrCopyToCollection(iterable).toArray();
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> clazz) {
        return Iterables.toArray(iterable, ObjectArrays.newArray(clazz, 0));
    }

    static <T> T[] toArray(Iterable<? extends T> iterable, T[] TArray) {
        return Iterables.castOrCopyToCollection(iterable).toArray(TArray);
    }

    static <T> Function<Iterable<? extends T>, Iterator<? extends T>> toIterator() {
        return new Function<Iterable<? extends T>, Iterator<? extends T>>(){

            @Override
            public Iterator<? extends T> apply(Iterable<? extends T> iterable) {
                return iterable.iterator();
            }
        };
    }

    public static String toString(Iterable<?> iterable) {
        return Iterators.toString(iterable.iterator());
    }

    public static <F, T> Iterable<T> transform(final Iterable<F> iterable, final Function<? super F, ? extends T> function) {
        Preconditions.checkNotNull(iterable);
        Preconditions.checkNotNull(function);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.transform(iterable.iterator(), function);
            }
        };
    }

    public static <T> Optional<T> tryFind(Iterable<T> iterable, Predicate<? super T> predicate) {
        return Iterators.tryFind(iterable.iterator(), predicate);
    }

    @Deprecated
    public static <E> Iterable<E> unmodifiableIterable(ImmutableCollection<E> immutableCollection) {
        return Preconditions.checkNotNull(immutableCollection);
    }

    public static <T> Iterable<T> unmodifiableIterable(Iterable<? extends T> iterable) {
        Preconditions.checkNotNull(iterable);
        if (!(iterable instanceof UnmodifiableIterable) && !(iterable instanceof ImmutableCollection)) {
            return new UnmodifiableIterable(iterable);
        }
        return iterable;
    }

    private static final class UnmodifiableIterable<T>
    extends FluentIterable<T> {
        private final Iterable<? extends T> iterable;

        private UnmodifiableIterable(Iterable<? extends T> iterable) {
            this.iterable = iterable;
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.unmodifiableIterator(this.iterable.iterator());
        }

        @Override
        public String toString() {
            return this.iterable.toString();
        }
    }
}

