/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractTable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.RegularImmutableTable;
import com.google.common.collect.SingletonImmutableTable;
import com.google.common.collect.SparseImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ImmutableTable<R, C, V>
extends AbstractTable<R, C, V>
implements Serializable {
    ImmutableTable() {
    }

    public static <R, C, V> Builder<R, C, V> builder() {
        return new Builder();
    }

    static <R, C, V> Table.Cell<R, C, V> cellOf(R r2, C c2, V v2) {
        return Tables.immutableCell(Preconditions.checkNotNull(r2, "rowKey"), Preconditions.checkNotNull(c2, "columnKey"), Preconditions.checkNotNull(v2, "value"));
    }

    public static <R, C, V> ImmutableTable<R, C, V> copyOf(Table<? extends R, ? extends C, ? extends V> table) {
        if (table instanceof ImmutableTable) {
            return (ImmutableTable)table;
        }
        return ImmutableTable.copyOf(table.cellSet());
    }

    private static <R, C, V> ImmutableTable<R, C, V> copyOf(Iterable<? extends Table.Cell<? extends R, ? extends C, ? extends V>> object) {
        Builder<R, C, V> builder = ImmutableTable.builder();
        object = object.iterator();
        while (object.hasNext()) {
            builder.put((Table.Cell)object.next());
        }
        return builder.build();
    }

    public static <R, C, V> ImmutableTable<R, C, V> of() {
        return SparseImmutableTable.EMPTY;
    }

    public static <R, C, V> ImmutableTable<R, C, V> of(R r2, C c2, V v2) {
        return new SingletonImmutableTable(r2, c2, v2);
    }

    @Override
    final UnmodifiableIterator<Table.Cell<R, C, V>> cellIterator() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    public ImmutableSet<Table.Cell<R, C, V>> cellSet() {
        return (ImmutableSet)super.cellSet();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableMap<R, V> column(C c2) {
        Preconditions.checkNotNull(c2, "columnKey");
        return MoreObjects.firstNonNull((ImmutableMap)((ImmutableMap)this.columnMap()).get(c2), ImmutableMap.of());
    }

    @Override
    public ImmutableSet<C> columnKeySet() {
        return ((ImmutableMap)this.columnMap()).keySet();
    }

    @Override
    public abstract ImmutableMap<C, Map<R, V>> columnMap();

    @Override
    public boolean contains(@NullableDecl Object object, @NullableDecl Object object2) {
        boolean bl = this.get(object, object2) != null;
        return bl;
    }

    @Override
    public boolean containsValue(@NullableDecl Object object) {
        return ((ImmutableCollection)this.values()).contains(object);
    }

    @Override
    abstract ImmutableSet<Table.Cell<R, C, V>> createCellSet();

    abstract SerializedForm createSerializedForm();

    @Override
    abstract ImmutableCollection<V> createValues();

    @Override
    @Deprecated
    public final V put(R r2, C c2, V v2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V remove(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableMap<C, V> row(R r2) {
        Preconditions.checkNotNull(r2, "rowKey");
        return MoreObjects.firstNonNull((ImmutableMap)((ImmutableMap)this.rowMap()).get(r2), ImmutableMap.of());
    }

    @Override
    public ImmutableSet<R> rowKeySet() {
        return ((ImmutableMap)this.rowMap()).keySet();
    }

    @Override
    public abstract ImmutableMap<R, Map<C, V>> rowMap();

    @Override
    public ImmutableCollection<V> values() {
        return (ImmutableCollection)super.values();
    }

    @Override
    final Iterator<V> valuesIterator() {
        throw new AssertionError((Object)"should never be called");
    }

    final Object writeReplace() {
        return this.createSerializedForm();
    }

    public static final class Builder<R, C, V> {
        private final List<Table.Cell<R, C, V>> cells = Lists.newArrayList();
        @MonotonicNonNullDecl
        private Comparator<? super C> columnComparator;
        @MonotonicNonNullDecl
        private Comparator<? super R> rowComparator;

        public ImmutableTable<R, C, V> build() {
            int n2 = this.cells.size();
            if (n2 != 0) {
                if (n2 != 1) {
                    return RegularImmutableTable.forCells(this.cells, this.rowComparator, this.columnComparator);
                }
                return new SingletonImmutableTable(Iterables.getOnlyElement(this.cells));
            }
            return ImmutableTable.of();
        }

        public Builder<R, C, V> orderColumnsBy(Comparator<? super C> comparator) {
            this.columnComparator = Preconditions.checkNotNull(comparator, "columnComparator");
            return this;
        }

        public Builder<R, C, V> orderRowsBy(Comparator<? super R> comparator) {
            this.rowComparator = Preconditions.checkNotNull(comparator, "rowComparator");
            return this;
        }

        public Builder<R, C, V> put(Table.Cell<? extends R, ? extends C, ? extends V> cell) {
            if (cell instanceof Tables.ImmutableCell) {
                Preconditions.checkNotNull(cell.getRowKey(), "row");
                Preconditions.checkNotNull(cell.getColumnKey(), "column");
                Preconditions.checkNotNull(cell.getValue(), "value");
                this.cells.add(cell);
            } else {
                this.put(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
            }
            return this;
        }

        public Builder<R, C, V> put(R r2, C c2, V v2) {
            this.cells.add(ImmutableTable.cellOf(r2, c2, v2));
            return this;
        }

        public Builder<R, C, V> putAll(Table<? extends R, ? extends C, ? extends V> object) {
            object = object.cellSet().iterator();
            while (object.hasNext()) {
                this.put((Table.Cell)object.next());
            }
            return this;
        }
    }

    static final class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final int[] cellColumnIndices;
        private final int[] cellRowIndices;
        private final Object[] cellValues;
        private final Object[] columnKeys;
        private final Object[] rowKeys;

        private SerializedForm(Object[] objectArray, Object[] objectArray2, Object[] objectArray3, int[] nArray, int[] nArray2) {
            this.rowKeys = objectArray;
            this.columnKeys = objectArray2;
            this.cellValues = objectArray3;
            this.cellRowIndices = nArray;
            this.cellColumnIndices = nArray2;
        }

        static SerializedForm create(ImmutableTable<?, ?, ?> immutableTable, int[] nArray, int[] nArray2) {
            return new SerializedForm(((ImmutableCollection)((Object)immutableTable.rowKeySet())).toArray(), ((ImmutableCollection)((Object)immutableTable.columnKeySet())).toArray(), ((ImmutableCollection)immutableTable.values()).toArray(), nArray, nArray2);
        }

        Object readResolve() {
            Object[] objectArray = this.cellValues;
            if (objectArray.length == 0) {
                return ImmutableTable.of();
            }
            int n2 = objectArray.length;
            if (n2 == 1) {
                return ImmutableTable.of(this.rowKeys[0], this.columnKeys[0], objectArray[0]);
            }
            ImmutableList.Builder builder = new ImmutableList.Builder(objectArray.length);
            for (int i2 = 0; i2 < (objectArray = this.cellValues).length; ++i2) {
                builder.add(ImmutableTable.cellOf(this.rowKeys[this.cellRowIndices[i2]], this.columnKeys[this.cellColumnIndices[i2]], objectArray[i2]));
            }
            return RegularImmutableTable.forOrderedComponents(builder.build(), ImmutableSet.copyOf(this.rowKeys), ImmutableSet.copyOf(this.columnKeys));
        }
    }
}

