/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSetFauxverideShim;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Ordering;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.SortedIterable;
import com.google.common.collect.SortedIterables;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ImmutableSortedSet<E>
extends ImmutableSortedSetFauxverideShim<E>
implements NavigableSet<E>,
SortedIterable<E> {
    final transient Comparator<? super E> comparator;
    @LazyInit
    transient ImmutableSortedSet<E> descendingSet;

    ImmutableSortedSet(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    static <E> ImmutableSortedSet<E> construct(Comparator<? super E> comparator, int n2, E ... EArray) {
        Object object;
        if (n2 == 0) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        ObjectArrays.checkElementsNotNull((Object[])EArray, n2);
        Arrays.sort(EArray, 0, n2, comparator);
        int n3 = 1;
        for (int i2 = 1; i2 < n2; ++i2) {
            object = EArray[i2];
            int n4 = n3;
            if (comparator.compare(object, EArray[n3 - 1]) != 0) {
                EArray[n3] = object;
                n4 = n3 + 1;
            }
            n3 = n4;
        }
        Arrays.fill(EArray, n3, n2, null);
        object = EArray;
        if (n3 < EArray.length / 2) {
            object = Arrays.copyOf(EArray, n3);
        }
        return new RegularImmutableSortedSet<E>(ImmutableList.asImmutableList(object, n3), comparator);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Iterable<? extends E> iterable) {
        return ImmutableSortedSet.copyOf(Ordering.natural(), iterable);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Collection<? extends E> collection) {
        return ImmutableSortedSet.copyOf(Ordering.natural(), collection);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterable<? extends E> objectArray) {
        ImmutableSortedSet immutableSortedSet;
        Preconditions.checkNotNull(comparator);
        if (SortedIterables.hasSameComparator(comparator, objectArray) && objectArray instanceof ImmutableSortedSet && !(immutableSortedSet = (ImmutableSortedSet)objectArray).isPartialView()) {
            return immutableSortedSet;
        }
        objectArray = Iterables.toArray(objectArray);
        return ImmutableSortedSet.construct(comparator, objectArray.length, objectArray);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Collection<? extends E> collection) {
        return ImmutableSortedSet.copyOf(comparator, collection);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterator<? extends E> iterator2) {
        return ((Builder)new Builder<E>(comparator).addAll((Iterator)iterator2)).build();
    }

    public static <E> ImmutableSortedSet<E> copyOf(Iterator<? extends E> iterator2) {
        return ImmutableSortedSet.copyOf(Ordering.natural(), iterator2);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> copyOf(E[] EArray) {
        return ImmutableSortedSet.construct(Ordering.natural(), EArray.length, (Object[])EArray.clone());
    }

    public static <E> ImmutableSortedSet<E> copyOfSorted(SortedSet<E> sequencedCollection) {
        Comparator comparator = SortedIterables.comparator(sequencedCollection);
        if (((AbstractCollection)((Object)(sequencedCollection = ImmutableList.copyOf(sequencedCollection)))).isEmpty()) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        return new RegularImmutableSortedSet<E>(sequencedCollection, comparator);
    }

    static <E> RegularImmutableSortedSet<E> emptySet(Comparator<? super E> comparator) {
        if (Ordering.natural().equals(comparator)) {
            return RegularImmutableSortedSet.NATURAL_EMPTY_SET;
        }
        return new RegularImmutableSortedSet<E>(ImmutableList.of(), comparator);
    }

    public static <E extends Comparable<?>> Builder<E> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    public static <E> ImmutableSortedSet<E> of() {
        return RegularImmutableSortedSet.NATURAL_EMPTY_SET;
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e2) {
        return new RegularImmutableSortedSet<E>(ImmutableList.of(e2), Ordering.natural());
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e2, E e3) {
        return ImmutableSortedSet.construct(Ordering.natural(), 2, e2, e3);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e2, E e3, E e4) {
        return ImmutableSortedSet.construct(Ordering.natural(), 3, e2, e3, e4);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e2, E e3, E e4, E e5) {
        return ImmutableSortedSet.construct(Ordering.natural(), 4, e2, e3, e4, e5);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e2, E e3, E e4, E e5, E e6) {
        return ImmutableSortedSet.construct(Ordering.natural(), 5, e2, e3, e4, e5, e6);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E ... EArray) {
        Comparable[] comparableArray = new Comparable[EArray.length + 6];
        comparableArray[0] = e2;
        comparableArray[1] = e3;
        comparableArray[2] = e4;
        comparableArray[3] = e5;
        comparableArray[4] = e6;
        comparableArray[5] = e7;
        System.arraycopy(EArray, 0, comparableArray, 6, EArray.length);
        return ImmutableSortedSet.construct(Ordering.natural(), comparableArray.length, comparableArray);
    }

    public static <E> Builder<E> orderedBy(Comparator<E> comparator) {
        return new Builder<E>(comparator);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    public static <E extends Comparable<?>> Builder<E> reverseOrder() {
        return new Builder(Collections.reverseOrder());
    }

    static int unsafeCompare(Comparator<?> comparator, Object object, Object object2) {
        return comparator.compare(object, object2);
    }

    @Override
    public E ceiling(E e2) {
        return Iterables.getFirst(this.tailSet((Object)e2, true), null);
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    abstract ImmutableSortedSet<E> createDescendingSet();

    @Override
    public abstract UnmodifiableIterator<E> descendingIterator();

    @Override
    public ImmutableSortedSet<E> descendingSet() {
        ImmutableSortedSet<E> immutableSortedSet;
        ImmutableSortedSet<E> immutableSortedSet2 = immutableSortedSet = this.descendingSet;
        if (immutableSortedSet == null) {
            this.descendingSet = immutableSortedSet2 = this.createDescendingSet();
            immutableSortedSet2.descendingSet = this;
        }
        return immutableSortedSet2;
    }

    @Override
    public E first() {
        return this.iterator().next();
    }

    @Override
    public E floor(E e2) {
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)e2, true)).descendingIterator(), null);
    }

    @Override
    public ImmutableSortedSet<E> headSet(E e2) {
        return this.headSet((Object)e2, false);
    }

    @Override
    public ImmutableSortedSet<E> headSet(E e2, boolean bl) {
        return this.headSetImpl(Preconditions.checkNotNull(e2), bl);
    }

    abstract ImmutableSortedSet<E> headSetImpl(E var1, boolean var2);

    @Override
    public E higher(E e2) {
        return Iterables.getFirst(this.tailSet((Object)e2, false), null);
    }

    abstract int indexOf(@NullableDecl Object var1);

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public E last() {
        return this.descendingIterator().next();
    }

    @Override
    public E lower(E e2) {
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)e2, false)).descendingIterator(), null);
    }

    @Override
    @Deprecated
    public final E pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final E pollLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableSortedSet<E> subSet(E e2, E e3) {
        return this.subSet((Object)e2, true, (Object)e3, false);
    }

    @Override
    public ImmutableSortedSet<E> subSet(E e2, boolean bl, E e3, boolean bl2) {
        Preconditions.checkNotNull(e2);
        Preconditions.checkNotNull(e3);
        boolean bl3 = this.comparator.compare(e2, e3) <= 0;
        Preconditions.checkArgument(bl3);
        return this.subSetImpl(e2, bl, e3, bl2);
    }

    abstract ImmutableSortedSet<E> subSetImpl(E var1, boolean var2, E var3, boolean var4);

    @Override
    public ImmutableSortedSet<E> tailSet(E e2) {
        return this.tailSet((Object)e2, true);
    }

    @Override
    public ImmutableSortedSet<E> tailSet(E e2, boolean bl) {
        return this.tailSetImpl(Preconditions.checkNotNull(e2), bl);
    }

    abstract ImmutableSortedSet<E> tailSetImpl(E var1, boolean var2);

    int unsafeCompare(Object object, Object object2) {
        return ImmutableSortedSet.unsafeCompare(this.comparator, object, object2);
    }

    @Override
    Object writeReplace() {
        return new SerializedForm<E>(this.comparator, this.toArray());
    }

    public static final class Builder<E>
    extends ImmutableSet.Builder<E> {
        private final Comparator<? super E> comparator;

        public Builder(Comparator<? super E> comparator) {
            this.comparator = Preconditions.checkNotNull(comparator);
        }

        @Override
        public Builder<E> add(E e2) {
            super.add((Object)e2);
            return this;
        }

        @Override
        public Builder<E> add(E ... EArray) {
            super.add((Object[])EArray);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> iterable) {
            super.addAll((Iterable)iterable);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> iterator2) {
            super.addAll((Iterator)iterator2);
            return this;
        }

        @Override
        public ImmutableSortedSet<E> build() {
            Object object = this.contents;
            object = ImmutableSortedSet.construct(this.comparator, this.size, object);
            this.size = ((AbstractCollection)object).size();
            this.forceCopy = true;
            return object;
        }
    }

    private static class SerializedForm<E>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        final Comparator<? super E> comparator;
        final Object[] elements;

        public SerializedForm(Comparator<? super E> comparator, Object[] objectArray) {
            this.comparator = comparator;
            this.elements = objectArray;
        }

        Object readResolve() {
            return ((Builder)new Builder<E>(this.comparator).add(this.elements)).build();
        }
    }
}

